# geotecha - A software suite for geotechncial engineering
# Copyright (C) 2013  Rohan T. Walker (rtrwalker@gmail.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/gpl.html.
"""Some test routines for the speccon_1d_vert_radial_boundary module.

"""
from __future__ import division, print_function

from nose import with_setup
from nose.tools.trivial import assert_almost_equal
from nose.tools.trivial import assert_raises
from nose.tools.trivial import ok_
from numpy.testing import assert_allclose
import unittest

from math import pi
import numpy as np
import textwrap
import matplotlib.pyplot as plt
from geotecha.piecewise.piecewise_linear_1d import PolyLine

from geotecha.consolidation.tangandonitsuka2000 import tangandonitsuka2000

def test_tang_and_onitsuka_one():
    """tang_and_onitsuka_vert_and_radial

    vertical and radial consolidation (no well resitance)


    H=1
    kv=kh=10, mv=1, gamw=10
    dTv=kvref/mvref/gamw/H**2 = 1
    #re=0.5, rw = 0.03, n = 16.6667, mu = 2.074475589, etref = 3.856396307
    #dTh = 2*khref/mvref/gamw/mu = 3.856396307

    """

    t = np.array([  1.00000000e-03,   2.00000000e-03,   3.00000000e-03,
         4.00000000e-03,   5.00000000e-03,   6.00000000e-03,
         7.00000000e-03,   8.00000000e-03,   9.00000000e-03,
         1.00000000e-02,   2.00000000e-02,   3.00000000e-02,
         4.00000000e-02,   5.00000000e-02,   6.00000000e-02,
         7.00000000e-02,   8.00000000e-02,   9.00000000e-02,
         1.00000000e-01,   1.10000000e-01,   1.20000000e-01,
         1.30000000e-01,   1.40000000e-01,   1.50000000e-01,
         1.60000000e-01,   1.70000000e-01,   1.80000000e-01,
         1.90000000e-01,   2.00000000e-01,   2.10000000e-01,
         2.20000000e-01,   2.30000000e-01,   2.40000000e-01,
         2.50000000e-01,   2.60000000e-01,   2.70000000e-01,
         2.80000000e-01,   2.90000000e-01,   3.00000000e-01,
         3.10000000e-01,   3.20000000e-01,   3.30000000e-01,
         3.40000000e-01,   3.50000000e-01,   3.60000000e-01,
         3.70000000e-01,   3.80000000e-01,   3.90000000e-01,
         4.00000000e-01,   4.10000000e-01,   4.20000000e-01,
         4.30000000e-01,   4.40000000e-01,   4.50000000e-01,
         4.60000000e-01,   4.70000000e-01,   4.80000000e-01,
         4.90000000e-01,   5.00000000e-01,   5.10000000e-01,
         5.20000000e-01,   5.30000000e-01,   5.40000000e-01,
         5.50000000e-01,   5.60000000e-01,   5.70000000e-01,
         5.80000000e-01,   5.90000000e-01,   6.00000000e-01,
         6.10000000e-01,   6.20000000e-01,   6.30000000e-01,
         6.40000000e-01,   6.50000000e-01,   6.60000000e-01,
         6.70000000e-01,   6.80000000e-01,   6.90000000e-01,
         7.00000000e-01,   7.10000000e-01,   7.20000000e-01,
         7.30000000e-01,   7.40000000e-01,   7.50000000e-01,
         7.60000000e-01,   7.70000000e-01,   7.80000000e-01,
         7.90000000e-01,   8.00000000e-01,   8.10000000e-01,
         8.20000000e-01,   8.30000000e-01,   8.40000000e-01,
         8.50000000e-01,   8.60000000e-01,   8.70000000e-01,
         8.80000000e-01,   8.90000000e-01,   9.00000000e-01,
         9.10000000e-01,   9.20000000e-01,   9.30000000e-01,
         9.40000000e-01,   9.50000000e-01,   9.60000000e-01,
         9.70000000e-01,   9.80000000e-01,   9.90000000e-01,
         1.00000000e+00,   1.01000000e+00])



    avp = 100*np.array([[ 0.00324696,  0.00641694,  0.00953238,  0.0126017 ,  0.01562987,
        0.01862029,  0.02157548,  0.02449743,  0.02738778,  0.03024788,
        0.05738761,  0.0822719 ,  0.10525907,  0.12658293,  0.1464181 ,
        0.16490438,  0.18215844,  0.19828034,  0.21335753,  0.22746753,
        0.24067983,  0.25305715,  0.26465659,  0.27553032,  0.25547838,
        0.23790104,  0.22198642,  0.2074141 ,  0.19398549,  0.18155873,
        0.17002455,  0.15929482,  0.14929611,  0.13996587,  0.13124986,
        0.12310046,  0.11547534,  0.10833658,  0.10164995,  0.12563221,
        0.14689894,  0.16627677,  0.18410003,  0.20058033,  0.21587175,
        0.23009504,  0.2433491 ,  0.25571746,  0.26727216,  0.27807632,
        0.28818593,  0.29765116,  0.30651729,  0.31482546,  0.29236538,
        0.27252759,  0.25449115,  0.2379271 ,  0.22262886,  0.20844708,
        0.19526545,  0.18298923,  0.1715388 ,  0.1608458 ,  0.15085055,
        0.14150028,  0.13274787,  0.1245509 ,  0.11687089,  0.10967276,
        0.10292438,  0.09659617,  0.09066084,  0.08509314,  0.07986962,
        0.0749685 ,  0.07036946,  0.06605359,  0.06200322,  0.05820182,
        0.05463397,  0.05128519,  0.04814195,  0.04519158,  0.04242218,
        0.03982263,  0.03738247,  0.03509191,  0.03294176,  0.0309234 ,
        0.02902874,  0.02725019,  0.02558063,  0.02401338,  0.02254216,
        0.02116109,  0.01986464,  0.01864762,  0.01750516,  0.01643271,
        0.01542596,  0.01448089,  0.01359372,  0.0127609 ,  0.01197911,
        0.01124522,  0.01055628,  0.00990956,  0.00930246,  0.00873255]])


    z = np.array(
      [ 0.        ,  0.11111111,  0.22222222,  0.33333333,  0.44444444,
        0.55555556,  0.66666667,  0.77777778,  0.88888889,  1.        ])

    por = np.array(
    [[  0.        ,   0.        ,   0.        ],
       [ 10.62834433,   5.71540426,   0.79195768],
       [ 18.10955225,  11.14818494,   1.55981113],
       [ 23.22767635,  16.0566849 ,   2.2801995 ],
       [ 26.62643019,  20.26892536,   2.93122316],
       [ 28.80909111,  23.69187844,   3.49311208],
       [ 30.15548187,  26.3014876 ,   3.94882356],
       [ 30.93852215,  28.11965758,   4.28455203],
       [ 31.33977648,  29.18687894,   4.49013755],
       [ 31.4624026 ,  29.5381209 ,   4.55936353]])


#    por = 100 * TERZ1D_POR
#    avp = 100 * TERZ1D_AVP
    settle = (np.interp(t,[0,0.15,0.3,0.45,4], [0.0,50,50,100,100]) - avp)




    H = 1
#    z  = np.linspace(0, H,40)
#    t = np.linspace(0,1,100)
    kv, kh, ks, kw = (10, 10, 10, 1e7)
    mv=1
    gamw = 10
    rw, rs, re = (0.03, 0.03, 0.5)
    drn = 1
    surcharge_vs_time = ((0,0.15, 0.3, 0.45,100.0), (0,50,50.0,100.0,100.0))
    tpor = t[np.array([20,60,90])]
    nterms = 20


    por_, avp_, settle_ = tangandonitsuka2000(z=z, t=t, kv=kv, kh=kh, ks=ks, kw=kw, mv=mv, gamw=gamw, rw=rw, rs=rs, re=re, H=H,
                       drn=drn, surcharge_vs_time=surcharge_vs_time,
                       tpor=tpor, nterms=nterms)



#    plt.figure()
#    plt.plot(por, z,'b-*', label='expected')
#    plt.plot(por_, z, 'r-+', label='calculated')
#    plt.legend()
#
#    plt.figure()
#    plt.plot(t,settle[0],'b-*', label='expected')
#    plt.plot(t, settle_, 'r-+', label='calculated')
#    plt.legend()
#
#    plt.figure()
#    plt.plot(t, avp[0],'b-*',  label='expected')
#    plt.plot(t, avp_, 'r-+', label='calculated')
#    plt.legend()
#    plt.show()

    assert_allclose(avp_, avp[0], atol=1e-3,
                    err_msg = ("Fail. test_tang_and_onitsuka_one, avp, "
                        ))
    assert_allclose(por_, por, atol=1e-2,
                    err_msg = ("Fail. test_tang_and_onitsuka_one, por, "
                        ))
    assert_allclose(settle_, settle[0], atol=1e-3,
                    err_msg = ("Fail. test_tang_and_onitsuka_one, settle, "
                        ))



def test_tang_and_onitsuka_well_resistance():
    """tang_and_onitsuka_vert_and_radial

    vertical and radial consolidation (no well resitance)


    H=1
    kv=kh=10, ks=3,kh=1 mv=1, gamw=10
    dTv=kvref/mvref/gamw/H**2 = 1
    #re=0.5, rw = 0.03, rs = 0.06,n = 16.6667,

    """

    t = np.array([  1.00000000e-03,   2.00000000e-03,   3.00000000e-03,
         4.00000000e-03,   5.00000000e-03,   6.00000000e-03,
         7.00000000e-03,   8.00000000e-03,   9.00000000e-03,
         1.00000000e-02,   2.00000000e-02,   3.00000000e-02,
         4.00000000e-02,   5.00000000e-02,   6.00000000e-02,
         7.00000000e-02,   8.00000000e-02,   9.00000000e-02,
         1.00000000e-01,   1.10000000e-01,   1.20000000e-01,
         1.30000000e-01,   1.40000000e-01,   1.50000000e-01,
         1.60000000e-01,   1.70000000e-01,   1.80000000e-01,
         1.90000000e-01,   2.00000000e-01,   2.10000000e-01,
         2.20000000e-01,   2.30000000e-01,   2.40000000e-01,
         2.50000000e-01,   2.60000000e-01,   2.70000000e-01,
         2.80000000e-01,   2.90000000e-01,   3.00000000e-01,
         3.10000000e-01,   3.20000000e-01,   3.30000000e-01,
         3.40000000e-01,   3.50000000e-01,   3.60000000e-01,
         3.70000000e-01,   3.80000000e-01,   3.90000000e-01,
         4.00000000e-01,   4.10000000e-01,   4.20000000e-01,
         4.30000000e-01,   4.40000000e-01,   4.50000000e-01,
         4.60000000e-01,   4.70000000e-01,   4.80000000e-01,
         4.90000000e-01,   5.00000000e-01,   5.10000000e-01,
         5.20000000e-01,   5.30000000e-01,   5.40000000e-01,
         5.50000000e-01,   5.60000000e-01,   5.70000000e-01,
         5.80000000e-01,   5.90000000e-01,   6.00000000e-01,
         6.10000000e-01,   6.20000000e-01,   6.30000000e-01,
         6.40000000e-01,   6.50000000e-01,   6.60000000e-01,
         6.70000000e-01,   6.80000000e-01,   6.90000000e-01,
         7.00000000e-01,   7.10000000e-01,   7.20000000e-01,
         7.30000000e-01,   7.40000000e-01,   7.50000000e-01,
         7.60000000e-01,   7.70000000e-01,   7.80000000e-01,
         7.90000000e-01,   8.00000000e-01,   8.10000000e-01,
         8.20000000e-01,   8.30000000e-01,   8.40000000e-01,
         8.50000000e-01,   8.60000000e-01,   8.70000000e-01,
         8.80000000e-01,   8.90000000e-01,   9.00000000e-01,
         9.10000000e-01,   9.20000000e-01,   9.30000000e-01,
         9.40000000e-01,   9.50000000e-01,   9.60000000e-01,
         9.70000000e-01,   9.80000000e-01,   9.90000000e-01,
         1.00000000e+00,   1.01000000e+00])



    avp = np.array(
      [  0.3251192 ,   0.64395033,   0.95850562,   1.26960208,
         1.57771263,   1.88315634,   2.18616747,   2.48692752,
         2.78558251,   3.08225325,   5.95702443,   8.69654156,
        11.32668082,  13.86239719,  16.31378114,  18.68824032,
        20.99151433,  23.22822128,  25.40218266,  27.51663094,
        29.57434975,  31.57777282,  33.5290564 ,  35.43013355,
        34.20050254,  33.13150101,  32.15237963,  31.23863743,
        30.37660731,  29.55741232,  28.77479436,  28.02410789,
        27.30178016,  26.60499195,  25.93147455,  25.2793733 ,
        24.64715174,  24.03352179,  23.43739162,  25.94007901,
        28.25103876,  30.44179037,  32.5375838 ,  34.55281498,
        36.49707039,  38.37729914,  40.19881996,  41.96586156,
        43.68188255,  45.34977489,  46.97200093,  48.55068966,
        50.08770698,  51.58470828,  49.96092538,  48.50743959,
        47.15325433,  45.87362973,  44.65466744,  43.48726638,
        42.36495094,  41.28286434,  40.23722852,  39.22502451,
        38.24378923,  37.29147879,  36.36637241,  35.46700242,
        34.592102  ,  33.74056512,  32.9114156 ,  32.10378279,
        31.31688239,  30.55000117,  29.80248479,  29.07372803,
        28.363167  ,  27.67027278,  26.99454634,  26.33551444,
        25.69272626,  25.06575072,  24.4541742 ,  23.85759878,
        23.27564071,  22.70792921,  22.15410538,  21.61382137,
        21.08673968,  20.5725325 ,  20.07088118,  19.5814758 ,
        19.10401475,  18.63820438,  18.18375868,  17.74039901,
        17.30785384,  16.88585849,  16.47415495,  16.07249165,
        15.68062329,  15.29831065,  14.92532042,  14.56142504,
        14.20640258,  13.86003653,  13.5221157 ,  13.19243408,
        12.87079071,  12.55698954])


    z = np.array(
      [ 0.        ,  0.11111111,  0.22222222,  0.33333333,  0.44444444,
        0.55555556,  0.66666667,  0.77777778,  0.88888889,  1.        ])

    por = np.array(
      [[  0.        ,   0.        ,   0.        ],
       [ 12.5344118 ,  12.14329704,   5.47538465],
       [ 21.7012175 ,  23.75366578,  10.78420577],
       [ 28.18367646,  34.36271994,  15.76501349],
       [ 32.61240579,  43.61300476,  20.26641576],
       [ 35.52623862,  51.27539117,  24.15169248],
       [ 37.36067079,  57.23734656,  27.3029355 ],
       [ 38.44529388,  61.47089897,  29.62459264],
       [ 39.00780488,  63.99300166,  31.04631827],
       [ 39.1808269 ,  64.82986319,  31.52505799]])


#    por = 100 * TERZ1D_POR
#    avp = 100 * TERZ1D_AVP
    settle = np.array(
      [  8.21413225e-03,   2.27163394e-02,   4.14943791e-02,
         6.37312486e-02,   8.89540401e-02,   1.16843663e-01,
         1.47165866e-01,   1.79739150e-01,   2.14417490e-01,
         2.51080087e-01,   7.09642240e-01,   1.30345844e+00,
         2.00665252e+00,   2.80426947e+00,   3.68621886e+00,
         4.64509301e+00,   5.67515233e+00,   6.77177872e+00,
         7.93115067e+00,   9.15003572e+00,   1.04256503e+01,
         1.17555605e+01,   1.31376103e+01,   1.45698664e+01,
         1.57994975e+01,   1.68684990e+01,   1.78476204e+01,
         1.87613626e+01,   1.96233927e+01,   2.04425877e+01,
         2.12252056e+01,   2.19758921e+01,   2.26982198e+01,
         2.33950081e+01,   2.40685255e+01,   2.47206267e+01,
         2.53528483e+01,   2.59664782e+01,   2.65626084e+01,
         2.73932543e+01,   2.84156279e+01,   2.95582096e+01,
         3.07957495e+01,   3.21138517e+01,   3.35029296e+01,
         3.49560342e+01,   3.64678467e+01,   3.80341384e+01,
         3.96514508e+01,   4.13168918e+01,   4.30279991e+01,
         4.47826437e+01,   4.65789597e+01,   4.84152917e+01,
         5.00390746e+01,   5.14925604e+01,   5.28467457e+01,
         5.41263703e+01,   5.53453326e+01,   5.65127336e+01,
         5.76350491e+01,   5.87171357e+01,   5.97627715e+01,
         6.07749755e+01,   6.17562108e+01,   6.27085212e+01,
         6.36336276e+01,   6.45329976e+01,   6.54078980e+01,
         6.62594349e+01,   6.70885844e+01,   6.78962172e+01,
         6.86831176e+01,   6.94499988e+01,   7.01975152e+01,
         7.09262720e+01,   7.16368330e+01,   7.23297272e+01,
         7.30054537e+01,   7.36644856e+01,   7.43072737e+01,
         7.49342493e+01,   7.55458258e+01,   7.61424012e+01,
         7.67243593e+01,   7.72920708e+01,   7.78458946e+01,
         7.83861786e+01,   7.89132603e+01,   7.94274675e+01,
         7.99291188e+01,   8.04185242e+01,   8.08959853e+01,
         8.13617956e+01,   8.18162413e+01,   8.22596010e+01,
         8.26921462e+01,   8.31141415e+01,   8.35258450e+01,
         8.39275083e+01,   8.43193767e+01,   8.47016894e+01,
         8.50746796e+01,   8.54385750e+01,   8.57935974e+01,
         8.61399635e+01,   8.64778843e+01,   8.68075659e+01,
         8.71292093e+01,   8.74430105e+01])




    H = 1
#    z  = np.linspace(0, H,40)
#    t = np.linspace(0,1,100)
    kv, kh, ks, kw = (10, 10, 3, 1)
    mv=1
    gamw = 10
    rw, rs, re = (0.03, 0.06, 0.5)
    drn = 1
    surcharge_vs_time = ((0,0.15, 0.3, 0.45,100.0), (0,50,50.0,100.0,100.0))
    tpor = t[np.array([20,60,90])]
    nterms = 20


    por_, avp_, settle_ = tangandonitsuka2000(z=z, t=t, kv=kv, kh=kh, ks=ks, kw=kw, mv=mv, gamw=gamw, rw=rw, rs=rs, re=re, H=H,
                       drn=drn, surcharge_vs_time=surcharge_vs_time,
                       tpor=tpor, nterms=nterms)



#    plt.figure()
#    plt.plot(por, z,'b-*', label='expected')
#    plt.plot(por_, z, 'r-+', label='calculated')
#    plt.legend()
#
#    plt.figure()
#    plt.plot(t,settle,'b-*', label='expected')
#    plt.plot(t, settle_, 'r-+', label='calculated')
#    plt.legend()
#
#    plt.figure()
#    plt.plot(t, avp,'b-*',  label='expected')
#    plt.plot(t, avp_, 'r-+', label='calculated')
#    plt.legend()
#    plt.show()

    assert_allclose(avp_, avp, atol=1e-3,
                    err_msg = ("Fail. test_tang_and_onitsuka_well_resistance, avp, "
                        ))
    assert_allclose(por_, por, atol=1e-2,
                    err_msg = ("Fail. test_tang_and_onitsuka_well_resistance, por, "
                        ))
    assert_allclose(settle_, settle, atol=1e-3,
                    err_msg = ("Fail. test_tang_and_onitsuka_well_resistance, settle, "
                        ))



if __name__ == '__main__':
    import nose
    nose.runmodule(argv=['nose', '--verbosity=3', '--with-doctest'])
#    nose.runmodule(argv=['nose', '--verbosity=3'])

#    test_tang_and_onitsuka_one()
#    test_tang_and_onitsuka_well_resistance()