/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import py4j.NetworkUtil;

public class EchoServer {
    public static final int TEST_PORT = 25332;
    public static final int SERVER_PORT = 25333;
    private int testPort = 25332;
    private int serverPort = 25333;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    public int getTestPort() {
        return this.testPort;
    }

    public void setTestPort(int testPort) {
        this.testPort = testPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    private void setupTestServer() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSocket sSocket = null;
                Socket testSocket = null;
                try {
                    sSocket = new ServerSocket(EchoServer.this.testPort);
                    testSocket = sSocket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(testSocket.getInputStream(), Charset.forName("UTF-8")));
                    while (true) {
                        System.out.println("Waiting for echo input.");
                        String command = reader.readLine();
                        System.out.println("Echo received: " + command);
                        if (command == null) break;
                        EchoServer.this.queue.put(command);
                    }
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        NetworkUtil.quietlyClose(testSocket);
                        NetworkUtil.quietlyClose(sSocket);
                        throw throwable;
                    }
                    NetworkUtil.quietlyClose(testSocket);
                    NetworkUtil.quietlyClose(sSocket);
                }
                NetworkUtil.quietlyClose(testSocket);
                NetworkUtil.quietlyClose(sSocket);
            }
        });
        t.start();
    }

    private void setupServer() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSocket sSocket = null;
                Socket clientSocket = null;
                try {
                    String command;
                    sSocket = new ServerSocket(EchoServer.this.serverPort);
                    clientSocket = sSocket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), Charset.forName("UTF-8")));
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream(), Charset.forName("UTF-8")));
                    while ((command = this.readCommand(reader)) != null) {
                        String returnCommand = (String)EchoServer.this.queue.poll();
                        System.out.println(returnCommand);
                        writer.write(returnCommand);
                        writer.flush();
                    }
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        NetworkUtil.quietlyClose(clientSocket);
                        NetworkUtil.quietlyClose(sSocket);
                        throw throwable;
                    }
                    NetworkUtil.quietlyClose(clientSocket);
                    NetworkUtil.quietlyClose(sSocket);
                }
                NetworkUtil.quietlyClose(clientSocket);
                NetworkUtil.quietlyClose(sSocket);
            }

            private String readCommand(BufferedReader reader) throws IOException {
                String command;
                String temp;
                System.out.println("Reading commands");
                StringBuilder commandBuilder = new StringBuilder();
                do {
                    temp = reader.readLine();
                    System.out.println("Received temp: " + temp);
                    if (temp == null) break;
                    commandBuilder.append(temp);
                    commandBuilder.append("\n");
                } while (!temp.trim().equals("e"));
                if ((command = commandBuilder.toString().trim()).length() == 0) {
                    command = null;
                }
                return command;
            }
        });
        t.start();
    }

    public static void main(String[] args) {
        EchoServer echoServer = new EchoServer();
        echoServer.setupTestServer();
        echoServer.setupServer();
        System.out.println("EchoServer started...");
    }
}

