


from pydentify import *



'''
This script shows you how to run a profile likelihood 
calculation using copasi and pydentify from the parameters
that are already in the model file. 

You should have already performed optimization using the GUI. In this 
example, this is already done.  

'''

#replace with the vilar_fit path on your own machine. Note the r at the begining of the string to remove escape characters
copasi_file=r'D:\MPhil\Model_Building\Models\Exercises\pydentify_examples\Vilar2006\Vilar_example\ProfileLikelihoodFromCurrentParmeters\Vilar2006.cps'
RSS_value=578.828 # RSS value from first optimization using the GUI. Needed later for calcualtion of confidence intervals

#initialize profile likelihood
PL=ProfileLikelihood(copasi_file,lb=4,ub=4,intervals=10)
#run
#PL.run('slow')
#plot
p=Plot(copasi_file,RSS_value)
p.plot_all(savefig=True,fontsize=28,axis_size=25)

#look more closely at a single plot
p.plot1('R2',ylimit=[0,20000],xlimit=[50,300])

#save with different names. Other keyword arguments available in technical doumentation




































