# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerServiceMasterProfile(Model):
    """
    Profile for container service master

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param count: Number of masters (VMs) in the container cluster
    :type count: int
    :param dns_prefix: DNS prefix to be used to create FQDN for master
    :type dns_prefix: str
    :ivar fqdn: FDQN for the master
    :vartype fqdn: str
    """ 

    _validation = {
        'dns_prefix': {'required': True},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(self, dns_prefix, count=None):
        self.count = count
        self.dns_prefix = dns_prefix
        self.fqdn = None
