//! Swift Demangling Tests
//! All functions were compiled with Swift 4.0 in a file called mangling.swift
//! see https://github.com/apple/swift/blob/master/test/SILGen/mangling.swift
#![cfg(feature = "swift")]

#[macro_use]
mod utils;

use symbolic_common::Language;
use symbolic_demangle::DemangleOptions;

#[test]
fn test_demangle_swift_short() {
    assert_demangle!(Language::Swift, DemangleOptions::name_only().parameters(true), {
        // Swift < 4 (old mangling)
        "_T08mangling0022egbpdajGbuEbxfgehfvwxnyyF" => "ليهمابتكلموشعربي؟()",
        "_T08mangling0024ihqwcrbEcvIaIdqgAFGpqjyeyyF" => "他们为什么不说中文()",
        "_T08mangling0027ihqwctvzcJBfGFJdrssDxIboAybyyF" => "他們爲什麽不說中文()",
        "_T08mangling0030Proprostnemluvesky_uybCEdmaEBayyF" => "Pročprostěnemluvíčesky()",
        "_T08mangling9r13757744ySaySiG1x_tF" => "r13757744(x: [Int])",
        "_T08mangling9r13757744ySi1xd_tF" => "r13757744(x: Int...)",
        "_T08mangling2psopyxlF" => "+- prefix<A>(A)",
        "_T08mangling2psoPyxlF" => "+- postfix<A>(A)",
        "_T08mangling2psoiyx_xtlF" => "+- infix<A>(A, A)",
        "_T08mangling2psopyx1a_x1bt_tlF" => "+- prefix<A>((a: A, b: A))",
        "_T08mangling2psoPyx1a_x1bt_tlF" => "+- postfix<A>((a: A, b: A))",
        "_T08mangling007p_qcaDcoiS2i_SitF" => "«+» infix(Int, Int)",
        "_T08mangling12any_protocolyypF" => "any_protocol(Any)",
        "_T08mangling12one_protocolyAA3Foo_pF" => "one_protocol(Foo)",
        "_T08mangling18one_protocol_twiceyAA3Foo_p_AaC_ptF" => "one_protocol_twice(Foo, Foo)",
        "_T08mangling12two_protocolyAA3Bar_AA3FoopF" => "two_protocol(Bar & Foo)",
        "_T08mangling3ZimC4zangyx_qd__tlF" => "Zim.zang<A>(A, A1)",
        "_T08mangling3ZimC4zungyqd___xtlF" => "Zim.zung<A>(A1, A)",
        "_T08mangling27single_protocol_compositionyAA3Foo_p1x_tF" => "single_protocol_composition(x: Foo)",
        "_T08mangling28uses_objc_class_and_protocolySo8NSObjectC1o_So8NSAnsing_p1ptF" => "uses_objc_class_and_protocol(o: NSObject, p: NSAnsing)",
        "_T08mangling17uses_clang_structySC6NSRectV1r_tF" => "uses_clang_struct(r: NSRect)",
        "_T08mangling14uses_optionalss7UnicodeO6ScalarVSgSiSg1x_tF" => "uses_optionals(x: Int?)",
        "_T08mangling12GenericUnionO3FooACyxGSicAEmlF" => "GenericUnion.Foo<A>(GenericUnion<A>.Type)",
        "_T08mangling10HasVarInitV5stateSbvpZfiSbyKXKfu_" => "implicit closure #1 in variable initialization expression of static HasVarInit.state",
        "_T08mangling19autoClosureOverloadySiyXK1f_tF" => "autoClosureOverload(f: @autoclosure ())",
        "_T08mangling19autoClosureOverloadySiyc1f_tF" => "autoClosureOverload(f: ())",
        "_T08mangling24autoClosureOverloadCallsyyF" => "autoClosureOverloadCalls()",
        "_T08mangling4fooAyxAA12HasAssocTypeRzlF" => "fooA<A>(A)",
        "_T08mangling4fooByxAA12HasAssocTypeRzAA0D4Reqt0D0RpzlF" => "fooB<A>(A)",
        "_T08mangling2qqoiySi_SitF" => "?? infix(Int, Int)",
        "_T08mangling24InstanceAndClassPropertyV8propertySivg" => "InstanceAndClassProperty.property.getter",
        "_T08mangling24InstanceAndClassPropertyV8propertySivs" => "InstanceAndClassProperty.property.setter",
        "_T08mangling24InstanceAndClassPropertyV8propertySivgZ" => "static InstanceAndClassProperty.property.getter",
        "_T08mangling24InstanceAndClassPropertyV8propertySivsZ" => "static InstanceAndClassProperty.property.setter",
        "_T08mangling6curry1yyF" => "curry1()",
        "_T08mangling3barSiyKF" => "bar()",
        "_T08mangling12curry1ThrowsyyKF" => "curry1Throws()",
        "_T08mangling12curry2ThrowsyycyKF" => "curry2Throws()",
        "_T08mangling6curry3yyKcyF" => "curry3()",
        "_T08mangling12curry3ThrowsyyKcyKF" => "curry3Throws()",
        "_T08mangling14varargsVsArrayySi3arrd_SS1ntF" => "varargsVsArray(arr: Int..., n: String)",
        "_T08mangling14varargsVsArrayySaySiG3arr_SS1ntF" => "varargsVsArray(arr: [Int], n: String)",
        "_T08mangling14varargsVsArrayySaySiG3arrd_SS1ntF" => "varargsVsArray(arr: [Int]..., n: String)",

        // Swift 4.2
        "$S8mangling0022egbpdajGbuEbxfgehfvwxnyyF" => "ليهمابتكلموشعربي؟()",
        "$S8mangling0024ihqwcrbEcvIaIdqgAFGpqjyeyyF" => "他们为什么不说中文()",
        "$S8mangling0027ihqwctvzcJBfGFJdrssDxIboAybyyF" => "他們爲什麽不說中文()",
        "$S8mangling0030Proprostnemluvesky_uybCEdmaEBayyF" => "Pročprostěnemluvíčesky()",
        "$S8mangling9r137577441xySaySiG_tF" => "r13757744(x: [Int])",
        "$S8mangling9r137577441xySid_tF" => "r13757744(x: Int...)",
        "$S8mangling2psopyyxlF" => "+- prefix<A>(A)",
        "$S8mangling2psoPyyxlF" => "+- postfix<A>(A)",
        "$S8mangling2psoiyyx_xtlF" => "+- infix<A>(A, A)",
        "$S8mangling2psopyyx1a_x1bt_tlF" => "+- prefix<A>((a: A, b: A))",
        "$S8mangling2psoPyyx1a_x1bt_tlF" => "+- postfix<A>((a: A, b: A))",
        "$S8mangling007p_qcaDcoiyS2i_SitF" => "«+» infix(Int, Int)",
        "$S8mangling12any_protocolyyypF" => "any_protocol(Any)",
        "$S8mangling12one_protocolyyAA3Foo_pF" => "one_protocol(Foo)",
        "$S8mangling18one_protocol_twiceyyAA3Foo_p_AaC_ptF" => "one_protocol_twice(Foo, Foo)",
        "$S8mangling12two_protocolyyAA3Bar_AA3FoopF" => "two_protocol(Bar & Foo)",
        "$S8mangling3ZimC4zangyyx_qd__tlF" => "Zim.zang<A>(A, A1)",
        "$S8mangling3ZimC4zungyyqd___xtlF" => "Zim.zung<A>(A1, A)",
        "$S8mangling28uses_objc_class_and_protocol1o1p2p2ySo8NSObjectC_So8NSAnsing_pSo14NSBetterAnsing_ptF" => "uses_objc_class_and_protocol(o: NSObject, p: NSAnsing, p2: NSBetterAnsing)",
        "$S8mangling17uses_clang_struct1rySo6NSRectV_tF" => "uses_clang_struct(r: NSRect)",
        "$S8mangling14uses_optionals1xs7UnicodeO6ScalarVSgSiSg_tF" => "uses_optionals(x: Int?)",
        "$S8mangling12GenericUnionO3FooyACyxGSicAEmlF" => "GenericUnion.Foo<A>(GenericUnion<A>.Type)",
        "$S8mangling10HasVarInitV5stateSbvpZfiSbyKXKfu_" => "implicit closure #1 in variable initialization expression of static HasVarInit.state",
        "$S8mangling19autoClosureOverload1fySiyXK_tF" => "autoClosureOverload(f: @autoclosure ())",
        "$S8mangling19autoClosureOverload1fySiyXE_tF" => "autoClosureOverload(f: ())",
        "$S8mangling24autoClosureOverloadCallsyyF" => "autoClosureOverloadCalls()",
        "$S8mangling4fooAyyxAA12HasAssocTypeRzlF" => "fooA<A>(A)",
        "$S8mangling4fooByyxAA12HasAssocTypeRzAA0D4Reqt0D0RpzlF" => "fooB<A>(A)",
        "$S8mangling2qqoiyySi_SitF" => "?? infix(Int, Int)",
        "$S8mangling24InstanceAndClassPropertyV8propertySivg" => "InstanceAndClassProperty.property.getter",
        "$S8mangling24InstanceAndClassPropertyV8propertySivs" => "InstanceAndClassProperty.property.setter",
        "$S8mangling24InstanceAndClassPropertyV8propertySivgZ" => "static InstanceAndClassProperty.property.getter",
        "$S8mangling24InstanceAndClassPropertyV8propertySivsZ" => "static InstanceAndClassProperty.property.setter",
        "$S8mangling6curry1yyF" => "curry1()",
        "$S8mangling3barSiyKF" => "bar()",
        "$S8mangling12curry1ThrowsyyKF" => "curry1Throws()",
        "$S8mangling12curry2ThrowsyycyKF" => "curry2Throws()",
        "$S8mangling6curry3yyKcyF" => "curry3()",
        "$S8mangling12curry3ThrowsyyKcyKF" => "curry3Throws()",
        "$S8mangling14varargsVsArray3arr1nySid_SStF" => "varargsVsArray(arr: Int..., n: String)",
        "$S8mangling14varargsVsArray3arr1nySaySiG_SStF" => "varargsVsArray(arr: [Int], n: String)",
        "$S8mangling14varargsVsArray3arr1nySaySiGd_SStF" => "varargsVsArray(arr: [Int]..., n: String)",

        // Swift 5
        "$s8mangling0022egbpdajGbuEbxfgehfvwxnyyF" => "ليهمابتكلموشعربي؟()",
        "$s8mangling0024ihqwcrbEcvIaIdqgAFGpqjyeyyF" => "他们为什么不说中文()",
        "$s8mangling0027ihqwctvzcJBfGFJdrssDxIboAybyyF" => "他們爲什麽不說中文()",
        "$s8mangling0030Proprostnemluvesky_uybCEdmaEBayyF" => "Pročprostěnemluvíčesky()",
        "$s8mangling9r137577441xySaySiG_tF" => "r13757744(x: [Int])",
        "$s8mangling9r137577441xySid_tF" => "r13757744(x: Int...)",
        "$s8mangling2psopyyxlF" => "+- prefix<A>(A)",
        "$s8mangling2psoPyyxlF" => "+- postfix<A>(A)",
        "$s8mangling2psoiyyx_xtlF" => "+- infix<A>(A, A)",
        "$s8mangling2psopyyx1a_x1bt_tlF" => "+- prefix<A>((a: A, b: A))",
        "$s8mangling2psoPyyx1a_x1bt_tlF" => "+- postfix<A>((a: A, b: A))",
        "$s8mangling007p_qcaDcoiyS2i_SitF" => "«+» infix(Int, Int)",
        "$s8mangling12any_protocolyyypF" => "any_protocol(Any)",
        "$s8mangling12one_protocolyyAA3Foo_pF" => "one_protocol(Foo)",
        "$s8mangling18one_protocol_twiceyyAA3Foo_p_AaC_ptF" => "one_protocol_twice(Foo, Foo)",
        "$s8mangling12two_protocolyyAA3Bar_AA3FoopF" => "two_protocol(Bar & Foo)",
        "$s8mangling3ZimC4zangyyx_qd__tlF" => "Zim.zang<A>(A, A1)",
        "$s8mangling3ZimC4zungyyqd___xtlF" => "Zim.zung<A>(A1, A)",
        "$s8mangling28uses_objc_class_and_protocol1o1p2p2ySo8NSObjectC_So8NSAnsing_pSo14NSBetterAnsing_ptF" => "uses_objc_class_and_protocol(o: NSObject, p: NSAnsing, p2: NSBetterAnsing)",
        "$s8mangling17uses_clang_struct1rySo6NSRectV_tF" => "uses_clang_struct(r: NSRect)",
        "$s8mangling14uses_optionals1xs7UnicodeO6ScalarVSgSiSg_tF" => "uses_optionals(x: Int?)",
        "$s8mangling12GenericUnionO3FooyACyxGSicAEmlF" => "GenericUnion.Foo<A>(GenericUnion<A>.Type)",
        "$s8mangling10HasVarInitV5stateSbvpZfiSbyKXKfu_" => "implicit closure #1 in variable initialization expression of static HasVarInit.state",
        "$s8mangling19autoClosureOverload1fySiyXK_tF" => "autoClosureOverload(f: @autoclosure ())",
        "$s8mangling19autoClosureOverload1fySiyXE_tF" => "autoClosureOverload(f: ())",
        "$s8mangling24autoClosureOverloadCallsyyF" => "autoClosureOverloadCalls()",
        "$s8mangling4fooAyyxAA12HasAssocTypeRzlF" => "fooA<A>(A)",
        "$s8mangling4fooByyxAA12HasAssocTypeRzAA0D4Reqt0D0RpzlF" => "fooB<A>(A)",
        "$s8mangling2qqoiyySi_SitF" => "?? infix(Int, Int)",
        "$s8mangling24InstanceAndClassPropertyV8propertySivg" => "InstanceAndClassProperty.property.getter",
        "$s8mangling24InstanceAndClassPropertyV8propertySivs" => "InstanceAndClassProperty.property.setter",
        "$s8mangling24InstanceAndClassPropertyV8propertySivgZ" => "static InstanceAndClassProperty.property.getter",
        "$s8mangling24InstanceAndClassPropertyV8propertySivsZ" => "static InstanceAndClassProperty.property.setter",
        "$s8mangling6curry1yyF" => "curry1()",
        "$s8mangling3barSiyKF" => "bar()",
        "$s8mangling12curry1ThrowsyyKF" => "curry1Throws()",
        "$s8mangling12curry2ThrowsyycyKF" => "curry2Throws()",
        "$s8mangling6curry3yyKcyF" => "curry3()",
        "$s8mangling12curry3ThrowsyyKcyKF" => "curry3Throws()",
        "$s8mangling14varargsVsArray3arr1nySid_SStF" => "varargsVsArray(arr: Int..., n: String)",
        "$s8mangling14varargsVsArray3arr1nySaySiG_SStF" => "varargsVsArray(arr: [Int], n: String)",
        "$s8mangling14varargsVsArray3arr1nySaySiGd_SStF" => "varargsVsArray(arr: [Int]..., n: String)",

        // Swift 5.2
        "$s7ranking22propertyVersusFunctionyyAA1P_p_xtAaCRzlFyAaC_pcAaC_pcfu_" => "implicit closure #1 (P) in propertyVersusFunction<A>(P, A)",
    });
}

#[test]
fn test_demangle_swift_no_args() {
    assert_demangle!(Language::Swift, DemangleOptions::name_only(), {
        // Swift < 4 (old mangling)
        "_T08mangling0022egbpdajGbuEbxfgehfvwxnyyF" => "ليهمابتكلموشعربي؟",
        "_T08mangling0024ihqwcrbEcvIaIdqgAFGpqjyeyyF" => "他们为什么不说中文",
        "_T08mangling0027ihqwctvzcJBfGFJdrssDxIboAybyyF" => "他們爲什麽不說中文",
        "_T08mangling0030Proprostnemluvesky_uybCEdmaEBayyF" => "Pročprostěnemluvíčesky",
        "_T08mangling9r13757744ySaySiG1x_tF" => "r13757744",
        "_T08mangling9r13757744ySi1xd_tF" => "r13757744",
        "_T08mangling2psopyxlF" => "+- prefix<A>",
        "_T08mangling2psoPyxlF" => "+- postfix<A>",
        "_T08mangling2psoiyx_xtlF" => "+- infix<A>",
        "_T08mangling2psopyx1a_x1bt_tlF" => "+- prefix<A>",
        "_T08mangling2psoPyx1a_x1bt_tlF" => "+- postfix<A>",
        "_T08mangling007p_qcaDcoiS2i_SitF" => "«+» infix",
        "_T08mangling12any_protocolyypF" => "any_protocol",
        "_T08mangling12one_protocolyAA3Foo_pF" => "one_protocol",
        "_T08mangling18one_protocol_twiceyAA3Foo_p_AaC_ptF" => "one_protocol_twice",
        "_T08mangling12two_protocolyAA3Bar_AA3FoopF" => "two_protocol",
        "_T08mangling3ZimC4zangyx_qd__tlF" => "Zim.zang<A>",
        "_T08mangling3ZimC4zungyqd___xtlF" => "Zim.zung<A>",
        "_T08mangling27single_protocol_compositionyAA3Foo_p1x_tF" => "single_protocol_composition",
        "_T08mangling28uses_objc_class_and_protocolySo8NSObjectC1o_So8NSAnsing_p1ptF" => "uses_objc_class_and_protocol",
        "_T08mangling17uses_clang_structySC6NSRectV1r_tF" => "uses_clang_struct",
        "_T08mangling14uses_optionalss7UnicodeO6ScalarVSgSiSg1x_tF" => "uses_optionals",
        "_T08mangling12GenericUnionO3FooACyxGSicAEmlF" => "GenericUnion.Foo<A>",
        "_T08mangling10HasVarInitV5stateSbvpZfiSbyKXKfu_" => "implicit closure #1 in variable initialization expression of static HasVarInit.state",
        "_T08mangling19autoClosureOverloadySiyXK1f_tF" => "autoClosureOverload",
        "_T08mangling19autoClosureOverloadySiyc1f_tF" => "autoClosureOverload",
        "_T08mangling24autoClosureOverloadCallsyyF" => "autoClosureOverloadCalls",
        "_T08mangling4fooAyxAA12HasAssocTypeRzlF" => "fooA<A>",
        "_T08mangling4fooByxAA12HasAssocTypeRzAA0D4Reqt0D0RpzlF" => "fooB<A>",
        "_T08mangling2qqoiySi_SitF" => "?? infix",
        "_T08mangling24InstanceAndClassPropertyV8propertySivg" => "InstanceAndClassProperty.property.getter",
        "_T08mangling24InstanceAndClassPropertyV8propertySivs" => "InstanceAndClassProperty.property.setter",
        "_T08mangling24InstanceAndClassPropertyV8propertySivgZ" => "static InstanceAndClassProperty.property.getter",
        "_T08mangling24InstanceAndClassPropertyV8propertySivsZ" => "static InstanceAndClassProperty.property.setter",
        "_T08mangling6curry1yyF" => "curry1",
        "_T08mangling3barSiyKF" => "bar",
        "_T08mangling12curry1ThrowsyyKF" => "curry1Throws",
        "_T08mangling12curry2ThrowsyycyKF" => "curry2Throws",
        "_T08mangling6curry3yyKcyF" => "curry3",
        "_T08mangling12curry3ThrowsyyKcyKF" => "curry3Throws",
        "_T08mangling14varargsVsArrayySi3arrd_SS1ntF" => "varargsVsArray",
        "_T08mangling14varargsVsArrayySaySiG3arr_SS1ntF" => "varargsVsArray",
        "_T08mangling14varargsVsArrayySaySiG3arrd_SS1ntF" => "varargsVsArray",

        // Swift 4.2
        "$S8mangling0022egbpdajGbuEbxfgehfvwxnyyF" => "ليهمابتكلموشعربي؟",
        "$S8mangling0024ihqwcrbEcvIaIdqgAFGpqjyeyyF" => "他们为什么不说中文",
        "$S8mangling0027ihqwctvzcJBfGFJdrssDxIboAybyyF" => "他們爲什麽不說中文",
        "$S8mangling0030Proprostnemluvesky_uybCEdmaEBayyF" => "Pročprostěnemluvíčesky",
        "$S8mangling9r137577441xySaySiG_tF" => "r13757744",
        "$S8mangling9r137577441xySid_tF" => "r13757744",
        "$S8mangling2psopyyxlF" => "+- prefix<A>",
        "$S8mangling2psoPyyxlF" => "+- postfix<A>",
        "$S8mangling2psoiyyx_xtlF" => "+- infix<A>",
        "$S8mangling2psopyyx1a_x1bt_tlF" => "+- prefix<A>",
        "$S8mangling2psoPyyx1a_x1bt_tlF" => "+- postfix<A>",
        "$S8mangling007p_qcaDcoiyS2i_SitF" => "«+» infix",
        "$S8mangling12any_protocolyyypF" => "any_protocol",
        "$S8mangling12one_protocolyyAA3Foo_pF" => "one_protocol",
        "$S8mangling18one_protocol_twiceyyAA3Foo_p_AaC_ptF" => "one_protocol_twice",
        "$S8mangling12two_protocolyyAA3Bar_AA3FoopF" => "two_protocol",
        "$S8mangling3ZimC4zangyyx_qd__tlF" => "Zim.zang<A>",
        "$S8mangling3ZimC4zungyyqd___xtlF" => "Zim.zung<A>",
        "$S8mangling28uses_objc_class_and_protocol1o1p2p2ySo8NSObjectC_So8NSAnsing_pSo14NSBetterAnsing_ptF" => "uses_objc_class_and_protocol",
        "$S8mangling17uses_clang_struct1rySo6NSRectV_tF" => "uses_clang_struct",
        "$S8mangling14uses_optionals1xs7UnicodeO6ScalarVSgSiSg_tF" => "uses_optionals",
        "$S8mangling12GenericUnionO3FooyACyxGSicAEmlF" => "GenericUnion.Foo<A>",
        "$S8mangling10HasVarInitV5stateSbvpZfiSbyKXKfu_" => "implicit closure #1 in variable initialization expression of static HasVarInit.state",
        "$S8mangling19autoClosureOverload1fySiyXK_tF" => "autoClosureOverload",
        "$S8mangling19autoClosureOverload1fySiyXE_tF" => "autoClosureOverload",
        "$S8mangling24autoClosureOverloadCallsyyF" => "autoClosureOverloadCalls",
        "$S8mangling4fooAyyxAA12HasAssocTypeRzlF" => "fooA<A>",
        "$S8mangling4fooByyxAA12HasAssocTypeRzAA0D4Reqt0D0RpzlF" => "fooB<A>",
        "$S8mangling2qqoiyySi_SitF" => "?? infix",
        "$S8mangling24InstanceAndClassPropertyV8propertySivg" => "InstanceAndClassProperty.property.getter",
        "$S8mangling24InstanceAndClassPropertyV8propertySivs" => "InstanceAndClassProperty.property.setter",
        "$S8mangling24InstanceAndClassPropertyV8propertySivgZ" => "static InstanceAndClassProperty.property.getter",
        "$S8mangling24InstanceAndClassPropertyV8propertySivsZ" => "static InstanceAndClassProperty.property.setter",
        "$S8mangling6curry1yyF" => "curry1",
        "$S8mangling3barSiyKF" => "bar",
        "$S8mangling12curry1ThrowsyyKF" => "curry1Throws",
        "$S8mangling12curry2ThrowsyycyKF" => "curry2Throws",
        "$S8mangling6curry3yyKcyF" => "curry3",
        "$S8mangling12curry3ThrowsyyKcyKF" => "curry3Throws",
        "$S8mangling14varargsVsArray3arr1nySid_SStF" => "varargsVsArray",
        "$S8mangling14varargsVsArray3arr1nySaySiG_SStF" => "varargsVsArray",
        "$S8mangling14varargsVsArray3arr1nySaySiGd_SStF" => "varargsVsArray",

        // Swift 5
        "$s8mangling0022egbpdajGbuEbxfgehfvwxnyyF" => "ليهمابتكلموشعربي؟",
        "$s8mangling0024ihqwcrbEcvIaIdqgAFGpqjyeyyF" => "他们为什么不说中文",
        "$s8mangling0027ihqwctvzcJBfGFJdrssDxIboAybyyF" => "他們爲什麽不說中文",
        "$s8mangling0030Proprostnemluvesky_uybCEdmaEBayyF" => "Pročprostěnemluvíčesky",
        "$s8mangling9r137577441xySaySiG_tF" => "r13757744",
        "$s8mangling9r137577441xySid_tF" => "r13757744",
        "$s8mangling2psopyyxlF" => "+- prefix<A>",
        "$s8mangling2psoPyyxlF" => "+- postfix<A>",
        "$s8mangling2psoiyyx_xtlF" => "+- infix<A>",
        "$s8mangling2psopyyx1a_x1bt_tlF" => "+- prefix<A>",
        "$s8mangling2psoPyyx1a_x1bt_tlF" => "+- postfix<A>",
        "$s8mangling007p_qcaDcoiyS2i_SitF" => "«+» infix",
        "$s8mangling12any_protocolyyypF" => "any_protocol",
        "$s8mangling12one_protocolyyAA3Foo_pF" => "one_protocol",
        "$s8mangling18one_protocol_twiceyyAA3Foo_p_AaC_ptF" => "one_protocol_twice",
        "$s8mangling12two_protocolyyAA3Bar_AA3FoopF" => "two_protocol",
        "$s8mangling3ZimC4zangyyx_qd__tlF" => "Zim.zang<A>",
        "$s8mangling3ZimC4zungyyqd___xtlF" => "Zim.zung<A>",
        "$s8mangling28uses_objc_class_and_protocol1o1p2p2ySo8NSObjectC_So8NSAnsing_pSo14NSBetterAnsing_ptF" => "uses_objc_class_and_protocol",
        "$s8mangling17uses_clang_struct1rySo6NSRectV_tF" => "uses_clang_struct",
        "$s8mangling14uses_optionals1xs7UnicodeO6ScalarVSgSiSg_tF" => "uses_optionals",
        "$s8mangling12GenericUnionO3FooyACyxGSicAEmlF" => "GenericUnion.Foo<A>",
        "$s8mangling10HasVarInitV5stateSbvpZfiSbyKXKfu_" => "implicit closure #1 in variable initialization expression of static HasVarInit.state",
        "$s8mangling19autoClosureOverload1fySiyXK_tF" => "autoClosureOverload",
        "$s8mangling19autoClosureOverload1fySiyXE_tF" => "autoClosureOverload",
        "$s8mangling24autoClosureOverloadCallsyyF" => "autoClosureOverloadCalls",
        "$s8mangling4fooAyyxAA12HasAssocTypeRzlF" => "fooA<A>",
        "$s8mangling4fooByyxAA12HasAssocTypeRzAA0D4Reqt0D0RpzlF" => "fooB<A>",
        "$s8mangling2qqoiyySi_SitF" => "?? infix",
        "$s8mangling24InstanceAndClassPropertyV8propertySivg" => "InstanceAndClassProperty.property.getter",
        "$s8mangling24InstanceAndClassPropertyV8propertySivs" => "InstanceAndClassProperty.property.setter",
        "$s8mangling24InstanceAndClassPropertyV8propertySivgZ" => "static InstanceAndClassProperty.property.getter",
        "$s8mangling24InstanceAndClassPropertyV8propertySivsZ" => "static InstanceAndClassProperty.property.setter",
        "$s8mangling6curry1yyF" => "curry1",
        "$s8mangling3barSiyKF" => "bar",
        "$s8mangling12curry1ThrowsyyKF" => "curry1Throws",
        "$s8mangling12curry2ThrowsyycyKF" => "curry2Throws",
        "$s8mangling6curry3yyKcyF" => "curry3",
        "$s8mangling12curry3ThrowsyyKcyKF" => "curry3Throws",
        "$s8mangling14varargsVsArray3arr1nySid_SStF" => "varargsVsArray",
        "$s8mangling14varargsVsArray3arr1nySaySiG_SStF" => "varargsVsArray",
        "$s8mangling14varargsVsArray3arr1nySaySiGd_SStF" => "varargsVsArray",

        // Swift 5.2
        "$s7ranking22propertyVersusFunctionyyAA1P_p_xtAaCRzlFyAaC_pcAaC_pcfu_" => "implicit closure #1 in propertyVersusFunction<A>",

        // Swift 5.5.1
        "$s10Speediness17NetworkQualityCLIO3run10sequentialAC6ResultVSb_tYaKFZTf4nd_nTQ0_" => "(1) await resume partial function for specialized static NetworkQualityCLI.run",
    });
}
