# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-08-09 17:25
from __future__ import unicode_literals

import django.core.validators
import django.db.models.deletion
import kolibri.content.models
from django.db import migrations, models

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('kolibriauth', '0001_initial_redone'),
    ]

    operations = [
        migrations.CreateModel(
            name='ContentRatingLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_id', kolibri.content.models.UUIDField(db_index=True)),
                ('channel_id', kolibri.content.models.UUIDField()),
                ('quality', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)])),
                ('ease', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)])),
                ('learning', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)])),
                ('feedback', models.TextField(blank=True)),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityDataset')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityUser')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContentSessionLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_id', kolibri.content.models.UUIDField(db_index=True)),
                ('channel_id', kolibri.content.models.UUIDField()),
                ('start_timestamp', models.DateTimeField()),
                ('end_timestamp', models.DateTimeField(blank=True, null=True)),
                ('time_spent', models.FloatField(default=0.0, help_text='(in seconds)', validators=[django.core.validators.MinValueValidator(0)])),
                ('progress', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('kind', models.CharField(max_length=200)),
                ('extra_fields', models.TextField(default='{}')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityDataset')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityUser')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContentSummaryLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_id', kolibri.content.models.UUIDField(db_index=True)),
                ('channel_id', kolibri.content.models.UUIDField()),
                ('start_timestamp', models.DateTimeField()),
                ('end_timestamp', models.DateTimeField(blank=True, null=True)),
                ('completion_timestamp', models.DateTimeField(blank=True, null=True)),
                ('time_spent', models.FloatField(default=0.0, help_text='(in seconds)', validators=[django.core.validators.MinValueValidator(0)])),
                ('progress', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])),
                ('kind', models.CharField(max_length=200)),
                ('extra_fields', models.TextField(default='{}')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityDataset')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityUser')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserSessionLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('channels', models.TextField(blank=True)),
                ('start_timestamp', models.DateTimeField(auto_now_add=True)),
                ('completion_timestamp', models.DateTimeField(blank=True, null=True)),
                ('pages', models.TextField(blank=True)),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityDataset')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityUser')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
