# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-08-15 22:54
from __future__ import unicode_literals

from django.db import migrations, models
import django.utils.timezone
import picklefield.fields


class Migration(migrations.Migration):

    replaces = [('django_q', '0001_squashed_0010_task_progress_fraction'), ('django_q', '0002_auto_20160815_2248')]

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Schedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('func', models.CharField(help_text='e.g. module.tasks.function', max_length=256)),
                ('hook', models.CharField(blank=True, help_text='e.g. module.tasks.result_function', max_length=256, null=True)),
                ('args', models.TextField(blank=True, help_text="e.g. 1, 2, 'John'", null=True)),
                ('kwargs', models.TextField(blank=True, help_text="e.g. x=1, y=2, name='John'", null=True)),
                ('schedule_type', models.CharField(choices=[('O', 'Once'), ('H', 'Hourly'), ('D', 'Daily'), ('W', 'Weekly'), ('M', 'Monthly'), ('Q', 'Quarterly'), ('Y', 'Yearly')], default='O', max_length=1, verbose_name='Schedule Type')),
                ('repeats', models.SmallIntegerField(default=-1, help_text='n = n times, -1 = forever', verbose_name='Repeats')),
                ('next_run', models.DateTimeField(default=django.utils.timezone.now, null=True, verbose_name='Next Run')),
                ('task', models.CharField(editable=False, max_length=100, null=True)),
            ],
            options={
                'verbose_name': 'Scheduled task',
                'ordering': ['next_run'],
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(editable=False, max_length=100)),
                ('func', models.CharField(max_length=256)),
                ('hook', models.CharField(max_length=256, null=True)),
                ('args', picklefield.fields.PickledObjectField(editable=False, null=True)),
                ('kwargs', picklefield.fields.PickledObjectField(editable=False, null=True)),
                ('result', picklefield.fields.PickledObjectField(editable=False, null=True)),
                ('started', models.DateTimeField(editable=False)),
                ('stopped', models.DateTimeField(editable=False)),
                ('success', models.BooleanField(default=True, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Failure',
            fields=[
            ],
            options={
                'verbose_name': 'Failed task',
                'proxy': True,
            },
            bases=('django_q.task',),
        ),
        migrations.CreateModel(
            name='Success',
            fields=[
            ],
            options={
                'verbose_name': 'Successful task',
                'proxy': True,
            },
            bases=('django_q.task',),
        ),
        migrations.AlterModelOptions(
            name='failure',
            options={'verbose_name': 'Failed task', 'verbose_name_plural': 'Failed tasks'},
        ),
        migrations.AlterModelOptions(
            name='schedule',
            options={'ordering': ['next_run'], 'verbose_name': 'Scheduled task', 'verbose_name_plural': 'Scheduled tasks'},
        ),
        migrations.AlterModelOptions(
            name='success',
            options={'verbose_name': 'Successful task', 'verbose_name_plural': 'Successful tasks'},
        ),
        migrations.AlterField(
            model_name='task',
            name='id',
            field=models.CharField(editable=False, max_length=32, primary_key=True, serialize=False),
        ),
        migrations.AlterModelOptions(
            name='failure',
            options={'ordering': ['-stopped'], 'verbose_name': 'Failed task', 'verbose_name_plural': 'Failed tasks'},
        ),
        migrations.AlterModelOptions(
            name='success',
            options={'ordering': ['-stopped'], 'verbose_name': 'Successful task', 'verbose_name_plural': 'Successful tasks'},
        ),
        migrations.AlterModelOptions(
            name='task',
            options={'ordering': ['-stopped']},
        ),
        migrations.AddField(
            model_name='schedule',
            name='name',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='task',
            name='group',
            field=models.CharField(editable=False, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='schedule',
            name='minutes',
            field=models.PositiveSmallIntegerField(blank=True, help_text='Number of minutes for the Minutes type', null=True),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='schedule_type',
            field=models.CharField(choices=[('O', 'Once'), ('I', 'Minutes'), ('H', 'Hourly'), ('D', 'Daily'), ('W', 'Weekly'), ('M', 'Monthly'), ('Q', 'Quarterly'), ('Y', 'Yearly')], default='O', max_length=1, verbose_name='Schedule Type'),
        ),
        migrations.CreateModel(
            name='OrmQ',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=100)),
                ('payload', models.TextField()),
                ('lock', models.DateTimeField(null=True)),
            ],
            options={
                'verbose_name': 'Queued task',
                'verbose_name_plural': 'Queued tasks',
            },
        ),
        migrations.AddField(
            model_name='task',
            name='is_updating_progress',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='task',
            name='progress_data',
            field=picklefield.fields.PickledObjectField(editable=False, null=True),
        ),
        migrations.AddField(
            model_name='task',
            name='task_status',
            field=models.CharField(choices=[('PENDING', 'Pending'), ('INPROGRESS', 'In Progress'), ('FAILED', 'Failed'), ('SUCCESS', 'Succeeded')], default='PENDING', max_length=15),
        ),
        migrations.AddField(
            model_name='task',
            name='progress_fraction',
            field=models.FloatField(default=0),
        ),
        migrations.AlterField(
            model_name='task',
            name='stopped',
            field=models.DateTimeField(blank=True, editable=False, null=True),
        ),
    ]
