# -*- coding: utf-8 -*-
# Generated by Django 1.9.1 on 2016-07-12 18:36
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import kolibri.content.models
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ChannelMetadata',
            fields=[
                ('id', kolibri.content.models.UUIDField(max_length=32, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=400)),
                ('author', models.CharField(blank=True, max_length=400)),
                ('version', models.IntegerField(default=0)),
                ('thumbnail', models.TextField(blank=True)),
                ('root_pk', kolibri.content.models.UUIDField(max_length=32)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ChannelMetadataCache',
            fields=[
                ('id', kolibri.content.models.UUIDField(max_length=32, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=400)),
                ('author', models.CharField(blank=True, max_length=400)),
                ('version', models.IntegerField(default=0)),
                ('thumbnail', models.TextField(blank=True)),
                ('root_pk', kolibri.content.models.UUIDField(max_length=32)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContentNode',
            fields=[
                ('id', kolibri.content.models.UUIDField(max_length=32, primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=200)),
                ('content_id', kolibri.content.models.UUIDField(max_length=32)),
                ('description', models.CharField(blank=True, max_length=400, null=True)),
                ('sort_order', models.FloatField(blank=True, null=True)),
                ('license_owner', models.CharField(blank=True, max_length=200)),
                ('author', models.CharField(blank=True, max_length=200)),
                ('kind', models.CharField(blank=True, choices=[(b'topic', 'Topic'), (b'video', 'Video'), (b'audio', 'Audio'), (b'exercise', 'Exercise'), (b'document', 'Document'), (b'image', 'Image')], max_length=200)),
                ('available', models.BooleanField(default=False)),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                ('has_prerequisite', models.ManyToManyField(blank=True, related_name='prerequisite_for', to='content.ContentNode')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContentTag',
            fields=[
                ('id', kolibri.content.models.UUIDField(max_length=32, primary_key=True, serialize=False)),
                ('tag_name', models.CharField(blank=True, max_length=30)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', kolibri.content.models.UUIDField(max_length=32, primary_key=True, serialize=False)),
                ('checksum', models.CharField(blank=True, max_length=400)),
                ('extension', models.CharField(blank=True, choices=[(b'mp4', 'mp4'), (b'vtt', 'vtt'), (b'srt', 'srt'), (b'mp3', 'mp3'), (b'pdf', 'pdf')], max_length=40)),
                ('available', models.BooleanField(default=False)),
                ('file_size', models.IntegerField(blank=True, null=True)),
                ('preset', models.CharField(blank=True, choices=[(b'high_res_video', 'High resolution video'), (b'low_res_video', 'Low resolution video'), (b'vector_video', 'Vertor video'), (b'thumbnail', 'Thumbnail'), (b'thumbnail', 'Thumbnail'), (b'caption', 'Caption')], max_length=150)),
                ('supplementary', models.BooleanField(default=False)),
                ('thumbnail', models.BooleanField(default=False)),
                ('priority', models.IntegerField(blank=True, null=True)),
                ('contentnode', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='files', to='content.ContentNode')),
            ],
            options={
                'ordering': ['priority'],
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lang_code', models.CharField(db_index=True, max_length=2)),
                ('lang_subcode', models.CharField(db_index=True, max_length=2)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='License',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('license_name', models.CharField(max_length=50)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='file',
            name='lang',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='content.Language'),
        ),
        migrations.AddField(
            model_name='contentnode',
            name='license',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='content.License'),
        ),
        migrations.AddField(
            model_name='contentnode',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='content.ContentNode'),
        ),
        migrations.AddField(
            model_name='contentnode',
            name='related',
            field=models.ManyToManyField(blank=True, related_name='_contentnode_related_+', to='content.ContentNode'),
        ),
        migrations.AddField(
            model_name='contentnode',
            name='tags',
            field=models.ManyToManyField(blank=True, related_name='tagged_content', to='content.ContentTag'),
        ),
    ]
