import json
import lxml

class objectJSONEncoder(json.JSONEncoder):
	"""A specialized JSON encoder that can handle simple lxml objectify types
	>>> from lxml import objectify
	>>> obj = objectify.fromstring("<Book><price>1.50</price><author>W. Shakespeare</author></Book>")
	>>> objectJSONEncoder().encode(obj)
	'{"price": 1.5, "author": "W. Shakespeare"}'
	"""
	def default(self,o):
		if isinstance(o, lxml.objectify.IntElement):
			return int(o)
		if isinstance(o, lxml.objectify.NumberElement) or isinstance(o, lxml.objectify.FloatElement):
			return float(o)
		if isinstance(o, lxml.objectify.ObjectifiedDataElement):
			return str(o)
		if hasattr(o, '__dict__'):
			#For objects with a __dict__, return the encoding of the __dict__
			return o.__dict__
		return json.JSONEncoder.default(self, o)
