# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import peering_group_peers_pb2 as peering__group__peers__pb2


class PeeringGroupPeersStub(object):
    """PeeringGroupPeers provides the building blocks necessary to link two peering groups.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.PeeringGroupPeers/Create',
                request_serializer=peering__group__peers__pb2.PeeringGroupPeerCreateRequest.SerializeToString,
                response_deserializer=peering__group__peers__pb2.PeeringGroupPeerCreateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.PeeringGroupPeers/Delete',
                request_serializer=peering__group__peers__pb2.PeeringGroupPeerDeleteRequest.SerializeToString,
                response_deserializer=peering__group__peers__pb2.PeeringGroupPeerDeleteResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.PeeringGroupPeers/Get',
                request_serializer=peering__group__peers__pb2.PeeringGroupPeerGetRequest.SerializeToString,
                response_deserializer=peering__group__peers__pb2.PeeringGroupPeerGetResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.PeeringGroupPeers/List',
                request_serializer=peering__group__peers__pb2.PeeringGroupPeerListRequest.SerializeToString,
                response_deserializer=peering__group__peers__pb2.PeeringGroupPeerListResponse.FromString,
                )


class PeeringGroupPeersServicer(object):
    """PeeringGroupPeers provides the building blocks necessary to link two peering groups.
    """

    def Create(self, request, context):
        """Create links two peering groups.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete unlinks two peering groups.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads the information of one peering group link.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of peering group links.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_PeeringGroupPeersServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=peering__group__peers__pb2.PeeringGroupPeerCreateRequest.FromString,
                    response_serializer=peering__group__peers__pb2.PeeringGroupPeerCreateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=peering__group__peers__pb2.PeeringGroupPeerDeleteRequest.FromString,
                    response_serializer=peering__group__peers__pb2.PeeringGroupPeerDeleteResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=peering__group__peers__pb2.PeeringGroupPeerGetRequest.FromString,
                    response_serializer=peering__group__peers__pb2.PeeringGroupPeerGetResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=peering__group__peers__pb2.PeeringGroupPeerListRequest.FromString,
                    response_serializer=peering__group__peers__pb2.PeeringGroupPeerListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.PeeringGroupPeers', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class PeeringGroupPeers(object):
    """PeeringGroupPeers provides the building blocks necessary to link two peering groups.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupPeers/Create',
            peering__group__peers__pb2.PeeringGroupPeerCreateRequest.SerializeToString,
            peering__group__peers__pb2.PeeringGroupPeerCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupPeers/Delete',
            peering__group__peers__pb2.PeeringGroupPeerDeleteRequest.SerializeToString,
            peering__group__peers__pb2.PeeringGroupPeerDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupPeers/Get',
            peering__group__peers__pb2.PeeringGroupPeerGetRequest.SerializeToString,
            peering__group__peers__pb2.PeeringGroupPeerGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupPeers/List',
            peering__group__peers__pb2.PeeringGroupPeerListRequest.SerializeToString,
            peering__group__peers__pb2.PeeringGroupPeerListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
