#!/usr/bin/python
# -*- coding: utf-8 -*-

# Hive Appier Framework
# Copyright (C) 2008-2014 Hive Solutions Lda.
#
# This file is part of Hive Appier Framework.
#
# Hive Appier Framework is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Hive Appier Framework is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Hive Appier Framework. If not, see <http://www.gnu.org/licenses/>.

__version__ = "1.0.0"
""" The version of the module """

__revision__ = "$LastChangedRevision$"
""" The revision number of the module """

__date__ = "$LastChangedDate$"
""" The last change date of the module """

__copyright__ = "Copyright (c) 2008-2014 Hive Solutions Lda."
""" The copyright for the module """

__license__ = "GNU General Public License (GPL), Version 3"
""" The license for the module """

from . import api
from . import async
from . import base
from . import config
from . import controller
from . import defines
from . import exceptions
from . import export
from . import http
from . import legacy
from . import log
from . import model
from . import mongo
from . import observer
from . import part
from . import request
from . import serialize
from . import session
from . import settings
from . import smtp
from . import structures
from . import typesf
from . import util
from . import validation

from .api import *
from .async import *
from .base import *
from .config import *
from .controller import *
from .defines import *
from .exceptions import *
from .export import *
from .http import *
from .legacy import *
from .log import *
from .model import *
from .mongo import *
from .observer import *
from .part import *
from .request import *
from .serialize import *
from .session import *
from .settings import *
from .smtp import *
from .structures import *
from .typesf import *
from .util import *
from .validation import *
