import os
from setuptools import setup, find_packages


def read_file(filename):
    """Read a file into a string"""
    path = os.path.abspath(os.path.dirname(__file__))
    filepath = os.path.join(path, filename)
    try:
        return open(filepath).read()
    except IOError:
        return ''


setup(
    name='flask-wysiwyg',
    version=__import__('flask_wysiwyg').__version__,
    author='ZebraApps, NBTCNET',
    author_email='nbtcnet@gmail.com',
    packages=find_packages(),
    include_package_data=True,
    url='https://github.com/nbtcnet/flask-wysiwyg/',
    license='BSD',
    description=u' '.join(__import__('flask_wysiwyg').__doc__.splitlines()).strip(),
    classifiers=[
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Intended Audience :: Developers',
        'Programming Language :: Python',      
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Framework :: Flask',
        'Development Status :: 4 - Beta',
        'Operating System :: OS Independent',
    ],
    long_description=read_file('README.rst'),
    install_requires=['Flask-WTF==0.9.4'],
   
    
)
