# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SharedAccessAuthorizationRuleCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Authorization Rules operation.

    :param location: Data center location.
    :type location: str
    :param name: Name of the authorization rule.
    :type name: str
    :param rights: The rights associated with the rule.
    :type rights: list of str or :class:`AccessRights
     <azure.mgmt.eventhub.models.AccessRights>`
    """

    _validation = {
        'rights': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[AccessRights]'},
    }

    def __init__(self, rights, location=None, name=None):
        self.location = location
        self.name = name
        self.rights = rights
