(function($) {
  $.fn.easySlider = function(options){
    var defaults = {      
      prevId : 'prevBtn',
      nextId : 'nextBtn',  
      firstId : 'firstBtn',
      lastId : 'lastBtn',  
      vertical : false,
      speed : 800,
      odd_speed : 0,
      auto : false,
      pause : 2000,
      odd_pause : 0,
      continuous : false,
      goToButtonId : 'goToButton',
      goToRotateAmount : 8,
      effect : 'Slide',
      navigation_type : 'Navigation Buttons',
      fadeNavigation : false,
      navigation_buttons_rendering_type : 'standard'
    }; 
    
    var options = $.extend(defaults, options);  
        
    this.each(function() {  
      var obj = $(this); 
      var locked = false; // lock while moving.
      var container = obj.parent();
      var slide = $("li.slide", container);
      var slides = slide.length;
      var width = slide.width(); 
      var height = slide.height(); 
      var timeout;
      var timer_activated = options.auto; 
      obj.css("overflow","hidden");
      var total_slides = slides-1;
      var current_slide = 0;
      var next_action = function(){};
      var trying = false;
      
      $("ul.slider-list", container).css('width',slides*width);      
      if(!options.vertical){ $("li.slide", container).css('float','left'); }
      
      //Navigation...
      if(options.navigation_type != "No Buttons"){
        var html = '';
        if(options.navigation_type == "Navigation Buttons"){
          html += "<div id='easySlider-goToButtons'>";
          html += ' <span id="leftb"><a class="leftright" href=\"javascript:void(0);\">&nbsp</a></span>';
          var count = 1;
          for(var i=0; i < total_slides+1; i++){ 
            var add = true;
            if((options.navigation_buttons_rendering_type == 'skip_even' && i % 2 == 1) ||
                  options.navigation_buttons_rendering_type == 'skip_odd' && i % 2 == 0){
              add = false;
            }
            if(add){
              html += "<a id=\"" + options.goToButtonId + i + "\" href=\"javascript:void(0);\">" + count + "</a> ";
              count++;
            }
          }
          html += ' <span id="rightb"><a class="leftright" href=\"javascript:void(0);\">&nbsp</a></span>';
          html += '<div id="pauseplay"></div>';
          html += "</div>";
        }
        if(options.navigation_type == "Big Arrows"){
          html += ' <span id="'+ options.prevId +'"><a href=\"javascript:void(0);\">&nbsp</a></span>';
          html += ' <span id="'+ options.nextId +'"><a href=\"javascript:void(0);\">&nbsp</a></span>';
        }else if(options.navigation_type == "Small Arrows"){
          html += "<div id='smallButtons'>";
          html += ' <span id="'+ options.prevId +'"><a href=\"javascript:void(0);\">&nbsp</a></span>';
          html += ' <span id="'+ options.nextId +'"><a href=\"javascript:void(0);\">&nbsp</a></span>';
          html += "</div>";
        }
        $(obj).after(html);                   
      };
      //end nav
          
      function try_action(){
        trying = true;
        setTimeout(function(){
          if(locked){
            try_action();
          }else if(next_action != null){
            next_action();
            next_action = null;
            trying = false;
          }
        }, 100);
      }
          
      function schedule(func){
        if(locked){
          next_action = func;
          if(!trying){
            try_action();
          }
        }else if(!trying){
          func();
        }
      }
          
      $("a","#"+options.nextId, container).click(function(){    
        schedule(function(){ animate("next",true, container); });
      });
      $("a","#"+options.prevId, container).click(function(){    
        schedule(function(){ animate("prev",true, container); });
      }); 
      $("span#leftb a", container).click(function(){    
        schedule(function(){ animate("prev",true, container); });
      });
      $("span#rightb a", container).click(function(){   
        schedule(function(){ animate("next",true, container); });
      });
      $("a","#"+options.firstId, container).click(function(){   
        schedule(function(){ animate("first",true, container); });
      });       
      $("a","#"+options.lastId, container).click(function(){    
        schedule(function(){ animate("last",true, container); });
      }); 
      $("div#easySlider-goToButtons a:not(.leftright)", container).click(function(){
        var number = parseInt($(this).attr('id').substring(options.goToButtonId.length));
        schedule(function(){ animate(number, true, container); });
      });
      
      if(options.navigation_type == "Navigation Buttons"){
        $("#" + options.goToButtonId + "0", container).addClass('active');
      }
      
      function update_goToButtons(btns){
        if(btns.size() > options.goToRotateAmount){
          var min = Math.max(current_slide - Math.floor(options.goToRotateAmount/2), 0);
          var max = Math.min(current_slide + Math.floor(options.goToRotateAmount/2), btns.size());
          var diff = max - min;
          if(diff != options.goToRotateAmount){
            min = Math.max(min - (options.goToRotateAmount - diff), 0);
          }
          diff = max - min;
          if(diff != options.goToRotateAmount){
            max = Math.min(max + (options.goToRotateAmount - diff), btns.size());
          }
          for(var i = 0; i < min; i++){
            $("#" + options.goToButtonId + i, container).hide();
          }
          for(var i = min; i < max; i++){
            $("#" + options.goToButtonId + i, container).show();
          }
          for(var i = max; i < btns.size(); i++){
            $("#" + options.goToButtonId + i, container).hide();
          }
        }
      }
      
      update_goToButtons($("div#easySlider-goToButtons a:not(.leftright)", container));
      
      function getPause(){
        var pause = options.pause;
        if(current_slide % 2 == 0 && options.odd_pause != 0){
          pause = options.odd_pause;
        }
        return pause;
      }
      
      function animate(dir, clicked, container){
        locked = true;
        var previous_slide = current_slide;       
        switch(dir){
          case "next":
            current_slide = (previous_slide>=total_slides) ? (options.continuous ? 0 : total_slides) : current_slide+1;           
            break; 
          case "prev":
            current_slide = (current_slide<=0) ? (options.continuous ? total_slides : 0) : current_slide-1;
            break; 
          case "first":
            current_slide = 0;
            break; 
          case "last":
            current_slide = total_slides;
            break; 
          default:
            if(typeof(dir) == "number"){
              current_slide = dir;
            }
            break; 
        };  
        
        if(options.navigation_type == "Navigation Buttons"){
          var btns = $("div#easySlider-goToButtons a:not(.leftright)", container);
          btns.removeClass("active");
          $("#" + options.goToButtonId + current_slide, container).addClass('active');
          update_goToButtons(btns);
        }
        
        var diff = Math.abs(previous_slide-current_slide);
        var position = (current_slide*width*-1);
        if(options.vertical){
          position = (current_slide*height*-1);
        }

        var speed = options.speed;
        if(current_slide % 2 == 0 && options.odd_speed != 0){
          speed = options.odd_speed;
        }
        
        if(diff != 0){//Only run it if it's moving to another slide.
          if(options.effect == "Slide"){
            var callback = function(){ locked = false; };
            
            if(options.continuous && dir == "next" && current_slide == 0 && previous_slide == total_slides){
              // This is the case when we don't want to do a reverse slide on the
              // last slide. To do this, we insert a clone in front of the slides
              // so we can slide from this cloned slide to the first slide in the 
              // slider
              var margin = "marginLeft";
              var variance = width;
              if(options.vertical){
                margin = "marginTop";
                variance = height;
              }
              var clone = $("ul.slider-list li:last", container).clone();
              $("ul.slider-list", container).prepend(clone);
              $("ul.slider-list").css(margin, 0);
              callback = function(){
                clone.remove();
                $("ul.slider-list").css(margin, 0);
                locked = false;
              }
              position = -variance;
            }else if(options.continuous && dir == "prev" && current_slide == total_slides && previous_slide == 0){
              var clone = $("ul.slider-list li:first", container).clone();
              $("ul.slider-list", container).append(clone);
              var slider_size = (total_slides*width)+width;
              var margin = "marginLeft";
              var dimen = "width";
              var variance = width;
              if(options.vertical){
                slider_size = (total_slides*height)+height;
                margin = "marginTop";
                dimen = "height";
                variance = height;
              }
              $("ul.slider-list", container).css(dimen, slider_size+variance);
              position = total_slides*variance*-1;
              $("ul.slider-list").css(margin, position-variance);
              callback = function(){
                clone.remove();
                $("ul.slider-list", container).css(dimen, slider_size);
                locked = false;
              }
            }else{
              speed = (diff*speed)/diff;
            }
            
            if(!options.vertical) {
              $("ul.slider-list",container).animate({ 
                  marginLeft: position
              }, speed, callback);        
            } else {
              p = (current_slide*height*-1);
              $("ul.slider-list",container).animate({ 
                marginTop: position 
              }, speed, callback);          
            }
            
          }else if(options.effect == "Fade"){
            var margin = "marginLeft";
            if(options.vertical){ 
              margin = "marginTop"; 
            }

            $("ul.slider-list", container).fadeOut(Math.ceil(speed/2), function(){
              $(this).css(margin, position).fadeIn(Math.ceil(speed/2), function(){ locked = false; });
            });
          }
        }
        
        if(!options.continuous){          
          if(current_slide==total_slides){
            $("a","#"+options.nextId, container).hide();
            $("a","#"+options.lastId, container).hide();
          } else {
            $("a","#"+options.nextId, container).show();
            $("a","#"+options.lastId, container).show();          
          };
          if(current_slide==0){
            $("a","#"+options.prevId, container).hide();
            $("a","#"+options.firstId, container).hide();
          } else {
            $("a","#"+options.prevId, container).show();
            $("a","#"+options.firstId, container).show();
          };          
        };        
        
        if(clicked){ 
          clear_timer(); 
        }
        if(timer_activated && dir=="next" && !clicked){
          set_timer(speed+getPause());
        };
      };
      
      function set_timer(duration){
        timeout = setTimeout(function(){
          if(locked){
            set_timer(100);
          }else if(!trying){
            animate("next",false, container);
          }
        }, duration);
        timer_activated = true;
        $('div#pauseplay', container).addClass('pause').removeClass('play');
      }
      
      function clear_timer(){
        clearTimeout(timeout);
        timer_activated = false;
        $('div#pauseplay', container).addClass('play').removeClass('pause');
      }

      if(options.fadeNavigation){
        var selector = "div#smallButtons,div#easySlider-goToButtons,#" + options.prevId + ",#" + options.nextId;
        container.hover(function(){
          $(selector, container).fadeIn('fast');
        }, function(){
          $(selector, container).fadeOut();
        });
      }

      $('div#pauseplay', container).click(function(){
        if(timer_activated){
          clear_timer();
        }else{
          set_timer(getPause());
        }
      });
          
      // init
      if(timer_activated){
        set_timer(getPause());
        $('div#pauseplay', container).addClass('pause');
      }else{
        $('div#pauseplay', container).addClass('play');
      }
      
      if(!options.continuous){          
        $("a","#"+options.prevId, container).hide();
        $("a","#"+options.firstId, container).hide();       
      }
    });
  }
})(jQuery);



