/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.xml.DocumentLocatorImpl;
import com.adobe.epubcheck.xml.XMLAttribute;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLValidator;
import com.google.common.io.Closer;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    private static final String SAXPROP_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String SAXPROP_DECL_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private SAXParser parser;
    private final ValidationContext context;
    private final Report report;
    private final String path;
    private final Vector<XMLHandler> contentHandlers = new Vector();
    private XMLElement currentElement;
    private final Vector<ContentHandler> validatorContentHandlers = new Vector();
    private final Vector<DTDHandler> validatorDTDHandlers = new Vector();
    private final Vector<LexicalHandler> validatorLexicalHandlers = new Vector();
    private final Vector<DeclHandler> validatorDeclHandlers = new Vector();
    private Locator2 documentLocator;
    private static final String zipRoot = "file:///epub-root/";
    private static final Hashtable<String, String> systemIdMap;
    private final HashSet<String> entities = new HashSet();
    private boolean firstStartDTDInvocation = true;
    private static final Set<String> knownXHTMLContentDocsNamespaces;
    private static final byte[][] utf16magic;
    private static final byte[][] ucs4magic;
    private static final byte[] utf8magic;
    private static final byte[] ebcdicmagic;

    public XMLParser(ValidationContext context) {
        this.context = context;
        this.report = context.report;
        this.path = context.path;
        this.entities.add("gt");
        this.entities.add("lt");
        this.entities.add("amp");
        this.entities.add("quot");
        this.entities.add("apos");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/validation", false);
            if (context.version == EPUBVersion.VERSION_3) {
                factory.setXIncludeAware(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.parser = factory.newSAXParser();
            XMLReader reader = this.parser.getXMLReader();
            reader.setDTDHandler(this);
            reader.setContentHandler(this);
            reader.setEntityResolver(this);
            reader.setErrorHandler(this);
            try {
                reader.setProperty(SAXPROP_LEXICAL_HANDLER, this);
                reader.setProperty(SAXPROP_DECL_HANDLER, this);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void addXMLHandler(XMLHandler handler) {
        if (handler != null) {
            this.contentHandlers.add(handler);
        }
    }

    public void addValidator(XMLValidator xv) {
        DTDHandler dtdHandler;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, this);
        Validator validator = xv.schema.createValidator(propertyMapBuilder.toPropertyMap());
        ContentHandler contentHandler = validator.getContentHandler();
        if (contentHandler != null) {
            this.validatorContentHandlers.add(contentHandler);
        }
        if ((dtdHandler = validator.getDTDHandler()) != null) {
            this.validatorDTDHandlers.add(dtdHandler);
        }
    }

    public void addDeclHandler(DeclHandler handler) {
        if (handler != null) {
            this.validatorDeclHandlers.add(handler);
        }
    }

    public void addLexicalHandler(LexicalHandler handler) {
        if (handler != null) {
            this.validatorLexicalHandlers.add(handler);
        }
    }

    public void process() {
        try {
            Closer closer = Closer.create();
            try {
                String encoding;
                InputStream in = closer.register(this.context.resourceProvider.getInputStream(this.path));
                if (!in.markSupported()) {
                    in = new BufferedInputStream(in);
                }
                if ((encoding = XMLParser.sniffEncoding(in)) != null && !encoding.equals("UTF-8") && !encoding.equals("UTF-16")) {
                    this.report.message(MessageId.CSS_003, EPUBLocation.create(this.path, ""), encoding);
                }
                InputSource ins = new InputSource(in);
                ins.setSystemId(zipRoot + this.path);
                this.parser.parse(ins, (DefaultHandler)this);
            }
            catch (Throwable e) {
                throw closer.rethrow(e, SAXException.class);
            }
            finally {
                closer.close();
            }
        }
        catch (FileNotFoundException e) {
            String message = e.getMessage();
            message = new File(message).getName();
            int p = message.indexOf("(");
            if (p > 0) {
                message = message.substring(0, message.indexOf("("));
            }
            message = message.trim();
            this.report.message(MessageId.RSC_001, EPUBLocation.create(this.path), message);
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.path), this.path);
        }
        catch (IllegalArgumentException e) {
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path), e.getMessage());
        }
        catch (SAXException e) {
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path), e.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String resourcePath = systemIdMap.get(systemId);
        if (resourcePath != null) {
            InputStream resourceStream = ResourceUtil.getResourceStream(resourcePath);
            InputSource source = new InputSource(resourceStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        if (systemId.equals("about:legacy-compat")) {
            return new InputSource(new StringReader(""));
        }
        boolean offline = Boolean.parseBoolean(System.getProperty("epubcheck.offline"));
        if (systemId.startsWith("http:") && offline) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        int len = this.validatorDTDHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.validatorDTDHandlers.elementAt(i).notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        int len = this.validatorDTDHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.validatorDTDHandlers.elementAt(i).unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        String message = ex.getMessage().trim();
        if (message != null && message.startsWith("WARNING:")) {
            this.report.message(MessageId.RSC_017, EPUBLocation.create(this.path, ex.getLineNumber(), ex.getColumnNumber()), message.substring(9, message.length()));
        } else {
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path, ex.getLineNumber(), ex.getColumnNumber()), message);
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.report.message(MessageId.RSC_016, EPUBLocation.create(this.path, ex.getLineNumber(), ex.getColumnNumber()), ex.getMessage());
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.report.message(MessageId.RSC_017, EPUBLocation.create(this.path, ex.getLineNumber(), ex.getColumnNumber()), ex.getMessage());
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).characters(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).characters(arg0, arg1, arg2);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int len = this.validatorContentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.validatorContentHandlers.elementAt(i).endDocument();
        }
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).endElement(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).endElement();
        }
        this.currentElement = this.currentElement.getParent();
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).endPrefixMapping(arg0);
        }
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).ignorableWhitespace(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).ignorableWhitespace(arg0, arg1, arg2);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).processingInstruction(arg0, arg1);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).processingInstruction(arg0, arg1);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).setDocumentLocator(locator);
        }
        this.documentLocator = new DocumentLocatorImpl(locator);
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).skippedEntity(arg0);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).startDocument();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String name;
        String prefix;
        AttributesImpl attribs = new AttributesImpl(atts);
        if ("application/xhtml+xml".equals(this.context.mimeType) && this.context.version == EPUBVersion.VERSION_3) {
            try {
                int len = attribs.getLength();
                ArrayList<String> removals = new ArrayList<String>();
                for (int i = 0; i < len; ++i) {
                    if (attribs.getLocalName(i).startsWith("data-")) {
                        removals.add(attribs.getQName(i));
                        continue;
                    }
                    if (!this.isCustomNamespaceAttr(attribs.getURI(i))) continue;
                    removals.add(attribs.getQName(i));
                }
                for (String remove : removals) {
                    int rmv = attribs.getIndex(remove);
                    attribs.removeAttribute(rmv);
                }
            }
            catch (Exception e) {
                System.err.println("data-* removal exception: " + e.getMessage());
            }
        }
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).startElement(namespaceURI, localName, qName, attribs);
        }
        int index = qName.indexOf(58);
        if (index < 0) {
            prefix = null;
            name = qName;
        } else {
            prefix = qName.substring(0, index);
            name = qName.substring(index + 1);
        }
        int count = attribs.getLength();
        XMLAttribute[] attributes = count == 0 ? null : new XMLAttribute[count];
        for (int i = 0; i < count; ++i) {
            String attPrefix;
            String attName = attribs.getLocalName(i);
            String attNamespace = attribs.getURI(i);
            String attQName = attribs.getQName(i);
            int attIndex = attQName.indexOf(58);
            if (attIndex < 0) {
                attPrefix = null;
                attNamespace = null;
            } else {
                attPrefix = attQName.substring(0, attIndex);
            }
            String attValue = attribs.getValue(i);
            assert (attributes != null);
            attributes[i] = new XMLAttribute(attNamespace, attPrefix, attName, attValue);
        }
        this.currentElement = new XMLElement(namespaceURI, prefix, name, attributes, this.currentElement);
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).startElement();
        }
    }

    private boolean isCustomNamespaceAttr(String nsuri) {
        if (nsuri == null || nsuri.trim().length() == 0) {
            return false;
        }
        for (String ns : knownXHTMLContentDocsNamespaces) {
            if (!ns.equals(nsuri)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).startPrefixMapping(arg0, arg1);
        }
    }

    @Override
    public void comment(char[] text, int arg1, int arg2) throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.comment(text, arg1, arg2);
            }
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.endCDATA();
            }
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.endDTD();
            }
        }
    }

    @Override
    public void endEntity(String ent) throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.endEntity(ent);
            }
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.startCDATA();
            }
        }
    }

    @Override
    public void startDTD(String root, String publicId, String systemId) throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.startDTD(root, publicId, systemId);
            }
        }
        this.handleDocTypeUserInfo(root, publicId, systemId);
    }

    private void handleDocTypeUserInfo(String root, String publicId, String systemId) {
        String mimeType = this.context.mimeType;
        if (!this.firstStartDTDInvocation) {
            return;
        }
        if (this.context.version == EPUBVersion.VERSION_2) {
            String complete;
            if (mimeType != null && "application/xhtml+xml".equals(mimeType) && root.equals("html") && this.matchDoctypeId("-//W3C//DTD XHTML 1.1//EN", publicId, complete = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \n\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">")) {
                this.matchDoctypeId("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", systemId, complete);
            }
            if (mimeType != null && "opf".equals(mimeType) && (publicId != null || systemId != null) && (!"package".equals(root) || publicId != null && !publicId.equals("+//ISBN 0-9673008-1-9//DTD OEB 1.2 Package//EN") || systemId != null && !systemId.equals("http://openebook.org/dtds/oeb-1.2/oebpkg12.dtd"))) {
                this.report.message(MessageId.HTM_009, EPUBLocation.create(this.path), new Object[0]);
            }
            if (mimeType != null && "application/x-dtbncx+xml".equals(mimeType) && this.matchDoctypeId("-//NISO//DTD ncx 2005-1//EN", publicId, complete = "<!DOCTYPE ncx PUBLIC \"-//NISO//DTD ncx 2005-1//EN\" \n \"http://www.daisy.org/z3986/2005/ncx-2005-1.dtd\">")) {
                this.matchDoctypeId("http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", systemId, complete);
            }
        } else if (this.context.version == EPUBVersion.VERSION_3) {
            if (mimeType != null && "application/xhtml+xml".equals(mimeType) && "html".equalsIgnoreCase(root)) {
                String complete = "<!DOCTYPE html>";
                if (publicId != null || systemId != null && !systemId.equals("about:legacy-compat")) {
                    this.report.message(MessageId.HTM_004, EPUBLocation.create(this.path), publicId, complete);
                }
            } else if (publicId != null || systemId != null) {
                this.report.message(MessageId.OPF_073, this.getLocation(), new Object[0]);
            }
        }
        this.firstStartDTDInvocation = false;
    }

    boolean checkDTD(String expectedPublicId, String expectedSystemId, String actualPublicId, String actualSystemId) {
        return (actualPublicId == null || actualPublicId != null && expectedPublicId.equalsIgnoreCase(actualPublicId)) && (actualSystemId == null || actualSystemId != null && expectedSystemId.equalsIgnoreCase(actualSystemId));
    }

    boolean matchDoctypeId(String expected, String given, String messageParam) {
        if (!expected.equals(given)) {
            this.report.message(MessageId.HTM_004, EPUBLocation.create(this.path), given == null ? "" : given, messageParam);
            return false;
        }
        return true;
    }

    @Override
    public void startEntity(String ent) throws SAXException {
        if (this.validatorLexicalHandlers.size() > 0) {
            for (LexicalHandler h : this.validatorLexicalHandlers) {
                h.startEntity(ent);
            }
        }
        if (!this.entities.contains(ent) && !ent.equals("[dtd]")) {
            this.report.message(MessageId.HTM_011, EPUBLocation.create(this.path, this.getLineNumber(), this.getColumnNumber(), ent), new Object[0]);
        }
    }

    @Override
    public void attributeDecl(String name, String name2, String type, String mode, String value) throws SAXException {
        if (this.validatorDeclHandlers.size() > 0) {
            for (DeclHandler h : this.validatorDeclHandlers) {
                h.attributeDecl(name, name2, type, mode, value);
            }
        }
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        if (this.validatorDeclHandlers.size() > 0) {
            for (DeclHandler h : this.validatorDeclHandlers) {
                h.elementDecl(name, model);
            }
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.validatorDeclHandlers.size() > 0) {
            for (DeclHandler h : this.validatorDeclHandlers) {
                h.externalEntityDecl(name, publicId, systemId);
            }
        }
        if (this.context.version == EPUBVersion.VERSION_3) {
            this.report.message(MessageId.HTM_003, EPUBLocation.create(this.path, this.getLineNumber(), this.getColumnNumber(), name), name);
            return;
        }
        this.entities.add(name);
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.validatorDeclHandlers.size() > 0) {
            for (DeclHandler h : this.validatorDeclHandlers) {
                h.internalEntityDecl(name, value);
            }
        }
        this.entities.add(name);
    }

    public XMLElement getCurrentElement() {
        return this.currentElement;
    }

    public Report getReport() {
        return this.report;
    }

    public int getLineNumber() {
        return this.documentLocator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.documentLocator.getColumnNumber();
    }

    public EPUBLocation getLocation() {
        return EPUBLocation.create(this.path, this.documentLocator.getLineNumber(), this.documentLocator.getColumnNumber());
    }

    public String getXMLVersion() {
        return this.documentLocator.getXMLVersion();
    }

    public String getResourceName() {
        return this.path;
    }

    private static boolean matchesMagic(byte[] magic, byte[] buffer) {
        for (int i = 0; i < magic.length; ++i) {
            if (buffer[i] == magic[i]) continue;
            return false;
        }
        return true;
    }

    private static String sniffEncoding(InputStream in) throws IOException {
        int c;
        int asciiLen;
        byte[] buffer = new byte[256];
        in.mark(buffer.length);
        int len = in.read(buffer);
        in.reset();
        if (len < 4) {
            return null;
        }
        for (byte[] magic : utf16magic) {
            if (!XMLParser.matchesMagic(magic, buffer)) continue;
            return "UTF-16";
        }
        for (byte[] anUcs4magic : ucs4magic) {
            if (!XMLParser.matchesMagic(anUcs4magic, buffer)) continue;
            return "UCS-4";
        }
        if (XMLParser.matchesMagic(utf8magic, buffer)) {
            return "UTF-8";
        }
        if (XMLParser.matchesMagic(ebcdicmagic, buffer)) {
            return "EBCDIC";
        }
        for (asciiLen = 0; asciiLen < len && (c = buffer[asciiLen] & 0xFF) != 0 && c <= 127; ++asciiLen) {
        }
        String header = new String(buffer, 0, asciiLen, "ASCII");
        int encIndex = header.indexOf("encoding=");
        if (encIndex < 0) {
            return null;
        }
        if ((encIndex += 9) >= header.length()) {
            return null;
        }
        char quote = header.charAt(encIndex);
        if (quote != '\"' && quote != '\'') {
            return null;
        }
        int encEnd = header.indexOf(quote, encIndex + 1);
        if (encEnd < 0) {
            return null;
        }
        String encoding = header.substring(encIndex + 1, encEnd);
        return encoding.toUpperCase();
    }

    static {
        knownXHTMLContentDocsNamespaces = new HashSet<String>();
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/1998/Math/MathML");
        knownXHTMLContentDocsNamespaces.add("http://www.idpf.org/2007/ops");
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/2001/10/synthesis");
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/2000/svg");
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/1999/xhtml");
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/2001/xml-events");
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/XML/1998/namespace");
        knownXHTMLContentDocsNamespaces.add("http://www.w3.org/1999/xlink");
        utf16magic = new byte[][]{{-2, -1}, {-1, -2}, {0, 60, 0, 63}, {60, 0, 63, 0}};
        ucs4magic = new byte[][]{{0, 0, -2, -1}, {-1, -2, 0, 0}, {0, 0, -1, -2}, {-2, -1, 0, 0}, {0, 0, 0, 60}, {0, 0, 60, 0}, {0, 60, 0, 0}, {60, 0, 0, 0}};
        utf8magic = new byte[]{-17, -69, -65};
        ebcdicmagic = new byte[]{76, 111, -89, -108};
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("http://openebook.org/dtds/oeb-1.2/oebpkg12.dtd", ResourceUtil.getResourcePath("schema/20/dtd/oebpkg12.dtd"));
        map.put("http://http://idpf.org/dtds/oeb-1.2/oebpkg12.dtd", ResourceUtil.getResourcePath("schema/20/dtd/oebpkg12.dtd"));
        map.put("http://openebook.org/dtds/oeb-1.2/oeb12.ent", ResourceUtil.getResourcePath("schema/20/dtd/oeb12.dtdinc"));
        map.put("http://openebook.org/dtds/oeb-1.2/oebdoc12.dtd", ResourceUtil.getResourcePath("schema/20/dtd/oebdoc12.dtd"));
        map.put("http://www.idpf.org/dtds/2007/opf.dtd", ResourceUtil.getResourcePath("schema/20/dtd/opf20.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", ResourceUtil.getResourcePath("schema/20/dtd/xhtml1-transitional.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", ResourceUtil.getResourcePath("schema/20/dtd/xhtml1-strict.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", ResourceUtil.getResourcePath("schema/20/dtd/xhtml-lat1.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", ResourceUtil.getResourcePath("schema/20/dtd/xhtml-symbol.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", ResourceUtil.getResourcePath("schema/20/dtd/xhtml-special.dtdinc"));
        map.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", ResourceUtil.getResourcePath("schema/20/dtd/svg11.dtd"));
        map.put("http://www.daisy.org/z3986/2005/dtbook-2005-2.dtd", ResourceUtil.getResourcePath("schema/20/dtd/dtbook-2005-2.dtd"));
        map.put("http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", ResourceUtil.getResourcePath("schema/20/dtd/ncx-2005-1.dtd"));
        map.put("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", ResourceUtil.getResourcePath("schema/20/dtd/xhtml11-ent.dtd"));
        map.put("http://www.w3.org/MarkUp/DTD/xhtml11.dtd", ResourceUtil.getResourcePath("schema/20/dtd/xhtml11-ent.dtd"));
        map.put("xhtml-lat1.ent", ResourceUtil.getResourcePath("dtd/xhtml-lat1.dtdinc"));
        map.put("xhtml-symbol.ent", ResourceUtil.getResourcePath("dtd/xhtml-symbol.dtdinc"));
        map.put("xhtml-special.ent", ResourceUtil.getResourcePath("dtd/xhtml-special.dtdinc"));
        systemIdMap = map;
    }
}

