/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.Vocab;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;

public final class EnumVocab<P extends Enum<P>>
implements Vocab {
    public static final Function<Enum<?>, String> ENUM_TO_NAME = new Function<Enum<?>, String>(){

        @Override
        public String apply(Enum<?> enumee) {
            return enumee.name().toLowerCase().replace('_', '-');
        }
    };
    private final Map<String, Property> index;
    private final String uri;

    public EnumVocab(Class<P> clazz, String base) {
        this(clazz, base, null);
    }

    public EnumVocab(Class<P> clazz, final String base, final String prefix) {
        this.uri = Strings.nullToEmpty(base);
        this.index = ImmutableMap.copyOf(Maps.transformEntries(Maps.uniqueIndex(EnumSet.allOf(clazz), ENUM_TO_NAME), new Maps.EntryTransformer<String, P, Property>(){

            @Override
            public Property transformEntry(String name, P enumee) {
                return Property.newFrom(name, base, prefix, enumee);
            }
        }));
    }

    @Override
    public Optional<Property> lookup(String name) {
        return Optional.fromNullable(this.index.get(name));
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public Property get(Enum<P> property) {
        Preconditions.checkNotNull(property);
        return this.lookup(ENUM_TO_NAME.apply(property)).get();
    }
}

