/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.tool;

import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.EpubCheckFactory;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.nav.NavCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.DocumentValidatorFactory;
import com.adobe.epubcheck.opf.OPFCheckerFactory;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.overlay.OverlayCheckerFactory;
import com.adobe.epubcheck.reporting.CheckingReport;
import com.adobe.epubcheck.util.Archive;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.FileResourceProvider;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.util.URLResourceProvider;
import com.adobe.epubcheck.util.XmlReportImpl;
import com.adobe.epubcheck.util.XmpReportImpl;
import com.adobe.epubcheck.util.outWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class EpubChecker {
    String path = null;
    String mode = null;
    EPUBProfile profile = null;
    EPUBVersion version = EPUBVersion.VERSION_3;
    boolean expanded = false;
    boolean keep = false;
    boolean jsonOutput = false;
    boolean xmlOutput = false;
    boolean xmpOutput = false;
    File fileOut;
    File listChecksOut;
    File customMessageFile;
    boolean listChecks = false;
    boolean useCustomMessageFile = false;
    boolean failOnWarnings = false;
    int reportingLevel = 2;
    private static final HashMap<OPSType, String> modeMimeTypeMap;
    private static final HashMap<OPSType, DocumentValidatorFactory> documentValidatorFactoryMap;
    private static final String E_PUB_CHECK_CUSTOM_MESSAGE_FILE = "ePubCheckCustomMessageFile";

    int validateFile(String path, EPUBVersion version, Report report, EPUBProfile profile) {
        GenericResourceProvider resourceProvider;
        if (path.startsWith("http://") || path.startsWith("https://")) {
            resourceProvider = new URLResourceProvider(path);
        } else {
            File f = new File(path);
            if (f.exists()) {
                resourceProvider = new FileResourceProvider(path);
            } else {
                System.err.println(String.format(Messages.get("file_not_found"), path));
                return 1;
            }
        }
        OPSType opsType = new OPSType(this.mode, version);
        DocumentValidatorFactory factory = documentValidatorFactoryMap.get(opsType);
        if (factory == null) {
            outWriter.println(Messages.get("display_help"));
            System.err.println(String.format(Messages.get("mode_version_not_supported"), new Object[]{this.mode, version}));
            throw new RuntimeException(String.format(Messages.get("mode_version_not_supported"), new Object[]{this.mode, version}));
        }
        DocumentValidator check = factory.newInstance(new ValidationContext.ValidationContextBuilder().path(path).report(report).resourceProvider(resourceProvider).mimetype(modeMimeTypeMap.get(opsType)).version(version).profile(profile).build());
        if (check.getClass() == EpubCheck.class) {
            int validationResult = ((EpubCheck)check).doValidate();
            if (validationResult == 0) {
                outWriter.println(Messages.get("no_errors__or_warnings"));
                return 0;
            }
            if (validationResult == 1) {
                System.err.println(Messages.get("there_were_warnings"));
                return this.failOnWarnings ? 1 : 0;
            }
            System.err.println(Messages.get("there_were_errors"));
            return 1;
        }
        if (check.validate()) {
            outWriter.println(Messages.get("no_errors__or_warnings"));
            return 0;
        }
        System.err.println(Messages.get("there_were_errors"));
        return 1;
    }

    int validateEpubFile(String path, EPUBVersion version, Report report) {
        GenericResourceProvider resourceProvider;
        if (path.startsWith("http://") || path.startsWith("https://")) {
            resourceProvider = new URLResourceProvider(path);
        } else {
            File f = new File(path);
            if (f.exists()) {
                resourceProvider = new FileResourceProvider(path);
            } else {
                System.err.println(String.format(Messages.get("file_not_found"), path));
                return 1;
            }
        }
        OPSType opsType = new OPSType(this.mode, version);
        DocumentValidatorFactory factory = documentValidatorFactoryMap.get(opsType);
        if (factory == null) {
            outWriter.println(Messages.get("display_help"));
            System.err.println(String.format(Messages.get("mode_version_not_supported"), new Object[]{this.mode, version}));
            throw new RuntimeException(String.format(Messages.get("mode_version_not_supported"), new Object[]{this.mode, version}));
        }
        DocumentValidator check = factory.newInstance(new ValidationContext.ValidationContextBuilder().path(path).report(report).resourceProvider(resourceProvider).mimetype(modeMimeTypeMap.get(opsType)).version(version).profile(this.profile).build());
        if (check.validate()) {
            outWriter.println(Messages.get("no_errors__or_warnings"));
            return 0;
        }
        System.err.println(Messages.get("there_were_errors"));
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) {
        int returnValue = 1;
        try {
            if (this.processArguments(args)) {
                Report report = this.createReport();
                report.initialize();
                if (this.listChecks) {
                    this.dumpMessageDictionary(report);
                    int n = 0;
                    return n;
                }
                if (this.useCustomMessageFile) {
                    report.setCustomMessageFile(this.customMessageFile.getAbsolutePath());
                }
                returnValue = this.processFile(report);
                int returnValue2 = report.generate();
                if (returnValue == 0) {
                    returnValue = returnValue2;
                }
            }
        }
        catch (Exception ignored) {
            returnValue = 1;
        }
        finally {
            outWriter.println(Messages.get("epubcheck_completed"));
            outWriter.setQuiet(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMessageDictionary(Report report) throws IOException {
        OutputStreamWriter fw = null;
        try {
            fw = this.listChecksOut != null ? new FileWriter(this.listChecksOut) : new OutputStreamWriter(System.out);
            report.getDictionary().dumpMessages(fw);
        }
        catch (Exception e) {
            if (this.listChecksOut != null) {
                System.err.println(String.format(Messages.get("error_creating_config_file"), this.listChecksOut.getAbsoluteFile()));
            }
            System.err.println(e.getMessage());
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Report createReport() throws IOException {
        MasterReport report;
        if (this.listChecks) {
            report = new DefaultReportImpl("none");
        } else if (this.jsonOutput) {
            report = new CheckingReport(this.path, this.fileOut == null ? null : this.fileOut.getPath());
        } else if (this.xmlOutput) {
            PrintWriter pw = null;
            pw = this.fileOut == null ? new PrintWriter(System.out, true) : new PrintWriter(this.fileOut, "UTF-8");
            report = new XmlReportImpl(pw, this.path, EpubCheck.version());
        } else if (this.xmpOutput) {
            PrintWriter pw = null;
            pw = this.fileOut == null ? new PrintWriter(System.out, true) : new PrintWriter(this.fileOut, "UTF-8");
            report = new XmpReportImpl(pw, this.path, EpubCheck.version());
        } else {
            report = new DefaultReportImpl(this.path);
        }
        report.setReportingLevel(this.reportingLevel);
        if (this.useCustomMessageFile) {
            report.setOverrideFile(this.customMessageFile);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processEpubFile(String[] args) {
        int returnValue = 1;
        try {
            if (this.processArguments(args)) {
                Report report = this.createReport();
                report.initialize();
                if (this.listChecks) {
                    this.dumpMessageDictionary(report);
                    int n = 0;
                    return n;
                }
                if (this.useCustomMessageFile) {
                    report.setCustomMessageFile(this.customMessageFile.getAbsolutePath());
                }
                returnValue = this.processEpubFile(report);
                int returnValue2 = report.generate();
                if (returnValue == 0) {
                    returnValue = returnValue2;
                }
            }
        }
        catch (Exception ignored) {
            returnValue = 1;
        }
        finally {
            outWriter.println(Messages.get("epubcheck_completed"));
            outWriter.setQuiet(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int processEpubFile(Report report) {
        report.info(null, FeatureEnum.TOOL_NAME, "epubcheck");
        report.info(null, FeatureEnum.TOOL_VERSION, EpubCheck.version());
        report.info(null, FeatureEnum.TOOL_DATE, EpubCheck.buildDate());
        try {
            if (!this.expanded) {
                if (this.mode != null) {
                    report.info(null, FeatureEnum.EXEC_MODE, String.format(Messages.get("single_file"), new Object[]{this.mode, this.version.toString(), this.profile}));
                }
            } else {
                System.err.println(Messages.get("error_processing_unexpanded_epub"));
                int n = 1;
                return n;
            }
            int result = this.validateFile(this.path, this.version, report, this.profile);
            int n = result;
            return n;
        }
        catch (Throwable e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            report.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processFile(Report report) {
        report.info(null, FeatureEnum.TOOL_NAME, "epubcheck");
        report.info(null, FeatureEnum.TOOL_VERSION, EpubCheck.version());
        report.info(null, FeatureEnum.TOOL_DATE, EpubCheck.buildDate());
        int result = 0;
        try {
            if (this.expanded) {
                Archive epub;
                try {
                    epub = new Archive(this.path, true);
                }
                catch (RuntimeException ex) {
                    System.err.println(Messages.get("there_were_errors"));
                    int n = 1;
                    report.close();
                    return n;
                }
                epub.createArchive();
                report.setEpubFileName(epub.getEpubFile().getAbsolutePath());
                EpubCheck check = new EpubCheck(epub.getEpubFile(), report, this.profile);
                int validationResult = check.doValidate();
                if (validationResult == 0) {
                    outWriter.println(Messages.get("no_errors__or_warnings"));
                    result = 0;
                } else if (validationResult == 1) {
                    System.err.println(Messages.get("there_were_warnings"));
                    result = this.failOnWarnings ? 1 : 0;
                } else if (validationResult >= 2) {
                    System.err.println(Messages.get("there_were_errors"));
                    result = 1;
                }
                if (this.keep) {
                    if (report.getErrorCount() > 0 || report.getFatalErrorCount() > 0) {
                        System.err.println(Messages.get("deleting_archive"));
                        epub.deleteEpubFile();
                    }
                } else {
                    epub.deleteEpubFile();
                }
            } else {
                if (this.mode != null) {
                    report.info(null, FeatureEnum.EXEC_MODE, String.format(Messages.get("single_file"), new Object[]{this.mode, this.version.toString(), this.profile}));
                }
                result = this.validateFile(this.path, this.version, report, this.profile);
            }
            int epub = result;
            return epub;
        }
        catch (Throwable e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            report.close();
        }
    }

    private boolean processArguments(String[] args) {
        if (args.length < 1) {
            System.err.println(Messages.get("argument_needed"));
            return false;
        }
        this.setCustomMessageFileFromEnvironment();
        for (int i = 0; i < args.length; ++i) {
            File pathFile;
            if (args[i].equals("--version") || args[i].equals("-version") || args[i].equals("-v")) {
                if (i + 1 < args.length) {
                    if (args[++i].equals("2.0") || args[i].equals("2")) {
                        this.version = EPUBVersion.VERSION_2;
                        continue;
                    }
                    if (args[i].equals("3.0") || args[i].equals("3")) {
                        this.version = EPUBVersion.VERSION_3;
                        continue;
                    }
                    outWriter.println(Messages.get("display_help"));
                    throw new RuntimeException(new InvalidVersionException("Version not supported"));
                }
                outWriter.println(Messages.get("display_help"));
                throw new RuntimeException(Messages.get("version_argument_expected"));
            }
            if (args[i].equals("--mode") || args[i].equals("-mode") || args[i].equals("-m")) {
                if (i + 1 < args.length) {
                    this.mode = args[++i];
                    this.expanded = this.mode.equals("exp");
                    continue;
                }
                outWriter.println(Messages.get("display_help"));
                throw new RuntimeException(Messages.get("mode_argument_expected"));
            }
            if (args[i].equals("--profile") || args[i].equals("-profile") || args[i].equals("-p")) {
                if (i + 1 < args.length) {
                    String profileStr = args[++i];
                    try {
                        this.profile = EPUBProfile.valueOf(profileStr.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(Messages.get("mode_version_ignored", profileStr));
                        this.profile = EPUBProfile.DEFAULT;
                    }
                    continue;
                }
                outWriter.println(Messages.get("display_help"));
                throw new RuntimeException(Messages.get("profile_argument_expected"));
            }
            if (args[i].equals("--save") || args[i].equals("-save") || args[i].equals("-s")) {
                this.keep = true;
                continue;
            }
            if (args[i].equals("--out") || args[i].equals("-out") || args[i].equals("-o")) {
                if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    this.fileOut = new File(args[++i]);
                } else if (args.length > i + 1 && args[i + 1].equalsIgnoreCase("-")) {
                    this.fileOut = null;
                    ++i;
                } else {
                    pathFile = new File(this.path);
                    this.fileOut = pathFile.isDirectory() ? new File(pathFile.getAbsoluteFile().getParentFile(), pathFile.getName() + "check.xml") : new File(this.path + "check.xml");
                }
                this.xmlOutput = true;
                continue;
            }
            if (args[i].equals("--json") || args[i].equals("-json") || args[i].equals("-j")) {
                if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    this.fileOut = new File(args[++i]);
                } else if (args.length > i + 1 && args[i + 1].equalsIgnoreCase("-")) {
                    this.fileOut = null;
                    ++i;
                } else {
                    pathFile = new File(this.path);
                    this.fileOut = pathFile.isDirectory() ? new File(pathFile.getAbsoluteFile().getParentFile(), pathFile.getName() + "check.json") : new File(this.path + "check.json");
                }
                this.jsonOutput = true;
                continue;
            }
            if (args[i].equals("--xmp") || args[i].equals("-xmp") || args[i].equals("-x")) {
                if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    this.fileOut = new File(args[++i]);
                } else if (args.length > i + 1 && args[i + 1].equalsIgnoreCase("-")) {
                    this.fileOut = null;
                    ++i;
                } else {
                    pathFile = new File(this.path);
                    this.fileOut = pathFile.isDirectory() ? new File(pathFile.getAbsoluteFile().getParentFile(), pathFile.getName() + "check.xmp") : new File(this.path + "check.xmp");
                }
                this.xmpOutput = true;
                continue;
            }
            if (args[i].equals("--info") || args[i].equals("-i")) {
                this.reportingLevel = 2;
                continue;
            }
            if (args[i].equals("--fatal") || args[i].equals("-f")) {
                this.reportingLevel = 5;
                continue;
            }
            if (args[i].equals("--error") || args[i].equals("-e")) {
                this.reportingLevel = 4;
                continue;
            }
            if (args[i].equals("--warn") || args[i].equals("-w")) {
                this.reportingLevel = 3;
                continue;
            }
            if (args[i].equals("--usage") || args[i].equals("-u")) {
                this.reportingLevel = 1;
                continue;
            }
            if (args[i].equals("--quiet") || args[i].equals("-q")) {
                outWriter.setQuiet(true);
                continue;
            }
            if (args[i].startsWith("--failonwarnings")) {
                String fw = args[i].substring("--failonwarnings".length());
                this.failOnWarnings = fw.compareTo("-") != 0;
                continue;
            }
            if (args[i].equals("--redir") || args[i].equals("-r")) {
                if (i + 1 >= args.length) continue;
                this.fileOut = new File(args[++i]);
                continue;
            }
            if (args[i].equals("--customMessages") || args[i].equals("-c")) {
                if (i + 1 >= args.length) continue;
                String fileName = args[i + 1];
                if ("none".compareTo(fileName.toLowerCase()) == 0) {
                    this.customMessageFile = null;
                    this.useCustomMessageFile = false;
                    ++i;
                    continue;
                }
                if (!fileName.startsWith("-")) {
                    this.customMessageFile = new File(fileName);
                    this.useCustomMessageFile = true;
                    ++i;
                    continue;
                }
                System.err.println(String.format(Messages.get("expected_message_filename"), fileName));
                EpubChecker.displayHelp();
                return false;
            }
            if (args[i].equals("--listChecks") || args[i].equals("-l")) {
                if (i + 1 < args.length) {
                    this.listChecksOut = !args[i + 1].startsWith("-") ? new File(args[++i]) : null;
                }
                this.listChecks = true;
                continue;
            }
            if (args[i].equals("--help") || args[i].equals("-help") || args[i].equals("-h") || args[i].equals("-?")) {
                EpubChecker.displayHelp();
                continue;
            }
            if (this.path == null) {
                this.path = args[i];
                continue;
            }
            System.err.println(String.format(Messages.get("unrecognized_argument"), args[i]));
            EpubChecker.displayHelp();
            return false;
        }
        if (this.xmlOutput && this.xmpOutput || this.xmlOutput && this.jsonOutput || this.xmpOutput && this.jsonOutput) {
            System.err.println(Messages.get("output_type_conflict"));
            return false;
        }
        if (this.path != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.path.length(); ++i) {
                if (this.path.charAt(i) == '\\') {
                    sb.append('/');
                    continue;
                }
                sb.append(this.path.charAt(i));
            }
            this.path = sb.toString();
        }
        if (this.path == null) {
            if (this.listChecks) {
                return true;
            }
            System.err.println(Messages.get("no_file_specified"));
            return false;
        }
        if (this.path.matches(".+\\.[Ee][Pp][Uu][Bb]")) {
            if (this.mode != null || this.version != EPUBVersion.VERSION_3) {
                System.err.println(Messages.get("mode_version_ignored"));
                this.mode = null;
            }
        } else if (this.mode == null) {
            outWriter.println(Messages.get("mode_required"));
            return false;
        }
        return true;
    }

    private void setCustomMessageFileFromEnvironment() {
        File f;
        Map<String, String> env = System.getenv();
        String customMessageFileName = env.get(E_PUB_CHECK_CUSTOM_MESSAGE_FILE);
        if (customMessageFileName != null && customMessageFileName.length() > 0 && (f = new File(customMessageFileName)).exists()) {
            this.customMessageFile = f;
            this.useCustomMessageFile = true;
        }
    }

    private static void displayHelp() {
        outWriter.println(String.format(Messages.get("help_text"), EpubCheck.version()));
    }

    static {
        HashMap<OPSType, Object> map = new HashMap<OPSType, Object>();
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), "application/xhtml+xml");
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), "application/xhtml+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), "image/svg+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), "image/svg+xml");
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), "application/smil+xml");
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), "application/xhtml+xml");
        modeMimeTypeMap = map;
        map = new HashMap();
        map.put(new OPSType(null, EPUBVersion.VERSION_2), EpubCheckFactory.getInstance());
        map.put(new OPSType(null, EPUBVersion.VERSION_3), EpubCheckFactory.getInstance());
        map.put(new OPSType("opf", EPUBVersion.VERSION_2), OPFCheckerFactory.getInstance());
        map.put(new OPSType("opf", EPUBVersion.VERSION_3), OPFCheckerFactory.getInstance());
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), OPSCheckerFactory.getInstance());
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), OPSCheckerFactory.getInstance());
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), OPSCheckerFactory.getInstance());
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), OPSCheckerFactory.getInstance());
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), OverlayCheckerFactory.getInstance());
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), NavCheckerFactory.getInstance());
        documentValidatorFactoryMap = map;
    }
}

