/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.xml.ScriptTagHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.SearchDictionary;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EpubScriptCheck
implements DocumentValidator {
    private final ZipFile zip;
    private final Report report;
    private final EpubPackage epack;

    public EpubScriptCheck(EpubPackage epack, Report report) {
        this.zip = epack.getZip();
        this.report = report;
        this.epack = epack;
    }

    @Override
    public boolean validate() {
        boolean result = false;
        SearchDictionary vtsd = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        for (int i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem mi = this.epack.getManifest().getItem(i);
            if (vtsd.isValidMediaType(mi.getMediaType())) {
                XMLContentDocParser parser = new XMLContentDocParser(this.zip, this.report);
                ScriptTagHandler sh = new ScriptTagHandler(this.report);
                String fileToParse = this.epack.getManifestItemFileName(mi);
                ZipEntry entry = this.zip.getEntry(fileToParse);
                if (entry == null) continue;
                sh.setFileName(fileToParse);
                sh.setVersion(this.epack.getVersion());
                parser.parseDoc(fileToParse, sh);
                if (sh.getScriptElementCount() > 0 || sh.getInlineScriptCount() > 0) {
                    if (sh.getInlineScriptCount() > 0) {
                        this.report.info(fileToParse, FeatureEnum.SCRIPT, "inline");
                    }
                    if (sh.getScriptElementCount() > 0) {
                        this.report.info(fileToParse, FeatureEnum.SCRIPT, "tag");
                    }
                    if (this.epack.getVersion() != EPUBVersion.VERSION_2) {
                        this.report.message(MessageId.SCP_010, EPUBLocation.create(fileToParse), new Object[0]);
                        if (mi.getProperties() == null || !mi.getProperties().contains("scripted")) {
                            this.report.message(MessageId.SCP_005, EPUBLocation.create(fileToParse), new Object[0]);
                        }
                    }
                }
            }
            this.checkJavascript(mi);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkJavascript(ManifestItem mi) {
        InputStream is = null;
        BufferedReader reader = null;
        String mediaType = mi.getMediaType();
        if (mediaType != null && "text/javascript".equalsIgnoreCase(mediaType)) {
            String fileToParse = this.epack.getManifestItemFileName(mi);
            ZipEntry entry = this.zip.getEntry(fileToParse);
            if (entry == null) {
                return;
            }
            this.report.info(fileToParse, FeatureEnum.SCRIPT, "javascript");
            this.report.info(fileToParse, FeatureEnum.HAS_SCRIPTS, "");
            if (this.epack.getVersion() == EPUBVersion.VERSION_2) {
                this.report.message(MessageId.SCP_004, EPUBLocation.create(fileToParse), new Object[0]);
            } else {
                this.report.message(MessageId.SCP_010, EPUBLocation.create(fileToParse), new Object[0]);
            }
            try {
                is = this.zip.getInputStream(entry);
                reader = new BufferedReader(new InputStreamReader(is));
                int lineNumber = 0;
                while (reader.ready()) {
                    String line = reader.readLine();
                    this.CheckForInner(fileToParse, ++lineNumber, line);
                }
                reader.close();
                is.close();
            }
            catch (FileNotFoundException ex) {
                this.report.message(MessageId.RSC_001, EPUBLocation.create(fileToParse), fileToParse);
            }
            catch (IOException ex) {
                this.report.message(MessageId.PKG_008, EPUBLocation.create(fileToParse), fileToParse);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    public void CheckForInner(String fileName, int line, String script) {
        String lower = script.toLowerCase();
        int column = lower.indexOf("innerhtml");
        if (column >= 0) {
            this.report.message(MessageId.SCP_007, EPUBLocation.create(fileName, line, column, EpubScriptCheck.trimContext(script, column)), new Object[0]);
        }
        if ((column = lower.indexOf("innertext")) >= 0) {
            this.report.message(MessageId.SCP_008, EPUBLocation.create(fileName, line, column, EpubScriptCheck.trimContext(script, column)), new Object[0]);
        }
        Matcher m = null;
        if (script.contains("eval") && (m = ScriptTagHandler.evalPattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_001, EPUBLocation.create(fileName, line, m.start(0), EpubScriptCheck.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = ScriptTagHandler.localStoragePattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_003, EPUBLocation.create(fileName, line, m.start(0), EpubScriptCheck.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = ScriptTagHandler.sessionStoragePattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_003, EPUBLocation.create(fileName, line, m.start(0), EpubScriptCheck.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = ScriptTagHandler.xmlHttpRequestPattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_002, EPUBLocation.create(fileName, line, m.start(0), EpubScriptCheck.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = ScriptTagHandler.microsoftXmlHttpRequestPattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_002, EPUBLocation.create(fileName, line, m.start(0), EpubScriptCheck.trimContext(script, m.start())), new Object[0]);
        }
    }

    public static String trimContext(String context, int start) {
        String trimmed = context.substring(start).trim();
        int end = trimmed.indexOf("\n");
        if (end < 0 && trimmed.length() < 60) {
            return trimmed;
        }
        int newEnd = Math.min(60, end > 0 ? end : trimmed.length());
        return trimmed.substring(0, newEnd);
    }
}

