# -*- coding: utf-8 -*-

OK = 0                                                         #: Nessun errore
ERROR = -1                                                     #: Errore generico
INTERNAL_ERROR = 1                                             #: Errore interno
OUT_OF_MEMORY = 2                                              #: Memoria esaurita
ACCESS_DENIED = 3                                              #: Accesso negato
TIMED_OUT = 4                                                  #: Tempo scaduto
INTERRUPTED = 5                                                #: Operazione interrotta
NOT_INITIALIZED = 6                                            #: Oggetto non inizializzato
ABORTED = 7                                                    #: Operazione annullata
TOO_MANY_OPEN_FILES = 8                                        #: Troppi file aperti
FILE_NOT_FOUND = 9                                             #: File non trovato
IO_ERROR = 10                                                  #: Errore di input/output
FILE_EXISTS = 11                                               #: Il file già esiste
RESOURCE_UNAVAILABLE = 12                                      #: La risorsa non è disponibile
DISK_FULL = 13                                                 #: Disco pieno
WOULD_BLOCK = 14                                               #: L'operazione sarebbe bloccante
INVALID_RESOURCE = 15                                          #: Risorsa non valida
CANNOT_CREATE_SOCKET = 100                                     #: Impossibile creare il socket
PROTOCOL_NOT_SUPPORTED = 101                                   #: Protocollo non supportato
BAD_ADDRESS = 102                                              #: Indirizzo dell'host non valido
CONNECTION_REFUSED = 103                                       #: Connessione rifiutata
NETWORK_IS_UNREACHABLE = 104                                   #: La rete non è raggiungibile
HOST_IS_UNREACHABLE = 105                                      #: L'host non è raggiungibile
ADDRESS_ALREADY_IN_USE = 106                                   #: Indirizzo già in uso
CANNOT_CONNECT = 107                                           #: Impossibile connettersi
CANNOT_CONFIGURE_SOCKET = 108                                  #: Impossibile configurare il socket
CANNOT_BIND_SOCKET = 109                                       #: Impossibile effettuare il bind del socket
CANNOT_LISTEN_SOCKET = 110                                     #: Impossibile mettere il socket in ascolto
WINSOCK_VERSION_NOT_SUPPORTED = 111                            #: Versione di Winsock non supportata
ERROR_READING_SOCKET = 112                                     #: Errore in lettura dal socket
ERROR_WRITING_SOCKET = 113                                     #: Errore in scrittura sul socket
NOT_CONNECTED = 114                                            #: Non connesso
CONNECTION_LOST = 115                                          #: La connessione è stata persa
ALREADY_CONNECTED = 116                                        #: Connessione già stabilita
BAD_SOCKET = 117                                               #: Socket non valido
NO_NICS_FOUND = 118                                            #: Nessuna interfaccia di rete trovata
BAD_REQUEST = 200                                              #: Richiesta di esecuzione non valida
BAD_REPLY = 201                                                #: Risposta dal server non valida
NOT_AUTHORIZED = 202                                           #: Autorizzazione fallita
AUTHORIZATION_DATA_TOO_BIG = 203                               #: Dati di autorizzazione troppo grandi
EXECUTE_FAILED = 204                                           #: La richiesta di esecuzione è fallita sul server
EXECUTE_ABORTED = 205                                          #: Richiesta di esecuzione annullata dall'utente
LISTENER_PORT_UNAVAILABLE = 206                                #: Porta di ascolto non disponibile
RESPONDER_PORT_UNAVAILABLE = 207                               #: Porta di risposta non disponibile
CLIENT_NOT_FOUND = 208                                         #: Client ID non trovato
SKIP_REQUEST = 209                                             #: Non registrare la richiesta al server
PIN_TO_THREAD = 210                                            #: Assegna il client al thread corrente del server
UNPIN_FROM_THREAD = 211                                        #: Rilascia il client dal thread corrente del server
OK_NO_TRANSACTION = 212                                        #: Completa la richiesta con successo senza commit/rollback di transazione
ARCHIVE_NOT_FOUND = 300                                        #: Archivio non trovato
MALFORMED_RESOURCE_INDEX = 301                                 #: Indice delle risorse non valido nell'archivio
MALFORMED_RESOURCE_DEFINITION = 302                            #: Definizione della risorsa non valida
CANNOT_FIND_RESOURCE_IN_ARCHIVE = 303                          #: Risorsa non trovata nell'archivio
CANNOT_READ_RESOURCE = 304                                     #: Impossibile leggere la risorsa
CONFLICTING_RESOURCE_FILE_NAME = 305                           #: Il nome del file di risorsa è in conflitto con un altro file nell'archivio
CANNOT_WRITE_RESOURCE = 306                                    #: Impossibile scrivere la risorsa
ARCHIVE_NOT_LOADED = 307                                       #: Archivio non caricato
BAD_STREAM = 400                                               #: Flusso dati corrotto
END_STREAM = 401                                               #: Flusso dati terminato
NO_MATCH = 500                                                 #: Nessun risultato
FATAL_SERVER_ERROR = 1999
INITIALIZING_DRIVERS = 2000
INVALID_DRIVERS_PATH_FALLING_BACK = 2001
INVALID_DRIVERS_PATH = 2002
NO_DRIVERS_FOUND = 2003
DRIVER_INITIALIZED = 2004
INVALID_LOG_PATH = 2005                                        #: Percorso del file di log non valido
CANNOT_PARSE_CONFIG_FILE = 2006
SERVER_NOT_CONFIGURED = 2007                                   #: Il server non è configurato
SERVER_INIT = 2008
SERVER_TERM = 2009
SERVER_RENAMED = 2010
DATABASE_OUTDATED = 2011                                       #: Il database è datato e necessita aggiornamento
BACKUP_NOT_FOUND = 2012                                        #: File di backup non trovato
INVALID_BACKUP = 2013                                          #: Il file di backup non è valido
NOT_IMPLEMENTED = 2014                                         #: Funzionalità non ancora implementata
TRANSACTION_BEGIN = 2015
TRANSACTION_COMMIT = 2016
TRANSACTION_ROLLBACK = 2017
CREATING_TABLE_TS_CACHE = 2018                                 #: Creazione della cache dei timestamp di modifica delle tabelle su prima connessione
USING_EXISTING_TABLE_TS_CACHE = 2019                           #: Riutilizzo della cache dei timestamp di modifica delle tabelle
UNSPECIFIED_LISTENER_PORT = 2020                               #: Porta di ascolto non specificata nella configurazione del server
NOT_ACTIVATED = 2021                                           #: Il prodotto non è stato ancora attivato
ACTIVATION_EXPIRED = 2022                                      #: La chiave di attivazione del prodotto è scaduta
ACTIVATION_NOT_VALID_ANYMORE = 2023                            #: L'attivazione del prodotto non è più valida per questa versione del programma; si prega di contattare EasyByte Software per ottenere una nuova licenza d'uso.
TOO_MANY_CLIENTS = 2024                                        #: Troppi utenti connessi; è necessario aggiornare la licenza di Konga per consentire un maggior numero di postazioni
ACTIVATED_TRIAL = 2025
ACTIVATED_BETA = 2026
ACTIVATED = 2027
UNLIMITED_CLIENTS = 2028                                       #: illimitati
ACTIVATION_PRODUCT_MISMATCH = 2029                             #: La chiave di attivazione fornita non supporta questo prodotto
CANNOT_CONNECT_EXTERNAL_CLIENT = 2030                          #: Il server non supporta connessioni da client esterni
TOO_MANY_BUSINESSES_FOR_LITE = 2031                            #: Konga Lite non supporta la gestione di più di un'azienda
TOO_MANY_ITEMS_FOR_LITE = 2032                                 #: Konga Lite non supporta la gestione di più di 250 articoli
TOO_MANY_CLIENTS_FOR_LITE = 2033                               #: Konga Lite non supporta la gestione di più di 250 tra clienti e fornitori
BACKUP_ALREADY_EXISTS = 2034                                   #: Il backup specificato già esiste
INVALID_BACKUP_PATH = 2035                                     #: Percorso del file di backup non valido
CANNOT_INDEX_RECORD = 2036
INDEXING_IN_PROGRESS = 2037                                    #: L'indicizzazione del database è già in corso
OLD_CONFIG_VERSION = 2038                                      #: La versione delle preferenze del server è vecchia
DRIVER_NOT_CONFIGURED = 2039
COMMAND_NOT_ALLOWED = 2040                                     #: Il comando non può essere eseguito nel contesto della connessione corrente
SERVER_PORT_OVERRIDE = 2041
RESOURCE_LOCKED = 2042                                         #: Risorsa utilizzata da un altro utente
SERVER_NEW_SESSION = 2043
SERVER_EXPIRED_SESSION = 2044
LDAP_SERVER_NOT_CONFIGURED = 2045                              #: Server LDAP non configurato
LDAP_SERVER_NOT_FOUND = 2046                                   #: Server LDAP non trovato
LDAP_SERVER_ERROR = 2047                                       #: Errore di comunicazione con il server LDAP
SERVER_VERSION = 2048
LOADED_USER_SERVER_CONFIG = 2049
EMAIL_SEND_FAILURE = 2050
EMAIL_TEST_SUBJECT = 2051                                      #: [konga] Messaggio di prova
EMAIL_TEST_BODY = 2052                                         #: Questo è un messaggio di prova inviato da Konga.
INVALID_TENANT_KEY = 2053                                      #: La chiave di proprietà inserita non è valida
TENANT_MISMATCH_DELETING_DATABASE = 2054                       #: Impossibile cancellare il database poichè appartiene ad un altro proprietario
TENANT_MISMATCH_DELETING_BACKUP = 2055                         #: Impossibile cancellare il backup poichè appartiene ad un altro proprietario
KSS_ERROR = 2056
LDAP_BAD_USER_NAME = 2057                                      #: Il nome deve includere la specifica di dominio
INVALID_BACKUP_POSITION = 2058                                 #: Posizione del backup non valida
DEAD_CLIENT = 2059                                             #: Il client non è più valido ed è impossibile eseguire la richiesta
INVALID_ALLEGATI_ACTION = 2060                                 #: Azione sugli allegati non valida
ENCRYPTED_BACKUP = 2061                                        #: Il backup è cifrato e richiede una password valida per la decifrazione
ENCRYPTION_NOT_SUPPORTED = 2062                                #: Impossibile cifrare il database a causa della mancanza del supporto di Konga modulo X
ENCRYPTION_NOT_ENABLED = 2063                                  #: Impossibile cifrare il database: il supporto per la crittografia dei dati è disabilitato
ENCRYPTION_ERROR = 2064                                        #: Errore di crifratura del database
ENCRYPTION_NOT_SUPPORTED_BY_RDBMS = 2065
CANNOT_SET_ENCRYPTION_PASSWORD = 2066                          #: Impossibile impostare la password crittografica; la crittografia dei dati verrà disabilitata
CANNOT_EXECUTE_TRIGGER = 2067
TRIGGER_OUTPUT = 2068
TRIGGER_ERROR = 2069
CRYPTO_SUPPORT_ENABLED = 2070                                  #: Crittografia dei dati abilitata
EDI_SERVICE_ENABLED = 2071
SERVER_NOT_CONFIGURED_ARCHIVE = 2072                           #: Risorse del server non trovate
INDEX_STORAGE_CONVERTION_ERROR = 2073                          #: Errore di conversione indice di ricerca del database; si prega di vedere il log del server per maggiori informazioni
FTS_ERROR = 2074                                               #: Errore nell'indice di ricerca del database; si prega di vedere il log del server per maggiori informazioni
DATABASE_HAS_DIFFERENT_OWNER = 2075
DRIVER_LOAD_FAILED = 2100
MALFORMED_DRIVER = 2101
INCOMPATIBLE_DRIVER_VERSION = 2102
DRIVER_CANNOT_LIST = 2103
DRIVER_CANNOT_CREATE = 2104
DRIVER_CANNOT_DELETE = 2105
DRIVER_CANNOT_RENAME = 2106
DRIVER_CANNOT_CONNECT = 2107
DRIVER_CANNOT_QUERY = 2108
DRIVER_CANNOT_QUERY_NATIVELY = 2109
DRIVER_CANNOT_FETCH_COLUMN_NAMES = 2110
DRIVER_CANNOT_FETCH_ROW = 2111
DRIVER_CANNOT_CONTROL = 2112
DRIVER_CANNOT_BIND = 2113
DRIVER_ERROR = 2114
DRIVER_NOT_SUPPORTED = 2115
DRIVER_RELOADED = 2116
DRIVER_CANNOT_REPAIR = 2117
DRIVER_CANNOT_ENCRYPT = 2118
DRIVER_CANNOT_CLONE = 2119
RESULT_ROW = 2200                                              #: Riga ottenuta con successo dal risultato della query
RESULT_DONE = 2201                                             #: Il risultato della query non ha più righe disponibili
RESULT_ERROR = 2202                                            #: Errore del driver durante l'ottenimento del risultato della query
PERMISSION_DENIED = 2203                                       #: Permesso negato
IO_ERROR = 2204                                                #: Errore di input/output
DISK_FULL = 2205                                               #: Il disco è pieno
BAD_DATABASE = 2206                                            #: Il database è corrotto o non valido
DATABASE_NOT_FOUND = 2207                                      #: Database non trovato
QUERY_ERROR = 2208                                             #: Errore di esecuzione della query
QUERY_ERROR_EX = 2209
QUERY_ERROR_LOG = 2210
DATABASE_BUSY = 2211                                           #: Il database è occupato
CANNOT_CONNECT_REMOTE_DB = 2212                                #: Impossibile connettersi al database remoto
COMMAND_NOT_SUPPORTED = 2213                                   #: Comando di controllo non supportato
BAD_PARAMETER = 2214                                           #: Nome di parametro sconosciuto
DATABASE_EXISTS = 2215                                         #: Il database già esiste
INVALID_NAME = 2216                                            #: Nome non valido
NO_ACTIVE_TRANSACTION = 2217                                   #: Nessuna transazione attiva
CANNOT_RENAME_OPEN_DATABASE = 2218                             #: Impossibile rinominare il database: ci sono postazioni connesse
QUERY_ERRORV = 2228
DRIVER_LOST_CONNECTION = 2229
ENCRYPTED_DATABASE = 2230                                      #: Il database è cifrato e richiede una password valida per la decifrazione
DATA_DICTIONARY_NOT_FOUND = 2400                               #: Dizionario dei dati non trovato
CANNOT_LOAD_DATA_DICTIONARY = 2401
MALFORMED_DATA_DICTIONARY = 2402                               #: Il data dictionary non è valido
MALFORMED_DATA_DICTIONARY_TABLE = 2403
MALFORMED_DATA_DICTIONARY_FIELD = 2404
MALFORMED_DATA_DICTIONARY_CONTEXT = 2405
DATA_DICTIONARY_INTEGRITY_COMPROMISED = 2406                   #: Controllo di integrità del data dictionary fallito
DATA_DICTIONARY_INTEGRITY_COMPROMISED_ON_FOREIGN_KEY = 2407
UNSOLVABLE_DATA_DICTIONARY_REFERENCE_CYCLE_DETECTED = 2408     #: Riferimento ciclico insolvibile individuato nel data dictionary
UNSOLVED_REFERENCES = 2409                                     #: Riferimenti insoluti:
DATA_DICTIONARY_REFERENCE_CYCLE_DETECTED = 2410
DATA_DICTIONARY_MISSING_CONTEXT_FIELD = 2411
DATA_DICTIONARY_MISSING_CONTEXT = 2412
DATA_DICTIONARY_MISSING_CHOICE = 2413
DATA_DICTIONARY_HAS_DUP_TABLE = 2414
DATA_DICTIONARY_HAS_DUP_FIELD = 2415
DATA_DICTIONARY_HAS_DUP_INDEX = 2416
DATA_DICTIONARY_MISSING_INDEX_FIELD = 2417
DATA_DICTIONARY_CREATION_QUERY = 2418
DATA_DICTIONARY_UPGRADING_QUERY = 2419
DATA_DICTIONARY_LOAD_QUERY = 2420
DATA_DICTIONARY_HAS_DUP_CHOICE = 2421
DATA_DICTIONARY_HAS_DUP_OPTIONVALUE = 2422
DATA_DICTIONARY_HAS_DUP_CONTEXT = 2423
DATA_DICTIONARY_CODES_UNKNOWN_FIELD = 2424
INVALID_DATA_DICTIONARY_CHOICE_NAME = 2425
INVALID_DATA_DICTIONARY_TABLE_NAME = 2426
INVALID_DATA_DICTIONARY_FIELD_NAME = 2427
INVALID_DATA_DICTIONARY_INDEX_NAME = 2428
DATA_DICTIONARY_TOO_MANY_FIELDS_IN_TABLE = 2429
DATA_DICTIONARY_TOO_MANY_REFERENCES_IN_TABLE = 2430
UPGRADE_CREATED_TABLE = 2500
UPGRADE_DELETED_TABLE = 2501
UPGRADE_MODIFIED_TABLE = 2502
UPGRADE_ADDED_FIELD = 2503
UPGRADE_DELETED_FIELD = 2504
UPGRADE_MODIFIED_FIELD = 2505
UPGRADE_CREATED_INDEX = 2506
UPGRADE_DELETED_INDEX = 2507
UPGRADE_FINISHED = 2508
UPGRADE_NOT_NEEDED = 2509                                      #: Il database risulta già aggiornato correttamente all'ultima versione
DATABASE_TOO_NEW = 2510                                        #: Il database ha una versione troppo nuova per essere aperto dal server
PROGRESS_CREATING_STRUCTURE = 2600                             #: Creo la struttura del database
PROGRESS_POPULATING_STORAGE_TABLES = 2601                      #: Inizializzo le tabelle di struttura
PROGRESS_CREATING_INDICES = 2602                               #: Creo gli indici
PROGRESS_OPTIMIZING_DATABASE = 2603                            #: Ottimizzo il database
PROGRESS_UPGRADING_STRUCTURE = 2604                            #: Aggiorno la struttura del database
PROGRESS_UPDATING_STORAGE_TABLES = 2605                        #: Aggiorno le tabelle di struttura
PROGRESS_UPGRADING_INDICES = 2606                              #: Aggiorno gli indici
PROGRESS_UPGRADE_CLEANUP = 2607                                #: Registro le modifiche (potrebbe impiegare qualche minuto…)
PROGRESS_INITIALIZING_BACKUP = 2608                            #: Inizializzo il backup
PROGRESS_BACKUP_TABLE = 2609
PROGRESS_RESTORE_TABLE = 2610
PROGRESS_RESTORE_CLEANUP = 2611                                #: Concludo il ripristino
PROGRESS_INDEXING = 2612                                       #: Indicizzo i dati in coda
PROGRESS_RESETTING_INDEX = 2613                                #: Scansiono i dati da indicizzare
PROGRESS_UP_ORD_FORN = 2614                                    #: Aggiornamento Ordini Fornitori in corso…
PROGRESS_UP_TIP_DOC = 2615                                     #: Aggiornamento Tipologie Documenti in corso…
PROGRESS_SAVING_BACKUP = 2616                                  #: Registro il file di backup…
PROGRESS_UPGRADE_PATCHING = 2617                               #: Aggiusto il database…
PROGRESS_UPGRADE_LOADING = 2618                                #: Controllo il database…
PROGRESS_ELAB_VERIFICA_SALDI_GET_SK = 2619                     #: Recupero dati schede contabili
PROGRESS_ELAB_VERIFICA_SALDI_GET_PROG_SK = 2620                #: Recupero progressivi schede contabili
PROGRESS_ELAB_VERIFICA_SALDI_GET_PROG_CLIFOR = 2621            #: Recupero progressivi clienti/fornitori
PROGRESS_ELAB_VERIFICA_SALDI_PROG = 2622                       #: Verifico i progressivi…
PROGRESS_ELAB_VERIFICA_SALDI_DATI_IVA = 2623                   #: Verifico i dati IVA…
PROGRESS_ELAB_VERIFICA_SALDI_FIXING = 2624                     #: Applico le correzioni necessarie…
PROGRESS_UPLOADING_TO_CLOUD = 2625                             #: Sposto i dati nel cloud…
PROGRESS_DOWNLOADING_FROM_CLOUD = 2626                         #: Ottengo i dati dal cloud…
SCHEDULER_CANNOT_LIST_DATABASES = 2700
SCHEDULER_CANNOT_CONNECT = 2701
SCHEDULER_JOB_ERROR = 2702
SCHEDULER_OPTIMIZATION_STARTED = 2703
SCHEDULER_OPTIMIZATION_FINISHED = 2704
SCHEDULER_BACKUP_STARTED = 2705
SCHEDULER_BACKUP_FINISHED = 2706
SCHEDULER_INDEXING_STARTED = 2707
SCHEDULER_INDEXING_FINISHED = 2708
SCHEDULER_UNKNOWN_JOB_TYPE = 2709
SCHEDULER_STARTING_JOB = 2710
SCHEDULER_EMPTY_JOB = 2711
SCHEDULER_CANNOT_START_JOB = 2712
SCHEDULER_SKIPPED_JOB = 2713
SCHEDULER_INDEX_RESET_STARTED = 2714
SCHEDULER_INDEX_RESET_FINISHED = 2715
SCHEDULER_CLEARING_INDEX = 2715
SCHEDULER_EDI_CANNOT_RUN_ON_ARCHIVE = 2716
WEB_SERVICE_STARTED = 3000
WEB_SERVICE_STOPPED = 3001                                     #: Servizio web fermato
WEB_SERVICE_NO_SERVICES = 3002                                 #: nessuno
WEB_SERVICE_DESC_JSON = 3050                                   #: Gestore di richieste JSON-RPC
WEB_SERVICE_DESC_CONSOLE = 3051                                #: Console ridotta di amministrazione remota
WEB_SERVICE_DESC_BARCODES = 3052                               #: Gestore lettori di codici a barre remoti
WEB_SERVICE_DESC_BINARY = 3053                                 #: Accesso diretto a immagini e allegati
WEB_JSON_RPC_INVALID_REQUEST = 3100                            #: La richiesta non è una richiesta JSON-RPC valida
WEB_JSON_RPC_METHOD_NOT_FOUND = 3101                           #: La procedura remota richiesta non esiste o non è disponibile
WEB_CONSOLE_TITLE = 3200                                       #: Console di amministrazione remota di Konga
WEB_INVALID_BINARY_DATA = 3300                                 #: Dati binari non validi; previsti dati codificati in base64
UNKNOWN_COMMAND = 4000                                         #: Comando sconosciuto
DATABASE_ALREADY_EXISTS = 4001                                 #: Il database già esiste
DATABASE_DRIVER_NOT_FOUND = 4002                               #: Driver di database non trovato
DATABASE_NOT_CONNECTED = 4003                                  #: Nessun database connesso
CLIENT_ID_NOT_FOUND = 4004                                     #: ID del client non trovato sul server
OPERATION_ABORTED = 4005                                       #: Operazione interrotta dall'utente
USER_UNKNOWN = 4006                                            #: Il nome utente non è valido
USER_DISABLED = 4007                                           #: L'utente è stato disabilitato
INVALID_PASSWORD = 4008                                        #: La parola chiave dell'utente non è valida
USER_NOT_AUTHENTICATED = 4009                                  #: L'utente non è autenticato e non può eseguire l'operazione
DELETE_NOT_ALLOWED = 4010                                      #: Gli elementi di questa tabella non si possono cancellare!
GETFIELDREFERENCE_FAILED = 4011                                #: Il nome campo non ha un riferimento esterno!
TABLENAME_NOT_FOUND = 4012                                     #: Nome tabella non trovato
PERCENTAGE_OUT_OF_RANGE = 4013                                 #: La percentuale deve essere compresa tra 0 e 100
CODE_IS_EMPTY = 4014                                           #: Il codice non può essere vuoto!
CODE_EXISTS = 4015                                             #: Il codice specificato è già presente!
AUTO_CODE_MODIFIED = 4016
NO_AUTO_CODE = 4017                                            #: La codifica automatica non è attiva sulla tabella specificata
BIND_FAILED = 4018
RECORD_NOT_FOUND = 4019                                        #: Scheda non trovata
DATABASE_CONNECTED = 4020                                      #: Un database è già connesso
INVALID_IMPORT_METHOD = 4021                                   #: Metodo di importazione non valido
INCOMPATIBLE_IMPORT_METHOD = 4022                              #: Il metodo di importazione non è compatibile con la tabella di destinazione
CANNOT_IMPORT_TABLE = 4023                                     #: La tabella non può essere importata direttamente
CANNOT_IMPORT_TABLE_WITHOUT_FIELD = 4024
INVALID_IMPORT_DATA = 4025                                     #: Dati di importazione non validi
AZIENDA_NOT_SPECIFIED = 4026                                   #: Azienda di appartenenza non specificata
PROT_IVA_MODIFIED = 4027
BINARY_NOT_FOUND = 4028                                        #: Dati binari non trovati
INDIRIZZO_NO_DELETE = 4029                                     #: L'indirizzo non può essere cancellato perchè è l'unica sede legale del cliente/fornitore
MOVIMENTO_IVA_NO_DELETE = 4030                                 #: Non si può cancellare un movimento generato automaticamente dalla prima nota!
PN_NO_DELETE = 4031                                            #: La registrazione non può essere cancellata perchè ci sono riferimenti ad essa in operazioni IVA rilevanti!
PN_NO_DELETE_PAG = 4032                                        #: La registrazione non può essere cancellata perchè ha generato una partita aperta a cui sono già stati abbinati dei pagamenti!
DUPLICATE_ROW_NUMBER = 4033
INVALID_IMPORT_DATA_ON_FIELD = 4034
UPDATE_ID_MISMATCH = 4035                                      #: Impossibile aggiornare la scheda: una scheda con lo stesso codice già esiste
INVALID_OPERATION_ON_ARCHIVE = 4036                            #: Operazione di modifica non permessa sui database storici
PN_NO_MODIFY_PA_WITH_PAG = 4037                                #: La registrazione richiede l'eliminazione di una o più partite aperte a cui sono già stati abbinati dei pagamenti, non è possibile proseguire!
OPERATION_TIMED_OUT = 4038                                     #: L'operazione sul database è stata interrotta a causa del tempo di esecuzione eccessivo; si prega di riprovare
PASSWORD_EXPIRED = 4039                                        #: La password dell'utente è scaduta
EB_CATEGORIE_INVALID_TYPE = 5000                               #: Il tipo categoria specificato non è valido!
EB_CATEGORIE_GRUPPO_NOT_FOUND = 5001                           #: Specificare un codice gruppo per questa categoria merceologica!
EB_CARICO_DATE_MISS = 5002                                     #: Specificare una data per questo movimento di magazzino!
EB_CARICO_DATE_WRONG = 5003                                    #: La data di registrazione del movimento di carico/scarico deve essere successiva alla data dell'ultimo carico/scarico definitivo(Stato archivi)
EB_CARICO_CAUSALE_MISS = 5004                                  #: Specificare una causale di magazzino per questo movimento di magazzino!
EB_CARICO_MAG_USC_MISS = 5005                                  #: Specificare un magazzino di uscita per questo movimento di magazzino!
EB_CARICO_MAG_ENT_USC_EQ = 5006                                #: Il magazzino di entrata e quello di uscita non possono coincidere!
EB_CARICO_BAD_TIPO_MERCE = 5007                                #: Il tipo di merce gestito dalla causale è diverso da quello del titolo di deposito!
EB_CARICO_DEP_ENT_MISS = 5008                                  #: Specificare un deposito di entrata per questo movimento di magazzino!
EB_CARICO_DEP_USC_MISS = 5009                                  #: Specificare un deposito di uscita per questo movimento di magazzino!
EB_CARICO_DEP_ENT_USC_EQ = 5010                                #: Il deposito di entrata e quello di uscita non possono coincidere!
EB_CARICO_MAG_ENT_MISS = 5011                                  #: Specificare un magazzino di entrata per questo movimento di magazzino!
UNITA_MISURA_RIGA_MISS = 5012
ARTICOLO_MISS = 5013
QUANTITA_MISS = 5014
EB_CATMERC_REF_GRUPPOCATEGORIE_NF = 5015                       #: EB_CategorieMerceologiche.ref_GruppoCategorie non trovato!
EB_CATMERC_REF_SOTTOCONTOVENDITA_NF = 5016                     #: EB_CategorieMerceologiche.ref_SottocontoVendita non trovato!
EB_CATMERC_REF_SOTTOCONTOACQUISTO_NF = 5017                    #: EB_CategorieMerceologiche.ref_SottocontoAcquisto non trovato!
EB_CARICO_DATE_INVALID = 5018                                  #: Specificare una data valida per questo movimento di magazzino!
EB_CC_DATE_INVALID = 5019                                      #: Specificare una data valida per questo movimento dei centri di costo!
QUANTITA_NN = 5020
EB_REF_AZIENDA_NF = 5021                                       #: ref_Azienda non trovato!
EB_RIGHEUM_ABBR_MISS = 5022                                    #: Specificare un'abbreviazione per ciascuna riga!
EB_RIGHEUM_ABBR_DUPL = 5023                                    #: Inserite 2 abbreviazioni uguali!
CAUSALI_DEP_USC_ERR = 5024                                     #: Specificato Deposito d'uscita non richiesto per il tipo causale considerato
CAUSALI_DEP_ENT_ERR = 5025                                     #: Specificato Deposito d'entrata non richiesto per il tipo causale considerato
EB_CODICIFISSI2_NF = 5026                                      #: Riga non trovata in EB_CodiciFissi2!
NO_ROWS = 5027                                                 #: Impossibile registrare senza l'inserimento di una riga
EB_REF_CLIENTE_NF = 5028                                       #: ref_Cliente non trovato!
EB_REF_FORNITORE_NF = 5029                                     #: ref_Fornitore non trovato!
EB_REF_ARTICOLO_NF = 5030                                      #: ref_Articolo non trovato!
ARTICOLI_DELETION_DENIED = 5031
EB_REF_CAT_MERC_NF = 5032                                      #: ref_CategoriaMerceologica non trovato!
EB_REF_AGENTE_NF = 5033                                        #: ref_Agente non trovato!
EB_REF_CAUSALE_MAG_NF = 5034                                   #: ref_CausaleMagazzino non trovato!
EB_PROV_QUNATITA_NULLA = 5035                                  #: Bisogna specificare una quantità diversa da zero!
EB_RAGG_CL_FOR_GRUPPO_NOT_FOUND = 5036                         #: Specificare un codice gruppo per questo sottogruppo!
EB_SCHEDA_INVALID_TYPE = 5037                                  #: Il tipo scheda specificata non è valido!
EB_ARTICOLI_UM_NULL = 5038                                     #: Bisogna specificare un'unità di misura!
EB_PARTI_ARTICOLI_ART_NULL = 5039
EB_PARTI_ARTICOLI_ART_PADRE_NULL = 5040
EB_BANCHE_IN_BA_NOT_FOUND = 5041                               #: Specificare un codice banca per la banca dell'azienda!
EB_INDIRIZZI_IN_CONT_NOT_FOUND = 5042                          #: Specificare un codice indirizzo a cui abbinare il contatto!
EB_CLIFORN_NOT_FOUND = 5043                                    #: Specificare un codice cliente/fornitore a cui abbinare la scheda!
EB_REF_VALUTA_NF = 5044                                        #: ref_Valuta non trovato!
VALUTE_DELETION_DENIED = 5045                                  #: Impossibile cancellare la valuta di default!
EB_VALUTE_DELETING_VALUTA_CONTO = 5046                         #: Impossibile cancellare una valuta di conto!
EB_TASSICAMBIO_TASSOCAMBIO_INAVLID = 5047                      #: Inserire un tasso di cambio diverso da zero!
EB_TASSICAMBIO_REF_VALUTE_UGUALI = 5048                        #: Le due valute specificate non possono coincidere!
CAUSALI_MAG_TIPOMERCE_MANCANTE = 5049                          #: Bisogna specificare il tipo di materiale di magazzino!
CAUSALI_MAG_TIPOCAUSALE_MANCANTE = 5050                        #: Bisogna specificare il tipo di causale di magazzino!
CAUSALI_MAG_OP_IMPOSSIBILE = 5051
TIT_DEP_UPDATE_IMPOSSIBILE = 5052                              #: Impossibile modificare la tipologia di un titolo di deposito!
EB_MULTI_ATTIVITA = 5053                                       #: L'azienda corrente prevede la gestione di una singola attività!
EB_CAT_CESP_CONTI = 5054                                       #: Non tutti i conti sono stati specificati!
EB_CESP_DATA = 5055                                            #: Manca la data di acquisizione del cespite!
EB_CESP_CATEGORIA = 5056                                       #: Manca la categoria di appartenenza del cespite!
EB_DOC_FISC_TIPOLOGIA = 5057                                   #: Manca la tipologia del documento fiscale!
EB_DOC_FISC_CLIENTE = 5058                                     #: Manca il cliente intestatario del documento fiscale!
EB_DOC_FISC_CAUSALE = 5059                                     #: Manca la causale di magazzino del documento fiscale!
ARTICOLI_OP_IMPOSSIBILE = 5060
LISTINI_OP_IMPOSSIBILE = 5061
EB_LISTINI_VALUTA_MISS = 5062                                  #: Il campo valuta non può esser vuoto!
EB_PREZZI_ART_LST_EXIST = 5063                                 #: Non è possibile associare 2 prezzi ad una stessa coppia articolo - listino!
EB_PREZZI_ART_NULL = 5064                                      #: Il campo articolo non può esser vuoto!
EB_PREZZI_LISTINO_NULL = 5065                                  #: Il campo listino non può esser vuoto!
TITDEP_OP_IMPOSSIBILE = 5066
UNITAMISURA_UPDATE_IMPOSSIBILE = 5067
UNITAMISURA_CANC_IMPOSSIBILE = 5068                            #: Impossibile cancellare la riga corrispondente all'unità di misura fiscale!
EB_MOVLOTTI_TIPO_MISS = 5069                                   #: Impossibile registrare un movimento lotti senza specificarne il tipo (carico o scarico)!
EB_PAPERTE_DATE_MISS = 5070                                    #: Specificare la data del documento!
EB_PAPERTE_NUM_MISS = 5071                                     #: Specificare il numero del documento!
EB_PAPERTE_PART_MISS = 5072                                    #: Specificare la partita!
EB_PAPERTE_ANNO_MISS = 5073                                    #: Specificare l' anno a cui si riferisce il documento!
EB_DOC_FISC_SC_CL = 5074                                       #: La causale di magazzino inserita prevede l'inserimento di un cliente e non di un fornitore!
EB_SCADPA_IMP = 5075
EB_SCADPA_DATA = 5076
EB_CARICO_ALIVA_MISS = 5077                                    #: Specificare un'aliquota iva per ogni riga movimentata!
EB_PAGPA_CAUS_CONT_NULL = 5078                                 #: Specificare la causale contabile!
CAT_PROV_PMIN_OVER_PMAX = 5079                                 #: La provvigione minima non può essere maggiore della provvigione massima!
CAT_PROV_RMIN_OVER_RMAX = 5080                                 #: Il ricarico minimo non può essere maggiore del ricarico massimo!
RCAT_PROVV_SCONTI_NOT_PROGRESS = 5081
EB_PAGPA_SCAD_NULL = 5082                                      #: Specificare la scadenza del pagamento!
EB_LISTINI_REFLISTINO_MISS = 5083                              #: Bisogna specificare il listino di riferimento!
VALUTA_NOT_FOUND = 5084                                        #: Bisogna specificare la valuta!
EB_ORDFOR_TIPDOC_NF = 5085                                     #: Bisogna specificare la tipologia del documento d'ordine!
EB_ORDFOR_CODFORN_NF = 5086                                    #: Bisogna specificare il codice del fornitore cui si riferisce l'ordine!
EB_ORDFOR_VALUTA_NF = 5087                                     #: Bisogna specificare il codice della valuta dell'ordine!
EB_ORD_AZIENDA_NF = 5088                                       #: Bisogna specificare l'azienda cui si riferisce l'ordine!
EB_ORDFOR_DATE_MISS = 5089                                     #: Specificare una data per questo ordine fornitore!
EB_ORDFOR_CAUSALE_MISS = 5090                                  #: Specificare una causale di magazzino per questo ordine fornitore!
CODE_NOT_FOUND = 5091
DATIARTMAG_UPDATE_FAILED = 5092                                #: Aggiornamento tabella DatiArticoliMagazzino fallito!
EB_CTERZI_ND = 5093                                            #: Specificare il numero documento!
EB_CTERZI_DATADOC_NOT_FOUND = 5094                             #: Specificare la data del documento!
EB_CTERZI_ANNORIF_NOT_FOUND = 5095                             #: Specificare l'anno di riferimento!
EB_CAUSTERZI_CODTRIB_NOT_FOUND = 5096                          #: Specificare il codice tributo!
EB_CTERZI_ALIQUOTA_NOT_FOUND = 5097                            #: Specificare l'aliquota dei compensi!
EB_CTERZI_PERC_NOT_FOUND = 5098                                #: Specificare il percipiente!
TITDEP_REFMAG_NF = 5099                                        #: Impossibile recuperare il magazzino dal titolo di deposito
TITDEP_LFN_WRONG = 5100                                        #: La lista dei nomi dei campi da settare deve avere lunghezza 2
TITDEP_FAILED_RETRIEVE_LIST = 5101                             #: Impossibile recuperare la lista dei titoli di deposito
EB_ORDFOR_BAD_TIPO_MERCE = 5102                                #: Il tipo di merce del titolo di deposito è errato!
EB_ORDFOR_CAUSALE_SCARICO = 5103                               #: Non è possibile specificare una causale di magazzino di tipo scarico per un ordine a fornitore!
EB_CAUSTERZI_PERCIMP_NOT_FOUND = 5104                          #: Specificare la percentuale di imponibile sul quale verrà calcolato il tributo!
EB_RAGG_CL_FOR_GRUPPO_ERROR = 5105                             #: Occorre specificare un sottogruppo e non un codice gruppo!
EB_ORDFOR_TITDEPENT_NF = 5106
EB_VERSRIT_MESE_NOT_FOUND = 5107                               #: Il mese specificato non è valido!
EB_EFFETTI_DATASCAD_NOT_FOUND = 5108                           #: Specificare la scadenza dell'effetto!
EB_EFFETTI_CLIENTE_NOT_FOUND = 5109                            #: Specificare il cliente abbinato all'effetto!
EB_ARTICOLI_ART_PRI_MISS = 5110                                #: E' necessario specificare il codice articolo primario cui l'articolo è associato!
EB_DAM_REFART_NF = 5111                                        #: Riferimento articolo non trovato (Dati articoli magazzino)!
EB_DAM_REFMAG_NF = 5112                                        #: Riferimento magazzino non trovato (Dati articoli magazzino)!
EB_EFFETTI_COMPENSO_MISS = 5114
EB_ORD_MDM_NON_SCOLLEGATI = 5115
ORD_CANC_IMPOSSIBILE = 5116
RIGHE_ORDFORN_MOD_ART_IMP = 5117                               #: Non è possibile modificare l'articolo di una riga parzialmente o totalmente evasa di un ordine fornitore!
RIGHE_ORDFORN_MOD_QTA_IMP = 5118                               #: La quantità di una riga parzialmente evasa di un ordine fornitore non può essere minore della quantita evasa!
EB_ORDFOR_CHANGE_TIPOLOGIA_DENIED = 5120                       #: Non è possibile modificare la Tipologia di un ordine confermato o evaso!
EB_ORDFOR_CHANGE_NUMPROG_DENIED = 5121                         #: Non è possibile modificare il Numero Progressivo di un ordine confermato o evaso!
EB_ORDFOR_CHANGE_SUFFISSO_DENIED = 5122                        #: Non è possibile modificare il Suffisso di un ordine confermato o evaso!
EB_ORDFOR_CHANGE_FORNITORE_DENIED = 5123                       #: Non è possibile modificare il Fornitore di un ordine parzialmente o totalmente evaso!
ROWLIST_NOT_FOUND = 5124                                       #: La lista delle righe non è presente!
OPIVARIL_INVALID_RECTYPE = 5125                                #: Tipo record non valido: deve essere compreso tra 1 e 5!
OPIVARIL_DATE_MISSING = 5126                                   #: Manca la data dell'operazione!
OPIVARIL_CODFISC_MISSING = 5127                                #: Manca il codice fiscale!
OPIVARIL_PIVA_MISSING = 5128                                   #: Manca la partita IVA!
OPIVARIL_CONDPAG_MISSING = 5129                                #: Manca la modalità di pagamento!
OPIVARIL_TIPOP_MISSING = 5130                                  #: Manca la tipologia di operazione!
OPIVARIL_TIPOP_INVALID = 5131                                  #: Per questo tipo record sono ammesse solo le tipologie: 'cessione di beni' e 'prestazione di servizi'!
OPIVARIL_IMPO_MISSING = 5132                                   #: Specificare un importo imponibile dell'operazione maggiore di zero!
OPIVARIL_ANAG_PF_MISS = 5133                                   #: Manca uno o più dati dell'anagrafica della persona fisica: cognome, nome, data/comune/provincia di nascita, stato estero del domicilio!
OPIVARIL_DENOM_EST_MISS = 5134                                 #: Manca la denominazione della società estera e/o lo stato estero della sede legale!
OPIVARIL_DATI_NV_MISS = 5135                                   #: Manca uno o più dati della nota di variazione: numero nota di variazione, data/numero della fattura da rettificare o l'indicazione del tipo di variazione (credito o debito)!
OPIVARIL_VAR_IMP_INVALID = 5136                                #: Il tipo di variazione deve essere 'C' o 'D'!
OPIVARIL_CODFISC_OR_PIVA = 5137                                #: Manca la partita IVA o il codice fiscale!
EB_TASSICAMBIO_CAMBIO_ALREADY_EXISTS = 5138                    #: Esiste già un tasso di cambio tra le due valute specificate!
DATE_MISSING = 5139                                            #: Manca la data di registrazione!
EB_LOTTI_DATA_SCADENZA_MISS = 5140                             #: E' necessario specificare la data di scadenza del lotto!
EB_LOTTI_DATA_PRODUZIONE_MISS = 5141                           #: E' necessario specificare la data di produzione del lotto!
EB_LOTTI_ARTICOLO_MISS = 5142                                  #: Occorre associare un articolo al lotto!
EB_LOTTI_DATE_LOTTO_WRONG = 5143                               #: La data di produzione del lotto deve essere anteriore alla data di scadenza!
LOCK_RESOURCE_FAILED = 5144
LOCK_ARTICOLO_FAILED = 5145
CARSCA_TABLE_RETRIEVE_FAILED = 5146
GENERIC_TABLE_UPDATE_FAILED = 5147
CARSCA_ML_INSERTED_FAILED = 5148                               #: Errore durante l'inserimento dei movimenti lotti generati dal carico-scarico!
CACHE_STATOARCHIVI_FAILED = 5149                               #: Gestione della cache dello stato degli archivi fallita!
EB_PARTI_ARTICOLI_QTA_MISS = 5150
EB_PARTI_ARTICOLI_QTA_NULL = 5151
ERROR_FORMATO_SCONTO = 5152                                    #: Lo sconto non ha un formato valido!
ERROR_RIC_O_SCONTO_FORMAT = 5153
EB_PARTI_ARTICOLI_SCONTO_FORMAT = 5154
ERROR_PARTIART_ROWS_MISS = 5155                                #: Non sono state specificate righe relativi agli articoli componenti!
EB_ARTICOLI_DELETE_NOT_ALLOWED = 5156                          #: Non è possibile cancellare l'articolo usato per le descrizioni libere!
EB_PARTI_ARTICOLI_UM_NULL = 5157
ERROR_FORMATO_SCONTO_RIGA = 5158
LOCK_ORD_FAILED = 5159
STRINGA_ERRORE = 5160
EB_ORDINI_ERROR_LOCK_TIPOLOGIA = 5161
EB_ORDFOR_TIPDOC_WRONG = 5162                                  #: La tipologia del documento deve essere di tipo 'Ordine a Fornitore'!
AGGREGAZIONE_ERROR = 5163
CENTRO_COSTO_MISS = 5164
PERCENTAGE_ERROR = 5165
SCHEDA_CONTABILE_MISS = 5166
CAT_PROV_INVALID_PERC = 5167
EB_MISFISCALI_ERROR_CAUSALE_VENDITA = 5168                     #: Il tipo della causale vendita al banco deve essere 'vendita corrispettivi' o 'scarico a cliente'!
EB_MISFISCALI_ERROR_CAUSALE_RESO = 5169                        #: Il tipo della causale reso al banco deve essere 'reso da cliente' o 'carico diverso' o 'carico da fornitore'!
EB_PARTIART_LISTA_VUOTA = 5170                                 #: La lista delle parti di un articolo composto non può essere vuota!
EB_PARTIART_INSERIMENTO_FALLITO = 5171
RECUPERO_DATI_FAILED = 5172
EB_ORDFOR_REF_TIP_INVALID = 5173                               #: Nei dati dell'ordine il campo ref_Tipologia non è valido!
EB_CARSCA_ERROR_MOV_LOTTI = 5174                               #: Errore durante la cancellazione del movimento lotti associato al movimento di carico scarico!
CAUSALI_MATERIALE_WORNG = 5175                                 #: la causale di magazzino ed il titolo di deposito devono avere lo stesso tipo materiale!
ERROR_LOCK_TIPOLOGIA = 5176
EB_TITDEP_CAMBIO_MAG_IMP = 5177                                #: Non è possibile modificare il magazzino associato ad un titolo di deposito!
EB_TITDEP_CAMBIO_TIPOLOGIA_IMP = 5178                          #: Non è possibile modificare la tipologia di un titolo di deposito!
EB_TIT_DEP_MAG_MISS = 5179                                     #: E' necessario specificare il magazzino di appartenenza del titolo di deposito!
UM_NOT_FOUND = 5180
ROW_OF_NOT_FOUND = 5181
UTIL_DATI_INV_UPDATE_ERROR = 5182
UTIL_DATI_INV_INSERT_ERROR = 5183
EB_ORDINI_VETTORE1_NF = 5184                                   #: Specificare il vettore che ha in carico il trasporto!
ATTACHMENTS_DELETE_ERROR = 5188                                #: Fallita la cancellazione degli allegati associati alla scheda
CARSCA_MOVLOTTI_DEL_FAILED = 5189                              #: Fallita la cancellazione del movimenti lotti associato al movimento di carico-scarico!
ROW_OC_NOT_FOUND = 5190
UPDATE_DAM_FAILED = 5191                                       #: Fallito l'aggiornamento delle quantità ordinate per gli articoli!
EB_DOC_FISC_DATE_MISS = 5192                                   #: Specificare una data del documento!
EB_DOC_FISC_DATE_INVALID = 5193                                #: Specificare una data valida per questo documento!
EB_PAPERTE_IMPORTO_MISS = 5194                                 #: Specificare l'importo/importo in valuta di conto della scadenza!
DATA_GESTIONE_CC_INVALID = 5195                                #: Per salvare la registrazione occorre specificare la data di inizio gestione centri di costo all'interno dello stato degli archivi
EB_ORDCL_DATE_MISS = 5196                                      #: Specificare una data per questo ordine cliente!
EB_DOC_FISC_PROGR = 5197                                       #: Errore durante l'aggiornamento dei progressivi!
ABBREVIAZIONE_VALUTA_DUPL = 5198                               #: Questa abbreviazione è già stata utilizzata!
CAUSMAG_MAG_RET_FAILED = 5199
TIPOART_QUERY_FAILED = 5200                                    #: Fallita la query per il recupero del tipo articolo!
CARSCA_TIPOART_WRONG = 5201                                    #: Non è possibile inserire righe di carico scarico con articoli descrittivi!
ERROR_LOCK = 5202
CARSCA_UPDATE_DATAULTMOV_FAILED = 5203                         #: Fallito l'aggiornamento della data ultimo movimento per l'esercizio corrente!
CARSCA_DATI_ESERCIZIO_NF = 5204                                #: Fallito il recupero dei dati esercizio relativi all'esercizio attivo!
DELETION_DENIED = 5205
DELETION_DENIED_NO_CODE = 5206
CAR_SCA_RIGHE_QTA_ZERO = 5207
CAR_SCA_RIGHEML_MISSING = 5208                                 #: Impossibile salvare il movimento di carico scarico in quanto non tutti i lotti richiesti sono stati specificati
DATAIVA_MISSING = 5209                                         #: Manca la data di competenza IVA!
MANCA_TIT_DEP_ENTRATA = 5210                                   #: Manca il titolo di deposito di entrata!
MANCA_TIT_DEP_USCITA = 5211                                    #: Manca il titolo di deposito di uscita!
MAGAZZINI_DELETION_DENIED = 5212                               #: Non è possibile cancellare il magazzino in quanto è l'unico dell'azienda corrente
REFS_DELETION_FAILED = 5213                                    #: Fallita la cancellazione dei riferimenti collegati
EB_FORNART_CLIENTE = 5214                                      #: Impossibile associare un cliente come fornitore dell'articolo!
EB_FORNART_ARTICOLO_MISS = 5215                                #: Impossibile salvare i dati sui fornitori articoli senza specificare l'articolo cui si riferiscono!
FORNART_TIPOART_WRONG = 5216                                   #: Non è possibile salvare informazioni sui fornitori associati ad un articolo di tipo descrittivo!
ARTICOLI_CAMBIO_GEST_LOTTI_IMP = 5217                          #: Non si può modificare la gestione dei lotti, questo articolo è stato movimentato successivamente alla data di inizio gestione lotti!
ARTFIELD_QUERY_FAILED = 5218
EB_LOTTI_ARTICOLO_NON_GESTIBILE = 5219                         #: L'articolo specificato per il lotto non prevede la gestione dei lotti!
PARTIART_TIPOART_WRONG = 5220
ERR_CAUS_CONT = 5221
CARSCA_TIPO_MOVIMENTO_MISMATCH = 5222                          #: Incongruenza tra il tipo di causale ed il tipo di movimento di magazzino!
EB_ARTICOLI_GEST_LOTTIF_PER_KIT = 5223                         #: Non è possibile attivare la gestione dei lotti per gli articoli di tipo kit!
EB_LOTTI_KIT_NON_GESTIBILE = 5224                              #: Non è possibile associare ad un lotto articoli di tipo kit!
TITDEP_NF = 5225                                               #: Impossibile recuperare il titolo di deposito!
EB_DOCFISC_VALUTA_NF = 5226                                    #: Bisogna specificare il codice della valuta del documento!
EB_SCONTI_DESC_VUOTA = 5227                                    #: La descrizione dello sconto non può essere vuota!
EB_SCONTI_FORMATO_STRINGA_INVALID = 5228                       #: La descrizione dello sconto non ha un formato valido!
SCONTO_OUT_OF_RANGE = 5229                                     #: Lo sconto deve essere compreso tra -100 e 100
EB_DOCFISC_ESERCIZIO_NF = 5230                                 #: Bisogna specificare l'esercizio cui si riferisce il documento!
EB_PROGART_ROT_IMP_NO_DATA = 5231                              #: Aggiornamento dei progressivi di rotazione fallito a causa del mancato recupero dei dati!
GENERIC_TABLE_INSERT_FAILED = 5232
CAR_SCA_CREATE_LOTTO_FAILED = 5233                             #: Fallita creazione del lotto dal movimento di carico scarico!
CARSCA_CREATE_LOTTO_IMP = 5234                                 #: Non è possibile creare automaticamente i lotti se non si abilita la codifica automatica!
CAT_PROV_NO_PROVV_SET = 5235                                   #: Non è possibile registrare una categoria provvigionale senza impostare alcuna provvigione!
RIGHE_CAT_PROV_NO_PROVV_SET = 5236                             #: Non è possibile registrare una categoria provvigionale con righe senza provvigione!
INVALID_OPTION_VAL = 5237
EB_RIGHEUM_RIGHE_MISS = 5238                                   #: Non è stata specificata nessuna unità di misura fiscale! Inserire l'abbreviazione!
EB_IVADIFF_CAUSALE_MISS = 5239                                 #: Non è stata specificata nessuna causale contabile!
EB_IVADIFF_CLIENTE_MISS = 5240                                 #: Non è stato specificato nessun cliente/fornitore!
EB_IVADIFF_REGIVA_MISS = 5241                                  #: Non è stato specificato nessun registro IVA!
IVADIFF_DATAESIG_MISS = 5242
IVADIFF_IMPIVA_MISS = 5243
IVADIFF_IMPIVA_NULL = 5244
IVADIFF_CAUS_ROW_MISS = 5245
IVADIFF_CAUSALE_WRONG = 5246                                   #: La causale contabile specificata ha un tipo gestione IVA non ammissibile!
IVADIFF_CAUS_ROW_WRONG = 5247
IVADIFF_CAUS_CANT_CHANGE = 5248                                #: E' stata specificata una causale contabile non ammissibile perchè varia il tipo di esigibilità!
GIACTITDEP_REFPROG_MISS = 5249                                 #: Impossibile salvare le giacenze titoli deposito senza il riferimento ai progressivi articolo!
GIACTITDEP_REFTITDEP_MISS = 5250                               #: Impossibile salvare le giacenze titoli deposito senza il riferimento al titolo di deposito!
PROGART_REFART_MISS = 5251                                     #: Impossibile salvare i progressivi articolo senza il riferimento all'articolo!
PROGART_REFMAG_MISS = 5252                                     #: Impossibile salvare i progressivi articolo senza il riferimento al magazzino!
MANCA_CF = 5253                                                #: Per procedere con la conferma del documento fiscale occorre compilare opportunamente la tabella dei codici fissi!
EB_ORDCL_CHANGE_CLIENTE_DENIED = 5254                          #: Non è possibile modificare il cliente di un ordine parzialmente o totalmente evaso!
CODE_SCADENZA_NOT_FOUND = 5255
KEY_SCADENZA_NOT_FOUND = 5256
PN_PAGAMENTIPA_MISSING = 5257
PN_PAGAMENTIPA_DIFFER = 5258
PN_PAGAMENTIPA_CAUS_MISS = 5259
PN_PAGAMENTIPA_SCAD_MISS = 5260
PARTIART_CODE_NOT_FOUND = 5261
PAPERTE_NO_DELETE_OR_UPDATE = 5262                             #: Non si può modificare e/o cancellare una scheda generata automaticamente dalla prima nota!
SCHEDA_CONTABILE_NO_DELETE = 5263                              #: Non si può cancellare una scheda contabile a cui sono collegati dei conti e/o sottoconti!
SCHEDA_CONTABILE_TIPO = 5264                                   #: Specificare il tipo scheda
SCHEDA_CONTABILE_TIPO_MASTRO = 5265                            #: Specificare il tipo mastro
SCHEDA_CONTABILE_DETTAGLIO = 5266
SCHEDA_CONTABILE_TIPO_SCHEDA = 5267                            #: La tipologia scheda del raggruppamento UE deve essere uguale alla tipologia della scheda contabile!
SCHEDA_CONTABILE_CODICE_ERRATO = 5268                          #: Il codice del mastro/conto/sottoconto è errato!
CARSCA_DELETE_ROW_FAILED = 5269
CARSCA_DELETION_DENIED = 5270                                  #: Il movimento di carico scarico non può essere cancellato perché già stampato in definitivo!
MOVLOTTI_MOV_AUTOMATICO = 5271
PAPERTE_PAG_NO_DELETE_OR_UPDATE = 5272
SOTT_RIEP_MISSING = 5273                                       #: Manca il sottoconto riepilogativo abbinato al cliente/fornitore!
RAGGRCEE_TIPOGRUPPO_WRONG = 5274                               #: Il tipo gruppo per le schede di tipo saldo o calcolo non può essere NESSUNO!
RAGGRCEE_SEQSTAMPA_MISS = 5275                                 #: Bisogna specificare il numero della sequenza di stampa!
RAGGRCEE_SEQSTAMPA_WRONG = 5276                                #: Il numero della sequenza di stampa specificato è già stato utilizzato!
RAGGRCEE_LIVELLO_WRONG = 5277                                  #: Il livello specificato non è valido! Il livello deve essere compreso tra 1 e 9
RAGGRCEE_CALCOLO_FORMULA_MISS = 5278                           #: Per le schede di tipo CALCOLO è necessario specificare almeno una riga!
RIGHERAGRRCEE_INVALID_OPERAND = 5279
RAGGRCEE_CALCOLO_CICLICO = 5280
RAGGRCEE_CODE_NOT_FOUND = 5281
CAUSMAG_UPDATE_DENIED = 5282
RIGHERAGRRCEE_INVALID_REFOP = 5283
PN_CAUSALE_MISS = 5284                                         #: Manca la causale contabile!
PN_REGIVA_MISS = 5285                                          #: Manca il registro IVA!
DF_SBILANCIO_SCADENZE = 5286                                   #: Non è possibile registrare il Documento Fiscale in quanto esiste uno sbilancio tra l'importo totale del documento e gli importi delle scadenze relative!
CF_BAD_TIPO = 5287                                             #: Il tipo che identifica un cliente o fornitore è errato!
DF_NOT_IN_PN = 5288                                            #: Non è possibile contabilizzare Documento Fiscale in quanto è presente almeno una riga senza sottoconto di ricavo!
DOCFIS_CONTO_MISS = 5289
DOCFISC_UPDATE_CAR_SCA_FAILED = 5290
OPIVARIL_CF_PIVA_COPRESENZA = 5291                             #: Non è possibile specificare contemporaneamente il Codice Fiscale e la Partita IVA!
OPIVARIL_CF_PIVA_COASSENZA = 5292
ORD_ALIQUOTA_NN = 5293
PN_NUMDOC_MISS = 5294                                          #: Manca il numero del documento!
CANNOT_DELETE_LAST_BUSINESS = 5295                             #: Impossibile cancellare la sola azienda disponibile sul database
EB_DOC_FISC_CAUS_CONT = 5296                                   #: Impossibile registrare il documento fiscale senza specificare la causale contabile!
DOCFIS_ALIQUOTA_MISS = 5297
EB_LOGIC_TIPODOC_WRONG = 5298                                  #: La tipologia Documento ha un tipo documento non valido!
OPIVARIL_CF_ASSENZA = 5299
OPIVARIL_PIVA_ASSENZA = 5300
EB_PAPERTE_DUPL = 5301                                         #: Esiste già una partita aperta dello stesso cliente-fornitore, dello stesso anno e con lo stesso numero documento!
IVADIFF_CODE_NOT_FOUND = 5302
DOC_FISC_RIGHEML_MISSING = 5303                                #: Impossibile salvare il documento fiscale in quanto non tutti i lotti richiesti sono stati specificati
CENTRI_COSTO_DATE_WRONG = 5304                                 #: Specificare una data fine competenza successiva alla data di inizio!
ACC_QDO_ART_DESC_ERR = 5305
DOCFISC_DELETION_DENIED = 5306                                 #: Il documento fiscale non può essere cancellato perché è già stato fatturato!
EB_EFFETTI_BANCA_NOT_FOUND = 5307                              #: Specificare la banca abbinata all'effetto!
COMMON_LISTA_MAG_ERROR = 5308                                  #: Errore durante la creazione della lista dei magazzini aziendali!
COMMON_LISTA_TIT_DEP_ERROR = 5309                              #: Errore durante la creazione della lista dei titoli deposito!
COMMON_LISTA_ARTICOLI_ERROR = 5310                             #: Errore durante la creazione della lista degli articoli aziendali!
PN_COFIX_IVA_ERROR = 5311                                      #: Manca il sottoconto IVA nella tabella dei codici fissi!
OPIVARIL_IMPO_IVA_NULLI = 5312
OPIVARIL_CODSTESTPF_MISSING = 5313
OPIVARIL_CODSTESTPG_MISSING = 5314
OPIVARIL_IMPO_IVA_NULLI2 = 5315                                #: Non e' possibile registrare un'operazione IVA rilevante con imponibile e importo IVA nulli!
OPIVARIL_CODSTESTPF_MISSING2 = 5316                            #: Non e' possibile registrare un'operazione IVA rilevante di tipo Non Residenti senza specificare il codice stato estero di domicilio!
OPIVARIL_CODSTESTPG_MISSING2 = 5317                            #: Non e' possibile registrare un'operazione IVA rilevante di tipo Non Residenti senza specificare il codice stato estero di residenza!
OPIVARIL_CF_PIVA_COASSENZA2 = 5318                             #: Non e' possibile registrare una operazione IVA rilevante senza specificare ne il Codice Fiscale ne la Partita IVA!
OPIVARIL_CF_ASSENZA2 = 5319                                    #: Non e' possibile registrare un'operazione IVA rilevante per un soggetto privato senza specificarne il Codice Fiscale!
OPIVARIL_PIVA_ASSENZA2 = 5320                                  #: Non e' possibile registrare un'operazione IVA rilevante per un soggetto giuridico senza specificarne la Partita IVA!
CARSCA_AUTO_DELETION_DENIED = 5321                             #: Il movimento di carico scarico non può essere cancellato perché è stato generato automaticamente da un documento fiscale!
CC_CF_MISS = 5322                                              #: Per procedere con la conferma della registrazione di prima nota che movimenta i centri di costo occorre compilare opportunamente la tabella dei codici fissi!
CARSCA_CAUS_COFIX_MISS = 5323
ZERO_TITDEP_FOUND = 5324
DUPLICATE_PRODUCT_TAG = 5325                                   #: Il tag già esiste tra quelli del tag padre specificato
TAG_NOT_SPECIFIED = 5326                                       #: Il tag non è specificato o non è stato trovato
AGENTE_DUP_OP_CASSA = 5327                                     #: Il numero dell'operatore di cassa è già in uso da un altro agente
AGENTE_BAD_PIN = 5328                                          #: Il PIN dell'operatore deve essere vuoto a 4 cifre decimali
PN_MISSING_SK_AND_CF = 5329
SCONTRINO_APERTO = 5330                                        #: Mancano dei pagamenti: lo scontrino è ancora aperto
SCONTRINO_MISSING_SERIAL = 5331
SCONTRINO_MISSING_CAUSALE_VENDITA = 5332                       #: La causale di vendita non è specificata per il misuratore fiscale o in codici fissi
SCONTRINO_MISSING_CAUSALE_RESO = 5333                          #: La causale dei resi non è specificata per il misuratore fiscale o in codici fissi
SCONTRINO_MISSING_TIT_DEP_USCITA = 5334                        #: Manca il titolo di deposito di uscita per la causale di vendita al banco
SCONTRINO_MISSING_TIT_DEP_ENTRATA = 5335                       #: Manca il titolo di deposito di entrata per la causale dei resi al banco
SCONTRINO_MISSING_ESERCIZIO = 5336                             #: Manca l'esercizio per la data di registrazione dello scontrino
SCONTRINO_BAD_SERIAL_QTA = 5337
REPARTI_MISSING_ARTICOLO = 5338                                #: Manca l'articolo predefinito per le vendite/resi di reparto
REPARTI_MISSING_ALIQUOTA_IVA = 5339                            #: Manca l'aliquota IVA associata al reparto
REPARTI_DUP_NUMBER = 5340                                      #: Il numero del reparto specificato è già in uso
REPARTI_ALIQUOTA_MISMATCH = 5341                               #: L'aliquota IVA associata al reparto deve essere uguale a quella associata all'articolo
SCONTRINO_MISSING_REPARTO = 5342
UM_IMPOSSIBILE_MOD_COD_STD = 5343                              #: Impossibile modificare il codice dell'unita' di misura standard!
CARTE_FIDELITY_MISSING_NUMERO_CARTA = 5344                     #: Manca il numero della carta fedeltà
CARTE_FIDELITY_MISSING_CLIENTE = 5345                          #: Manca il cliente associato alla carta fedeltà
CARTE_FIDELITY_DUP_CARTA = 5346                                #: Il numero della carta fedeltà specificato è già in uso
PROGFIDELITY_REFAZIENDA_MISS = 5347                            #: Manca l'azienda associata ai progressivi carta fedeltà
PROGFIDELITY_REFCLIENTE_MISS = 5348                            #: Manca il cliente associato ai progressivi carta fedeltà
PROGFIDELITY_REFCONCORSO_MISS = 5349                           #: Manca il concorso associato ai progressivi carta fedeltà
CONCORSI_OVERLAP_DATES = 5350                                  #: Esiste già un concorso definito nell'intervallo di date specificato
CONCORSI_BAD_DATES = 5351                                      #: La data di inizio del concorso deve precedere la data di fine
CONCORSI_BAD_VALUE = 5352                                      #: Il valore del singolo punto deve essere maggiore di zero
MOVFIDELITY_REFCLIENTE_MISS = 5353                             #: Manca il riferimento al cliente della carta fedeltà
MOVFIDELITY_NO_CONCORSO = 5354                                 #: Non esiste un concorso definito per la data specificata
MOVFIDELITY_DATADOCUMENTO_MISS = 5355                          #: Manca la data del documento
MOVFIDELITY_DATAREGISTRAZIONE_MISS = 5356                      #: Manca la data di registrazione
CONTE_CASSA_REFMF_MISS = 5357                                  #: Manca il riferimento al misuratore fiscale
CONTE_CASSA_REFAGENTE_MISS = 5358                              #: Manca il riferimento all'operatore di cassa
KEY_IVA_DIFF_NOT_FOUND = 5359
SEDI_NO_SEDE_LEGALE = 5360                                     #: Deve essere definita almeno una sede legale dell'azienda
EB_DOC_FISC_ALIQUOTAIVA_ART15_MISS = 5361                      #: Non è stato specificato il codice dell'aliquota IVA escluso articolo 15 nella tabella codici fissi
EB_DOC_FISC_SOTT_ABBUONI_POS_MISS = 5362                       #: Non è stato specificato il codice del sottoconto per abbuoni positivi nella tabella codici fissi
EB_DOC_FISC_SOTT_ABBUONI_NEG_MISS = 5363                       #: Non è stato specificato il codice del sottoconto per abbuoni negativi nella tabella codici fissi
REPARTI_BAD_ARTICOLO = 5364                                    #: L'articolo associato al reparto deve essere di tipo standard
PN_SOTTOCONTO_INCASSO_MISS = 5365                              #: Manca il sottoconto per l'incasso automatico (Codici Fissi->Contabilità)!
RAGG_UE_CANC_IMPOSSIBILE = 5366
EB_RIGHEUM_COEFF_CONV_NULL = 5367
COMMON_MARGINE_NV = 5368
CARSCA_RO_MISMATCH = 5369                                      #: Incongruenza di articoli!
CONCORSI_DATE_MISS = 5370                                      #: Mancano la data di inizio e/o fine del concorso
CONCORSI_BAD_COEFF = 5371                                      #: Il valore del coefficiente di conversione da punti a valuta deve essere maggiore di zero
CONCORSI_BAD_LAST_DATE = 5372                                  #: La data di fine del concorso deve precedere la data di ultimo utilizzo punti
DF_NOT_IN_PN2 = 5373                                           #: Non è possibile contabilizzare il Documento Fiscale in quanto è presente almeno un importo spese senza il relativo sottoconto di ricavo!
SA_AI_MISSED = 5374                                            #: Non e' stata impostata nella configurazione azienda l'aliquota IVA per l'addebito spese accessorie!
DF_AI_SPESE_MISSED = 5375                                      #: Non e' stata impostata nel documento fiscale l'aliquota IVA per le spese!
DOCFIS_EO_CONTO_MISS = 5376
LOTTI_IDE_PRESENTE = 5377
MOV_LOTTI_GIAC_NEG = 5378
CAUSALE_GIROCONTO_MISS = 5379                                  #: Manca la causale per il giroconto automatico (Codici Fissi->Fatturazione)!
CANNOT_DELETE_LAST_ACCOUNTING_YEAR = 5380                      #: Impossibile cancellare il solo esercizio disponibile per questa azienda
COMPUTING_DEPENDENCIES = 5381                                  #: Calcolo delle dipendenze in corso…
ART_NOT_DELETE = 5382                                          #: Impossibile cancellare l'articolo!
ART_IS_PART = 5383
ART_IS_PRIMARY = 5384
SCHEDA_CONTABILE_DETTAGLIO_ALT = 5385
CF_AI_MISSED = 5386                                            #: Non e' stata impostata nell'ordine a fornitore e/o nei codici fissi l'aliquota IVA per l'addebito spese accessorie!
INDIRIZZI_CODE_EXISTS = 5387
SCONTRINO_DUP_NUMBER = 5388                                    #: Uno scontrino con lo stesso numero e data è già stato emesso dal misuratore fiscale corrente
SCONTRINO_MISSING_ALIQUOTA_IVA = 5389
USER_CONFIG_MISSED = 5390                                      #: Il file 'user-config.xml' è vuoto pertanto non è possibile utilizzare i pagamenti misti!
PAGAMENTI_ERRATI = 5391                                        #: Il totale dei pagamenti specificati non corrisponde al totale del documento e/o la tipologia specificata non è presente sulla configurazione del server!
PAGAMENTI_SC_MISSED = 5392                                     #: Il sottoconto è inesistente pertanto la prima nota non può essere generata!
PAGAMENTI_PREFS_MISSED = 5393                                  #: Il file di configurazione dell'utente sul server è inisistente oppure errato!
CLSCNT_DATA_INIZIO_MISS = 5394                                 #: E' necessario specificare una data di inizio per le classi di sconto promozionali!
CLSCNT_DATA_FINE_MISS = 5395                                   #: E' necessario specificare una data di fine per le classi di sconto promozionali!
CLSCNT_VALIDITA_WRONG = 5396                                   #: Impostare correttamente le date di validità per la classe di sconto promozionale!
CLSCNT_PERIODOCS_WRONG = 5397                                  #: Impossibile registrare la classe di sconto in quanto il periodo si sovrappone con quello di un'altra classe di sconto promozionale!
CLSCNT_CLT_ALREADY = 5398
EB_IVADIFF_DATAIVA_MISS = 5399                                 #: Impossibile registare la scheda IVA Differita in quanto il campo Data IVA e' errato o mancante!
EB_DF_CLFOR_MISS1 = 5401
EB_DF_CLFOR_MISS2 = 5402                                       #: Specificare il cliente o il fornitore!
EB_DF_DATA1 = 5403
EB_DF_DATA2 = 5404                                             #: Specificare la data della registrazione e/o la data del documento!
EB_DATI_FATTURA_DELETE_NOT_ALLOWED = 5408                      #: Non è possibile cancellare le schede dati fattura con stato TRASMESSO!
EB_DF_MAX_LEN_ROWS = 5409                                      #: La scheda dei dati fatture può contenere fino a 1000 fatture! (Creare una nuova scheda per registrare le fatture in eccesso.)
DATA_REG_ERR_DEF_GIORNALE = 5410                               #: La data di registrazione è anteriore o uguale alla data dell'ultima registrazione definitiva del libro giornale!
DATA_REG_ERR_LIQIVA = 5411                                     #: La data di registrazione è anteriore o uguale alla data dell'ultima liquidazione IVA!
EB_DACF_ANNO_INV = 5412                                        #: Impossibile registrare i Dati annuali clienti fornitori senza specificare un anno valido!
EB_DACF_RDCFA_INV = 5413                                       #: Impossibile registrare i Dati annuali clienti fornitori senza specificare un riferimento valido!
EB_DACF_DUP_KEY = 5414                                         #: Nella tabella e' gia' presente un record per la coppia (ref_DatiCliForAzienda, Anno)!
QUANTITA_SCANSIONE_MISS = 5415
QUANTITA_SCANSIONE_NN = 5416
OC_QUANTITA_ART_DESC = 5417                                    #: L'ordine non può essere inserito perchè la quantità di un articolo descrittivo deve essere zero
DE_DATI_XML_MISSING = 5418                                     #: Il documento elettronico non contiene dati XML validi
EVENTI_DE_REF_DE_MISSING = 5419                                #: L'evento non è associato ad alcun documento elettronico
PN_NUMDE_ERR = 5420                                            #: Numero interno del documento elettronico non trovato! Inserire un numero interno valido o lasciare il campo vuoto
DE_SET_PN_NUMDOC_NOT_FOUND = 5421                              #: Il numero del documento non è presente nel documento elettronico specificato!
DE_SET_PN_DE_NOT_FOUND = 5422                                  #: Errore nella lettura del documento elettronico!
DICHINTENTO_INSERT_FAILED = 5423                               #: Inserimento dichiarazione intento fallito!
PN_UNEDITABLE = 5424                                           #: La prima nota non puo' essere modificata perchè la partita aperta associata è stata movimentata!
PAPERTE_NO_UPDATE_CAMBI = 5425                                 #: Errore durante la modifica manuale del cambio all'interno della partita aperta!
PAPERTE_DATE_MISS = 5425                                       #: Specificare una data di registrazione!
PAPERTE_DATE_INVALID = 5426                                    #: Specificare una data registrazione valida!
DATIGESTIONALIDE_TIPODATO_MISS = 5427
PREVENTIVI_ALIQUOTA_MISS = 5428
EB_DOC_FISC_ESIG_IVA_ERR = 5429                                #: Il tipo di esigibilità IVA del documento fiscale è diverso da quello della causale contabile!
EB_CLIENTI_EMAIL_EXISTS = 5430                                 #: Nell'archivio clienti è già presente un cliente con l'indirizzo email specificato!
CONFERMA_DF_VERIFICA_QTA_FALLITA = 5431                        #: Impossibile confermare il documento fiscale: manca la verifica delle quantità
DATI_INTRA_CODICE_MISS = 5432                                  #: Non è stato specificato il codice intrastat!
DATI_INTRA_CLFOR_MISS = 5433                                   #: Non è stato specificato il cliente/fornitore a cui si riferisce la scheda!
ERROR_DATI_DETT_SCAD = 5434
DATI_INTRA_DELETE_PROGRESSIVO = 5435                           #: Non è possibile eliminare i dati intrast contenuti nella registrazione di prima nota perchè sono stati inviati!
PN_CLIFO_INCASSO_MISS = 5436                                   #: Manca il Cliente/Fornitore per l'incasso automatico!
CARSCA_LOTTO_NOT_FOUND = 5437
DOCUMENTO_TRASPORTO = 6000                                     #: Documento di Trasporto
FATTURA = 6001                                                 #: Fattura
NOTA_CREDITO = 6002                                            #: Nota di credito
PRO_FORMA = 6003                                               #: Pro forma
RICEVUTA_FISCALE = 6004                                        #: Ricevuta Fiscale
NOTA_DEBITO = 6005                                             #: Nota di debito
FATT_RIC_FISCALE = 6006                                        #: Fattura - Ricevuta fiscale
PREVENTIVO = 6007                                              #: Preventivo
ORDINE_CLIENTE = 6008                                          #: Ordine da cliente
ORDINE_FORNITORE = 6009                                        #: Ordine a fornitore
DESC_INCASSO_AUTO = 6010                                       #: Movimento Automatico
STORNO_SPLIT_PAYMNT = 6011                                     #: Storno C/Split-Payment
DESC_FATTURA_SCONTRINO = 6012
ASPETTO_BENI_FATTURA_SCONTRINO = 6013                          #: A vista
LOTTO_FATTURA_SCONTRINO = 6014                                 #: Lotto
MATRICOLA_FATTURA_SCONTRINO = 6015                             #: Matricola
RIGA_DOC_FISC_ARROTONDAMENTO_POS = 6016                        #: Arrotondamento positivo
RIGA_DOC_FISC_ARROTONDAMENTO_NEG = 6017                        #: Arrotondamento negativo
DESC_AUTO_PAGAMENTO_EFFETTO = 6018                             #: Pagamento da effetto
DESC_AUTO_INSOLUTO_EFFETTO = 6019                              #: Insoluto da effetto
EDI_EVENT_CHANGED_DOC_STATE = 6500
EDI_EVENT_CHANGED_DOC_STATE_EX = 6501
EDI_EVENT_CHANGED_XML = 6502                                   #: Modificato file XML
EDI_EVENT_RECEIVED_DESC = 6503                                 #: Ricevuto file XML da intermediario
EDI_EVENT_IMPORTED = 6504                                      #: Scheda creata da file XML importato
EDI_EVENT_CREATED_FROM_DF = 6505
EDI_EVENT_REGISTERED_PN = 6506
EDI_UPLOAD_IO_ERROR = 6600
EDI_UPLOAD_INT_ERROR = 6601
EDI_CHECK_OUTCOME_IO_ERROR = 6602
EDI_CHECK_OUTCOME_INT_ERROR = 6603
EDI_GET_LOG_IO_ERROR = 6604
EDI_GET_LOG_INT_ERROR = 6605
EDI_FETCH_DOCUMENTS_IO_ERROR = 6606
EDI_SET_DOCUMENT_DATA_IO_ERROR = 6607
EDI_FETCH_DOCUMENT_DOC_ALREADY_EXISTS = 6608                   #: Un documento elettronico con lo stesso ID SDI è già presente nel database
EDI_FETCH_DOCUMENT_NOT_FOUND = 6609                            #: Documento elettronico non trovato
EDI_FETCH_DOCUMENT_INVALID_XML = 6610
EDI_NO_INTERCHANGE = 6700                                      #: Nessun contratto per la comunicazione automatica dei documenti elettronici è stato attivato per questa azienda
EDI_CANNOT_DELETE_RECORD = 6701
EDI_IMPORT_ERROR = 6702
EDI_IMPORT_SUCCESSFUL = 6703                                   #: Documento elettronico importato con successo
EDI_UPLOAD_ERROR = 6704
EDI_UPLOAD_SUCCESSFUL = 6705
EDI_UPLOAD_EMAIL_ERROR = 6706
EDI_CANNOT_PRESERVE_DATA = 6707                                #: Impossibile procedere alla conservazione dei dati per questo tipo di documento
EDI_PRESERVE_ERROR = 6708
EDI_PRESERVE_SUCCESSFUL = 6709
EDI_PRESERVE_MISSING_REG_NUM = 6710
EDI_PRESERVE_MISSING_REG_DATE = 6711
EDI_PRESERVE_MISSING_VAT_PROTOCOL = 6712
EDI_PRESERVE_MISSING_VAT_DATE = 6713
EDI_PRESERVE_MISSING_SEC = 6714
EDI_CANNOT_PRESERVE_NOT_FOUND = 6715                           #: Impossibile procedere alla conservazione dei dati: il documento non è presente sull'intermediario
EDI_ID_RICEZIONE_MSG = 6716
EDI_ID_ESITO_MSG = 6717
ELAB_NOT_FOUND = 7000                                          #: Elaborazione non trovata!
ELAB_FAILED = 7001
ELAB_TABLE_LOCK_ERROR = 7002
ELAB_INVALID_PARAMETERS = 7003                                 #: Parametri dell'elaborazione mancanti o non validi
ELAB_TABLE_LOCK_EXPIRED_ERROR = 7004
ELAB_RIMFIN_DATAREG_MISS = 7100                                #: L'elaborazione Rimanenze Finali deve ricevere come parametro la data di registrazione dei movimenti di carico giacenze iniziali!
ELAB_RIMFIN_ESERCIZIO_FUTURO_MISS = 7101                       #: L'elaborazione Rimanenze Finali deve ricevere come parametro il riferimento all'esercizio di pertinenza dei movimenti di carico giacenze iniziali!
ELAB_RIMFIN_CAUS_MAG_GIAC_PROPRIA_MISS = 7102                  #: L'elaborazione Rimanenze Finali deve ricevere come parametro il riferimento alla causale di carico giacenze iniziali merce propria!
ELAB_RIMFIN_CAUS_MAG_GIAC_TERZI_MISS = 7103                    #: L'elaborazione Rimanenze Finali deve ricevere come parametro il riferimento alla causale di carico giacenze iniziali merce terzi!
ELAB_RIMFIN_VALUTA_MISS = 7104                                 #: L'elaborazione Rimanenze Finali deve ricevere come parametro il riferimento alla valuta di conto dell'azienda corrente!
ELAB_RIMFIN_DATA_CAMBIO_MISS = 7105                            #: L'elaborazione Rimanenze Finali deve ricevere come parametro la data di cambio della valuta di conto dell'azienda corrente!
ELAB_RIMFIN_NUOVO_ANNO_INV_MISS = 7106                         #: L'elaborazione Rimanenze Finali deve ricevere come parametro l'anno successivo all'anno ultimo inventario!
ELAB_RIMFIN_DATAREG_WRONG = 7107                               #: La data di generazione dei movimenti non può essere antecedente alla data ultimo carico scarico definitivo!
ELAB_RIMFIN_INSERT_ERROR = 7108                                #: Inserimento carico giacenza iniziale fallito!
ELAB_RIMFIN_INFOART_WARNING = 7109
ELAB_VAR_CO_DATA_MISMATCH = 7125                               #: La data iniziale deve essere antcedente alla data finale!
ELAB_VAR_CO_TNAME_NOT_FOUND = 7126                             #: Non è stata specificata nessuna tabella su cui eseguire l'elaborazione!
ELAB_VAR_CO_FNAME_NOT_FOUND = 7127                             #: Non è stato specificato nessuno riferimento su cui eseguire l'elaborazione!
ELAB_VAR_CO_FVALUE_NOT_FOUND = 7128                            #: Non è stata specificato il valore del campo da cambiare!
ELAB_VAR_CO_TVALUE_NOT_FOUND = 7129                            #: Non è stato specificato il valore da assegnare al campo!
ELAB_VAR_CO_FREF_NF = 7130                                     #: Il valore iniziale specificato non è un codice valido!
ELAB_VAR_CO_TREF_NF = 7131                                     #: Il valore finale specificato non è un codice valido!
ELAB_VAR_CO_EXIT_MESSAGE_1 = 7132
ELAB_VAR_CO_EXIT_MESSAGE_2 = 7133
ELAB_VAR_CO_NO_RESULT = 7134                                   #: Non sono presenti elementi che soddisfino i criteri di ricerca
ELAB_VAR_CODS_FVALUE_NOT_FOUND = 7135                          #: Non è stato specificato nè il valore del campo da cambiare nè il valore che deve assumere!
ELAB_VAR_CODS_AZIENDA_NULL = 7136                              #: Non è possibile effettuare l'elaborazione in quanto non è stata specificata l'azienda corrente!
ELAB_VAR_LI_FAILED_PREZZI_FIELD_LIST = 7150                    #: Non è stato possibile recuperare la lista dei campi della tabella prezzi!
ELAB_VAR_LI_PREZZI_INSERT_FAILED = 7151                        #: Fallito l'inserimento dei prezzi!
ELAB_VAR_LI_FAILED_ARTICOLI_FIELD_LIST = 7152                  #: Non è stato possibile recuperare la lista dei campi della tabella articoli!
ELAB_VAR_LI_PREZZI_UPDATE_FAILED = 7153                        #: Fallito l'aggiornamento dei prezzi!
ELAB_VAR_LI_TIPO_ELAB_ERRATO = 7154                            #: L'operazione richiesta corrisponde ad una variazione del listino origine!
ELAB_VAR_LI_STRINGA_PERC_INVALID = 7155                        #: La stringa dello scostamento contiene dei caratteri non validi!
ELAB_VAR_LI_DELETION_FAILED = 7156
ELAB_VARLIS_VALUTA_NON_RECUPERATA = 7157
ELAB_VAR_LI_RICARICO_NON_VALIDO = 7158                         #: Il ricarico non può essere maggiore o uguale a 100
ELAB_VAR_LI_ART_NOT_FIND = 7159
ELAB_VAR_LI_NO_PREZZI = 7160                                   #: Non ci sono prezzi che soddisfino i criteri di ricerca specificati
ELAB_UI_DATINV_NON_RECUPERATI = 7175
ELAB_LISMAG_LOCK_ERROR = 7200
ELAB_LISMAG_LOCK_FAILED = 7201                                 #: Non è stato possibile bloccare le risorse richieste per l'elaborazione!
ELAB_CC_DATA_CONFERMA_INVALID = 7225
ELAB_CC_ID_FROM_NUMINT = 7226
ELAB_CC_UPDATE_OF_FAILED = 7227
ELAB_CC_NO_DOCUMENTI = 7228                                    #: Nessun documento da confermare!
ELAB_MSE_ID_FROM_NUMINT = 7250
ELAB_MSE_UPDATE_OF_FAILED = 7251
ELAB_MSE_ID_GET_EFFETO = 7252
ELAB_GIORNCONTDEF_DATE_INVALID = 7275                          #: Stampa definitiva Giornale Contabile - la data dell'ultima registrazione è mancante o non valida!
ELAB_GIORNCONTDEF_NUMPAG_INVALID = 7276                        #: Stampa definitiva Giornale Contabile - l'ultimo numero di pagina stampato in definitivo è mancante o non valido!
ERROR_SA_LOCK = 7277
GIORNCONT_NUMPAG_ZERO = 7278                                   #: Avendo eseguito una stampa definitiva del giornale di contabilità sino al 31 dicembre, è stato azzerato automaticamente il numero dell’ultima pagina stampata in definitivo. In tal modo, per il prossimo anno solare, la numerazione delle pagine ripartirà dal numero 1.
STATO_SACD_PA_PARAMS_MISS = 7300                               #: L'elaborazione non ha ricevuto sufficienti parametri!
DISPPAG_HD_PARAMETER_NF = 7301                                 #: L'elaborazione non ha ricevuto i dati relativi alla testata della prima nota!
DISPPAG_ROWS_PARAMETER_NF = 7302                               #: L'elaborazione non ha ricevuto i dati relativi alle righe della prima nota!
DISPPAG_BON_PARAMETER_NF = 7303                                #: L'elaborazione non ha ricevuto il sottoconto per i bonifici!
DISPPAG_NOBON_PARAMETER_NF = 7304                              #: L'elaborazione non ha ricevuto il sottoconto relativo a pagamenti diversi da bonifici!
DISPPAG_FINAL_PARAMETER_NF = 7305                              #: L'elaborazione non ha ricevuto i dati per la chiusura della prima nota!
ELAB_GENPROV_RECUPERO_PA_FAILED = 7325
GENPROV_DATA_DA_MISS = 7326                                    #: Non è stata specificata la data di fine generazione!
GENPROV_DATA_A_MISS = 7327                                     #: Non è stata specificata la data di fine generazione!
ELAB_GENPROV_RECUPERO_RDC_FAILED = 7328
ELAB_GENPROV_NO_PA_FOR_PROV = 7329
ELAB_GENPROV_TOO_PA_FOR_PROV = 7330
ELAB_GENPROV_CALC_PERC_QERR = 7331
ELAB_GENPROV_SCHEDA_AGG = 7332
GEN_OA_PARAM_MISS = 7350                                       #: L'elaborazione non ha ricevuto sufficienti parametri!
CALC_LIQ_PER_DATI_SA_MISS = 7375                               #: L'elaborazione non ha ricevuto i dati per l'aggiornamento dello stato degli archivi!
CALC_LIQ_PER_DATI_LIQ_MISS = 7376                              #: L'elaborazione non ha ricevuto i dati sulla liquidazione IVA da inserire!
CALC_LIQ_PER_DATI_ICV_MISS = 7377                              #: L'elaborazione non ha ricevuto i dati sugli imponibili dei corrispettivi ventilati!
UPDATE_SA_FAILED = 7378                                        #: Aggiornamento Stato degli Archivi fallito!
CALC_LIQ_PER_INSERTLI_FAILED = 7379                            #: Inserimento Liquidazione IVA fallito!
CALC_LIQ_PER_INSERTICV_FAILED = 7380
CALC_LIQ_PER_INSERTCIVA_FAILED = 7381                          #: Inserimento Compensazioni IVA fallito!
CALC_LIQ_PER_UPDIVADIFF_FAILED = 7382
ERROR_LOCK_STATOARCHIVI = 7383
ERROR_LOCK_IVADIFF = 7384
MODELLOIVA_INSERT_FAILED = 7385                                #: Inserimento Modello IVA fallito!
STAMPA_LIQ_PER_LASTPAGE_MISS = 7400                            #: L'elaborazione ha ricevuto un dato errato per l'aggiornamento dell'ultima pagina stampata!
ELAB_BILUE_FIELDS_NF = 7425                                    #: L'elaborazione non ha ricevuto i nomi dei campi necessari per la stampa!
ELAB_BILUE_COD_RISULTATO_NF = 7426                             #: L'elaborazione non ha ricevuto il codice del raggruppamento UE che corrisponde al risultato di esercizio. Non è possibile procedere con la stampa!
ELAB_BILUE_TIPO_NF = 7427                                      #: Non è stato specificato il tipo di aggiornamento che si desidera. Non è possibile procedere con la stampa!
ELAB_BILUE_DATAA_NF = 7428                                     #: Non è stato specificata la data sino alla quale si vuole eseguire l'analisi. Non è possibile procedere con la stampa!
ELAB_BILUE_DIFF_CALC = 7429                                    #: Differenza calcolata
ELAB_BILUE_SK_NOT_SALDO = 7430
ELAB_BILCA_ABORTED_SALDO_PREC = 7450                           #: L'elaborazione non e' riuscita ad aggiornare il saldo precedente dei progressivi schede contabili relativi all'esercizio successivo a quello di chiusura!
ELAB_BILCA_SALDO_PREC_MISS = 7451                              #: L'elaborazione non ha ricevuto i dati per l'aggiornamento del saldo precedente nei progressivi delle schede contabili relativi all'esercizio successivo a quello di chiusura!
ELAB_BILCA_HEADPNPP_MISS = 7452                                #: L'elaborazione non ha ricevuto i dati relativi alla testata dei movimenti di chiusura per profitti e perdite!
ELAB_BILCA_ABORTED_DURING = 7453
ELAB_BILCA_HEADPNRE_MISS = 7454                                #: L'elaborazione non ha ricevuto i dati relativi alla testata del movimento relativo al risultato d'esercizio!
ELAB_BILCA_CHIUSURA_MISS = 7455                                #: L'elaborazione non ha ricevuto i dati relativi alla chiusura dell'esercizio corrente!
ELAB_BILCA_APERTURA_MISS = 7456                                #: L'elaborazione non ha ricevuto i dati relativi all'apertura dell'esercizio successivo!
ELAB_BILCA_DATA_APERTURA_MISS = 7457                           #: L'elaborazione non ha ricevuto la data di registrazione dei movimenti di apertura dell'esercizio successivo!
ELAB_BILCA_CAUSALE_APERTURA_MISS = 7458                        #: L'elaborazione non ha ricevuto la causale contabile dei movimenti di apertura dell'esercizio successivo!
ELAB_BILCA_DESC_APERTURA_MISS = 7459                           #: L'elaborazione non ha ricevuto la descrizione per le righe dei movimenti di apertura dell'esercizio successivo!
ELAB_BILCA_ES_APERTURA_MISS = 7460                             #: L'elaborazione non ha ricevuto l'esercizio di riferimento dei movimenti di apertura dell'esercizio successivo!
ELAB_BILCA_HEADPNSP_MISS = 7461                                #: L'elaborazione non ha ricevuto i dati relativi alla testata dei movimenti di chiusura dello stato patrimoniale!
ELAB_FATT_DIFF_CREATE_PN_FAIL_CC = 7475
ELAB_FATT_DIFF_DATAFATT_MISS = 7476                            #: L'elaborazione non può procedere perché non è stata specificata la data di fatturazione!
ELAB_FATT_DIFF_FAIL_DATA_FATT = 7477
ELAB_FATT_DIFF_FAILED_UPDATE_TIP = 7478                        #: Fallito l'aggiornamento dei dati della tipologia documenti
ELAB_FATT_DIFF_CODTIPFATT_MISS = 7479                          #: L'elaborazione non può procedere perché non è stato specificato il codice della tipologia di fatturazione!
ELAB_REG_IVA_LAST_PAGE_NF = 7500                               #: La stampa non può essere resa definitiva in quanto manca il numero dell'ultima pagina stampata!
ELAB_REG_IVA_LAST_PROT_NF = 7501                               #: La stampa non può essere resa definitiva in quanto manca il numero dell'ultimo protocollo stampato!
ELAB_REG_IVA_DATE_LAST_PROT_NF = 7502                          #: La stampa non può essere resa definitiva in quanto manca la data dell'ultimo protocollo stampato!
ELAB_REG_IVA_COD_REG_NF = 7503                                 #: La stampa non può essere resa definitiva in quanto non è stato specificato il codice del registro IVA da aggiornare!
ELAB_COIR_TIPO_STAMPA_MISS = 7525                              #: E' necessario specificare il tipo di Operazione da eseguire (Aggiornamento - Stampa controllo - Generazione)!
ELAB_COIR_SORGENTE_MISS = 7526                                 #: E' necessario specificare la sorgente dati su cui operare (EB_MovimentiIVA - EB_Scontrini)!
ELAB_COIR_DA_DATA_MISS = 7527                                  #: E' necessario specificare la data a partire dalla quale si devono considerare i dati!
ELAB_COIR_A_DATA_MISS = 7528                                   #: E' necessario specificare la data fino alla quale si devono considerare i dati!
ELAB_COIR_SORGENTE_WRONG = 7529                                #: La sorgente dati su cui operare deve essere o EB_MovimentiIVA o  EB_Scontrini!
ELAB_COIR_DATASOURCE_VUOTO = 7530                              #: Non ci sono dati per le selezioni effettuate!
ELAB_COIR_SCHEDE_INSERITE = 7531
ELAB_COIR_ANNO_MISS = 7532                                     #: E' necessario specificare l'anno di generazione dei dati!
ELAB_COIR_TIPOCOM_MISS1 = 7533                                 #: E' necessario specificare il tipo di comunicazione!
ELAB_COIR_TIPOCOM_MISS2 = 7534                                 #: (0 = Operazioni IVA rilevanti, 1 = Black List, 2 = San Marino - Acquisti, 3 = Turismo)
ELAB_COIR_FAILED = 7535                                        #: L'operazione di aggiornamento delle Operazioni IVA Rilevanti e' fallita a causa di errori!
ELAB_COIR_NUM_ERRS = 7536
ELAB_COIR_NO_CLIENTE = 7537
ELAB_BENI_AMM_NUMPAG_INVALID = 7540                            #: Stampa definitiva registro beni ammortizzabili - l'ultimo numero di pagina stampato in definitivo è mancante o non valido
ELAB_ASS_EFF_BANCA_INVALID = 7541                              #: Assegnazione effetti - la banca da assegnare agli effetti è mancante o non valida
ELAB_FATT_DIFF_MG_DESCRITT_NF = 7542                           #: L'elaborazione non può procedere perché non è presente l'articolo descrittivo con codice '#'!
ELAB_NUM_FATT_CAR_ROWS_MISS = 7550                             #: L'elaborazione non può procedere perché non sono stati indicati i movimenti di magazzino da aggiornare!
ELAB_NUM_FATT_CAR_NUMERO_MISS = 7551                           #: L'elaborazione non può procedere perché non e' stato specificato il numero fattura da assegnare!
ELAB_VERORD_LISTA_MAG_ERROR = 7575                             #: L'elaborazione non può procedere perché non sono stati recuperati i dati sui magazzini dell'azienda!
ELAB_VERORD_LISTA_ROC_ERROR = 7576                             #: L'elaborazione non può procedere perché non sono stati recuperati i dati sulle righe degli ordini clienti!
ELAB_VERORD_LISTA_ROF_ERROR = 7577                             #: L'elaborazione non può procedere perché non sono stati recuperati i dati sulle righe degli ordini fornitori!
ELAB_VERORD_LISTA_DAM_ERROR = 7578                             #: L'elaborazione non può procedere perché non sono stati recuperati i dati articolo magazzino!
ELAB_VERSAL_UPDATE_PROGSK_FAILED = 7600
ELAB_VERSAL_UPDATE_PROGCF_FAILED = 7601
ELAB_VERSAL_INSERT_PROGSK_FAILED = 7602
ELAB_VERSAL_INSERT_PROGCF_FAILED = 7603
ELAB_VERSAL_UPDATE_DIVA_FAILED = 7604
ELAB_VERSAL_INSERT_DIVA_FAILED = 7605
ELAB_VERSAL_NESSUNA_SPEC = 7606                                #: Occorre specificare cosa verificare, saldi, dati IVA o entrambi!
ELAB_VERGIAC_ZERO_TITDEP_FOUND = 7625
ELAB_VERGIAC_PROGART_NOT_FOUND = 7626
ELAB_DEL_SCHEDE_TAB_MISS = 7630                                #: Non e' stata specificata la tabella di cui si vogliono eliminare le schede!
ELAB_DEL_SCHEDE_TAB_WRONG = 7631                               #: L'elaborazione non può essere completata perche' non e' stata specificata una tabella valida!
ELAB_DEL_SCHEDE_ANNO_MISS = 7632                               #: Non e' stato specificato l'anno di cui si vuole eliminare le schede!
ELAB_DEL_SCHEDE_DATA_MISS = 7633                               #: Non e' stata specificata la data fino alla quale si vogliono eliminare le schede!
ELAB_DEL_SCHEDE_REF_NOT_REMOVED = 7634
ELAB_DEL_SCHEDE_WHERE_MISS = 7635                              #: Non e' stato specificato alcun filtraggio per l'eliminazione delle schede dati fattura!
ELAB_GENFATSC_SCONTRINO_MISS = 7650                            #: Non e' stato specificato lo scontrino da cui generare la fattura
ELAB_GENFATSC_SCONTRINO_NOT_FOUND = 7651                       #: Lo scontrino specificato non esiste
ELAB_GENFATSC_CLIENTE_NOT_FOUND = 7652                         #: Il cliente specificato non esiste
ELAB_GENFATSC_TIPO_DOCUMENTO_NOT_SET = 7653                    #: La tipologia documento per le fatture da scontrino non è stata impostata nella configurazione dell'azienda
ELAB_GENFATSC_INDIRIZZO_MISS = 7654                            #: Il cliente non ha un indirizzo valido abbinato
ELAB_GENFATSC_SCONTRINO_RESI = 7655                            #: Lo scontrino presenta dei resi; si prega di compilare la fattura manualmente
ELAB_VERLOTTI_LISTALOTTI_ERROR = 7675                          #: Errore durante la creazione della lista dei lotti aziendali!
ELAB_LIFOFIFO_PROG_RETRIEVE_FAILED = 7700
ELAB_TRDF_FAILED = 7701                                        #: L'operazione di aggiornamento dell'archivio dati fatture e' fallita a causa di errori!
ELAB_TRDF_NUM_ERRS = 7702
ELAB_TRDF_SCHEDE_INSERITE = 7703
ELAB_TRDF_ELAB_OK = 7704                                       #: La generazione delle schede nell'archivio dati fatture è andata a buon fine.
ELAB_TRDF_MOV_IVA_ZERO = 7705
ELAB_TRDF_ASSEGNATA_ID = 7706
ELAB_TRDF_RETTIFICA_NF = 7707
ELAB_TRDF_RETTIFICA_OK = 7708
ELAB_TRDF_RETTIFICA_ROW_NF = 7709                              #: ATTENZIONE: impossibile leggere la riga della fattura della scheda da rettificare
ELAB_VERFAT_UPDATE_DACF_FAILED = 7725
ELAB_VERFAT_INSERT_DACF_FAILED = 7726
ELAB_DIFFCAMBIO_ESERCIZIO = 7727                               #: Non è possibile effettuare l'elaborazione sull'ultimo esercizio inserito!
ACTIVITY_LOGIN = 8000                                          #: Iniziata sessione di lavoro
ACTIVITY_LOGOUT = 8001                                         #: Terminata sessione di lavoro
ACTIVITY_BAD_LOGIN = 8002                                      #: Tentativo di accesso non riuscito
ACTIVITY_DELETE = 8003
ACTIVITY_INSERT = 8004
ACTIVITY_UPDATE = 8005
ACTIVITY_DELETE_COMMON = 8006
ACTIVITY_INSERT_COMMON = 8007
ACTIVITY_UPDATE_COMMON = 8008
ACTIVITY_IMPORT_START = 8009                                   #: Iniziata importazione dati da sorgente esterna
ACTIVITY_IMPORT_END_SUCCESS = 8010                             #: Importazione dati da sorgente esterna terminata con successo
ACTIVITY_IMPORT_END_ERROR = 8011                               #: Importazione dati da sorgente esterna fallita
ACTIVITY_ELAB_START = 8012
ACTIVITY_ELAB_SUCCEED = 8013
ACTIVITY_ELAB_FAILED = 8014
ACTIVITY_DATABASE_RESTORED = 8015
ACTIVITY_BAD_LOGIN_EX = 8016
ACTIVITY_BACKUP_STARTED = 8017
ACTIVITY_BACKUP_ENDED = 8018
ACTIVITY_BACKUP_ERROR = 8019
ACTIVITY_START_PATCHING = 8020
ACTIVITY_END_PATCHING = 8021
ACTIVITY_ERROR_PATCHING = 8022
ACTIVITY_UPDATE_UNIQUE = 8023
ACTIVITY_UPDATE_UNIQUE_COMMON = 8024
ACTIVITY_DELETED_DE_WITH_SDI = 8025
CLOUD_CANNOT_INIT = 9000                                       #: Impossibile inizializzare i servizi cloud
CLOUD_INIT_ERROR = 9001
CLOUD_NOT_ACTIVE = 9002                                        #: I servizi cloud non sono attivi
CLOUD_ERROR = 9003
CLOUD_BLOB_NOT_FOUND = 9004                                    #: Blob non trovato nel cloud
CLOUD_FULL = 9005                                              #: Spazio disponibile sul cloud insufficiente
CLOUD_INITED = 9006
CLOUD_NOT_INITED = 9007                                        #: Servizi cloud non disponibili
CLOUD_NOT_SUPPORTED = 9008                                     #: Servizi cloud non supportati
CLOUD_BLOB_ALREADY_EXISTS = 9009                               #: Blob già esistente nel cloud
CLOUD_ERROR_EMAIL_SUBJECT = 9100                               #: [konga] Errore dei servizi cloud
CLOUD_BACKUP_ERROR_EMAIL_BODY = 9101
CLOUD_BACKUP_UNAVAILABLE_EMAIL_BODY = 9102
CLOUD_BACKUP_NOT_PURGED_EMAIL_BODY = 9103
MYSQL_ERR_OFFSET = 90000
MYSQL_HASHCHK = 91000
MYSQL_NISAMCHK = 91001
MYSQL_NO = 91002
MYSQL_YES = 91003
MYSQL_CANT_CREATE_FILE = 91004
MYSQL_CANT_CREATE_TABLE = 91005
MYSQL_CANT_CREATE_DB = 91006
MYSQL_DB_CREATE_EXISTS = 91007
MYSQL_DB_DROP_EXISTS = 91008
MYSQL_DB_DROP_DELETE = 91009
MYSQL_DB_DROP_RMDIR = 91010
MYSQL_CANT_DELETE_FILE = 91011
MYSQL_CANT_FIND_SYSTEM_REC = 91012
MYSQL_CANT_GET_STAT = 91013
MYSQL_CANT_GET_WD = 91014
MYSQL_CANT_LOCK = 91015
MYSQL_CANT_OPEN_FILE = 91016
MYSQL_FILE_NOT_FOUND = 91017
MYSQL_CANT_READ_DIR = 91018
MYSQL_CANT_SET_WD = 91019
MYSQL_CHECKREAD = 91020
MYSQL_DISK_FULL = 91021
MYSQL_DUP_KEY = 91022
MYSQL_ERROR_ON_CLOSE = 91023
MYSQL_ERROR_ON_READ = 91024
MYSQL_ERROR_ON_RENAME = 91025
MYSQL_ERROR_ON_WRITE = 91026
MYSQL_FILE_USED = 91027
MYSQL_FILSORT_ABORT = 91028
MYSQL_FORM_NOT_FOUND = 91029
MYSQL_GET_ERRNO = 91030
MYSQL_ILLEGAL_HA = 91031
MYSQL_KEY_NOT_FOUND = 91032
MYSQL_NOT_FORM_FILE = 91033
MYSQL_NOT_KEYFILE = 91034
MYSQL_OLD_KEYFILE = 91035
MYSQL_OPEN_AS_READONLY = 91036
MYSQL_OUTOFMEMORY = 91037
MYSQL_OUT_OF_SORTMEMORY = 91038
MYSQL_UNEXPECTED_EOF = 91039
MYSQL_CON_COUNT_ERROR = 91040
MYSQL_OUT_OF_RESOURCES = 91041
MYSQL_BAD_HOST_ERROR = 91042
MYSQL_HANDSHAKE_ERROR = 91043
MYSQL_DBACCESS_DENIED_ERROR = 91044
MYSQL_ACCESS_DENIED_ERROR = 91045
MYSQL_NO_DB_ERROR = 91046
MYSQL_UNKNOWN_COM_ERROR = 91047
MYSQL_BAD_NULL_ERROR = 91048
MYSQL_BAD_DB_ERROR = 91049
MYSQL_TABLE_EXISTS_ERROR = 91050
MYSQL_BAD_TABLE_ERROR = 91051
MYSQL_NON_UNIQ_ERROR = 91052
MYSQL_SERVER_SHUTDOWN = 91053
MYSQL_BAD_FIELD_ERROR = 91054
MYSQL_WRONG_FIELD_WITH_GROUP = 91055
MYSQL_WRONG_GROUP_FIELD = 91056
MYSQL_WRONG_SUM_SELECT = 91057
MYSQL_WRONG_VALUE_COUNT = 91058
MYSQL_TOO_LONG_IDENT = 91059
MYSQL_DUP_FIELDNAME = 91060
MYSQL_DUP_KEYNAME = 91061
MYSQL_DUP_ENTRY = 91062
MYSQL_WRONG_FIELD_SPEC = 91063
MYSQL_PARSE_ERROR = 91064
MYSQL_EMPTY_QUERY = 91065
MYSQL_NONUNIQ_TABLE = 91066
MYSQL_INVALID_DEFAULT = 91067
MYSQL_MULTIPLE_PRI_KEY = 91068
MYSQL_TOO_MANY_KEYS = 91069
MYSQL_TOO_MANY_KEY_PARTS = 91070
MYSQL_TOO_LONG_KEY = 91071
MYSQL_KEY_COLUMN_DOES_NOT_EXITS = 91072
MYSQL_BLOB_USED_AS_KEY = 91073
MYSQL_TOO_BIG_FIELDLENGTH = 91074
MYSQL_WRONG_AUTO_KEY = 91075
MYSQL_READY = 91076
MYSQL_NORMAL_SHUTDOWN = 91077
MYSQL_GOT_SIGNAL = 91078
MYSQL_SHUTDOWN_COMPLETE = 91079
MYSQL_FORCING_CLOSE = 91080
MYSQL_IPSOCK_ERROR = 91081
MYSQL_NO_SUCH_INDEX = 91082
MYSQL_WRONG_FIELD_TERMINATORS = 91083
MYSQL_BLOBS_AND_NO_TERMINATED = 91084
MYSQL_TEXTFILE_NOT_READABLE = 91085
MYSQL_FILE_EXISTS_ERROR = 91086
MYSQL_LOAD_INFO = 91087
MYSQL_ALTER_INFO = 91088
MYSQL_WRONG_SUB_KEY = 91089
MYSQL_CANT_REMOVE_ALL_FIELDS = 91090
MYSQL_CANT_DROP_FIELD_OR_KEY = 91091
MYSQL_INSERT_INFO = 91092
MYSQL_UPDATE_TABLE_USED = 91093
MYSQL_NO_SUCH_THREAD = 91094
MYSQL_KILL_DENIED_ERROR = 91095
MYSQL_NO_TABLES_USED = 91096
MYSQL_TOO_BIG_SET = 91097
MYSQL_NO_UNIQUE_LOGFILE = 91098
MYSQL_TABLE_NOT_LOCKED_FOR_WRITE = 91099
MYSQL_TABLE_NOT_LOCKED = 91100
MYSQL_BLOB_CANT_HAVE_DEFAULT = 91101
MYSQL_WRONG_DB_NAME = 91102
MYSQL_WRONG_TABLE_NAME = 91103
MYSQL_TOO_BIG_SELECT = 91104
MYSQL_UNKNOWN_ERROR = 91105
MYSQL_UNKNOWN_PROCEDURE = 91106
MYSQL_WRONG_PARAMCOUNT_TO_PROCEDURE = 91107
MYSQL_WRONG_PARAMETERS_TO_PROCEDURE = 91108
MYSQL_UNKNOWN_TABLE = 91109
MYSQL_FIELD_SPECIFIED_TWICE = 91110
MYSQL_INVALID_GROUP_FUNC_USE = 91111
MYSQL_UNSUPPORTED_EXTENSION = 91112
MYSQL_TABLE_MUST_HAVE_COLUMNS = 91113
MYSQL_RECORD_FILE_FULL = 91114
MYSQL_UNKNOWN_CHARACTER_SET = 91115
MYSQL_TOO_MANY_TABLES = 91116
MYSQL_TOO_MANY_FIELDS = 91117
MYSQL_TOO_BIG_ROWSIZE = 91118
MYSQL_STACK_OVERRUN = 91119
MYSQL_WRONG_OUTER_JOIN = 91120
MYSQL_NULL_COLUMN_IN_INDEX = 91121
MYSQL_CANT_FIND_UDF = 91122
MYSQL_CANT_INITIALIZE_UDF = 91123
MYSQL_UDF_NO_PATHS = 91124
MYSQL_UDF_EXISTS = 91125
MYSQL_CANT_OPEN_LIBRARY = 91126
MYSQL_CANT_FIND_DL_ENTRY = 91127
MYSQL_FUNCTION_NOT_DEFINED = 91128
MYSQL_HOST_IS_BLOCKED = 91129
MYSQL_HOST_NOT_PRIVILEGED = 91130
MYSQL_PASSWORD_ANONYMOUS_USER = 91131
MYSQL_PASSWORD_NOT_ALLOWED = 91132
MYSQL_PASSWORD_NO_MATCH = 91133
MYSQL_UPDATE_INFO = 91134
MYSQL_CANT_CREATE_THREAD = 91135
MYSQL_WRONG_VALUE_COUNT_ON_ROW = 91136
MYSQL_CANT_REOPEN_TABLE = 91137
MYSQL_INVALID_USE_OF_NULL = 91138
MYSQL_REGEXP_ERROR = 91139
MYSQL_MIX_OF_GROUP_FUNC_AND_FIELDS = 91140
MYSQL_NONEXISTING_GRANT = 91141
MYSQL_TABLEACCESS_DENIED_ERROR = 91142
MYSQL_COLUMNACCESS_DENIED_ERROR = 91143
MYSQL_ILLEGAL_GRANT_FOR_TABLE = 91144
MYSQL_GRANT_WRONG_HOST_OR_USER = 91145
MYSQL_NO_SUCH_TABLE = 91146
MYSQL_NONEXISTING_TABLE_GRANT = 91147
MYSQL_NOT_ALLOWED_COMMAND = 91148
MYSQL_SYNTAX_ERROR = 91149
MYSQL_DELAYED_CANT_CHANGE_LOCK = 91150
MYSQL_TOO_MANY_DELAYED_THREADS = 91151
MYSQL_ABORTING_CONNECTION = 91152
MYSQL_NET_PACKET_TOO_LARGE = 91153
MYSQL_NET_READ_ERROR_FROM_PIPE = 91154
MYSQL_NET_FCNTL_ERROR = 91155
MYSQL_NET_PACKETS_OUT_OF_ORDER = 91156
MYSQL_NET_UNCOMPRESS_ERROR = 91157
MYSQL_NET_READ_ERROR = 91158
MYSQL_NET_READ_INTERRUPTED = 91159
MYSQL_NET_ERROR_ON_WRITE = 91160
MYSQL_NET_WRITE_INTERRUPTED = 91161
MYSQL_TOO_LONG_STRING = 91162
MYSQL_TABLE_CANT_HANDLE_BLOB = 91163
MYSQL_TABLE_CANT_HANDLE_AUTO_INCREMENT = 91164
MYSQL_DELAYED_INSERT_TABLE_LOCKED = 91165
MYSQL_WRONG_COLUMN_NAME = 91166
MYSQL_WRONG_KEY_COLUMN = 91167
MYSQL_WRONG_MRG_TABLE = 91168
MYSQL_DUP_UNIQUE = 91169
MYSQL_BLOB_KEY_WITHOUT_LENGTH = 91170
MYSQL_PRIMARY_CANT_HAVE_NULL = 91171
MYSQL_TOO_MANY_ROWS = 91172
MYSQL_REQUIRES_PRIMARY_KEY = 91173
MYSQL_NO_RAID_COMPILED = 91174
MYSQL_UPDATE_WITHOUT_KEY_IN_SAFE_MODE = 91175
MYSQL_KEY_DOES_NOT_EXITS = 91176
MYSQL_CHECK_NO_SUCH_TABLE = 91177
MYSQL_CHECK_NOT_IMPLEMENTED = 91178
MYSQL_CANT_DO_THIS_DURING_AN_TRANSACTION = 91179
MYSQL_ERROR_DURING_COMMIT = 91180
MYSQL_ERROR_DURING_ROLLBACK = 91181
MYSQL_ERROR_DURING_FLUSH_LOGS = 91182
MYSQL_ERROR_DURING_CHECKPOINT = 91183
MYSQL_NEW_ABORTING_CONNECTION = 91184
MYSQL_DUMP_NOT_IMPLEMENTED = 91185
MYSQL_FLUSH_MASTER_BINLOG_CLOSED = 91186
MYSQL_INDEX_REBUILD = 91187
MYSQL_MASTER = 91188
MYSQL_MASTER_NET_READ = 91189
MYSQL_MASTER_NET_WRITE = 91190
MYSQL_FT_MATCHING_KEY_NOT_FOUND = 91191
MYSQL_LOCK_OR_ACTIVE_TRANSACTION = 91192
MYSQL_UNKNOWN_SYSTEM_VARIABLE = 91193
MYSQL_CRASHED_ON_USAGE = 91194
MYSQL_CRASHED_ON_REPAIR = 91195
MYSQL_WARNING_NOT_COMPLETE_ROLLBACK = 91196
MYSQL_TRANS_CACHE_FULL = 91197
MYSQL_SLAVE_MUST_STOP = 91198
MYSQL_SLAVE_NOT_RUNNING = 91199
MYSQL_BAD_SLAVE = 91200
MYSQL_MASTER_INFO = 91201
MYSQL_SLAVE_THREAD = 91202
MYSQL_TOO_MANY_USER_CONNECTIONS = 91203
MYSQL_SET_CONSTANTS_ONLY = 91204
MYSQL_LOCK_WAIT_TIMEOUT = 91205
MYSQL_LOCK_TABLE_FULL = 91206
MYSQL_READ_ONLY_TRANSACTION = 91207
MYSQL_DROP_DB_WITH_READ_LOCK = 91208
MYSQL_CREATE_DB_WITH_READ_LOCK = 91209
MYSQL_WRONG_ARGUMENTS = 91210
MYSQL_NO_PERMISSION_TO_CREATE_USER = 91211
MYSQL_UNION_TABLES_IN_DIFFERENT_DIR = 91212
MYSQL_LOCK_DEADLOCK = 91213
MYSQL_TABLE_CANT_HANDLE_FT = 91214
MYSQL_CANNOT_ADD_FOREIGN = 91215
MYSQL_NO_REFERENCED_ROW = 91216
MYSQL_ROW_IS_REFERENCED = 91217
MYSQL_CONNECT_TO_MASTER = 91218
MYSQL_QUERY_ON_MASTER = 91219
MYSQL_ERROR_WHEN_EXECUTING_COMMAND = 91220
MYSQL_WRONG_USAGE = 91221
MYSQL_WRONG_NUMBER_OF_COLUMNS_IN_SELECT = 91222
MYSQL_CANT_UPDATE_WITH_READLOCK = 91223
MYSQL_MIXING_NOT_ALLOWED = 91224
MYSQL_DUP_ARGUMENT = 91225
MYSQL_USER_LIMIT_REACHED = 91226
MYSQL_SPECIFIC_ACCESS_DENIED_ERROR = 91227
MYSQL_LOCAL_VARIABLE = 91228
MYSQL_GLOBAL_VARIABLE = 91229
MYSQL_NO_DEFAULT = 91230
MYSQL_WRONG_VALUE_FOR_VAR = 91231
MYSQL_WRONG_TYPE_FOR_VAR = 91232
MYSQL_VAR_CANT_BE_READ = 91233
MYSQL_CANT_USE_OPTION_HERE = 91234
MYSQL_NOT_SUPPORTED_YET = 91235
MYSQL_MASTER_FATAL_ERROR_READING_BINLOG = 91236
MYSQL_SLAVE_IGNORED_TABLE = 91237
MYSQL_INCORRECT_GLOBAL_LOCAL_VAR = 91238
MYSQL_WRONG_FK_DEF = 91239
MYSQL_KEY_REF_DO_NOT_MATCH_TABLE_REF = 91240
MYSQL_OPERAND_COLUMNS = 91241
MYSQL_SUBQUERY_NO_1_ROW = 91242
MYSQL_UNKNOWN_STMT_HANDLER = 91243
MYSQL_CORRUPT_HELP_DB = 91244
MYSQL_CYCLIC_REFERENCE = 91245
MYSQL_AUTO_CONVERT = 91246
MYSQL_ILLEGAL_REFERENCE = 91247
MYSQL_DERIVED_MUST_HAVE_ALIAS = 91248
MYSQL_SELECT_REDUCED = 91249
MYSQL_TABLENAME_NOT_ALLOWED_HERE = 91250
MYSQL_NOT_SUPPORTED_AUTH_MODE = 91251
MYSQL_SPATIAL_CANT_HAVE_NULL = 91252
MYSQL_COLLATION_CHARSET_MISMATCH = 91253
MYSQL_SLAVE_WAS_RUNNING = 91254
MYSQL_SLAVE_WAS_NOT_RUNNING = 91255
MYSQL_TOO_BIG_FOR_UNCOMPRESS = 91256
MYSQL_ZLIB_Z_MEM_ERROR = 91257
MYSQL_ZLIB_Z_BUF_ERROR = 91258
MYSQL_ZLIB_Z_DATA_ERROR = 91259
MYSQL_CUT_VALUE_GROUP_CONCAT = 91260
MYSQL_WARN_TOO_FEW_RECORDS = 91261
MYSQL_WARN_TOO_MANY_RECORDS = 91262
MYSQL_WARN_NULL_TO_NOTNULL = 91263
MYSQL_WARN_DATA_OUT_OF_RANGE = 91264
MYSQL_WARN_DATA_TRUNCATED = 91265
MYSQL_WARN_USING_OTHER_HANDLER = 91266
MYSQL_CANT_AGGREGATE_2COLLATIONS = 91267
MYSQL_DROP_USER = 91268
MYSQL_REVOKE_GRANTS = 91269
MYSQL_CANT_AGGREGATE_3COLLATIONS = 91270
MYSQL_CANT_AGGREGATE_NCOLLATIONS = 91271
MYSQL_VARIABLE_IS_NOT_STRUCT = 91272
MYSQL_UNKNOWN_COLLATION = 91273
MYSQL_SLAVE_IGNORED_SSL_PARAMS = 91274
MYSQL_SERVER_IS_IN_SECURE_AUTH_MODE = 91275
MYSQL_WARN_FIELD_RESOLVED = 91276
MYSQL_BAD_SLAVE_UNTIL_COND = 91277
MYSQL_MISSING_SKIP_SLAVE = 91278
MYSQL_UNTIL_COND_IGNORED = 91279
MYSQL_WRONG_NAME_FOR_INDEX = 91280
MYSQL_WRONG_NAME_FOR_CATALOG = 91281
MYSQL_WARN_QC_RESIZE = 91282
MYSQL_BAD_FT_COLUMN = 91283
MYSQL_UNKNOWN_KEY_CACHE = 91284
MYSQL_WARN_HOSTNAME_WONT_WORK = 91285
MYSQL_UNKNOWN_STORAGE_ENGINE = 91286
MYSQL_WARN_DEPRECATED_SYNTAX = 91287
MYSQL_NON_UPDATABLE_TABLE = 91288
MYSQL_FEATURE_DISABLED = 91289
MYSQL_OPTION_PREVENTS_STATEMENT = 91290
MYSQL_DUPLICATED_VALUE_IN_TYPE = 91291
MYSQL_TRUNCATED_WRONG_VALUE = 91292
MYSQL_TOO_MUCH_AUTO_TIMESTAMP_COLS = 91293
MYSQL_INVALID_ON_UPDATE = 91294
MYSQL_UNSUPPORTED_PS = 91295
MYSQL_GET_ERRMSG = 91296
MYSQL_GET_TEMPORARY_ERRMSG = 91297
MYSQL_UNKNOWN_TIME_ZONE = 91298
MYSQL_WARN_INVALID_TIMESTAMP = 91299
MYSQL_INVALID_CHARACTER_STRING = 91300
MYSQL_WARN_ALLOWED_PACKET_OVERFLOWED = 91301
MYSQL_CONFLICTING_DECLARATIONS = 91302
MYSQL_SP_NO_RECURSIVE_CREATE = 91303
MYSQL_SP_ALREADY_EXISTS = 91304
MYSQL_SP_DOES_NOT_EXIST = 91305
MYSQL_SP_DROP_FAILED = 91306
MYSQL_SP_STORE_FAILED = 91307
MYSQL_SP_LILABEL_MISMATCH = 91308
MYSQL_SP_LABEL_REDEFINE = 91309
MYSQL_SP_LABEL_MISMATCH = 91310
MYSQL_SP_UNINIT_VAR = 91311
MYSQL_SP_BADSELECT = 91312
MYSQL_SP_BADRETURN = 91313
MYSQL_SP_BADSTATEMENT = 91314
MYSQL_UPDATE_LOG_DEPRECATED_IGNORED = 91315
MYSQL_UPDATE_LOG_DEPRECATED_TRANSLATED = 91316
MYSQL_QUERY_INTERRUPTED = 91317
MYSQL_SP_WRONG_NO_OF_ARGS = 91318
MYSQL_SP_COND_MISMATCH = 91319
MYSQL_SP_NORETURN = 91320
MYSQL_SP_NORETURNEND = 91321
MYSQL_SP_BAD_CURSOR_QUERY = 91322
MYSQL_SP_BAD_CURSOR_SELECT = 91323
MYSQL_SP_CURSOR_MISMATCH = 91324
MYSQL_SP_CURSOR_ALREADY_OPEN = 91325
MYSQL_SP_CURSOR_NOT_OPEN = 91326
MYSQL_SP_UNDECLARED_VAR = 91327
MYSQL_SP_WRONG_NO_OF_FETCH_ARGS = 91328
MYSQL_SP_FETCH_NO_DATA = 91329
MYSQL_SP_DUP_PARAM = 91330
MYSQL_SP_DUP_VAR = 91331
MYSQL_SP_DUP_COND = 91332
MYSQL_SP_DUP_CURS = 91333
MYSQL_SP_CANT_ALTER = 91334
MYSQL_SP_SUBSELECT_NYI = 91335
MYSQL_STMT_NOT_ALLOWED_IN_SF_OR_TRG = 91336
MYSQL_SP_VARCOND_AFTER_CURSHNDLR = 91337
MYSQL_SP_CURSOR_AFTER_HANDLER = 91338
MYSQL_SP_CASE_NOT_FOUND = 91339
MYSQL_FPARSER_TOO_BIG_FILE = 91340
MYSQL_FPARSER_BAD_HEADER = 91341
MYSQL_FPARSER_EOF_IN_COMMENT = 91342
MYSQL_FPARSER_ERROR_IN_PARAMETER = 91343
MYSQL_FPARSER_EOF_IN_UNKNOWN_PARAMETER = 91344
MYSQL_VIEW_NO_EXPLAIN = 91345
MYSQL_FRM_UNKNOWN_TYPE = 91346
MYSQL_WRONG_OBJECT = 91347
MYSQL_NONUPDATEABLE_COLUMN = 91348
MYSQL_VIEW_SELECT_DERIVED = 91349
MYSQL_VIEW_SELECT_CLAUSE = 91350
MYSQL_VIEW_SELECT_VARIABLE = 91351
MYSQL_VIEW_SELECT_TMPTABLE = 91352
MYSQL_VIEW_WRONG_LIST = 91353
MYSQL_WARN_VIEW_MERGE = 91354
MYSQL_WARN_VIEW_WITHOUT_KEY = 91355
MYSQL_VIEW_INVALID = 91356
MYSQL_SP_NO_DROP_SP = 91357
MYSQL_SP_GOTO_IN_HNDLR = 91358
MYSQL_TRG_ALREADY_EXISTS = 91359
MYSQL_TRG_DOES_NOT_EXIST = 91360
MYSQL_TRG_ON_VIEW_OR_TEMP_TABLE = 91361
MYSQL_TRG_CANT_CHANGE_ROW = 91362
MYSQL_TRG_NO_SUCH_ROW_IN_TRG = 91363
MYSQL_NO_DEFAULT_FOR_FIELD = 91364
MYSQL_DIVISION_BY_ZERO = 91365
MYSQL_TRUNCATED_WRONG_VALUE_FOR_FIELD = 91366
MYSQL_ILLEGAL_VALUE_FOR_TYPE = 91367
MYSQL_VIEW_NONUPD_CHECK = 91368
MYSQL_VIEW_CHECK_FAILED = 91369
MYSQL_PROCACCESS_DENIED_ERROR = 91370
MYSQL_RELAY_LOG_FAIL = 91371
MYSQL_PASSWD_LENGTH = 91372
MYSQL_UNKNOWN_TARGET_BINLOG = 91373
MYSQL_IO_ERR_LOG_INDEX_READ = 91374
MYSQL_BINLOG_PURGE_PROHIBITED = 91375
MYSQL_FSEEK_FAIL = 91376
MYSQL_BINLOG_PURGE_FATAL_ERR = 91377
MYSQL_LOG_IN_USE = 91378
MYSQL_LOG_PURGE_UNKNOWN_ERR = 91379
MYSQL_RELAY_LOG_INIT = 91380
MYSQL_NO_BINARY_LOGGING = 91381
MYSQL_RESERVED_SYNTAX = 91382
MYSQL_WSAS_FAILED = 91383
MYSQL_DIFF_GROUPS_PROC = 91384
MYSQL_NO_GROUP_FOR_PROC = 91385
MYSQL_ORDER_WITH_PROC = 91386
MYSQL_LOGGING_PROHIBIT_CHANGING_OF = 91387
MYSQL_NO_FILE_MAPPING = 91388
MYSQL_WRONG_MAGIC = 91389
MYSQL_PS_MANY_PARAM = 91390
MYSQL_KEY_PART_0 = 91391
MYSQL_VIEW_CHECKSUM = 91392
MYSQL_VIEW_MULTIUPDATE = 91393
MYSQL_VIEW_NO_INSERT_FIELD_LIST = 91394
MYSQL_VIEW_DELETE_MERGE_VIEW = 91395
MYSQL_CANNOT_USER = 91396
MYSQL_XAER_NOTA = 91397
MYSQL_XAER_INVAL = 91398
MYSQL_XAER_RMFAIL = 91399
MYSQL_XAER_OUTSIDE = 91400
MYSQL_XAER_RMERR = 91401
MYSQL_XA_RBROLLBACK = 91402
MYSQL_NONEXISTING_PROC_GRANT = 91403
MYSQL_PROC_AUTO_GRANT_FAIL = 91404
MYSQL_PROC_AUTO_REVOKE_FAIL = 91405
MYSQL_DATA_TOO_LONG = 91406
MYSQL_SP_BAD_SQLSTATE = 91407
MYSQL_STARTUP = 91408
MYSQL_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR = 91409
MYSQL_CANT_CREATE_USER_WITH_GRANT = 91410
MYSQL_WRONG_VALUE_FOR_TYPE = 91411
MYSQL_TABLE_DEF_CHANGED = 91412
MYSQL_SP_DUP_HANDLER = 91413
MYSQL_SP_NOT_VAR_ARG = 91414
MYSQL_SP_NO_RETSET = 91415
MYSQL_CANT_CREATE_GEOMETRY_OBJECT = 91416
MYSQL_FAILED_ROUTINE_BREAK_BINLOG = 91417
MYSQL_BINLOG_UNSAFE_ROUTINE = 91418
MYSQL_BINLOG_CREATE_ROUTINE_NEED_SUPER = 91419
MYSQL_EXEC_STMT_WITH_OPEN_CURSOR = 91420
MYSQL_STMT_HAS_NO_OPEN_CURSOR = 91421
MYSQL_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG = 91422
MYSQL_NO_DEFAULT_FOR_VIEW_FIELD = 91423
MYSQL_SP_NO_RECURSION = 91424
MYSQL_TOO_BIG_SCALE = 91425
MYSQL_TOO_BIG_PRECISION = 91426
MYSQL_M_BIGGER_THAN_D = 91427
MYSQL_WRONG_LOCK_OF_SYSTEM_TABLE = 91428
MYSQL_CONNECT_TO_FOREIGN_DATA_SOURCE = 91429
MYSQL_QUERY_ON_FOREIGN_DATA_SOURCE = 91430
MYSQL_FOREIGN_DATA_SOURCE_DOESNT_EXIST = 91431
MYSQL_FOREIGN_DATA_STRING_INVALID_CANT_CREATE = 91432
MYSQL_FOREIGN_DATA_STRING_INVALID = 91433
MYSQL_CANT_CREATE_FEDERATED_TABLE = 91434
MYSQL_TRG_IN_WRONG_SCHEMA = 91435
MYSQL_STACK_OVERRUN_NEED_MORE = 91436
MYSQL_TOO_LONG_BODY = 91437
MYSQL_WARN_CANT_DROP_DEFAULT_KEYCACHE = 91438
MYSQL_TOO_BIG_DISPLAYWIDTH = 91439
MYSQL_XAER_DUPID = 91440
MYSQL_DATETIME_FUNCTION_OVERFLOW = 91441
MYSQL_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG = 91442
MYSQL_VIEW_PREVENT_UPDATE = 91443
MYSQL_PS_NO_RECURSION = 91444
MYSQL_SP_CANT_SET_AUTOCOMMIT = 91445
MYSQL_MALFORMED_DEFINER = 91446
MYSQL_VIEW_FRM_NO_USER = 91447
MYSQL_VIEW_OTHER_USER = 91448
MYSQL_NO_SUCH_USER = 91449
MYSQL_FORBID_SCHEMA_CHANGE = 91450
MYSQL_ROW_IS_REFERENCED_2 = 91451
MYSQL_NO_REFERENCED_ROW_2 = 91452
MYSQL_SP_BAD_VAR_SHADOW = 91453
MYSQL_TRG_NO_DEFINER = 91454
MYSQL_OLD_FILE_FORMAT = 91455
MYSQL_SP_RECURSION_LIMIT = 91456
MYSQL_SP_PROC_TABLE_CORRUPT = 91457
MYSQL_SP_WRONG_NAME = 91458
MYSQL_TABLE_NEEDS_UPGRADE = 91459
MYSQL_SP_NO_AGGREGATE = 91460
MYSQL_MAX_PREPARED_STMT_COUNT_REACHED = 91461
MYSQL_VIEW_RECURSIVE = 91462
MYSQL_NON_GROUPING_FIELD_USED = 91463
MYSQL_TABLE_CANT_HANDLE_SPKEYS = 91464
MYSQL_NO_TRIGGERS_ON_SYSTEM_SCHEMA = 91465
MYSQL_REMOVED_SPACES = 91466
MYSQL_AUTOINC_READ_FAILED = 91467
MYSQL_USERNAME = 91468
MYSQL_HOSTNAME = 91469
MYSQL_WRONG_STRING_LENGTH = 91470
MYSQL_NON_INSERTABLE_TABLE = 91471
MYSQL_ADMIN_WRONG_MRG_TABLE = 91472
MYSQL_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT = 91473
MYSQL_NAME_BECOMES_EMPTY = 91474
MYSQL_AMBIGUOUS_FIELD_TERM = 91475
MYSQL_LOAD_DATA_INVALID_COLUMN = 91476
MYSQL_LOG_PURGE_NO_FILE = 91477
CMD_PING = 0
OUT_CHECKSUM = 'CHECKSUM'
CMD_CHECK_LICENSE = 1
OUT_STATUS = 'STATUS'
OUT_PRODUCT = 'PRODUCT'
OUT_VERSION = 'VERSION'
OUT_TAG = 'TAG'
OUT_BUILD = 'BUILD'
OUT_SYSTEM = 'SYSTEM'
OUT_FLAGS = 'FLAGS'
OUT_EXPIRE_TIME = 'EXPIRE_TIME'
OUT_NAME = 'NAME'
OUT_KEY = 'KEY'
OUT_SERIAL = 'SERIAL'
OUT_INSTALL_CODE = 'INSTALL_CODE'
OUT_MODULES = 'MODULES'
OUT_MAX_CLIENTS = 'MAX_CLIENTS'
OUT_CLOUD_ENABLED = 'CLOUD_ENABLED'
OUT_CLOUD_ERROR = 'CLOUD_ERROR'
CMD_ACTIVATE = 2
IN_KEY = 'KEY'
IN_NAME = 'NAME'
IN_SERIAL = 'SERIAL'
IN_RESTART = 'RESTART'
CMD_CHECK_PASSWORD = 3
IN_PASSWORD = 'PASSWORD'
CMD_LIST_DRIVERS = 4
IN_CONFIGURED = 'CONFIGURED'
OUT_DRIVERS = 'DRIVERS'
CMD_LIST_DATABASES = 5
IN_DRIVER = 'DRIVER'
IN_PATTERN = 'PATTERN'
IN_QUICK = 'QUICK'
OUT_DATABASES = 'DATABASES'
OUT_COMPLETED = 'COMPLETED'
CMD_CREATE_DATABASE = 6
IN_DESC = 'DESC'
OUT_INFO = 'INFO'
CMD_OPEN_DATABASE = 7
IN_FORCE = 'FORCE'
CMD_CLOSE_DATABASE = 8
IN_BACKUP = 'BACKUP'
CMD_UPGRADE_DATABASE = 9
OUT_LOG = 'LOG'
OUT_OLD_VERSION = 'OLD_VERSION'
OUT_NEW_VERSION = 'NEW_VERSION'
CMD_DELETE_DATABASE = 10
CMD_QUERY_DATABASE = 11
IN_QUERY = 'QUERY'
IN_FULL_COLUMNS_LIST = 'FULL_COLUMNS_LIST'
IN_COLLAPSE_BLOBS = 'COLLAPSE_BLOBS'
OUT_AFFECTED_ROWS = 'AFFECTED_ROWS'
OUT_COLUMNS_LIST = 'COLUMNS_LIST'
OUT_RESULT_SET = 'RESULT_SET'
CMD_QUERY_DATABASE_NATIVELY = 12
CMD_CONTROL_DATABASE = 13
IN_COMMAND = 'COMMAND'
IN_DATA = 'DATA'
OUT_DATA = 'DATA'
CMD_BACKUP_DATABASE = 14
IN_BACKUP_NAME = 'BACKUP_NAME'
IN_AUTO_BACKUP = 'AUTO_BACKUP'
IN_OVERWRITE = 'OVERWRITE'
IN_POSITION = 'POSITION'
IN_STORE_INDEX = 'STORE_INDEX'
CMD_RESTORE_DATABASE = 15
IN_CHANGE_UUID = 'CHANGE_UUID'
IN_RESTORE_INDEX = 'RESTORE_INDEX'
CMD_LIST_BACKUPS = 16
OUT_BACKUPS = 'BACKUPS'
CMD_DELETE_BACKUP = 17
CMD_OPTIMIZE_DATABASE = 18
CMD_INDEX_DATABASE = 19
IN_RESET = 'RESET'
IN_RUN = 'RUN'
CMD_CONFIGURE_DATABASE = 20
IN_NEW_NAME = 'NEW_NAME'
IN_NEW_DESC = 'NEW_DESC'
CMD_SEARCH = 21
IN_LIMIT = 'LIMIT'
OUT_HITS = 'HITS'
CMD_GET_SERVER_INFO = 22
IN_BASIC = 'BASIC'
OUT_DESC = 'DESC'
OUT_VERSION_TAG = 'VERSION_TAG'
OUT_DATA_VERSION = 'DATA_VERSION'
OUT_DATA_VERSION_TAG = 'DATA_VERSION_TAG'
OUT_CPU_USAGE = 'CPU_USAGE'
OUT_TOTAL_MEMORY = 'TOTAL_MEMORY'
OUT_AVAILABLE_MEMORY = 'AVAILABLE_MEMORY'
OUT_USED_MEMORY = 'USED_MEMORY'
OUT_IP = 'IP'
OUT_LISTENER_PORT = 'LISTENER_PORT'
OUT_RESPONDER_PORT = 'RESPONDER_PORT'
OUT_STARTUP_TIME = 'STARTUP_TIME'
OUT_TOTAL_CONNECTIONS = 'TOTAL_CONNECTIONS'
OUT_TOTAL_REQUESTS = 'TOTAL_REQUESTS'
OUT_LOG_LEVEL = 'LOG_LEVEL'
CMD_GET_SERVER_CONFIG = 23
OUT_CONFIG = 'CONFIG'
OUT_CRYPTO_CONFIGURED = 'CRYPTO_CONFIGURED'
CMD_SET_SERVER_CONFIG = 24
IN_CONFIG = 'CONFIG'
CMD_GET_CLIENT_LIST = 25
IN_FULL = 'FULL'
IN_ANY = 'ANY'
OUT_CLIENT_LIST = 'CLIENT_LIST'
CMD_GET_CLIENT_INFO = 26
IN_CLIENT_ID = 'CLIENT_ID'
OUT_CLIENT_INFO = 'CLIENT_INFO'
CMD_KILL_CLIENT = 27
CMD_BEGIN_TRANSACTION = 28
IN_FLAGS = 'FLAGS'
CMD_COMMIT_TRANSACTION = 29
CMD_ROLLBACK_TRANSACTION = 30
CMD_GET_DATA_DICTIONARY = 31
IN_CHECKSUM = 'CHECKSUM'
OUT_DICTIONARY = 'DICTIONARY'
OUT_TABLES_MAPPING = 'TABLES_MAPPING'
CMD_AUTHENTICATE = 32
IN_USERNAME = 'USERNAME'
IN_NEW_PASSWORD = 'NEW_PASSWORD'
OUT_USERINFO = 'USERINFO'
CMD_GET_PERMISSIONS = 33
IN_USER_ID = 'USER_ID'
OUT_PERMISSIONS = 'PERMISSIONS'
CMD_SET_PERMISSIONS = 34
IN_PERMISSIONS = 'PERMISSIONS'
CMD_RELEASE_MEMORY = 35
CMD_CRASH = 36
CMD_SELECT = 37
IN_TABLE_NAME = 'TABLE_NAME'
IN_COLUMN_NAMES = 'COLUMN_NAMES'
IN_WHERE_CLAUSE = 'WHERE_CLAUSE'
IN_ORDER_BY = 'ORDER_BY'
IN_ORDER_DESC = 'ORDER_DESC'
IN_OFFSET = 'OFFSET'
IN_ROW_COUNT = 'ROW_COUNT'
IN_GET_TOTAL_ROWS = 'GET_TOTAL_ROWS'
IN_GET_ROWS_EXIST = 'GET_ROWS_EXIST'
OUT_TOTAL_ROWS = 'TOTAL_ROWS'
OUT_EXIST = 'EXIST'
OUT_COLUMN_NAMES = 'COLUMN_NAMES'
CMD_ROWS_EXIST = 38
IN_ROW_IDS = 'ROW_IDS'
CMD_GET = 39
IN_ROW_ID = 'ROW_ID'
IN_CODE = 'CODE'
IN_CODE_AZIENDA = 'CODE_AZIENDA'
IN_NUM_ESERCIZIO = 'NUM_ESERCIZIO'
IN_ROW_EXTRA_FIELDS = 'ROW_EXTRA_FIELDS'
OUT_DICT_DATA = 'DICT_DATA'
CMD_GET_COMPLETER_LIST = 40
IN_COLUMN_NAME = 'COLUMN_NAME'
IN_TEXT = 'TEXT'
IN_EXTRA_WHERE = 'EXTRA_WHERE'
IN_VARIANT = 'VARIANT'
IN_AS_TABLE = 'AS_TABLE'
CMD_DECODE = 41
IN_COMPLETION = 'COMPLETION'
CMD_CODE_EXISTS = 42
OUT_EXISTS = 'EXISTS'
CMD_GET_NEXT_CODE = 43
IN_DRY_RUN = 'DRY_RUN'
OUT_CODE = 'CODE'
CMD_INSERT_FROM_DICT = 44
IN_DICT_DATA = 'DICT_DATA'
OUT_ID = 'ID'
CMD_UPDATE_FROM_DICT = 45
CMD_ASK_DELETE_FROM_CODE = 46
CMD_DELETE_FROM_CODE = 47
CMD_LOCK = 48
IN_COMMAND_NAME = 'COMMAND_NAME'
OUT_ANSWER = 'ANSWER'
OUT_OWNER_DATA = 'OWNER_DATA'
CMD_UNLOCK = 49
CMD_GET_TABLE_TS = 50
OUT_RESULTS = 'RESULTS'
OUT_INDEXING_PROGRESS = 'INDEXING_PROGRESS'
CMD_BEGIN_IMPORT = 51
IN_FORMAT = 'FORMAT'
IN_TRANSACTION = 'TRANSACTION'
IN_NO_SCHEDULER = 'NO_SCHEDULER'
IN_ON_CREATION = 'ON_CREATION'
IN_AUTO_CC = 'AUTO_CC'
CMD_END_IMPORT = 52
IN_SUCCESS = 'SUCCESS'
CMD_IMPORT_DATA = 53
IN_METHOD = 'METHOD'
IN_HEADER = 'HEADER'
IN_TABLES_LEFT = 'TABLES_LEFT'
IN_NO_INDEXING = 'NO_INDEXING'
CMD_START_ELAB = 54
IN_PARAMS = 'PARAMS'
IN_TX = 'TX'
CMD_FETCH_BINARY = 55
IN_FIELD_NAME = 'FIELD_NAME'
IN_TYPE = 'TYPE'
IN_FILENAME = 'FILENAME'
IN_STORAGE_TYPE = 'STORAGE_TYPE'
OUT_FILENAME = 'FILENAME'
CMD_TOUCH_DATABASE = 56
OUT_UUID = 'UUID'
CMD_LIST_LOCKS = 57
OUT_LOCKS = 'LOCKS'
CMD_RELEASE_LOCK = 58
IN_RESOURCE_NAME = 'RESOURCE_NAME'
CMD_LOG_ACTIVITY = 59
IN_LEVEL = 'LEVEL'
IN_MESSAGE = 'MESSAGE'
CMD_SELECT_ROW_IDS = 60
OUT_ROW_IDS = 'ROW_IDS'
CMD_GET_ACTIVE_DIRECTORY_USERS = 61
IN_FILTER = 'FILTER'
OUT_LIST = 'LIST'
CMD_CONNECT_ACTIVE_DIRECTORY = 62
IN_SERVER = 'SERVER'
CMD_RECEIVE_MESSAGES = 63
CMD_SEND_MESSAGE = 64
IN_TARGET = 'TARGET'
CMD_REPAIR_DATABASE = 65
IN_OUTPUT = 'OUTPUT'
CMD_TRANSLATE = 66
IN_FIELD = 'FIELD'
IN_VALUE = 'VALUE'
IN_LANGUAGE = 'LANGUAGE'
OUT_TEXT = 'TEXT'
CMD_SET_DATABASE_LANGUAGE = 67
CMD_ARCHIVE_ACCOUNTING_YEAR = 68
IN_DATABASE = 'DATABASE'
IN_CREATE = 'CREATE'
IN_OPTIMIZE = 'OPTIMIZE'
CMD_SYNC_PREFERENCES = 69
CMD_GET_CLOUD_STATS = 70
OUT_TOTAL_SIZE = 'TOTAL_SIZE'
OUT_USED_SIZE = 'USED_SIZE'
OUT_USED_BACKUPS_SIZE = 'USED_BACKUPS_SIZE'
OUT_USED_IMAGES_SIZE = 'USED_IMAGES_SIZE'
OUT_USED_ATTACHMENTS_SIZE = 'USED_ATTACHMENTS_SIZE'
CMD_TEST_EMAIL = 71
IN_FROM = 'FROM'
IN_SMTP_HOST = 'SMTP_HOST'
IN_SMTP_PORT = 'SMTP_PORT'
IN_SMTP_USERNAME = 'SMTP_USERNAME'
IN_SMTP_PASSWORD = 'SMTP_PASSWORD'
IN_SMTP_ENCRYPTION = 'SMTP_ENCRYPTION'
IN_SENDMAIL_PATH = 'SENDMAIL_PATH'
CMD_COPY_BACKUP = 72
IN_FROM_POSITION = 'FROM_POSITION'
IN_TO_POSITION = 'TO_POSITION'
CMD_SET_BACKUP_PERSIST = 73
IN_PERSIST = 'PERSIST'
CMD_STORE_BINARY = 74
CMD_UPLOAD_DATABASE = 75
CMD_UPLOAD_BACKUP = 76
CMD_ABORT_ALL_REQUESTS = 77
CMD_ENCRYPT_DATABASE = 78
IN_ENCRYPT = 'ENCRYPT'
CMD_ENCRYPT_BACKUP = 79
CMD_RENAME_BACKUP = 80
IN_OLD_BACKUP_NAME = 'OLD_BACKUP_NAME'
IN_NEW_BACKUP_NAME = 'NEW_BACKUP_NAME'
CMD_SET_ENCRYPTION_PASSWORD = 81
IN_ENCRYPTION_PASSWORD = 'ENCRYPTION_PASSWORD'
CMD_GET_EDI_INFO = 82
CMD_TRANSLATE_DE = 83
IN_XML = 'XML'
IN_XSLT = 'XSLT'
OUT_HTML = 'HTML'
CMD_GET_DE_STATUS = 84
IN_YEAR = 'YEAR'
OUT_ACTIVE_COUNT = 'ACTIVE_COUNT'
OUT_ACTIVE_ERRORS = 'ACTIVE_ERRORS'
OUT_PASSIVE_COUNT = 'PASSIVE_COUNT'
CMD_GET_DE_EDI_LOG = 85
OUT_MESSAGES_LOG = 'MESSAGES_LOG'
CMD_LIST_BINARIES = 86
CMD_SET_EDI_CONFIG = 87
CMD_CLONE_DATABASE = 88
IN_NEW_DRIVER = 'NEW_DRIVER'
CMD_GET_LAST_NPFE = 89
OUT_NPFE = 'NPFE'
CMD_GET_EDI_CONFIG = 90
CMD_GET_FTS_INDEX_INFO = 91
OUT_FTS_ENABLED = 'FTS_ENABLED'
OUT_INDEX_STORAGE_TYPE = 'INDEX_STORAGE_TYPE'
OUT_INDEX_CACHE_PATH = 'INDEX_CACHE_PATH'
CMD_CONVERT_FTS_INDEX = 92
CMD_GET_TABLE_TYPES = 93
OUT_TYPES = 'TYPES'
CMD_TEST = 94
IN_INPUT = 'INPUT'
OUT_OUTPUT = 'OUTPUT'
ELAB_SITUAZIONE_CASSA = 0
ELAB_VARIAZIONE_LISTINI = 1
ELAB_VARIAZIONE_CODICI = 2
ELAB_CONFERMA_CUMULATIVA_DOCUMENTI = 3
ELAB_CONFERMA_PAGAMENTO_PROVVIGIONI = 4
ELAB_ELIMINAZIONE_SCHEDE_PREGRESSE = 5
ELAB_AGGIORNA_INVENTARIO = 6
ELAB_RIMANENZE_FINALI = 7
ELAB_RECUPERA_PROGRESSIVI = 8
ELAB_MODIFICA_STATO_EFFETTI = 9
ELAB_GIORNALE_CONTABILE_DEFINITIVO = 10
ELAB_AGGIORNA_STATO_SCADENZE_PA = 11
ELAB_BENI_AMMORTIZZABILI_DEFINITIVO = 12
ELAB_ASSEGNAZIONE_EFFETTI = 13
ELAB_VERSAMENTI_DEFINITIVO = 14
ELAB_GENERAZIONE_PROVVIGIONI = 15
ELAB_GENERA_ORDINI_ACQUISTO = 16
ELAB_EVASIONE_ORDINI = 17
ELAB_CALCOLO_LIQ_IVA_PERIODICA = 18
ELAB_GENERAZIONE_AMMORTAMENTI = 19
ELAB_STAMPA_LIQ_IVA_PERIODICA = 20
ELAB_BILANCIO_UE = 21
ELAB_BILANCI = 22
ELAB_BIL_CHIUSURA_APERTURA = 23
ELAB_REGISTRI_IVA = 24
ELAB_UTILITA_INVENTARIO = 25
ELAB_LISTE_MAGAZZINO = 26
ELAB_PARTITARI_PRIMANOTA = 27
ELAB_STAMPA_DOC_FISCALI = 28
ELAB_FATTURE_DIFFERITE = 29
ELAB_SITUAZIONE_GIACENZE = 30
ELAB_COMUNICAZIONE_IVA = 31
ELAB_STAMPA_LIQ_IVA_ANNUALE = 32
ELAB_COMUNICAZIONE_OPIR = 33
ELAB_NUM_FATT_PER_CARICHI = 34
ELAB_PARTITARI_CC = 35
ELAB_AGGIORNA_ULTIMO_ARTICOLO = 36
ELAB_INVIO_FATTURA_ELETTRONICA = 37
ELAB_ACCETTA_PREVENTIVO = 38
ELAB_BILANCI_CENTRI_COSTO = 39
ELAB_VERIFICA_ORDINI = 40
ELAB_AGGIORNA_PRACQ_VALUTA = 41
ELAB_VERIFICA_SALDI = 42
ELAB_AGGIORNA_CESPITI = 43
ELAB_AGGIORNA_TAGS_ARTICOLO = 44
ELAB_VERIFICA_GIACENZE = 45
ELAB_PRODUCI_TRASFORMA_COMPOSTI = 46
ELAB_GENERA_MOVIMENTI_SCONTRINI = 47
ELAB_VERIFICA_ESPOSIZIONE = 48
ELAB_CHIUSURA_PARTITE_APERTE = 49
ELAB_GENERA_FATTURA_SCONTRINO = 50
ELAB_AZZERA_INVENTARIO = 51
ELAB_VERIFICA_LOTTI = 52
ELAB_GENERAZIONE_PN_ACQUISTO = 53
ELAB_CALCOLO_MATURAZIONE_PROVVIGIONI = 54
ELAB_TRASMISSIONE_DATI_FATTURE = 55
ELAB_VAL_LIFO_FIFO = 56
ELAB_ANNULLA_SCONTRINO = 57
ELAB_UPLOAD_DE = 58
ELAB_IMPORT_DE = 59
ELAB_GENERAZIONE_RATEI_RISCONTI = 60
ELAB_PRESERVE_DE = 61
ELAB_GENERAZIONE_DIFFERENZE_CAMBI = 62
ELAB_FETCH_DE = 63
ELAB_GIROCONTO_RIBA_RID = 64
ELAB_GESTIONE_DETTAGLI = 65
