# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import MixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_analyze_conversation_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-01"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/:analyze-conversations"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class ConversationAnalysisClientOperationsMixin(MixinABC):
    @overload
    def analyze_conversation(self, task: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Analyzes the input conversation utterance.

        :param task: A single conversational task to execute. Required.
        :type task: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "Conversation":
                analyze_conversation_task = {
                    "analysisInput": {
                        "conversationItem": {
                            "id": "str",  # The ID of a conversation item. Required.
                            "language": "str",  # Optional. The override language of a
                              conversation item in BCP 47 language representation.
                            "modality": "str",  # Optional. Enumeration of supported
                              conversational modalities. Known values are: "transcript" and "text".
                            "participantId": "str"  # The participant ID of a
                              conversation item. Required.
                        }
                    },
                    "kind": "Conversation",
                    "parameters": {
                        "deploymentName": "str",  # The name of the deployment to use.
                          Required.
                        "directTarget": "str",  # Optional. The name of a target project to
                          forward the request to.
                        "isLoggingEnabled": bool,  # Optional. If true, the service will keep
                          the query for further review.
                        "projectName": "str",  # The name of the project to use. Required.
                        "stringIndexType": "TextElements_v8",  # Optional. Default value is
                          "TextElements_v8". Specifies the method used to interpret string offsets. Set
                          to "UnicodeCodePoint" for Python strings. Known values are:
                          "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
                        "targetProjectParameters": {
                            "str": analysis_parameters
                        },
                        "verbose": bool  # Optional. If true, the service will return more
                          detailed information in the response.
                    }
                }

                # JSON input template you can fill out and use as your body input.
                task = analyze_conversation_task
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "ConversationResult":
                analyze_conversation_task_result = {
                    "kind": "ConversationResult",
                    "result": {
                        "detectedLanguage": "str",  # Optional. The system detected language
                          for the query in BCP 47 language representation..
                        "prediction": base_prediction,
                        "query": "str"  # The conversation utterance given by the caller.
                          Required.
                    }
                }

                # response body for status code(s): 200
                response == analyze_conversation_task_result
        """

    @overload
    def analyze_conversation(self, task: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Analyzes the input conversation utterance.

        :param task: A single conversational task to execute. Required.
        :type task: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "ConversationResult":
                analyze_conversation_task_result = {
                    "kind": "ConversationResult",
                    "result": {
                        "detectedLanguage": "str",  # Optional. The system detected language
                          for the query in BCP 47 language representation..
                        "prediction": base_prediction,
                        "query": "str"  # The conversation utterance given by the caller.
                          Required.
                    }
                }

                # response body for status code(s): 200
                response == analyze_conversation_task_result
        """

    @distributed_trace
    def analyze_conversation(self, task: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Analyzes the input conversation utterance.

        :param task: A single conversational task to execute. Is either a model type or a IO type.
         Required.
        :type task: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "ConversationResult":
                analyze_conversation_task_result = {
                    "kind": "ConversationResult",
                    "result": {
                        "detectedLanguage": "str",  # Optional. The system detected language
                          for the query in BCP 47 language representation..
                        "prediction": base_prediction,
                        "query": "str"  # The conversation utterance given by the caller.
                          Required.
                    }
                }

                # response body for status code(s): 200
                response == analyze_conversation_task_result
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(task, (IO, bytes)):
            _content = task
        else:
            _json = task

        request = build_analyze_conversation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)
