# Copyright (c) 2014-2018 Adam Karpierz
# Licensed under the zlib/libpng License
# http://opensource.org/licenses/zlib

from ..... import jni
from .....jvm.java.org.python import embed


# Class: jep.python.PyObject

# Method: native void set_var(long tstate, long obj, String name, boolean value);

@jni.method("(JJLjava/lang/String;Z)V", name="set_var")
def set_boolean(env, this,
                tstate, obj, name, value):

    return embed.set_boolean(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, char value);

@jni.method("(JJLjava/lang/String;C)V", name="set_var")
def set_char(env, this,
             tstate, obj, name, value):

    pass # Not needed because method in PyObject make this through String conversion

# Method: native void set_var(long tstate, long obj, String name, byte value);

@jni.method("(JJLjava/lang/String;B)V", name="set_var")
def set_byte(env, this,
             tstate, obj, name, value):

    return embed.set_byte(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, short value);

@jni.method("(JJLjava/lang/String;S)V", name="set_var")
def set_short(env, this,
              tstate, obj, name, value):

    return embed.set_short(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, int value);

@jni.method("(JJLjava/lang/String;I)V", name="set_var")
def set_int(env, this,
            tstate, obj, name, value):

    return embed.set_int(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, long value);

@jni.method("(JJLjava/lang/String;J)V", name="set_var")
def set_long(env, this,
             tstate, obj, name, value):

    return embed.set_long(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, float value);

@jni.method("(JJLjava/lang/String;F)V", name="set_var")
def set_float(env, this,
              tstate, obj, name, value):

    return embed.set_float(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, double value);

@jni.method("(JJLjava/lang/String;D)V", name="set_var")
def set_double(env, this,
               tstate, obj, name, value):

    return embed.set_double(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, String value);

@jni.method("(JJLjava/lang/String;Ljava/lang/String;)V", name="set_var")
def set_string(env, this,
               tstate, obj, name, value):

    return embed.set_string(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, Object value);

@jni.method("(JJLjava/lang/String;Ljava/lang/Object;)V", name="set_var")
def set_object(env, this,
               tstate, obj, name, value):

    return embed.set_object(env[0], tstate, obj, name, value)

# Method: native void set_var(long tstate, long obj, String name, boolean[] value);

@jni.method("(JJLjava/lang/String;[Z)V", name="set_var")
def set_booleanarray(env, this,
                     tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)

# Method: native void set_var(long tstate, long obj, String name, char[] value);

@jni.method("(JJLjava/lang/String;[C)V", name="set_var")
def set_chararray(env, this,
                  tstate, obj, name, array):

    pass # Not needed because method in PyObject make this through String conversion

# Method: native void set_var(long tstate, long obj, String name, byte[] value);

@jni.method("(JJLjava/lang/String;[B)V", name="set_var")
def set_bytearray(env, this,
                  tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)

# Method: native void set_var(long tstate, long obj, String name, short[] value);

@jni.method("(JJLjava/lang/String;[S)V", name="set_var")
def set_shortarray(env, this,
                   tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)

# Method: native void set_var(long tstate, long obj, String name, int[] value);

@jni.method("(JJLjava/lang/String;[I)V", name="set_var")
def set_intarray(env, this,
                 tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)

# Method: native void set_var(long tstate, long obj, String name, long[] value);

@jni.method("(JJLjava/lang/String;[J)V", name="set_var")
def set_longarray(env, this,
                  tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)

# Method: native void set_var(long tstate, long obj, String name, float[] value);

@jni.method("(JJLjava/lang/String;[F)V", name="set_var")
def set_floatarray(env, this,
                   tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)

# Method: native void set_var(long tstate, long obj, String name, double[] value);

@jni.method("(JJLjava/lang/String;[D)V", name="set_var")
def set_doublearray(env, this,
                    tstate, obj, name, array):

    return embed.set_array(env[0], tstate, obj, name, array)


__jnimethods__ = (
    set_boolean,
    set_char,
    set_byte,
    set_short,
    set_int,
    set_long,
    set_float,
    set_double,
    set_string,
    set_object,
    set_booleanarray,
    set_chararray,
    set_bytearray,
    set_shortarray,
    set_intarray,
    set_longarray,
    set_floatarray,
    set_doublearray,
)

__javacode__ = bytearray(  # Auto-generated; DO NOT EDIT!
    b"\xca\xfe\xba\xbe\x00\x00\x00\x34\x00\x96\x0a\x00\x26\x00\x64\x0a\x00\x26\x00\x65"
    b"\x07\x00\x66\x07\x00\x67\x0a\x00\x03\x00\x68\x0a\x00\x04\x00\x69\x0a\x00\x04\x00"
    b"\x6a\x0a\x00\x26\x00\x6b\x0a\x00\x25\x00\x6b\x0a\x00\x26\x00\x6c\x0a\x00\x26\x00"
    b"\x6d\x0a\x00\x26\x00\x6e\x0a\x00\x26\x00\x6f\x09\x00\x26\x00\x70\x09\x00\x71\x00"
    b"\x72\x09\x00\x26\x00\x73\x0a\x00\x25\x00\x74\x07\x00\x75\x0a\x00\x12\x00\x76\x0a"
    b"\x00\x25\x00\x77\x0a\x00\x25\x00\x78\x0a\x00\x25\x00\x79\x0a\x00\x25\x00\x7a\x0a"
    b"\x00\x25\x00\x7b\x0a\x00\x25\x00\x7c\x0a\x00\x25\x00\x7d\x0a\x00\x25\x00\x7e\x0a"
    b"\x00\x25\x00\x7f\x0a\x00\x25\x00\x80\x0a\x00\x25\x00\x81\x0a\x00\x25\x00\x82\x0a"
    b"\x00\x25\x00\x83\x0a\x00\x25\x00\x84\x0a\x00\x25\x00\x85\x0a\x00\x26\x00\x86\x0a"
    b"\x00\x26\x00\x87\x07\x00\x88\x07\x00\x89\x01\x00\x06\x3c\x69\x6e\x69\x74\x3e\x01"
    b"\x00\x0e\x28\x4a\x4a\x4c\x6a\x65\x70\x2f\x4a\x65\x70\x3b\x29\x56\x01\x00\x04\x43"
    b"\x6f\x64\x65\x01\x00\x0a\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x73\x01\x00\x05\x63"
    b"\x6c\x6f\x73\x65\x01\x00\x03\x28\x29\x56\x01\x00\x0d\x53\x74\x61\x63\x6b\x4d\x61"
    b"\x70\x54\x61\x62\x6c\x65\x07\x00\x66\x01\x00\x0a\x63\x68\x65\x63\x6b\x56\x61\x6c"
    b"\x69\x64\x01\x00\x07\x69\x73\x56\x61\x6c\x69\x64\x01\x00\x0a\x44\x65\x70\x72\x65"
    b"\x63\x61\x74\x65\x64\x01\x00\x19\x52\x75\x6e\x74\x69\x6d\x65\x56\x69\x73\x69\x62"
    b"\x6c\x65\x41\x6e\x6e\x6f\x74\x61\x74\x69\x6f\x6e\x73\x01\x00\x16\x4c\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x44\x65\x70\x72\x65\x63\x61\x74\x65\x64\x3b\x01\x00"
    b"\x07\x67\x65\x74\x41\x74\x74\x72\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61"
    b"\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x01\x00\x37\x28\x4c\x6a\x61\x76\x61\x2f\x6c"
    b"\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x43\x6c\x61\x73\x73\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f"
    b"\x4f\x62\x6a\x65\x63\x74\x3b\x01\x00\x09\x53\x69\x67\x6e\x61\x74\x75\x72\x65\x01"
    b"\x00\x43\x3c\x54\x3a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65"
    b"\x63\x74\x3b\x3e\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3c"
    b"\x54\x54\x3b\x3e\x3b\x29\x54\x54\x3b\x01\x00\x07\x73\x65\x74\x41\x74\x74\x72\x01"
    b"\x00\x27\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67"
    b"\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x29"
    b"\x56\x01\x00\x07\x64\x65\x6c\x41\x74\x74\x72\x01\x00\x15\x28\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x56\x01\x00\x03\x73\x65"
    b"\x74\x01\x00\x16\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x5a\x29\x56\x01\x00\x16\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67"
    b"\x2f\x53\x74\x72\x69\x6e\x67\x3b\x43\x29\x56\x01\x00\x16\x28\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x42\x29\x56\x01\x00\x16\x28"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x53\x29"
    b"\x56\x01\x00\x16\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x49\x29\x56\x01\x00\x16\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67"
    b"\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4a\x29\x56\x01\x00\x16\x28\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x46\x29\x56\x01\x00\x16\x28"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x44\x29"
    b"\x56\x01\x00\x27\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67"
    b"\x3b\x29\x56\x01\x00\x17\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x5b\x5a\x29\x56\x01\x00\x17\x28\x4c\x6a\x61\x76\x61\x2f\x6c"
    b"\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x43\x29\x56\x01\x00\x17\x28\x4c"
    b"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x42\x29"
    b"\x56\x01\x00\x17\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x5b\x53\x29\x56\x01\x00\x17\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x49\x29\x56\x01\x00\x17\x28\x4c\x6a\x61"
    b"\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x4a\x29\x56\x01"
    b"\x00\x17\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67"
    b"\x3b\x5b\x46\x29\x56\x01\x00\x17\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f"
    b"\x53\x74\x72\x69\x6e\x67\x3b\x5b\x44\x29\x56\x01\x00\x07\x73\x65\x74\x5f\x76\x61"
    b"\x72\x01\x00\x18\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x5a\x29\x56\x01\x00\x18\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f"
    b"\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x43\x29\x56\x01\x00\x18\x28\x4a"
    b"\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x42"
    b"\x29\x56\x01\x00\x18\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53"
    b"\x74\x72\x69\x6e\x67\x3b\x53\x29\x56\x01\x00\x18\x28\x4a\x4a\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x49\x29\x56\x01\x00\x18\x28"
    b"\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b"
    b"\x4a\x29\x56\x01\x00\x18\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f"
    b"\x53\x74\x72\x69\x6e\x67\x3b\x46\x29\x56\x01\x00\x18\x28\x4a\x4a\x4c\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x44\x29\x56\x01\x00\x29"
    b"\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67"
    b"\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29"
    b"\x56\x01\x00\x29\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65"
    b"\x63\x74\x3b\x29\x56\x01\x00\x19\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x5a\x29\x56\x01\x00\x19\x28\x4a\x4a\x4c"
    b"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x43\x29"
    b"\x56\x01\x00\x19\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x5b\x42\x29\x56\x01\x00\x19\x28\x4a\x4a\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x53\x29\x56\x01\x00\x19"
    b"\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67"
    b"\x3b\x5b\x49\x29\x56\x01\x00\x19\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x4a\x29\x56\x01\x00\x19\x28\x4a\x4a\x4c"
    b"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x46\x29"
    b"\x56\x01\x00\x19\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x5b\x44\x29\x56\x01\x00\x06\x69\x6e\x63\x72\x65\x66\x01\x00"
    b"\x06\x64\x65\x63\x72\x65\x66\x0c\x00\x27\x00\x8a\x0c\x00\x2b\x00\x2c\x01\x00\x1b"
    b"\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x50\x79\x45\x78"
    b"\x63\x65\x70\x74\x69\x6f\x6e\x01\x00\x10\x6a\x65\x70\x2f\x4a\x65\x70\x45\x78\x63"
    b"\x65\x70\x74\x69\x6f\x6e\x0c\x00\x8b\x00\x8c\x0c\x00\x27\x00\x3c\x0c\x00\x8d\x00"
    b"\x8e\x0c\x00\x2f\x00\x2c\x0c\x00\x34\x00\x35\x0c\x00\x34\x00\x36\x0c\x00\x39\x00"
    b"\x3a\x0c\x00\x3b\x00\x3c\x0c\x00\x8f\x00\x90\x07\x00\x91\x0c\x00\x92\x00\x93\x0c"
    b"\x00\x94\x00\x93\x0c\x00\x4f\x00\x50\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x53\x74\x72\x69\x6e\x67\x0c\x00\x27\x00\x95\x0c\x00\x4f\x00\x58\x0c\x00"
    b"\x4f\x00\x52\x0c\x00\x4f\x00\x53\x0c\x00\x4f\x00\x54\x0c\x00\x4f\x00\x55\x0c\x00"
    b"\x4f\x00\x56\x0c\x00\x4f\x00\x57\x0c\x00\x4f\x00\x59\x0c\x00\x4f\x00\x5a\x0c\x00"
    b"\x4f\x00\x5c\x0c\x00\x4f\x00\x5d\x0c\x00\x4f\x00\x5e\x0c\x00\x4f\x00\x5f\x0c\x00"
    b"\x4f\x00\x60\x0c\x00\x4f\x00\x61\x0c\x00\x62\x00\x2c\x0c\x00\x63\x00\x2c\x01\x00"
    b"\x13\x6a\x65\x70\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x50\x79\x4f\x62\x6a\x65\x63\x74"
    b"\x01\x00\x18\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x50"
    b"\x79\x4f\x62\x6a\x65\x63\x74\x01\x00\x27\x28\x4c\x6f\x72\x67\x2f\x70\x79\x74\x68"
    b"\x6f\x6e\x2f\x75\x74\x69\x6c\x2f\x50\x79\x74\x68\x6f\x6e\x49\x6e\x74\x65\x72\x70"
    b"\x72\x65\x74\x65\x72\x3b\x4a\x29\x56\x01\x00\x0a\x67\x65\x74\x4d\x65\x73\x73\x61"
    b"\x67\x65\x01\x00\x14\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x01\x00\x09\x69\x6e\x69\x74\x43\x61\x75\x73\x65\x01\x00\x2c"
    b"\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x54\x68\x72\x6f\x77\x61\x62\x6c"
    b"\x65\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x54\x68\x72\x6f\x77\x61"
    b"\x62\x6c\x65\x3b\x01\x00\x06\x69\x6e\x74\x65\x72\x70\x01\x00\x23\x4c\x6f\x72\x67"
    b"\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x75\x74\x69\x6c\x2f\x50\x79\x74\x68\x6f\x6e\x49"
    b"\x6e\x74\x65\x72\x70\x72\x65\x74\x65\x72\x3b\x01\x00\x21\x6f\x72\x67\x2f\x70\x79"
    b"\x74\x68\x6f\x6e\x2f\x75\x74\x69\x6c\x2f\x50\x79\x74\x68\x6f\x6e\x49\x6e\x74\x65"
    b"\x72\x70\x72\x65\x74\x65\x72\x01\x00\x06\x74\x73\x74\x61\x74\x65\x01\x00\x01\x4a"
    b"\x01\x00\x05\x70\x79\x6f\x62\x6a\x01\x00\x05\x28\x5b\x43\x29\x56\x00\x21\x00\x25"
    b"\x00\x26\x00\x00\x00\x00\x00\x2e\x00\x01\x00\x27\x00\x28\x00\x02\x00\x29\x00\x00"
    b"\x00\x14\x00\x04\x00\x06\x00\x00\x00\x08\x2a\x19\x05\x21\xb7\x00\x01\xb1\x00\x00"
    b"\x00\x00\x00\x2a\x00\x00\x00\x06\x00\x02\x00\x04\x00\x03\x00\x01\x00\x2b\x00\x2c"
    b"\x00\x02\x00\x29\x00\x00\x00\x3d\x00\x03\x00\x02\x00\x00\x00\x1c\x2a\xb7\x00\x02"
    b"\xa7\x00\x17\x4c\xbb\x00\x04\x59\x2b\xb6\x00\x05\xb7\x00\x06\x2b\xb6\x00\x07\xc0"
    b"\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x04\x00\x07\x00\x03\x00\x01\x00\x2d\x00\x00"
    b"\x00\x07\x00\x02\x47\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00"
    b"\x04\x00\x2f\x00\x2c\x00\x02\x00\x29\x00\x00\x00\x3d\x00\x03\x00\x02\x00\x00\x00"
    b"\x1c\x2a\xb7\x00\x08\xa7\x00\x17\x4c\xbb\x00\x04\x59\x2b\xb6\x00\x05\xb7\x00\x06"
    b"\x2b\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x04\x00\x07\x00\x03\x00"
    b"\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x47\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04"
    b"\x00\x01\x00\x04\x00\x01\x00\x30\x00\x2c\x00\x04\x00\x29\x00\x00\x00\x11\x00\x01"
    b"\x00\x01\x00\x00\x00\x05\x2a\xb6\x00\x09\xb1\x00\x00\x00\x00\x00\x2a\x00\x00\x00"
    b"\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00"
    b"\x33\x00\x00\x00\x01\x00\x34\x00\x35\x00\x02\x00\x29\x00\x00\x00\x3a\x00\x03\x00"
    b"\x03\x00\x00\x00\x1a\x2a\x2b\xb7\x00\x0a\xb0\x4d\xbb\x00\x04\x59\x2c\xb6\x00\x05"
    b"\xb7\x00\x06\x2c\xb6\x00\x07\xc0\x00\x04\xbf\x00\x01\x00\x00\x00\x05\x00\x06\x00"
    b"\x03\x00\x01\x00\x2d\x00\x00\x00\x06\x00\x01\x46\x07\x00\x2e\x00\x2a\x00\x00\x00"
    b"\x04\x00\x01\x00\x04\x00\x01\x00\x34\x00\x36\x00\x03\x00\x29\x00\x00\x00\x3b\x00"
    b"\x03\x00\x04\x00\x00\x00\x1b\x2a\x2b\x2c\xb7\x00\x0b\xb0\x4e\xbb\x00\x04\x59\x2d"
    b"\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04\xbf\x00\x01\x00\x00\x00\x06"
    b"\x00\x07\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x06\x00\x01\x47\x07\x00\x2e\x00\x2a"
    b"\x00\x00\x00\x04\x00\x01\x00\x04\x00\x37\x00\x00\x00\x02\x00\x38\x00\x01\x00\x39"
    b"\x00\x3a\x00\x02\x00\x29\x00\x00\x00\x3f\x00\x03\x00\x04\x00\x00\x00\x1e\x2a\x2b"
    b"\x2c\xb7\x00\x0c\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d"
    b"\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x06\x00\x09\x00\x03\x00\x01"
    b"\x00\x2d\x00\x00\x00\x07\x00\x02\x49\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00"
    b"\x01\x00\x04\x00\x01\x00\x3b\x00\x3c\x00\x02\x00\x29\x00\x00\x00\x3e\x00\x03\x00"
    b"\x03\x00\x00\x00\x1d\x2a\x2b\xb7\x00\x0d\xa7\x00\x17\x4d\xbb\x00\x04\x59\x2c\xb6"
    b"\x00\x05\xb7\x00\x06\x2c\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x05"
    b"\x00\x08\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x48\x07\x00\x2e\x13\x00"
    b"\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x01\x00\x3d\x00\x3e\x00\x04\x00\x29\x00"
    b"\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e"
    b"\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x1c\xb7\x00\x11\xa7\x00\x17\x4e\xbb\x00\x04\x59"
    b"\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00"
    b"\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e"
    b"\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00"
    b"\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x3f\x00\x04\x00\x29\x00"
    b"\x00\x00\x5b\x00\x0c\x00\x04\x00\x00\x00\x3a\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e"
    b"\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\xbb\x00\x12\x59\x04\xbc\x05\x59\x03\x1c\x55\xb7"
    b"\x00\x13\xb7\x00\x14\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06"
    b"\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x22\x00\x25\x00\x03\x00"
    b"\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x65\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04"
    b"\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33"
    b"\x00\x00\x00\x01\x00\x3d\x00\x40\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04"
    b"\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10"
    b"\x2b\x1c\xb7\x00\x15\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06"
    b"\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00"
    b"\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04"
    b"\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33"
    b"\x00\x00\x00\x01\x00\x3d\x00\x41\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04"
    b"\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10"
    b"\x2b\x1c\xb7\x00\x16\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06"
    b"\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00"
    b"\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04"
    b"\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33"
    b"\x00\x00\x00\x01\x00\x3d\x00\x42\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04"
    b"\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10"
    b"\x2b\x1c\xb7\x00\x17\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06"
    b"\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00"
    b"\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04"
    b"\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33"
    b"\x00\x00\x00\x01\x00\x3d\x00\x43\x00\x04\x00\x29\x00\x00\x00\x51\x00\x08\x00\x05"
    b"\x00\x00\x00\x30\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10"
    b"\x2b\x20\xb7\x00\x18\xa7\x00\x1a\x3a\x04\xbb\x00\x04\x59\x19\x04\xb6\x00\x05\xb7"
    b"\x00\x06\x19\x04\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18"
    b"\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x16\x00\x2a\x00"
    b"\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00"
    b"\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x44\x00\x04\x00\x29\x00\x00\x00\x4e\x00"
    b"\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a"
    b"\xb4\x00\x10\x2b\x24\xb7\x00\x19\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05"
    b"\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18"
    b"\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00"
    b"\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00"
    b"\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x45\x00\x04\x00\x29\x00\x00\x00\x51\x00"
    b"\x08\x00\x05\x00\x00\x00\x30\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a"
    b"\xb4\x00\x10\x2b\x28\xb7\x00\x1a\xa7\x00\x1a\x3a\x04\xbb\x00\x04\x59\x19\x04\xb6"
    b"\x00\x05\xb7\x00\x06\x19\x04\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00"
    b"\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x16"
    b"\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00"
    b"\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x46\x00\x04\x00\x29\x00\x00"
    b"\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4"
    b"\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x14\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d"
    b"\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00"
    b"\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13"
    b"\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00"
    b"\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x3a\x00\x04\x00\x29\x00\x00"
    b"\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4"
    b"\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x1b\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d"
    b"\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00"
    b"\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13"
    b"\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00"
    b"\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x47\x00\x04\x00\x29\x00\x00"
    b"\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4"
    b"\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x1c\xa7\x00\x17\x4e\xbb\x00\x04\x59\x2d"
    b"\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00"
    b"\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x58\x07\x00\x2e\x13"
    b"\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00\x00\x00\x00\x00\x32\x00\x00"
    b"\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00\x48\x00\x04\x00\x29\x00\x00"
    b"\x00\x55\x00\x09\x00\x04\x00\x00\x00\x34\x2a\xb7\x00\x08\x2a\x2a\xb4\x00\x0e\xb4"
    b"\x00\x0f\x2a\xb4\x00\x10\x2b\xbb\x00\x12\x59\x2c\xb7\x00\x13\xb7\x00\x14\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x1c\x00\x1f\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x5f\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00"
    b"\x49\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00"
    b"\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x1d\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00"
    b"\x4a\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00"
    b"\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x1e\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00"
    b"\x4b\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00"
    b"\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x1f\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00"
    b"\x4c\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00"
    b"\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x20\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00"
    b"\x4d\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00"
    b"\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x21\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x00\x01\x00\x3d\x00"
    b"\x4e\x00\x04\x00\x29\x00\x00\x00\x4e\x00\x07\x00\x04\x00\x00\x00\x2d\x2a\xb7\x00"
    b"\x08\x2a\x2a\xb4\x00\x0e\xb4\x00\x0f\x2a\xb4\x00\x10\x2b\x2c\xb7\x00\x22\xa7\x00"
    b"\x17\x4e\xbb\x00\x04\x59\x2d\xb6\x00\x05\xb7\x00\x06\x2d\xb6\x00\x07\xc0\x00\x04"
    b"\xbf\xb1\x00\x01\x00\x00\x00\x15\x00\x18\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07"
    b"\x00\x02\x58\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x31\x00"
    b"\x00\x00\x00\x00\x32\x00\x00\x00\x06\x00\x01\x00\x33\x00\x00\x01\x02\x00\x4f\x00"
    b"\x50\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x51\x00"
    b"\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x52\x00\x01\x00"
    b"\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x53\x00\x01\x00\x2a\x00"
    b"\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x54\x00\x01\x00\x2a\x00\x00\x00"
    b"\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x55\x00\x01\x00\x2a\x00\x00\x00\x04\x00"
    b"\x01\x00\x03\x01\x02\x00\x4f\x00\x56\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00"
    b"\x03\x01\x02\x00\x4f\x00\x57\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01"
    b"\x02\x00\x4f\x00\x58\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00"
    b"\x4f\x00\x59\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00"
    b"\x5a\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x5b\x00"
    b"\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x5c\x00\x01\x00"
    b"\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x5d\x00\x01\x00\x2a\x00"
    b"\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x5e\x00\x01\x00\x2a\x00\x00\x00"
    b"\x04\x00\x01\x00\x03\x01\x02\x00\x4f\x00\x5f\x00\x01\x00\x2a\x00\x00\x00\x04\x00"
    b"\x01\x00\x03\x01\x02\x00\x4f\x00\x60\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00"
    b"\x03\x01\x02\x00\x4f\x00\x61\x00\x01\x00\x2a\x00\x00\x00\x04\x00\x01\x00\x03\x00"
    b"\x01\x00\x62\x00\x2c\x00\x02\x00\x29\x00\x00\x00\x3d\x00\x03\x00\x02\x00\x00\x00"
    b"\x1c\x2a\xb7\x00\x23\xa7\x00\x17\x4c\xbb\x00\x04\x59\x2b\xb6\x00\x05\xb7\x00\x06"
    b"\x2b\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x04\x00\x07\x00\x03\x00"
    b"\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x47\x07\x00\x2e\x13\x00\x2a\x00\x00\x00\x04"
    b"\x00\x01\x00\x04\x00\x01\x00\x63\x00\x2c\x00\x02\x00\x29\x00\x00\x00\x3d\x00\x03"
    b"\x00\x02\x00\x00\x00\x1c\x2a\xb7\x00\x24\xa7\x00\x17\x4c\xbb\x00\x04\x59\x2b\xb6"
    b"\x00\x05\xb7\x00\x06\x2b\xb6\x00\x07\xc0\x00\x04\xbf\xb1\x00\x01\x00\x00\x00\x04"
    b"\x00\x07\x00\x03\x00\x01\x00\x2d\x00\x00\x00\x07\x00\x02\x47\x07\x00\x2e\x13\x00"
    b"\x2a\x00\x00\x00\x04\x00\x01\x00\x04\x00\x00"
)
