# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .image_template_customizer_py3 import ImageTemplateCustomizer


class ImageTemplateRestartCustomizer(ImageTemplateCustomizer):
    """Reboots a VM and waits for it to come back online (Windows). Corresponds to
    Packer windows-restart provisioner.

    All required parameters must be populated in order to send to Azure.

    :param name: Friendly Name to provide context on what this customization
     step does
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param restart_command: Command to execute the restart [Default: 'shutdown
     /r /f /t 0 /c "packer restart"']
    :type restart_command: str
    :param restart_check_command: Command to check if restart succeeded
     [Default: '']
    :type restart_check_command: str
    :param restart_timeout: Restart timeout specified as a string of magnitude
     and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
    :type restart_timeout: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'restart_command': {'key': 'restartCommand', 'type': 'str'},
        'restart_check_command': {'key': 'restartCheckCommand', 'type': 'str'},
        'restart_timeout': {'key': 'restartTimeout', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, restart_command: str=None, restart_check_command: str=None, restart_timeout: str=None, **kwargs) -> None:
        super(ImageTemplateRestartCustomizer, self).__init__(name=name, **kwargs)
        self.restart_command = restart_command
        self.restart_check_command = restart_check_command
        self.restart_timeout = restart_timeout
        self.type = 'WindowsRestart'
