# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import MixinABC, _format_url_section

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_projects_request(*, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects"

    # Construct parameters
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_export_project_request(
    project_name: str,
    *,
    string_index_type: str,
    exported_project_format: Optional[str] = None,
    asset_kind: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/:export"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if exported_project_format is not None:
        _params["format"] = _SERIALIZER.query("exported_project_format", exported_project_format, "str")
    _params["stringIndexType"] = _SERIALIZER.query("string_index_type", string_index_type, "str")
    if asset_kind is not None:
        _params["assetKind"] = _SERIALIZER.query("asset_kind", asset_kind, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_import_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    exported_project_format = kwargs.pop("exported_project_format", _params.pop("format", None))  # type: Optional[str]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/:import"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if exported_project_format is not None:
        _params["format"] = _SERIALIZER.query("exported_project_format", exported_project_format, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_train_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/:train"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_deployments_request(
    project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_swap_deployments_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments/:swap"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_deployment_request(project_name: str, deployment_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments/{deploymentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "deploymentName": _SERIALIZER.url("deployment_name", deployment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_deploy_project_request(project_name: str, deployment_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments/{deploymentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "deploymentName": _SERIALIZER.url("deployment_name", deployment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_deployment_request(project_name: str, deployment_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments/{deploymentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "deploymentName": _SERIALIZER.url("deployment_name", deployment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_deployment_job_status_request(
    project_name: str, deployment_name: str, job_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments/{deploymentName}/jobs/{jobId}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "deploymentName": _SERIALIZER.url("deployment_name", deployment_name, "str"),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_swap_deployments_job_status_request(project_name: str, job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/deployments/swap/jobs/{jobId}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_export_project_job_status_request(project_name: str, job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/export/jobs/{jobId}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_import_project_job_status_request(project_name: str, job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/import/jobs/{jobId}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_trained_models_request(
    project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/models"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_trained_model_request(project_name: str, trained_model_label: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/models/{trainedModelLabel}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "trainedModelLabel": _SERIALIZER.url("trained_model_label", trained_model_label, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_trained_model_request(project_name: str, trained_model_label: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/models/{trainedModelLabel}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "trainedModelLabel": _SERIALIZER.url("trained_model_label", trained_model_label, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_model_evaluation_results_request(
    project_name: str,
    trained_model_label: str,
    *,
    string_index_type: str,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/models/{trainedModelLabel}/evaluation/result"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "trainedModelLabel": _SERIALIZER.url("trained_model_label", trained_model_label, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["stringIndexType"] = _SERIALIZER.query("string_index_type", string_index_type, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_model_evaluation_summary_request(
    project_name: str, trained_model_label: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = (
        "/authoring/analyze-conversations/projects/{projectName}/models/{trainedModelLabel}/evaluation/summary-result"
    )
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "trainedModelLabel": _SERIALIZER.url("trained_model_label", trained_model_label, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_training_jobs_request(
    project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/train/jobs"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_training_job_status_request(project_name: str, job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/train/jobs/{jobId}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_cancel_training_job_request(project_name: str, job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/{projectName}/train/jobs/{jobId}/:cancel"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, "str", max_length=100),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_project_deletion_job_status_request(job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/global/deletion-jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_supported_languages_request(
    *, project_kind: str, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/global/languages"

    # Construct parameters
    _params["projectKind"] = _SERIALIZER.query("project_kind", project_kind, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_supported_prebuilt_entities_request(
    *,
    language: Optional[str] = None,
    multilingual: Optional[bool] = None,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/global/prebuilt-entities"

    # Construct parameters
    if language is not None:
        _params["language"] = _SERIALIZER.query("language", language, "str")
    if multilingual is not None:
        _params["multilingual"] = _SERIALIZER.query("multilingual", multilingual, "bool")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_training_config_versions_request(
    *, project_kind: str, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-05-15-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/authoring/analyze-conversations/projects/global/training-config-versions"

    # Construct parameters
    _params["projectKind"] = _SERIALIZER.query("project_kind", project_kind, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class ConversationAuthoringClientOperationsMixin(MixinABC):  # pylint: disable=too-many-public-methods
    @distributed_trace
    def list_projects(self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any) -> Iterable[JSON]:
        """Lists the existing projects.

        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "description": "str",  # Optional. The project description.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation" and "Orchestration".
                    "projectName": "str",  # The new project name. Required.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". Required.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_projects_request(
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @overload
    def create_project(
        self, project_name: str, project: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates a new project or updates an existing one.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project parameters. Required.
        :type project: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                project = {
                    "description": "str",  # Optional. The project description.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation" and "Orchestration".
                    "projectName": "str",  # The new project name. Required.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". Required.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "description": "str",  # Optional. The project description.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation" and "Orchestration".
                    "projectName": "str",  # The new project name. Required.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". Required.
                    }
                }
        """

    @overload
    def create_project(
        self, project_name: str, project: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates a new project or updates an existing one.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project parameters. Required.
        :type project: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "description": "str",  # Optional. The project description.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation" and "Orchestration".
                    "projectName": "str",  # The new project name. Required.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". Required.
                    }
                }
        """

    @distributed_trace
    def create_project(self, project_name: str, project: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates a new project or updates an existing one.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project parameters. Is either a model type or a IO type. Required.
        :type project: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "description": "str",  # Optional. The project description.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation" and "Orchestration".
                    "projectName": "str",  # The new project name. Required.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". Required.
                    }
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(project, (IO, bytes)):
            _content = project
        else:
            _json = project

        request = build_create_project_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def get_project(self, project_name: str, **kwargs: Any) -> JSON:
        """Gets the details of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "description": "str",  # Optional. The project description.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation" and "Orchestration".
                    "projectName": "str",  # The new project name. Required.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". Required.
                    }
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    def _delete_project_initial(self, project_name: str, **kwargs: Any) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_delete_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_delete_project(self, project_name: str, **kwargs: Any) -> LROPoller[JSON]:
        """Deletes a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_project_initial(  # type: ignore
                project_name=project_name, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _export_project_initial(
        self,
        project_name: str,
        *,
        string_index_type: str,
        exported_project_format: Optional[str] = None,
        asset_kind: Optional[str] = None,
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_export_project_request(
            project_name=project_name,
            string_index_type=string_index_type,
            exported_project_format=exported_project_format,
            asset_kind=asset_kind,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_export_project(
        self,
        project_name: str,
        *,
        string_index_type: str,
        exported_project_format: Optional[str] = None,
        asset_kind: Optional[str] = None,
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Triggers a job to export a project's data.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword string_index_type: Specifies the method used to interpret string offsets. For
         additional information see https://aka.ms/text-analytics-offsets. "Utf16CodeUnit" Required.
        :paramtype string_index_type: str
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword asset_kind: Kind of asset to export. Default value is None.
        :paramtype asset_kind: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "resultUrl": "str",  # Optional. The URL to use in order to download the
                      exported project.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._export_project_initial(  # type: ignore
                project_name=project_name,
                string_index_type=string_index_type,
                exported_project_format=exported_project_format,
                asset_kind=asset_kind,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _import_project_initial(
        self,
        project_name: str,
        project: Union[JSON, IO],
        *,
        exported_project_format: Optional[str] = None,
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(project, (IO, bytes)):
            _content = project
        else:
            _json = project

        request = build_import_project_request(
            project_name=project_name,
            exported_project_format=exported_project_format,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    def begin_import_project(
        self,
        project_name: str,
        project: JSON,
        *,
        exported_project_format: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Triggers a job to import a project. If a project with the same name already exists, the data of
        that project is replaced.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project data to import. Required.
        :type project: JSON
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                project = {
                    "assets": exported_project_assets,
                    "metadata": {
                        "description": "str",  # Optional. The project description.
                        "language": "str",  # The project language. This is BCP-47
                          representation of a language. For example, use "en" for English, "en-gb" for
                          English (UK), "es" for Spanish etc. Required.
                        "multilingual": bool,  # Optional. Whether the project would be used
                          for multiple languages or not.
                        "projectKind": "str",  # Represents the project kind. Required. Known
                          values are: "Conversation" and "Orchestration".
                        "projectName": "str",  # The new project name. Required.
                        "settings": {
                            "confidenceThreshold": 0.0  # The threshold of the intent
                              with the highest confidence, at which the prediction will automatically
                              be changed to "None". Required.
                        }
                    },
                    "projectFileVersion": "str",  # The version of the exported file. Required.
                    "stringIndexType": "str"  # Specifies the method used to interpret string
                      offsets. For additional information see https://aka.ms/text-analytics-offsets.
                      Required. "Utf16CodeUnit"
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    def begin_import_project(
        self,
        project_name: str,
        project: IO,
        *,
        exported_project_format: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Triggers a job to import a project. If a project with the same name already exists, the data of
        that project is replaced.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project data to import. Required.
        :type project: IO
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def begin_import_project(
        self,
        project_name: str,
        project: Union[JSON, IO],
        *,
        exported_project_format: Optional[str] = None,
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Triggers a job to import a project. If a project with the same name already exists, the data of
        that project is replaced.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project data to import. Is either a model type or a IO type. Required.
        :type project: JSON or IO
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._import_project_initial(  # type: ignore
                project_name=project_name,
                project=project,
                exported_project_format=exported_project_format,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _train_initial(self, project_name: str, configuration: Union[JSON, IO], **kwargs: Any) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(configuration, (IO, bytes)):
            _content = configuration
        else:
            _json = configuration

        request = build_train_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    def begin_train(
        self, project_name: str, configuration: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Triggers a training job for a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param configuration: The training input parameters. Required.
        :type configuration: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                configuration = {
                    "evaluationOptions": {
                        "kind": "str",  # Optional. Represents the evaluation kind. By
                          default, the evaluation kind is set to percentage. Known values are:
                          "percentage" and "manual".
                        "testingSplitPercentage": 0,  # Optional. Represents the testing
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                        "trainingSplitPercentage": 0  # Optional. Represents the training
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                    },
                    "modelLabel": "str",  # Represents the output model label. Required.
                    "trainingConfigVersion": "str",  # Optional. Represents training config
                      version. By default, "latest" value is used which uses the latest released
                      training config version.
                    "trainingMode": "str"  # Represents the mode of the training operation.
                      Required. Known values are: "advanced" and "standard".
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        },
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingMode": "str",  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                        "trainingStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        }
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    def begin_train(
        self, project_name: str, configuration: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Triggers a training job for a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param configuration: The training input parameters. Required.
        :type configuration: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        },
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingMode": "str",  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                        "trainingStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        }
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def begin_train(self, project_name: str, configuration: Union[JSON, IO], **kwargs: Any) -> LROPoller[JSON]:
        """Triggers a training job for a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param configuration: The training input parameters. Is either a model type or a IO type.
         Required.
        :type configuration: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        },
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingMode": "str",  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                        "trainingStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        }
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._train_initial(  # type: ignore
                project_name=project_name,
                configuration=configuration,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def list_deployments(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the deployments belonging to a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str"  # Represents model training config
                      version. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_deployments_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    def _swap_deployments_initial(
        self, project_name: str, deployments: Union[JSON, IO], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployments, (IO, bytes)):
            _content = deployments
        else:
            _json = deployments

        request = build_swap_deployments_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    def begin_swap_deployments(
        self, project_name: str, deployments: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Swaps two existing deployments with each other.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployments: The job object to swap two deployments. Required.
        :type deployments: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                deployments = {
                    "firstDeploymentName": "str",  # Represents the first deployment name.
                      Required.
                    "secondDeploymentName": "str"  # Represents the second deployment name.
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    def begin_swap_deployments(
        self, project_name: str, deployments: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Swaps two existing deployments with each other.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployments: The job object to swap two deployments. Required.
        :type deployments: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def begin_swap_deployments(self, project_name: str, deployments: Union[JSON, IO], **kwargs: Any) -> LROPoller[JSON]:
        """Swaps two existing deployments with each other.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployments: The job object to swap two deployments. Is either a model type or a IO
         type. Required.
        :type deployments: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._swap_deployments_initial(  # type: ignore
                project_name=project_name,
                deployments=deployments,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def get_deployment(self, project_name: str, deployment_name: str, **kwargs: Any) -> JSON:
        """Gets the details of a deployment.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str"  # Represents model training config
                      version. Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_deployment_request(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    def _deploy_project_initial(
        self, project_name: str, deployment_name: str, deployment: Union[JSON, IO], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment, (IO, bytes)):
            _content = deployment
        else:
            _json = deployment

        request = build_deploy_project_request(
            project_name=project_name,
            deployment_name=deployment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    def begin_deploy_project(
        self,
        project_name: str,
        deployment_name: str,
        deployment: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates a new deployment or replaces an existing one.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param deployment: The new deployment info. Required.
        :type deployment: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                deployment = {
                    "trainedModelLabel": "str"  # Represents the trained model label. Required.
                }

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str"  # Represents model training config
                      version. Required.
                }
        """

    @overload
    def begin_deploy_project(
        self,
        project_name: str,
        deployment_name: str,
        deployment: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates a new deployment or replaces an existing one.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param deployment: The new deployment info. Required.
        :type deployment: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str"  # Represents model training config
                      version. Required.
                }
        """

    @distributed_trace
    def begin_deploy_project(
        self, project_name: str, deployment_name: str, deployment: Union[JSON, IO], **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates a new deployment or replaces an existing one.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param deployment: The new deployment info. Is either a model type or a IO type. Required.
        :type deployment: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str"  # Represents model training config
                      version. Required.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._deploy_project_initial(  # type: ignore
                project_name=project_name,
                deployment_name=deployment_name,
                deployment=deployment,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _delete_deployment_initial(self, project_name: str, deployment_name: str, **kwargs: Any) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_delete_deployment_request(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_delete_deployment(self, project_name: str, deployment_name: str, **kwargs: Any) -> LROPoller[JSON]:
        """Deletes a project deployment.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_deployment_initial(  # type: ignore
                project_name=project_name,
                deployment_name=deployment_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def get_deployment_job_status(self, project_name: str, deployment_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an existing deployment job.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_deployment_job_status_request(
            project_name=project_name,
            deployment_name=deployment_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def get_swap_deployments_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an existing swap deployment job.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_swap_deployments_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def get_export_project_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an export job. Once job completes, returns the project metadata, and assets.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "resultUrl": "str",  # Optional. The URL to use in order to download the
                      exported project.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_export_project_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def get_import_project_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status for an import.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_import_project_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_trained_models(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the trained models belonging to a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "label": "str",  # The trained model label. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # The last trained date time
                      of the model. Required.
                    "lastTrainingDurationInSeconds": 0,  # The duration of the model's last
                      training request in seconds. Required.
                    "modelExpirationDate": "2020-02-20",  # The model expiration date. Required.
                    "modelId": "str",  # The model ID. Required.
                    "modelTrainingConfigVersion": "str"  # The model training config version.
                      Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_trained_models_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_trained_model(self, project_name: str, trained_model_label: str, **kwargs: Any) -> JSON:
        """Gets the details of a trained model.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "label": "str",  # The trained model label. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # The last trained date time
                      of the model. Required.
                    "lastTrainingDurationInSeconds": 0,  # The duration of the model's last
                      training request in seconds. Required.
                    "modelExpirationDate": "2020-02-20",  # The model expiration date. Required.
                    "modelId": "str",  # The model ID. Required.
                    "modelTrainingConfigVersion": "str"  # The model training config version.
                      Required.
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_trained_model_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def delete_trained_model(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, trained_model_label: str, **kwargs: Any
    ) -> None:
        """Deletes an existing trained model.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_trained_model_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_model_evaluation_results(
        self,
        project_name: str,
        trained_model_label: str,
        *,
        string_index_type: str,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        """Gets the detailed results of the evaluation for a trained model. This includes the raw
        inference results for the data included in the evaluation process.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :keyword string_index_type: Specifies the method used to interpret string offsets. For
         additional information see https://aka.ms/text-analytics-offsets. "Utf16CodeUnit" Required.
        :paramtype string_index_type: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entitiesResult": {
                        "expectedEntities": [
                            {
                                "category": "str",  # Represents the entity category.
                                  Required.
                                "length": 0,  # Represents the entity length.
                                  Required.
                                "offset": 0  # Represents the entity offset index
                                  relative to the original text. Required.
                            }
                        ],
                        "predictedEntities": [
                            {
                                "category": "str",  # Represents the entity category.
                                  Required.
                                "length": 0,  # Represents the entity length.
                                  Required.
                                "offset": 0  # Represents the entity offset index
                                  relative to the original text. Required.
                            }
                        ]
                    },
                    "intentsResult": {
                        "expectedIntent": "str",  # Represents the utterance's expected
                          intent. Required.
                        "predictedIntent": "str"  # Represents the utterance's predicted
                          intent. Required.
                    },
                    "language": "str",  # Represents the utterance language. This is BCP-47
                      representation of a language. For example, use "en" for English, "en-gb" for
                      English (UK), "es" for Spanish etc. Required.
                    "text": "str"  # Represents the utterance text. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_model_evaluation_results_request(
                    project_name=project_name,
                    trained_model_label=trained_model_label,
                    string_index_type=string_index_type,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_model_evaluation_summary(self, project_name: str, trained_model_label: str, **kwargs: Any) -> JSON:
        """Gets the evaluation summary of a trained model. The summary includes high level performance
        measurements of the model e.g., F1, Precision, Recall, etc.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entitiesEvaluation": {
                        "confusionMatrix": {
                            "str": {
                                "str": {
                                    "normalizedValue": 0.0,  # Represents
                                      normalized value in percentages. Required.
                                    "rawValue": 0.0  # Represents raw value.
                                      Required.
                                }
                            }
                        },
                        "entities": {
                            "str": {
                                "f1": 0.0,  # Represents the model precision.
                                  Required.
                                "falseNegativeCount": 0,  # Represents the count of
                                  false negative. Required.
                                "falsePositiveCount": 0,  # Represents the count of
                                  false positive. Required.
                                "precision": 0.0,  # Represents the model recall.
                                  Required.
                                "recall": 0.0,  # Represents the model F1 score.
                                  Required.
                                "trueNegativeCount": 0,  # Represents the count of
                                  true negative. Required.
                                "truePositiveCount": 0  # Represents the count of
                                  true positive. Required.
                            }
                        },
                        "macroF1": 0.0,  # Represents the macro F1. Required.
                        "macroPrecision": 0.0,  # Represents the macro precision. Required.
                        "macroRecall": 0.0,  # Represents the macro recall. Required.
                        "microF1": 0.0,  # Represents the micro F1. Required.
                        "microPrecision": 0.0,  # Represents the micro precision. Required.
                        "microRecall": 0.0  # Represents the micro recall. Required.
                    },
                    "evaluationOptions": {
                        "kind": "str",  # Optional. Represents the evaluation kind. By
                          default, the evaluation kind is set to percentage. Known values are:
                          "percentage" and "manual".
                        "testingSplitPercentage": 0,  # Optional. Represents the testing
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                        "trainingSplitPercentage": 0  # Optional. Represents the training
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                    },
                    "intentsEvaluation": {
                        "confusionMatrix": {
                            "str": {
                                "str": {
                                    "normalizedValue": 0.0,  # Represents
                                      normalized value in percentages. Required.
                                    "rawValue": 0.0  # Represents raw value.
                                      Required.
                                }
                            }
                        },
                        "intents": {
                            "str": {
                                "f1": 0.0,  # Represents the model precision.
                                  Required.
                                "falseNegativeCount": 0,  # Represents the count of
                                  false negative. Required.
                                "falsePositiveCount": 0,  # Represents the count of
                                  false positive. Required.
                                "precision": 0.0,  # Represents the model recall.
                                  Required.
                                "recall": 0.0,  # Represents the model F1 score.
                                  Required.
                                "trueNegativeCount": 0,  # Represents the count of
                                  true negative. Required.
                                "truePositiveCount": 0  # Represents the count of
                                  true positive. Required.
                            }
                        },
                        "macroF1": 0.0,  # Represents the macro F1. Required.
                        "macroPrecision": 0.0,  # Represents the macro precision. Required.
                        "macroRecall": 0.0,  # Represents the macro recall. Required.
                        "microF1": 0.0,  # Represents the micro F1. Required.
                        "microPrecision": 0.0,  # Represents the micro precision. Required.
                        "microRecall": 0.0  # Represents the micro recall. Required.
                    }
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_model_evaluation_summary_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_training_jobs(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the non-expired training jobs created for a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        },
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingMode": "str",  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                        "trainingStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        }
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_training_jobs_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_training_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status for a training job.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        },
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingMode": "str",  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                        "trainingStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        }
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_training_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    def _cancel_training_job_initial(self, project_name: str, job_id: str, **kwargs: Any) -> Optional[JSON]:
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_cancel_training_job_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_cancel_training_job(self, project_name: str, job_id: str, **kwargs: Any) -> LROPoller[JSON]:
        """Triggers a cancellation for a running training job.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        },
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingMode": "str",  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                        "trainingStatus": {
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "startDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the start date time.
                            "status": "str"  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                        }
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._cancel_training_job_initial(  # type: ignore
                project_name=project_name,
                job_id=job_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def get_project_deletion_job_status(self, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status for a project deletion job.

        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Error message. Required.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_get_project_deletion_job_status_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_supported_languages(
        self, *, project_kind: str, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the supported languages for the given project type.

        :keyword project_kind: The project kind. Known values are: "Conversation" and "Orchestration".
         Required.
        :paramtype project_kind: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "languageCode": "str",  # The language code. This is BCP-47 representation of
                      a language. For example, "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "languageName": "str"  # The language name. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_supported_languages_request(
                    project_kind=project_kind,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_supported_prebuilt_entities(
        self,
        *,
        language: Optional[str] = None,
        multilingual: Optional[bool] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the supported prebuilt entities that can be used while creating composed entities.

        :keyword language: The language to get supported prebuilt entities for. Required if
         multilingual is false. This is BCP-47 representation of a language. For example, use "en" for
         English, "en-gb" for English (UK), "es" for Spanish etc. Default value is None.
        :paramtype language: str
        :keyword multilingual: Whether to get the support prebuilt entities for multilingual or
         monolingual projects. If true, the language parameter is ignored. Default value is None.
        :paramtype multilingual: bool
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "category": "str",  # The prebuilt entity category. Required.
                    "description": "str",  # The description. Required.
                    "examples": "str"  # English examples for the entity. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_supported_prebuilt_entities_request(
                    language=language,
                    multilingual=multilingual,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_training_config_versions(
        self, *, project_kind: str, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the support training config version for a given project type.

        :keyword project_kind: The project kind. Known values are: "Conversation" and "Orchestration".
         Required.
        :paramtype project_kind: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "modelExpirationDate": "2020-02-20",  # Represents the training config
                      version expiration date. Required.
                    "trainingConfigVersion": "str"  # Represents the version of the config.
                      Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_training_config_versions_request(
                    project_kind=project_kind,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
