/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Scanner;
import org.brunel.build.d3.D3Builder;
import org.brunel.build.util.BuilderOptions;
import org.brunel.model.VisItem;
import org.brunel.util.LocalOutputFiles;
import org.brunel.util.PageOutput;

public class WebDisplay {
    private static final String NAV_LOCATION = "/org/brunel/util/webdisplay-navigation.html";
    private static final String NAV_BASE = new Scanner(WebDisplay.class.getResourceAsStream("/org/brunel/util/webdisplay-navigation.html"), "UTF-8").useDelimiter("\\A").next();
    private final File displayBaseDir;
    private final BuilderOptions options;
    private int count;
    private String menuString = "<html><head><title>Charts</title></head><body>\n";

    public static String writeHtml(D3Builder builder, int width, int height, String brunel, String ... titles) {
        StringWriter writer = new StringWriter();
        PageOutput output = new PageOutput(builder, writer);
        output.addTitles(titles);
        if (brunel != null) {
            output.addFooters("<small>" + PageOutput.escapeHTML(brunel) + "</small>");
        }
        output.write();
        return writer.toString();
    }

    public WebDisplay(BuilderOptions options, String dirName) {
        this.options = options;
        if (this.isLocalReference(options.locJavaScript)) {
            LocalOutputFiles.install();
        }
        this.displayBaseDir = LocalOutputFiles.makeDirectory(dirName);
    }

    private boolean isLocalReference(String location) {
        return location.startsWith("file:");
    }

    public File makeFile(String s) {
        return new File(this.displayBaseDir, s);
    }

    public void buildOneOfMultiple(VisItem target, String groupName, String name, Dimension size) {
        if (this.count == 0) {
            this.writeToFile("index.html", NAV_BASE.replace("$TITLE$", this.displayBaseDir.getName()));
        }
        String file = this.count + ".html";
        String text = this.count + ": " + groupName;
        this.menuString = this.menuString + "<a href=\"" + file + " \" target=\"content\">" + text + "</a><br>\n";
        this.writeToFile("menu.html", this.menuString + "</body></html>");
        try {
            ++this.count;
            this.buildSingle(target, size.width, size.height, file, name);
        }
        catch (Exception ex) {
            this.buildError(file, ex);
        }
    }

    public void buildSingle(VisItem target, int width, int height, String file, String ... titles) {
        D3Builder builder = D3Builder.make(this.options);
        builder.build(target, width, height);
        String html = WebDisplay.writeHtml(builder, width, height, null, titles);
        this.writeToFile(file, html);
    }

    public void showInBrowser() {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new File(this.displayBaseDir, "index.html").toURI());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void buildError(String file, Exception ex) {
        try {
            StringBuilder b = new StringBuilder();
            b.append("<html><head><title>Brunel Error</title></head><body><h2>Error Building Brunel</h2>\n");
            b.append("<p>").append(PageOutput.escapeHTML(ex.getMessage())).append("</p>\n");
            b.append("<ul>\n");
            for (StackTraceElement e : ex.getStackTrace()) {
                b.append("<li>").append(PageOutput.escapeHTML(e.toString())).append("</li>\n");
            }
            b.append("</ul>\n</body></html>");
            this.writeToFile(file, b.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToFile(String fileName, String html) {
        try {
            File file = new File(this.displayBaseDir, fileName);
            PrintWriter item = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            item.println(html);
            item.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

