/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import org.brunel.geom.Point;

public class LabelPoint
extends Point {
    public final String label;
    public final int pop;
    public final int importance;

    public static LabelPoint makeFromArray(String[] p) {
        return new LabelPoint(Double.parseDouble(p[2]), Double.parseDouble(p[1]), p[0], Integer.parseInt(p[3]), Integer.parseInt(p[4]));
    }

    private LabelPoint(double x, double y, String label, int pop, int importance) {
        super(x, y);
        this.label = label;
        this.pop = pop;
        this.importance = importance;
    }

    @Override
    public String toString() {
        return this.label + "[" + this.importance + "," + this.pop + "]";
    }

    @Override
    public int compareTo(Point p) {
        if (p instanceof LabelPoint) {
            LabelPoint o = (LabelPoint)p;
            int diff = o.rank() - this.rank();
            return diff != 0 ? diff : this.label.compareTo(o.label);
        }
        return super.compareTo(p);
    }

    private int rank() {
        return this.pop + 7 * this.importance;
    }
}

