/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.ArrayList;
import java.util.List;
import org.brunel.geom.Point;
import org.brunel.geom.Poly;
import org.brunel.geom.Rect;
import org.brunel.maps.LabelPoint;

class GeoFile
implements Comparable<GeoFile> {
    public final String name;
    public final Rect bounds;
    public final List<LabelPoint> pts;
    public final Poly hull;

    public GeoFile(String name, String boundsString, String hullString) {
        this.name = name;
        String[] b = boundsString.split(",");
        this.bounds = new Rect(Double.parseDouble(b[0]), Double.parseDouble(b[1]), Double.parseDouble(b[2]), Double.parseDouble(b[3]));
        this.hull = new Poly(this.parse(hullString));
        this.pts = new ArrayList<LabelPoint>();
    }

    private Point[] parse(String hullString) {
        String[] parts = hullString.split(";");
        Point[] result = new Point[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String[] p = parts[i].split(",");
            result[i] = new Point(Double.parseDouble(p[0]), Double.parseDouble(p[1]));
        }
        return result;
    }

    @Override
    public int compareTo(GeoFile o) {
        return Double.compare(o.bounds.area(), this.bounds.area());
    }

    public boolean covers(Point p) {
        return this.hull.contains(p);
    }

    public String toString() {
        return this.name;
    }
}

