/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import org.brunel.build.util.Padding;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleSheet;
import org.brunel.model.style.StyleTarget;

public class ModelUtil {
    public static boolean combinationIsCategorical(Field[] fields, boolean preferContinuous) {
        boolean allPreferCategorical = true;
        for (Field f : fields) {
            if (!f.preferCategorical()) {
                allPreferCategorical = false;
            }
            if (f.isNumeric()) continue;
            return true;
        }
        if (preferContinuous) {
            return false;
        }
        return allPreferCategorical;
    }

    public static Size getSize(VisSingle vis, StyleTarget target, String tag) {
        String s = ModelUtil.getStyle(vis, target, tag);
        if (s == null) {
            if (tag.equals("height") || tag.equals("width")) {
                return ModelUtil.getSize(vis, target, "size");
            }
            return null;
        }
        return ModelUtil.decompose(s);
    }

    public static String getElementSymbol(VisSingle vis) {
        StyleTarget target = StyleTarget.makeElementTarget(null, "element", "point");
        return vis.styles == null ? null : vis.styles.get(target, "symbol");
    }

    public static double getFontSize(VisSingle vis, StyleTarget target, int defaultSize) {
        Size size = ModelUtil.getSize(vis, target, "font-size");
        return size == null ? (double)defaultSize : size.value(defaultSize);
    }

    private static String getStyle(VisSingle vis, StyleTarget target, String key) {
        String result = vis.styles == null ? null : vis.styles.get(target, key);
        return result == null ? StyleSheet.getBrunelDefault(target, key) : result;
    }

    private static Size decompose(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        try {
            int pUnit;
            for (pUnit = s.length(); pUnit > 0 && "1234567890.".indexOf(s.charAt(pUnit - 1)) < 0; --pUnit) {
            }
            double v = Double.parseDouble(s.substring(0, pUnit));
            return new Size(v, s.substring(pUnit));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse style defined as: " + s, e);
        }
    }

    public static String getLabelPosition(VisSingle vis) {
        if (vis == null) {
            return null;
        }
        String s = ModelUtil.getStyle(vis, StyleTarget.makeElementTarget(null, "element"), "label-location");
        if (s != null) {
            return s;
        }
        return ModelUtil.getStyle(vis, StyleTarget.makeElementTarget(null, "label"), "label-location");
    }

    public static String getLabelAlignment(VisSingle vis) {
        String s = ModelUtil.getStyle(vis, StyleTarget.makeElementTarget(null, "element"), "text-align");
        if (s != null) {
            return s;
        }
        return ModelUtil.getStyle(vis, StyleTarget.makeElementTarget(null, "label"), "text-align");
    }

    public static double getLabelPadding(VisSingle vis, int defaultValue) {
        Size s = ModelUtil.getSize(vis, StyleTarget.makeElementTarget(null, "element"), "padding");
        if (s == null) {
            s = ModelUtil.getSize(vis, StyleTarget.makeElementTarget(null, "label"), "padding");
        }
        return s == null ? (double)defaultValue : s.value(defaultValue);
    }

    public static String getTitlePosition(VisSingle vis, StyleTarget target) {
        String s = ModelUtil.getStyle(vis, target, "label-location");
        return s == null ? "center" : s;
    }

    public static Padding getPadding(VisSingle vis, StyleTarget target, int defaultSize) {
        int top = defaultSize;
        int left = defaultSize;
        int bottom = defaultSize;
        int right = defaultSize;
        String s = ModelUtil.getStyle(vis, target, "padding");
        if (s != null) {
            right = bottom = (int)ModelUtil.decompose(s).value(100.0);
            left = bottom;
            top = bottom;
        }
        if ((s = ModelUtil.getStyle(vis, target, "padding-top")) != null) {
            top = (int)ModelUtil.decompose(s).value(100.0);
        }
        if ((s = ModelUtil.getStyle(vis, target, "padding-bottom")) != null) {
            bottom = (int)ModelUtil.decompose(s).value(100.0);
        }
        if ((s = ModelUtil.getStyle(vis, target, "padding-left")) != null) {
            left = (int)ModelUtil.decompose(s).value(100.0);
        }
        if ((s = ModelUtil.getStyle(vis, target, "padding-right")) != null) {
            right = (int)ModelUtil.decompose(s).value(100.0);
        }
        return new Padding(top, left, bottom, right);
    }

    public static double getSize(VisSingle vis, StyleTarget target, String tag, double defaultSize) {
        Size size = ModelUtil.getSize(vis, target, tag);
        return size == null ? defaultSize : size.value(defaultSize);
    }

    public static final class Size {
        private static final int DPI = 96;
        private final double value;
        private final String unit;

        public Size(double value, String unit) {
            this.value = value;
            this.unit = unit.isEmpty() ? "px" : unit;
        }

        public String suffix() {
            return this.isPercent() ? this.unit : "px";
        }

        public boolean isPercent() {
            return this.unit.equals("%");
        }

        public String toString() {
            return this.value + this.unit;
        }

        public double value(double percentSize100) {
            if (this.isPercent()) {
                return this.value * percentSize100 / 100.0;
            }
            if (this.unit.equals("px")) {
                return this.value;
            }
            if (this.unit.equals("mm")) {
                return this.value * 96.0 / 25.4;
            }
            if (this.unit.equals("cm")) {
                return this.value * 96.0 / 2.54;
            }
            if (this.unit.equals("in")) {
                return this.value * 96.0;
            }
            if (this.unit.equals("pt")) {
                return this.value * 96.0 / 72.0;
            }
            if (this.unit.equals("pc")) {
                return this.value * 96.0 / 6.0;
            }
            throw new IllegalStateException("Unknown unit: " + this.unit);
        }
    }
}

