/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.model.VisSingle;

public class Accessibility {
    public static void defineElementLabelFunction(ElementStructure structure, ScriptWriter out, D3LabelBuilder labelBuilder) {
        if (!structure.chart.accessible) {
            return;
        }
        VisSingle vis = structure.vis;
        out.onNewLine().add("function ariaLabel(d) { return ");
        if (!vis.itemsTooltip.isEmpty()) {
            labelBuilder.writeContent(vis.itemsTooltip, false);
        } else if (!vis.itemsLabel.isEmpty()) {
            labelBuilder.writeContent(vis.itemsLabel, false);
        } else {
            out.add("data._key(d.row)");
        }
        out.add("}").endStatement();
    }

    public static void useElementLabelFunction(ElementStructure structure, ScriptWriter out) {
        if (structure.chart.accessible) {
            out.addChained("attr('role', 'img').attr('aria-label', ariaLabel)");
        }
    }

    public static String makeNumberingTitle(String name, int index) {
        if (index == 0) {
            return "First " + name;
        }
        if (index == 1) {
            return "Second " + name;
        }
        if (index == 2) {
            return "Third " + name;
        }
        return name + " number " + (index + 1);
    }

    public static void writeLabelAttribute(String label, ScriptWriter out) {
        out.addChained("attr('role', 'region').attr('aria-label', " + Data.quote((String)label) + ")");
    }

    public static void addElementInformation(ElementStructure structure, ScriptWriter out) {
        if (structure.chart.accessible) {
            out.addChained("attr('role', 'region').attr('aria-label', " + Data.quote((String)Accessibility.makeVisSingleLabel(structure.vis)) + ")");
        }
    }

    protected static String makeVisSingleLabel(VisSingle vis) {
        Object[] pos = vis.positionFields();
        String label = pos.length == 0 ? "No data" : Data.join((Object[])pos);
        label = vis.tDiagram != null ? label + " as a " + (Object)((Object)vis.tDiagram) + " diagram" : label + " as " + (Object)((Object)vis.tElement) + "s";
        pos = vis.aestheticFields();
        if (pos.length > 0) {
            label = label + ", also showing " + Data.join((Object[])pos);
        }
        if (!vis.fSort.isEmpty()) {
            label = label + ", sorted by " + Data.join(vis.fSort);
        }
        return label.replaceAll("#", "");
    }
}

