/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.info;

import java.util.ArrayList;
import java.util.List;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.Dependency;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.maps.GeoMapping;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ElementStructure {
    public final ChartStructure chart;
    public final int index;
    public final VisSingle vis;
    public final Dataset original;
    public final Dataset data;
    public final GeoMapping geo;
    public ElementDetails details;
    public List<Dependency> dependencies;

    public ElementStructure(ChartStructure chartStructure, int elementIndex, VisSingle vis, Dataset data, GeoMapping geo) {
        this.chart = chartStructure;
        this.index = elementIndex;
        this.vis = vis;
        this.data = data;
        this.geo = geo;
        this.original = vis.getDataset();
        this.dependencies = new ArrayList<Dependency>();
    }

    public ElementStructure findDependentEdges() {
        for (Dependency dependency : this.dependencies) {
            if (dependency.base != this || dependency.dependent.vis.fKeys.size() <= 1) continue;
            return dependency.dependent;
        }
        return null;
    }

    public int getBaseDatasetIndex() {
        return this.chart.getBaseDatasetIndex(this.original);
    }

    public String elementID() {
        return "" + (this.index + 1);
    }

    public boolean hasHierarchicalData() {
        return this.chart.diagram != null && this.chart.diagram.isHierarchical;
    }

    public boolean isClustered() {
        return this.chart.diagram == null && this.vis.fX.size() > 1;
    }

    public boolean isDependent() {
        return this.getDependencyBase() != null;
    }

    public ElementStructure getDependencyBase() {
        for (Dependency dependency : this.dependencies) {
            if (dependency.dependent != this) continue;
            return dependency.base;
        }
        return null;
    }

    public boolean isDependentEdge() {
        return this.vis.tElement == VisTypes.Element.edge && this.isDependent();
    }

    public String[] makeReferences(Field[] keys) {
        String idToPointName = "elements[" + this.getDependencyBase().index + "].internal()._idToPoint(";
        String[] references = new String[keys.length];
        for (int i = 0; i < references.length; ++i) {
            references[i] = idToPointName + D3Util.writeCall(keys[i]) + ")";
        }
        return references;
    }
}

