/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.info;

import java.util.Arrays;
import java.util.Comparator;
import org.brunel.build.info.ChartCoordinates;
import org.brunel.build.info.Dependency;
import org.brunel.build.info.ElementStructure;
import org.brunel.data.Dataset;
import org.brunel.maps.GeoInformation;
import org.brunel.maps.GeoMapping;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ChartStructure {
    public final ChartCoordinates coordinates;
    public final int chartIndex;
    public final VisSingle[] elements;
    public final GeoInformation geo;
    public final VisTypes.Diagram diagram;
    public final ElementStructure[] elementStructure;
    public final ChartStructure outer;
    public final Integer innerChartIndex;
    public final String visIdentifier;
    public boolean accessible;
    public final Dataset[] baseDataSets;
    public int chartHeight;
    public int chartWidth;

    public ChartStructure(int chartIndex, VisSingle[] elements, Dataset[] data, Dataset[] dataSets, ChartStructure outer, Integer innerChartIndex, String visIdentifier) {
        this.baseDataSets = dataSets;
        this.chartIndex = chartIndex;
        this.elements = elements;
        this.outer = outer;
        this.innerChartIndex = innerChartIndex;
        this.visIdentifier = visIdentifier;
        this.elementStructure = new ElementStructure[elements.length];
        this.diagram = this.findDiagram();
        this.coordinates = new ChartCoordinates(elements, data, this.diagram);
        this.geo = this.makeGeo(elements, data);
        for (int i = 0; i < elements.length; ++i) {
            GeoMapping geoMapping = this.geo == null ? null : this.geo.getGeo(elements[i]);
            this.elementStructure[i] = new ElementStructure(this, i, elements[i], data[i], geoMapping);
        }
        int sourceIndex = this.findSourceElement(elements);
        if (sourceIndex >= 0) {
            for (ElementStructure structure : this.elementStructure) {
                VisSingle vis = structure.vis;
                if (vis.positionFields().length != 0 || vis.tDiagram != null || vis.fKeys.isEmpty() || structure == this.elementStructure[sourceIndex]) continue;
                Dependency dependency = new Dependency(this.elementStructure[sourceIndex], structure);
                dependency.attach();
            }
        }
    }

    public void setExtent(int chartWidth, int chartHeight) {
        this.chartWidth = chartWidth;
        this.chartHeight = chartHeight;
    }

    public static String makeChartID(int index) {
        return "" + (index + 1);
    }

    public boolean hasMultipleElements() {
        return this.elements.length > 1;
    }

    public boolean nested() {
        return this.outer != null;
    }

    private VisTypes.Diagram findDiagram() {
        for (VisSingle e : this.elements) {
            if (e.tDiagram == null) continue;
            return e.tDiagram;
        }
        return null;
    }

    private int findSourceElement(VisSingle[] elements) {
        int candidate = -1;
        for (int i = 0; i < elements.length; ++i) {
            VisSingle vis = elements[i];
            if (vis.fKeys.size() != 1) continue;
            if (candidate < 0) {
                candidate = i;
                continue;
            }
            if (vis.tDiagram != null) {
                return i;
            }
            if (vis.positionFields().length <= elements[candidate].positionFields().length) continue;
            candidate = i;
        }
        return candidate;
    }

    public GeoInformation makeGeo(VisSingle[] elements, Dataset[] data) {
        for (VisSingle vis : elements) {
            if (vis.tDiagram != VisTypes.Diagram.map) continue;
            return new GeoInformation(elements, data, this.coordinates);
        }
        return null;
    }

    public Integer[] elementBuildOrder() {
        Integer[] order = new Integer[this.elements.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        Arrays.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                VisSingle aa = ChartStructure.this.elements[a];
                VisSingle bb = ChartStructure.this.elements[b];
                if (aa.tDiagram != null && bb.tDiagram == null) {
                    return -1;
                }
                if (aa.tDiagram == null && bb.tDiagram != null) {
                    return 1;
                }
                if (aa.tElement == VisTypes.Element.edge && bb.tElement != VisTypes.Element.edge) {
                    return 1;
                }
                if (aa.tElement != VisTypes.Element.edge && bb.tElement == VisTypes.Element.edge) {
                    return -1;
                }
                return aa.fKeys.size() - bb.fKeys.size();
            }
        });
        return order;
    }

    public int getBaseDatasetIndex(Dataset dataset) {
        for (int i = 0; i < this.baseDataSets.length; ++i) {
            if (dataset != this.baseDataSets[i]) continue;
            return i;
        }
        throw new IllegalStateException("Could not find data set in array of datasets");
    }

    public String chartID() {
        return ChartStructure.makeChartID(this.chartIndex);
    }
}

