/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.titles;

import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.Padding;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleTarget;

public abstract class TitleBuilder {
    protected final VisSingle vis;
    protected final StyleTarget styleTarget;
    protected final Padding padding;
    private final String alignment;
    protected final int fontSize;
    private String content;

    public TitleBuilder(VisSingle vis, StyleTarget styleTarget) {
        this.vis = vis;
        this.styleTarget = styleTarget;
        this.alignment = ModelUtil.getTitlePosition(vis, styleTarget);
        this.padding = ModelUtil.getPadding(vis, styleTarget, 4);
        this.fontSize = (int)ModelUtil.getFontSize(vis, styleTarget, 16);
    }

    public String content() {
        if (this.content == null) {
            String s = this.makeText();
            this.content = s == null || s.isEmpty() ? null : Data.quote((String)s);
        }
        return this.content;
    }

    public void writeContent(String group, ScriptWriter out) {
        if (this.content() == null) {
            return;
        }
        out.add(group + ".append('text').attr('class', '" + Data.join((Object[])this.styleTarget.classes, (String)" ") + "')").add(".text(" + this.content() + ")");
        this.defineHorizontalLocation(out);
        this.defineVerticalLocation(out);
        out.endStatement();
    }

    private void defineHorizontalLocation(ScriptWriter out) {
        int dx;
        String anchor;
        String xLoc;
        String[] xOffsets = this.getXOffsets();
        switch (this.alignment) {
            case "left": {
                xLoc = xOffsets[0];
                anchor = "start";
                dx = this.padding.left;
                break;
            }
            case "right": {
                xLoc = xOffsets[2];
                anchor = "end";
                dx = -this.padding.right;
                break;
            }
            default: {
                xLoc = xOffsets[1];
                anchor = "middle";
                dx = (this.padding.left - this.padding.right) / 2;
            }
        }
        out.add(".style('text-anchor', '" + anchor + "')").addChained("attr('x'," + xLoc + ")");
        if (dx != 0) {
            out.addChained("attr('dx',", dx, ")");
        }
    }

    protected String[] getXOffsets() {
        return new String[]{"'0%'", "'50%'", "'100%'"};
    }

    protected abstract void defineVerticalLocation(ScriptWriter var1);

    public double verticalSpace() {
        return this.content() == null ? 0.0 : (double)(this.fontSize + this.padding.vertical());
    }

    protected abstract String makeText();
}

