/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.titles;

import org.brunel.build.d3.AxisDetails;
import org.brunel.build.d3.titles.TitleBuilder;
import org.brunel.build.util.ScriptWriter;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleTarget;

public class AxisTitleBuilder
extends TitleBuilder {
    private final AxisDetails axis;
    private final boolean isHorizontal;
    public double bottomOffset;

    public AxisTitleBuilder(VisSingle vis, AxisDetails axis, boolean isHorizontal) {
        super(vis, StyleTarget.makeTarget("text", axis.styleTarget, "title"));
        this.axis = axis;
        this.isHorizontal = isHorizontal;
    }

    @Override
    protected String[] getXOffsets() {
        if (this.isHorizontal) {
            return new String[]{"0", "geom.inner_rawWidth/2", "geom.inner_rawWidth"};
        }
        return new String[]{"-geom.inner_rawHeight", "-geom.inner_rawHeight/2", "0"};
    }

    @Override
    protected void defineVerticalLocation(ScriptWriter out) {
        if (this.isHorizontal) {
            out.addChained("attr('y', geom.inner_bottom - " + (this.bottomOffset + (double)this.padding.bottom) + ").attr('dy','-0.27em')");
        } else {
            out.addChained("attr('y', " + (2 + this.padding.top) + "-geom.inner_left).attr('dy', '0.7em').attr('transform', 'rotate(270)')");
        }
    }

    @Override
    protected String makeText() {
        return this.axis.title;
    }
}

