/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

public class GeomAttribute {
    private final String def;
    private final boolean func;

    private GeomAttribute(String def, boolean func) {
        this.def = def;
        this.func = func;
    }

    public static GeomAttribute makeFunction(String def) {
        return new GeomAttribute(def, true);
    }

    public static GeomAttribute makeConstant(String def) {
        return new GeomAttribute(def, false);
    }

    public String call() {
        return this.call(this.def);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeomAttribute that = (GeomAttribute)o;
        return this.func == that.func && this.def.equals(that.def);
    }

    public GeomAttribute halved() {
        return new GeomAttribute(this.def + " / 2", this.func);
    }

    public int hashCode() {
        int result = this.def.hashCode();
        result = 31 * result + (this.func ? 1 : 0);
        return result;
    }

    public String call(String functionName) {
        return this.isFunc() ? functionName + "(d)" : functionName;
    }

    public String definition() {
        return this.def;
    }

    public boolean isFunc() {
        return this.func;
    }

    public String toString() {
        return this.func ? "function(d) { return " + this.def + "}" : this.def;
    }
}

