/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public enum ElementRepresentation {
    pointLikeCircle("circle", "right", false),
    spaceFillingCircle("circle", "box", true),
    largeCircle("circle", "center", false),
    segment("line", "box", false),
    curvedPath("path", "box", false),
    text("text", "box", true),
    rect("rect", "box", true),
    generalPath("path", "path", false),
    polygon("path", "poly", false),
    area("path", "area", true),
    geoFeature("path", "geo", false),
    symbol("path", "right", false),
    wedge("path", "wedge", false);

    private final String mark;
    private final String defaultTextMethod;
    private final boolean textFitsShape;

    static ElementRepresentation makeForCoordinateElement(VisTypes.Element element, String symbolName, VisSingle vis) {
        VisTypes.Coordinates coords = vis.coords;
        if (element == VisTypes.Element.bar && coords == VisTypes.Coordinates.polar) {
            return wedge;
        }
        if (element == VisTypes.Element.area) {
            return area;
        }
        if (element == VisTypes.Element.line) {
            return generalPath;
        }
        if (element == VisTypes.Element.path) {
            return generalPath;
        }
        if (element == VisTypes.Element.polygon) {
            return polygon;
        }
        if (element == VisTypes.Element.edge) {
            return segment;
        }
        if (element == VisTypes.Element.text) {
            return text;
        }
        if (element == VisTypes.Element.bar) {
            return rect;
        }
        if ("rect".equals(symbolName)) {
            return rect;
        }
        if (symbolName == null || symbolName.equals("circle")) {
            return pointLikeCircle;
        }
        return symbol;
    }

    private ElementRepresentation(String mark, String textMethod, boolean textFitsShape) {
        this.mark = mark;
        this.defaultTextMethod = textMethod;
        this.textFitsShape = textFitsShape;
    }

    public String getDefaultTextMethod() {
        return this.defaultTextMethod;
    }

    public String getMark() {
        return this.mark;
    }

    public String getTooltipTextMethod() {
        if (this == area) {
            return "poly";
        }
        if (this.isDrawnAsPath() || this == segment) {
            return this.getDefaultTextMethod();
        }
        return "top";
    }

    public boolean isDrawnAsPath() {
        return this.mark.equals("path") && this != symbol;
    }

    public boolean textFitsShape() {
        return this.textFitsShape;
    }
}

