/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.Padding;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.style.StyleTarget;

class Table
extends D3Diagram {
    private final double[] fraction;
    private final double fontSize;
    private final Padding padding;
    private final Field[] fields;

    public Table(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
        this.fields = data.fieldArray(this.vis.positionFields());
        this.padding = ModelUtil.getPadding(this.vis, StyleTarget.makeElementTarget(null, new String[0]), 2);
        this.padding.top += 15;
        this.fraction = this.divideColumnSpace(this.fields);
        StyleTarget styleTarget = StyleTarget.makeElementTarget("text", new String[0]);
        this.fontSize = ModelUtil.getFontSize(this.vis, styleTarget, 12);
    }

    private double[] divideColumnSpace(Field[] dataFields) {
        double[] fraction = new double[this.fields.length];
        for (int i = 0; i < dataFields.length; ++i) {
            for (int j = 0; j < dataFields[i].rowCount(); ++j) {
                String s = dataFields[i].valueFormatted(j);
                if (s == null) continue;
                fraction[i] = Math.max(fraction[i], (double)s.length());
            }
        }
        double total = 0.0;
        for (double f : fraction) {
            total += f;
        }
        int i = 0;
        while (i < fraction.length) {
            int n = i++;
            fraction[n] = fraction[n] / total;
        }
        return fraction;
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.onNewLine().comment("Define columns for the table");
        this.out.add("var L = " + this.padding.left + ", W = geom.inner_width - " + this.padding.horizontal()).endStatement();
        this.out.add("var columns = [").onNewLine().indentMore();
        double pos = 0.0;
        for (int i = 0; i < this.fields.length; ++i) {
            Field f = this.fields[i];
            if (i > 0) {
                this.out.add(",").onNewLine();
            }
            this.out.add("{ label: " + Data.quote((String)f.label)).add(", value: data." + D3Util.canonicalFieldName(f.name) + "_f").add(", ext: [L + W * " + Data.format((Object)pos, (boolean)false) + ", L + W * " + Data.format((Object)(pos + this.fraction[i]), (boolean)false) + "]").add(" }");
            pos += this.fraction[i];
        }
        this.out.indentLess().add("]").endStatement();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.rect, "rect", "data._rows");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('x', L).attr('width', W)").addChained("attr('y', function(d,i) { return " + this.padding.top + " + " + this.fontSize + " * i }).attr('height', " + this.fontSize + ")");
        this.addAestheticsAndTooltips(details);
    }
}

