/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.brunel.action.Param;
import org.brunel.build.d3.AxisDetails;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.ScalePurpose;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.Padding;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.style.StyleTarget;

class ParallelCoordinates
extends D3Diagram {
    private final Set<String> TRANSFORMS = new HashSet<String>(Arrays.asList("linear", "log", "root"));
    private final Field[] fields;
    private final D3ScaleBuilder builder;
    private final AxisDetails[] axes;
    private final Padding padding;
    private final double smoothness;

    public ParallelCoordinates(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
        this.fields = data.fieldArray(this.vis.positionFields());
        this.builder = new D3ScaleBuilder(structure.chart, out);
        this.axes = ParallelCoordinates.makeAxisDetails(structure.chart, this.fields);
        this.padding = ModelUtil.getPadding(this.vis, StyleTarget.makeElementTarget(null, new String[0]), 6);
        this.padding.left += this.axes[0].size;
        this.padding.bottom += 15;
        this.smoothness = this.vis.tDiagramParameters.length == 0 ? 0.0 : this.vis.tDiagramParameters[0].asDouble();
    }

    private static AxisDetails[] makeAxisDetails(ChartStructure chart, Field[] fields) {
        AxisDetails[] axes = new AxisDetails[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            AxisDetails details = new AxisDetails("y" + i, new Field[]{f}, f.preferCategorical(), null, 9999, false);
            details.setTextDetails(chart, false);
            details.layoutVertically(chart.chartHeight);
            axes[i] = details;
        }
        return axes;
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.add("var axes = interior.selectAll('g.parallel.axis').data(parallel)").endStatement();
        this.out.add("var builtAxes = axes.enter().append('g')").addChained("attr('class', function(d,i) { return 'parallel axis dim' + (i+1) })").addChained("attr('transform', function(d,i) { return 'translate(' + scale_x(i) + ',0)' })").addChained("each(function(d) {").indentMore().indentMore().add("d3.select(this).append('text').attr('class', 'axis title').text(d.label)").addChained("attr('x', 0).attr('y', geom.inner_height).attr('dy', '-0.3em').style('text-anchor', 'middle')").indentLess().indentLess().add("})").endStatement();
        this.out.add("BrunelD3.transition(axes.merge(builtAxes), transitionMillis)").addChained("each(function(d,i) { d3.select(this).call(d.axis.scale(d.scale)); })").endStatement();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.generalPath, "path", "data._rows");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('d', path)");
        this.addAestheticsAndTooltips(details);
    }

    @Override
    public void writePerChartDefinitions() {
        this.out.add("var parallel;").at(50).comment("Structure to store parallel axes");
    }

    @Override
    public void preBuildDefinitions() {
        this.out.add("var rangeVertical = [geom.inner_height -", this.padding.vertical() + ", " + this.padding.top + "];").at(50).comment("vertical range");
        this.out.add("var scale_x = d3.scaleLinear().range([" + this.padding.left + ", geom.inner_width -", this.padding.horizontal() + "])").addChained("domain([0,", this.fields.length - 1, "])").endStatement();
        this.out.onNewLine().ln().comment("Define data structures for parallel axes");
        this.out.add("parallel = [").onNewLine().indentMore();
        for (int i = 0; i < this.fields.length; ++i) {
            Field f = this.fields[i];
            if (i > 0) {
                this.out.add(",").onNewLine();
            }
            this.out.add("{").indentMore().onNewLine().add("label : " + Data.quote((String)f.label) + ",").onNewLine().add("scale : ");
            this.builder.defineScaleWithDomain(null, new Field[]{f}, ScalePurpose.parallel, 2, this.getTransform(f), null, this.isReversed(f));
            if (this.out.currentColumn() > 60) {
                this.out.addChained("range(rangeVertical),");
            } else {
                this.out.add(".range(rangeVertical),");
            }
            String positionExpression = D3Util.writeCall(f);
            if (f.isBinned()) {
                positionExpression = positionExpression + ".mid";
            }
            this.out.onNewLine().add("y : function(d) { return this.scale(" + positionExpression + ") },");
            this.out.onNewLine().add("axis : d3.axisLeft(), numeric: " + f.isNumeric());
            this.out.onNewLine().indentLess().add("}");
        }
        this.out.indentLess().add("]").endStatement();
        this.out.onNewLine().ln().add("function path(d) {").indentMore().ln();
        this.out.add("var p = d3.path()").endStatement();
        if (this.smoothness == 0.0) {
            this.defineLinearPath();
        } else {
            this.defineSmoothPath(this.smoothness);
        }
        this.out.add("return p");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    private void defineLinearPath() {
        this.out.add("parallel.forEach(function(dim, i) {").indentMore().indentMore().onNewLine().add("if (i) p.lineTo(scale_x(i), dim.y(d))").endStatement().add("else   p.moveTo(scale_x(i), dim.y(d))").endStatement().indentLess().indentLess().add("} )").endStatement();
    }

    private void defineSmoothPath(double r) {
        this.out.add("var xa, ya, xb, yb, i, xm, ym, r = ", r / 2.0).endStatement();
        this.out.add("parallel.forEach(function(dim, i) {").indentMore().indentMore().onNewLine().add("xb = scale_x(i), yb = parallel[i].y(d)").endStatement().add("if (i) p.bezierCurveTo(xa +(xb-xa)*r, ya, xb +(xa-xb)*r, yb, xb, yb)").endStatement().add("else   p.moveTo(xb, yb)").endStatement().add("xa = xb; ya = yb").endStatement().indentLess().indentLess().add("} )").endStatement();
    }

    private String getTransform(Field field) {
        String s;
        for (Param p : this.vis.fX) {
            s = this.getTransform(field, p);
            if (s == null) continue;
            return s;
        }
        for (Param p : this.vis.fY) {
            s = this.getTransform(field, p);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private String getTransform(Field field, Param p) {
        if (p.asField().equals(field.name)) {
            for (Param q : p.modifiers()) {
                if (!this.TRANSFORMS.contains(q.asString())) continue;
                return q.asString();
            }
        }
        return null;
    }

    private boolean isReversed(Field field) {
        boolean reversed = !field.preferCategorical();
        for (Param p : this.vis.fX) {
            if (!this.requestsReverse(field, p)) continue;
            reversed = !reversed;
        }
        for (Param p : this.vis.fY) {
            if (!this.requestsReverse(field, p)) continue;
            reversed = !reversed;
        }
        return reversed;
    }

    private boolean requestsReverse(Field field, Param p) {
        return p.asField().equals(field.name) && p.hasModifierOption("reverse");
    }
}

