/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.maps.GeoInformation;
import org.brunel.maps.GeoMapping;
import org.brunel.model.VisTypes;

public class GeoMap
extends D3Diagram {
    private final GeoMapping mapping;

    private static void writeProjection(ScriptWriter out, GeoInformation geo) {
        String[] projectionDescription = geo.d3Definition().split("\n");
        out.add("var base = ").indentMore();
        for (String p : projectionDescription) {
            out.add(p.trim()).onNewLine();
        }
        out.indentLess();
        out.add("function projection(p) {").indentMore().indentMore().onNewLine().add("var q = base(p), t = d3.zoomTransform(zoomNode)").endStatement().add("return q ? [t.k*q[0]+t.x, t.k*q[1]+t.y] : null").endStatement().indentLess().indentLess().add("}").endStatement();
        out.add("function project_center(v) { return (v ? projection([v.c, v.d]) : null) || [-9e6, -9e6] }").endStatement();
        out.add("var path = d3.geoPath().projection(BrunelD3.geoStream(projection))").endStatement();
        if (geo.withGraticule) {
            double step = Math.min(geo.bounds().width(), geo.bounds().height()) / 5.0;
            if (step < 0.1) {
                step = (double)Math.round(step * 200.0) / 200.0;
            }
            step = step < 1.0 ? (double)Math.round(step * 20.0) / 20.0 : (step < 10.0 ? (double)Math.round(step * 2.0) / 2.0 : 10.0);
            out.onNewLine().add("var graticule = d3.geoGraticule().step([", step, ",", step, "])(),").continueOnNextLine(new String[0]).add("graticulePath = interior.append('path').attr('class', 'grid')").endStatement().onNewLine().add("function buildAxes() { graticulePath.attr('d', path(graticule) ) }");
        }
    }

    public GeoMap(ElementStructure vis, Dataset data, GeoMapping geo, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
        this.mapping = geo;
        if (this.mapping == null) {
            throw new IllegalStateException("Maps need either a position field or key with the feature names; or another element to define positions");
        }
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.indentLess().comment("Read in the feature data and call build again when done");
        this.writeFeatureHookup(this.mapping, GeoInformation.getIDField(this.vis));
        if (this.vis.tElement == VisTypes.Element.point || this.vis.tElement == VisTypes.Element.text) {
            return ElementDetails.makeForCoordinates(this.vis, ModelUtil.getElementSymbol(this.vis));
        }
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.geoFeature, "polygon", "data._rows");
    }

    @Override
    public void writePerChartDefinitions() {
        this.out.titleComment("Projection");
        GeoMap.writeProjection(this.out, this.mapping.getGeoInformation());
    }

    private void writeFeatureHookup(GeoMapping mapping, String idField) {
        if (mapping.fileCount() == 0) {
            throw new IllegalStateException("No suitable map found");
        }
        this.out.add("var features = ");
        GeoMap.writeMapping(this.out, mapping);
        this.out.endStatement();
        String idName = idField == null ? "null" : "data." + D3Util.canonicalFieldName(idField);
        this.out.add("if (BrunelD3.addFeatures(data, features,", idName, ", this, transitionMillis)) return").endStatement();
    }

    public static void writeMapping(ScriptWriter out, GeoMapping map) {
        String[] files = map.getFiles();
        LinkedHashMap combined = new LinkedHashMap();
        for (String geo : files) {
            combined.put(geo, new TreeMap());
        }
        for (Map.Entry<Object, int[]> e : map.getFeatureMap().entrySet()) {
            Object dataName = e.getKey();
            int[] indices = e.getValue();
            String fileName = files[indices[0]];
            Map features = (Map)combined.get(fileName);
            features.put(dataName, indices[1]);
        }
        out.add("{").indentMore();
        for (int k = 0; k < files.length; ++k) {
            if (k > 0) {
                out.add(",").onNewLine();
            }
            String fileName = files[k];
            String source = Data.quote((String)(out.options.locMaps + "/" + out.options.version + "/" + map.getQuality() + "/" + fileName + ".json"));
            out.onNewLine().add(source, ":{").indentMore();
            int i = 0;
            Map features = (Map)combined.get(fileName);
            for (Map.Entry s : features.entrySet()) {
                if (i++ > 0) {
                    out.add(", ");
                }
                out.addQuoted(s.getKey()).add(":").add(s.getValue());
            }
            out.indentLess().onNewLine().add("}");
        }
        out.indentLess().onNewLine().add("}");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
    }

    @Override
    public void writePreDefinition(ElementDetails details) {
        this.out.add("merged.classed('nondata', function(d) {return !d || d.row == null})").endStatement();
    }
}

