/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.EdgeBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;

class DependentEdge
extends D3Diagram {
    DependentEdge(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        if (this.structure.chart.diagram.isHierarchical) {
            return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.curvedPath, "edge", "graph.links");
        }
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.segment, "edge", "graph.links");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        new EdgeBuilder(this.out, this.structure.chart.coordinates.isPolar()).defineLocation();
        this.addAestheticsAndTooltips(details);
    }

    @Override
    public String getStyleClasses() {
        return "'diagram hierarchy edge'";
    }

    @Override
    public String getRowKeyFunction() {
        return "function(d) { return d.key }";
    }
}

