/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.model.style.StyleTarget;

class Chord
extends D3Diagram {
    public Chord(ElementStructure vis, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
    }

    @Override
    public String getRowKeyFunction() {
        return "function(d) { return d.source.index + '|' + d.target.index }";
    }

    @Override
    public ElementDetails initializeDiagram() {
        String f1 = this.vis.positionFields()[0];
        String f2 = this.position[1];
        this.out.comment("Define chord data structures");
        this.out.add("var chordData = BrunelData.diagram_Chord.make(processed,");
        if (this.size == null) {
            this.out.addQuoted(f1, f2);
        } else {
            this.out.addQuoted(f1, f2, this.size);
        }
        this.out.add(")").endStatement();
        this.out.add("var chord = d3.chord().padAngle(.025).sortSubgroups(d3.descending)").endStatement();
        this.out.add("var chords = chord(chordData.matrix())").endStatement();
        StyleTarget target = StyleTarget.makeElementTarget("text", "axis", "label");
        double labelSize = ModelUtil.getSize(this.vis, target, "font-size", 8.0);
        double arcWidth = labelSize * 1.2;
        this.out.add("var arc_width =", Data.formatNumeric((double)arcWidth, null, (boolean)false), ";").comment("Width of exterior arc");
        this.out.add("function keyFunction(d) { return d.source.index + '|' + d.target.index };").comment(" special key function for the edges");
        this.out.add("var R = scale_x(geom.inner_radius)-scale_x(0), svgTrans = 'translate(' + scale_x(0) + ',' + scale_y(0) + ')'").endStatement();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.polygon, "edge", "chords");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('d', d3.ribbon().radius(R-arc_width))").addChained("attr('class', 'element " + this.element.name() + "')").addChained("attr('transform', svgTrans)");
        this.addAestheticsAndTooltips(details);
        this.out.onNewLine().ln().comment("Add in the arcs on the outside for the groups");
        this.out.add("diagramExtras.attr('class', 'diagram chord arcs')").endStatement();
        this.out.add("var arcGroup = diagramExtras.selectAll('g').data(chords.groups),").continueOnNextLine(new String[0]).add("addedArcGroups = arcGroup.enter().append('g'),").continueOnNextLine(new String[0]).add("arcPath = d3.arc().innerRadius(R - arc_width).outerRadius(R)").endStatement();
        this.out.add("addedArcGroups.append('path').attr('class', 'box')").addChained("attr('id', function(d, i) { return 'arc' + i; })").endStatement();
        this.out.add("addedArcGroups.append('text').attr('class', 'label')").addChained("attr('dy', arc_width*0.72).attr('class', 'label')").addChained("append('textPath').attr('xlink:href', function(d, i) { return '#arc' + i })").endStatement();
        this.out.add("var mergedArcGroups = addedArcGroups.merge(arcGroup)").endStatement();
        this.out.add("BrunelD3.tween(mergedArcGroups, transitionMillis, function(d, i) { ").indentMore().indentMore().onNewLine().add("var group = d3.select(this)").endStatement().add("group.attr('transform', svgTrans)").endStatement().add("return function() {").indentMore().indentMore().onNewLine().add("group.select('path').attr('d', arcPath(d))").endStatement().add("group.select('textPath').text(chordData.group(i))").endStatement().add("BrunelD3.centerInWedge(group.select('text'), arc_width)").endStatement().indentLess().indentLess().onNewLine().add("}").indentLess().indentLess().onNewLine().add("})").endStatement();
        D3ElementBuilder.writeRemovalOnExit(this.out, "arcGroup");
    }

    @Override
    public boolean needsDiagramExtras() {
        return true;
    }

    @Override
    public void writeDiagramEnter() {
        this.out.add("merged.each(function(d) { d.row = chordData.index(d.target.index, d.target.subindex) })").endStatement();
    }
}

