/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;

class Bubble
extends D3Diagram {
    public Bubble(ElementStructure structure, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(structure, data, interaction, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define bubble (hierarchy) data structures");
        this.makeHierarchicalTree(false);
        this.out.add("var pack = d3.pack().size([geom.inner_width, geom.inner_height])").endStatement();
        ElementRepresentation representation = ModelUtil.getElementSymbol(this.vis) == null ? ElementRepresentation.spaceFillingCircle : ElementRepresentation.symbol;
        return ElementDetails.makeForDiagram(this.vis, representation, "point", "pack(tree).descendants()");
    }

    @Override
    public void writeDiagramEnter() {
        this.out.add("added.filter(function(d) { return d.parent })").addChained("attr('cx', function(d) { return scale_x(d.parent.x) })").addChained("attr('cy', function(d) { return scale_y(d.parent.y) })").addChained("attr('r', 0)");
        this.out.endStatement();
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.writeHierarchicalClass();
        this.out.addChained("filter(function(d) { return d.depth })");
        this.out.addChained("attr('cx', function(d) { return scale_x(d.x) })").addChained("attr('cy', function(d) { return scale_y(d.y) })").addChained("attr('r', function(d) { return scale_x(d.r) - scale_x(0) })");
        details.x.center = GeomAttribute.makeFunction("scale_x(d.x)");
        details.y.center = GeomAttribute.makeFunction("scale_y(d.y)");
        details.overallSize = GeomAttribute.makeFunction("scale_x(d.r) - scale_x(0)");
        this.out.addChained("attr('class', function(d) { return (d.children ? 'element L' + d.depth : 'leaf element " + this.element.name() + "') })");
        D3ElementBuilder.definePointLikeMark(details, this.vis, this.out);
        this.addAestheticsAndTooltips(details);
    }
}

