/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.brunel.data.util.DateFormat;
import org.brunel.translator.JSTranslation;

@JSTranslation(ignore=true)
public class Dates {
    private static final Map<String, Date> parsed = new LinkedHashMap<String, Date>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Date> eldest) {
            return this.size() > 1000;
        }
    };
    private static final List<SimpleDateFormat> dateFormats;
    private static final SimpleDateFormat[] outputFormats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getPattern(DateFormat dateFormat) {
        SimpleDateFormat[] simpleDateFormatArray = outputFormats;
        synchronized (outputFormats) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outputFormats[dateFormat.ordinal()].toPattern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date date, DateFormat dateFormat) {
        SimpleDateFormat[] simpleDateFormatArray = outputFormats;
        synchronized (outputFormats) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return outputFormats[dateFormat.ordinal()].format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(Object c) {
        List<SimpleDateFormat> list = dateFormats;
        synchronized (list) {
            if (c == null || c instanceof Date) {
                return (Date)c;
            }
            if (c instanceof Number) {
                return new Date(Math.round(((Number)c).doubleValue() * 8.64E7));
            }
            String s = c.toString().trim();
            if (s.isEmpty()) {
                return null;
            }
            if (parsed.containsKey(s)) {
                return parsed.get(s);
            }
            Date result = null;
            for (SimpleDateFormat f : dateFormats) {
                try {
                    result = f.parse(s);
                    break;
                }
                catch (ParseException parseException) {
                }
            }
            parsed.put(s, result);
            return result;
        }
    }

    static {
        outputFormats = new SimpleDateFormat[]{new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("HH:mm"), new SimpleDateFormat("MMM d HH:mm"), new SimpleDateFormat("MMM d, yyyy"), new SimpleDateFormat("MMM yyyy"), new SimpleDateFormat("yyyy")};
        dateFormats = new LinkedList<SimpleDateFormat>();
        dateFormats.add(new SimpleDateFormat("y-M-d'T'H:m:s.SSS", Locale.US));
        dateFormats.add(new SimpleDateFormat("y-M-d'T'H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("y-M-d'T'H:m", Locale.US));
        dateFormats.add(new SimpleDateFormat("MMM d, yyyy H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));
        dateFormats.add(new SimpleDateFormat("y-MM-dd", Locale.US));
        dateFormats.add(new SimpleDateFormat("d-MMM-y", Locale.US));
        dateFormats.add(new SimpleDateFormat("MMM d, yyyy", Locale.US));
        dateFormats.add(new SimpleDateFormat("M/d/y H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("d/M/y H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("M-d-y H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("M/d/y H:m", Locale.US));
        dateFormats.add(new SimpleDateFormat("d-M-y H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("d/M/y H:m", Locale.US));
        dateFormats.add(new SimpleDateFormat("M-d-y H:m", Locale.US));
        dateFormats.add(new SimpleDateFormat("d-M-y H:m", Locale.US));
        dateFormats.add(new SimpleDateFormat("M/d/y", Locale.US));
        dateFormats.add(new SimpleDateFormat("d/M/y", Locale.US));
        dateFormats.add(new SimpleDateFormat("MMM-y", Locale.US));
        dateFormats.add(new SimpleDateFormat("MMM d", Locale.US));
        dateFormats.add(new SimpleDateFormat("d-M-y", Locale.US));
        dateFormats.add(new SimpleDateFormat("M/d", Locale.US));
        dateFormats.add(new SimpleDateFormat("HH:mm:ss.SSS", Locale.US));
        dateFormats.add(new SimpleDateFormat("H:m:s", Locale.US));
        dateFormats.add(new SimpleDateFormat("H:m", Locale.US));
        for (SimpleDateFormat df : outputFormats) {
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        for (SimpleDateFormat format : dateFormats) {
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

