/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.List;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.summary.Fit;

public class Smooth
extends Fit {
    private final double window;

    public Smooth(Field y, Field x, Double windowPercent, List<Integer> rows) {
        super(y, x, rows);
        this.window = this.getWindowWidth(x, windowPercent);
    }

    private double getWindowWidth(Field x, Double windowPercent) {
        double high;
        double low;
        if (x.isNumeric()) {
            low = x.min();
            high = x.max();
        } else {
            low = 0.0;
            high = x.categories().length - 1;
        }
        if (windowPercent != null) {
            return (high - low) * windowPercent / 200.0;
        }
        int n = Auto.optimalBinCount(x);
        return (high - low) / (double)n;
    }

    @Override
    public Object get(Object value) {
        Double at = this.vx(value);
        if (at == null) {
            return null;
        }
        return this.reverseY(this.calc(at, this.window));
    }

    private double calc(double at, double h) {
        int low = this.search(at - h, this.x);
        int high = this.search(at + h, this.x);
        double sy = 0.0;
        double sw = 0.0;
        for (int i = low; i <= high; ++i) {
            double d = (this.x[i] - at) / h;
            double w = 0.75 * (1.0 - d * d);
            if (!(w > 1.0E-5)) continue;
            sw += w;
            sy += w * this.y[i];
        }
        if (sw < 1.0E-4) {
            return h < this.window * 10.0 ? this.calc(at, h * 2.0) : this.my;
        }
        return sy / sw;
    }

    private int search(double at, double[] x) {
        int p = 0;
        int q = x.length - 1;
        while (q - p > 1) {
            int t = p + q >> 1;
            if (x[t] <= at) {
                p = t;
            }
            if (!(x[t] >= at)) continue;
            q = t;
        }
        while (p > 0 && x[p - 1] == at) {
            --p;
        }
        while (q < x.length - 1 && x[q + 1] == at) {
            ++q;
        }
        return p + q >> 1;
    }
}

