/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.Arrays;
import java.util.Comparator;
import org.brunel.data.Data;
import org.brunel.data.Field;

public class FieldRowComparison
implements Comparator<Integer> {
    private final boolean[] ascending;
    private final boolean rowsBreakTies;
    private final int n;
    private final Field[] fields;

    public FieldRowComparison(Field[] fields, boolean[] ascending, boolean rowsBreakTies) {
        this.fields = fields;
        this.ascending = ascending;
        this.rowsBreakTies = rowsBreakTies;
        this.n = ascending == null ? fields.length : ascending.length;
    }

    @Override
    public int compare(Integer a, Integer b) {
        for (int i = 0; i < this.n; ++i) {
            int n = this.fields[i].compareRows(a, b);
            if (n == 0) continue;
            return this.ascending != null && !this.ascending[i] ? -n : n;
        }
        return this.rowsBreakTies ? a - b : 0;
    }

    public boolean isEmpty() {
        return this.fields.length == 0;
    }

    public int[] makeSortedOrder() {
        int n = this.fields[0].rowCount();
        Integer[] items = new Integer[n];
        for (int i = 0; i < n; ++i) {
            items[i] = i;
        }
        Arrays.sort(items, this);
        return Data.toPrimitive(items);
    }
}

