/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.io;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.io.ByteInput;
import org.brunel.data.io.ByteOutput;

public class Serialize {
    public static final int DATA_SET = 1;
    public static final int FIELD = 2;
    public static final int NUMBER = 3;
    public static final int STRING = 4;
    public static final int DATE = 5;
    public static final int VERSION = 6;
    public static final int DATASET_VERSION_NUMBER = 1;

    public static byte[] serializeDataset(Dataset data) {
        data = data.removeSpecialFields();
        ByteOutput s = new ByteOutput();
        s.addByte(6).addNumber(1);
        s.addByte(1).addNumber(data.fields.length);
        for (Field f : data.fields) {
            Serialize.addFieldToOutput(f, s);
        }
        return s.asBytes();
    }

    public static byte[] serializeField(Field field) {
        ByteOutput s = new ByteOutput();
        Serialize.addFieldToOutput(field, s);
        return s.asBytes();
    }

    private static void addFieldToOutput(Field field, ByteOutput s) {
        int N = field.rowCount();
        s.addByte(2).addString(field.name).addString(field.label);
        HashMap<Object, Integer> items = new HashMap<Object, Integer>();
        ArrayList<Object> uniques = new ArrayList<Object>();
        for (int i = 0; i < N; ++i) {
            Object object = field.value(i);
            if (items.containsKey(object)) continue;
            items.put(object, items.size());
            uniques.add(object);
        }
        s.addNumber(uniques.size());
        if (field.isDate()) {
            s.addByte(5);
            for (Object e : uniques) {
                s.addDate((Date)e);
            }
        } else if (field.isNumeric()) {
            s.addByte(3);
            for (Object e : uniques) {
                s.addNumber((Number)e);
            }
        } else {
            s.addByte(4);
            for (Object e : uniques) {
                s.addString((String)e);
            }
        }
        s.addNumber(N);
        for (int i = 0; i < N; ++i) {
            s.addNumber((Number)items.get(field.value(i)));
        }
    }

    public static Object deserialize(byte[] data) {
        ByteInput d = new ByteInput(data);
        return Serialize.readFromByteInput(d);
    }

    private static Object readFromByteInput(ByteInput d) {
        byte b = d.readByte();
        if (b == 2) {
            String name = d.readString();
            String label = d.readString();
            int uniqueCount = d.readNumber().intValue();
            b = d.readByte();
            Object[] items = new Object[uniqueCount];
            for (int i = 0; i < uniqueCount; ++i) {
                if (b == 3) {
                    items[i] = d.readNumber();
                    continue;
                }
                if (b == 4) {
                    items[i] = d.readString();
                    continue;
                }
                if (b == 5) {
                    items[i] = d.readDate();
                    continue;
                }
                throw new IllegalStateException("Unknown column type " + b);
            }
            int len = d.readNumber().intValue();
            int[] indices = new int[len];
            for (int i = 0; i < len; ++i) {
                indices[i] = d.readNumber().intValue();
            }
            Field field = Fields.permute(Fields.makeColumnField(name, label, items), indices, false);
            if (b == 3 || b == 5) {
                field.setNumeric();
            }
            if (b == 5) {
                field.set("date", true);
            }
            return field;
        }
        if (b == 1) {
            int len = d.readNumber().intValue();
            Field[] fields = new Field[len];
            for (int i = 0; i < len; ++i) {
                fields[i] = (Field)Serialize.readFromByteInput(d);
            }
            return Dataset.make(fields, false);
        }
        if (b == 6) {
            int versionNum = d.readNumber().intValue();
            if (versionNum != 1) {
                throw new IllegalStateException("Serialized version differs from current execution version");
            }
            return Serialize.readFromByteInput(d);
        }
        throw new IllegalArgumentException("Unknown class: " + b);
    }
}

