/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.util.Dates;
import org.brunel.data.util.ItemsList;
import org.brunel.data.util.Range;
import org.brunel.translator.JSTranslation;

public class Data {
    @JSTranslation(ignore=true)
    public static final double MILLIS_PER_DAY = 8.64E7;
    @JSTranslation(ignore=true)
    private static final DecimalFormat bigIntegerFormat = new DecimalFormat("0,000");
    @JSTranslation(ignore=true)
    private static final DecimalFormat integerFormat = new DecimalFormat("0");
    @JSTranslation(ignore=true)
    private static final DecimalFormat[] numericFormatGrouped = new DecimalFormat[]{new DecimalFormat("#,###"), new DecimalFormat("#,###.#"), new DecimalFormat("#,###.##"), new DecimalFormat("#,###.###"), new DecimalFormat("#,###.####"), new DecimalFormat("#,###.#####"), new DecimalFormat("#,###.######"), new DecimalFormat("#,###.#######")};
    @JSTranslation(ignore=true)
    private static final DecimalFormat[] numericFormat = new DecimalFormat[]{new DecimalFormat("#"), new DecimalFormat("#.#"), new DecimalFormat("#.##"), new DecimalFormat("#.###"), new DecimalFormat("#.####"), new DecimalFormat("#.#####"), new DecimalFormat("#.######"), new DecimalFormat("#.#######")};
    @JSTranslation(ignore=true)
    private static final DecimalFormat scientificFormat = new DecimalFormat("0.0##E0");

    public static int indexOf(double v, Double[] d) {
        int low = -1;
        int high = d.length;
        while (high - low > 1) {
            int mid = (int)((double)(high + low) / 2.0);
            if (d[mid] <= v) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return low;
    }

    @JSTranslation(ignore=true)
    public static String join(Collection<?> items) {
        return Data.join(items, null);
    }

    public static String join(Collection<?> items, String inter) {
        if (inter == null) {
            inter = ", ";
        }
        String s = "";
        boolean first = true;
        for (Object o : items) {
            if (!first) {
                s = s + inter;
            }
            s = s + Data.format(o, false);
            first = false;
        }
        return s;
    }

    @JSTranslation(js={"if (o == null) return '?';", "if (typeof(o) == 'number') return $$CLASS$$.formatNumeric(o, null, useGrouping);", "return '' + o;"})
    public static String format(Object o, boolean useGrouping) {
        if (o == null) {
            return "?";
        }
        if (o instanceof Number) {
            return Data.formatNumeric(((Number)o).doubleValue(), null, useGrouping);
        }
        return o.toString();
    }

    @JSTranslation(js={"if (d == 0) return '0';", "if (Math.abs(d) <= 1e-6 || Math.abs(d) >= 1e8) return $.formatScientific(d);", "if (Math.abs((d - Math.round(d)) / d) < 1e-9) return $.formatInt(Math.round(d), useGrouping);", "return $.formatFixed(d, decimalPlaces == null ? 6 : decimalPlaces, useGrouping);"})
    public static String formatNumeric(double d, Number decimalPlaces, boolean useGrouping) {
        if (d == 0.0) {
            return "0";
        }
        if (Math.abs(d) <= 1.0E-6 || Math.abs(d) >= 1.0E8) {
            return scientificFormat.format(d).replace('E', 'e');
        }
        if (Math.abs((d - (double)Math.round(d)) / d) < 1.0E-9) {
            return Math.abs(d) >= 10000.0 && useGrouping ? bigIntegerFormat.format(d) : integerFormat.format(d);
        }
        int place = decimalPlaces != null ? decimalPlaces.intValue() : 7 - Math.min(7, Math.max(0, (int)Math.floor(Math.log10(d))));
        return (useGrouping ? numericFormatGrouped : numericFormat)[place].format(d);
    }

    @JSTranslation(ignore=true)
    public static String join(double[] items) {
        Object[] oo = new Double[items.length];
        for (int i = 0; i < oo.length; ++i) {
            oo[i] = items[i];
        }
        return Data.join(oo, null);
    }

    @JSTranslation(ignore=true)
    public static String join(int[] items) {
        Object[] oo = new Integer[items.length];
        for (int i = 0; i < oo.length; ++i) {
            oo[i] = items[i];
        }
        return Data.join(oo, null);
    }

    @JSTranslation(ignore=true)
    public static String join(Object[] items, String inter) {
        if (inter == null) {
            inter = ", ";
        }
        String s = "";
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                s = s + inter;
            }
            s = s + Data.format(items[i], false);
        }
        return s;
    }

    @JSTranslation(ignore=true)
    public static String join(Object[] items) {
        return Data.join(items, null);
    }

    @JSTranslation(js={"if (c == null) return null;", "if (c && c.asNumeric) return c.asNumeric();", "if (c && c.getTime) return c.getTime() / 86400000;", "var v = Number(c); ", "if (!isNaN(v)) return v;", "return null;"})
    public static Double asNumeric(Object c) {
        if (c == null) {
            return null;
        }
        Double d = null;
        if (c instanceof Double) {
            d = (Double)c;
        }
        if (c instanceof Number) {
            d = ((Number)c).doubleValue();
        }
        if (c instanceof Range) {
            return ((Range)c).asNumeric();
        }
        if (c instanceof Date) {
            return (double)((Date)c).getTime() / 8.64E7;
        }
        if (c instanceof String) {
            try {
                String s = ((String)c).trim();
                if (s.isEmpty()) {
                    return null;
                }
                d = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d == null || Double.isNaN(d) ? null : d;
    }

    @JSTranslation(js={"$.sort(data, $$CLASS$$.compare)"})
    public static void sort(Object[] data) {
        Arrays.sort(data, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return Data.compare(o1, o2);
            }
        });
    }

    @JSTranslation(js={"return $.compare(a,b);"})
    public static int compare(Object a, Object b) {
        if (a == null) {
            return b == null ? 0 : 1;
        }
        if (b == null) {
            return -1;
        }
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        if (a.getClass() != b.getClass()) {
            return a.getClass().getCanonicalName().compareTo(b.getClass().getCanonicalName());
        }
        return ((Comparable)a).compareTo(b);
    }

    @JSTranslation(ignore=true)
    public static Field toDate(Field f) {
        return Data.toDate(f, null);
    }

    public static Field toDate(Field f, String method) {
        if (f.isDate()) {
            return f;
        }
        Object[] data = new Date[f.rowCount()];
        boolean changed = false;
        for (int i = 0; i < data.length; ++i) {
            Double v;
            Object o = f.value(i);
            if ("year".equals(method)) {
                v = Data.asNumeric(o);
                if (v != null && v > 0.0) {
                    data[i] = Data.asDate(Data.format(v, false) + "-01-01");
                }
            } else if ("excel".equals(method)) {
                v = Data.asNumeric(o);
                if (v != null) {
                    data[i] = Data.asDate(v - 24107.0);
                }
            } else {
                data[i] = Data.asDate(o);
            }
            if (changed) continue;
            changed = Data.compare(o, data[i]) != 0;
        }
        Field result = Fields.makeColumnField(f.name, f.label, data);
        result.set("date", true);
        result.setNumeric();
        return result;
    }

    @JSTranslation(js={"if (c==null) return null;", "if (c.getTime) return c;", "if (typeof c == 'string') {d = $.parseDate(c); return d == null || isNaN(d.getTime()) ? null : d };", "if (!isNaN(c)) return new Date(c*86400000);", "return null;"})
    public static Date asDate(Object c) {
        return Dates.parse(c);
    }

    public static Field toNumeric(Field f) {
        if (f.isNumeric()) {
            return f;
        }
        Object[] data = new Number[f.rowCount()];
        for (int i = 0; i < data.length; ++i) {
            Object o = f.value(i);
            data[i] = Data.asNumeric(o);
        }
        Field result = Fields.makeColumnField(f.name, f.label, data);
        result.setNumeric();
        return result;
    }

    public static Field toList(Field base) {
        char sep = ',';
        int nSep = -1;
        for (char s : new char[]{',', ';', '|'}) {
            int c = 0;
            for (Object o : base.categories()) {
                if (o.toString().indexOf(c) < 0) continue;
                ++c;
            }
            if (c <= nSep) continue;
            sep = s;
            nSep = c;
        }
        int n = base.rowCount();
        HashMap<String, String> commonParts = new HashMap<String, String>();
        Object[] items = new ItemsList[n];
        for (int i = 0; i < n; ++i) {
            Object o = base.value(i);
            if (o == null) continue;
            ArrayList<String> valid = new ArrayList<String>();
            for (String s : Data.split(o.toString(), sep)) {
                if ((s = s.trim()).length() <= 0) continue;
                String common = (String)commonParts.get(s);
                if (common == null) {
                    common = s;
                    commonParts.put(common, s);
                }
                valid.add(common);
            }
            items[i] = new ItemsList(valid.toArray(new String[valid.size()]));
        }
        Field f = Fields.makeColumnField(base.name, base.label, items);
        Collection parts = commonParts.values();
        Object[] common = parts.toArray(new String[parts.size()]);
        Arrays.sort(common);
        f.set("list", true);
        f.set("listCategories", common);
        return f;
    }

    @JSTranslation(js={"return text.split(sep);"})
    public static String[] split(String text, char sep) {
        return text.split("\\" + sep);
    }

    public static boolean isQuoted(String txt) {
        if (txt == null || txt.length() < 2) {
            return false;
        }
        char c = txt.charAt(0);
        return c == '\"' || c == '\'' && txt.charAt(txt.length() - 1) == c;
    }

    public static String deQuote(String s) {
        String text = "";
        int n = s.length() - 1;
        for (int i = 1; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if ((c = s.charAt(++i)) == 'n') {
                    text = text + "\n";
                    continue;
                }
                if (c == 't') {
                    text = text + "\t";
                    continue;
                }
                text = text + c;
                continue;
            }
            text = text + c;
        }
        return text;
    }

    public static String quote(String s) {
        if (s == null) {
            return "null";
        }
        char quoteChar = '\'';
        if (s.indexOf(quoteChar) >= 0) {
            quoteChar = '\"';
        }
        String text = "";
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            text = c == '\n' ? text + "\\n" : (c == '\t' ? text + "\\t" : (c == '\\' ? text + "\\\\" : (c == quoteChar ? text + "\\" + c : text + c)));
        }
        return quoteChar + text + quoteChar;
    }

    @JSTranslation(ignore=true)
    public static Integer[] order(int[] c, boolean ascending) {
        Object[] cc = new Integer[c.length];
        for (int i = 0; i < cc.length; ++i) {
            cc[i] = c[i];
        }
        return Data.order(cc, ascending);
    }

    @JSTranslation(js={"var v = [];", "for (var i=0; i<c.length; i++) v.push(i);", "v.sort(function(s,t) { var r= $.compare(c[s], c[t]); return ascending ? r : -r});", "return v;"})
    public static Integer[] order(Object[] c, boolean ascending) {
        Integer[] o = new Integer[c.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = i;
        }
        Arrays.sort(o, new IndexedCompare(c, ascending));
        return o;
    }

    @JSTranslation(js={"return items;"})
    public static int[] toPrimitive(Integer[] items) {
        int[] result = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = items[i];
        }
        return result;
    }

    @JSTranslation(ignore=true)
    static class IndexedCompare
    implements Comparator<Integer> {
        private final Object[] base;
        private final boolean ascending;

        public IndexedCompare(Object[] base, boolean ascending) {
            this.base = base;
            this.ascending = ascending;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            int v = Data.compare(this.base[o1], this.base[o2]);
            return this.ascending ? v : -v;
        }
    }
}

