/*
---

description: Port of bgiframe plugin for mootools

authors:
 - Fábio Miranda Costa

requires:
 - Core/Class.Extras

license: MIT-style license Original plugin copyright Copyright (c) 2006 Brandon Aaron (http://brandonaaron.net) Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses. Version 2.1.1

provides: [BGIFrame]

...
*/
/*
---

description: A plugin for enabling autocomplete of a text input or textarea.

authors:
 - Fábio Miranda Costa

requires:
 - Core/Class.Extras
 - Core/Element.Event
 - Core/Element.Style
 - More/Element.Forms

license: MIT-style license

provides: [Meio.Autocomplete]

...
*/
(function(B,C){var D=Browser.ie6;var A=new Class({Implements:Options,options:{top:"auto",left:"auto",width:"auto",height:"auto",opacity:true,src:"javascript:false;"},initialize:function(F,E){if(!D){return }this.setOptions(E);this.element=C(F);var G=this.element.getFirst();if(!(G&&G.hasClass("bgiframe"))){this.element.grab(document.createElement(this.render()),"top")}},toPx:function(E){return isFinite(E)?E+"px":E},render:function(){var E=this.options;return'<iframe class="bgiframe" frameborder="0" tabindex="-1" src="'+E.src+'" style="display:block;position:absolute;z-index:-1;'+(E.opacity!==false?"filter:alpha(opacity='0');":"")+"top:"+(E.top=="auto"?"expression(((parseInt(this.parentNode.currentStyle.borderTopWidth)||0)*-1)+'px')":this.toPx(E.top))+";left:"+(E.left=="auto"?"expression(((parseInt(this.parentNode.currentStyle.borderLeftWidth)||0)*-1)+'px')":this.toPx(E.left))+";width:"+(E.width=="auto"?"expression(this.parentNode.offsetWidth+'px')":this.toPx(E.width))+";height:"+(E.height=="auto"?"expression(this.parentNode.offsetHeight+'px')":this.toPx(E.height))+';"/>'}});Element.implement("bgiframe",function(E){if(D){new A(this,E)}return this})})(this,document.id||$);(function(E,F){var C=Browser;Object.append(Element.NativeEvents,{"paste":2,"input":2});Element.Events.paste={base:(C.opera||(C.firefox&&C.version<3))?"input":"paste",condition:function(H){this.fireEvent("paste",H,1);return false}};Element.Events.keyrepeat={base:(C.firefox||C.opera)?"keypress":"keydown",condition:Function.from(true)};var A=E.Meio||{};var G;var B={9:1,16:1,17:1,18:1,224:1,91:1,37:1,38:1,39:1,40:1};var D=function(H){return H.replace(/"/g,"&quot;").replace(/'/g,"&#39;")};A.Widget=new Class({initialize:function(){this.elements={}},addElement:function(H,I){this.elements[H]=I},addEventToElement:function(I,H,J){this.elements[I].addEvent(H,J.bind(this))},addEventsToElement:function(I,J){for(var H in J){this.addEventToElement(I,H,J[H])}},attach:function(){for(var H in this.elements){this.elements[H].attach()}},detach:function(){for(var H in this.elements){this.elements[H].detach()}},destroy:function(){for(var H in this.elements){this.elements[H]&&this.elements[H].destroy()}}});A.Autocomplete=new Class({Extends:A.Widget,Implements:[Options,Events],options:{delay:200,minChars:0,cacheLength:20,selectOnTab:true,maxVisibleItems:10,cacheType:"shared",filter:{},fieldOptions:{},listOptions:{},requestOptions:{},urlOptions:{}},initialize:function(H,K,I,J){this.parent();this.setOptions(I);this.active=0;this.filters=A.Autocomplete.Filter.get(this.options.filter);this.addElement("list",J||new A.Element.List(this.options.listOptions));this.addListEvents();this.addElement("field",new A.Element.Field(H,this.options.fieldOptions));this.addFieldEvents();this.addSelectEvents();this.attach();this.initCache();this.initData(K)},addFieldEvents:function(){this.addEventsToElement("field",{"beforeKeyrepeat":function(J){this.active=1;var H=J.key,I=this.elements.list;if(H=="up"||H=="down"||(H=="enter"&&I.showing)){J.preventDefault()}},"delayedKeyrepeat":function(J){var H=J.key,I=this.elements.field;I.keyPressControl[H]=true;switch(H){case"up":case"down":this.focusItem(H);break;case"enter":this.setInputValue();break;case"tab":if(this.options.selectOnTab){this.setInputValue()}I.keyPressControl[H]=false;break;case"esc":this.elements.list.hide();break;default:this.setupList()}this.oldInputedText=I.node.get("value")},"keyup":function(I){var H=this.elements.field;if(!B[I.code]){if(!H.keyPressControl[I.key]){this.setupList()}H.keyPressControl[I.key]=false}},"focus":function(){this.active=1;var H=this.elements.list;H.focusedItem=null;H.positionNextTo(this.elements.field.node)},"click":function(){if(++this.active>2&&!this.elements.list.showing){this.forceSetupList()}},"blur":function(I){this.active=0;var H=this.elements.list;if(H.shouldNotBlur){this.elements.field.node.setCaretPosition("end");H.shouldNotBlur=false;if(H.focusedItem){H.hide()}}else{H.hide()}},"paste":function(){return this.setupList()}})},addListEvents:function(){this.addEventsToElement("list",{"mousedown":function(H){if(this.active&&!H.dontHide){this.setInputValue()}}})},update:function(){var N=this.data,P=this.elements.list;var R=N.getKey(),K=this.cache.get(R),O;if(K){O=K.html;this.itemsData=K.data}else{N=N.get();var T=[],S=[],L=P.options.classes,U=this.inputedText;var I=this.filters.filter,H=this.filters.formatMatch,Q=this.filters.formatItem;for(var V,M=0,J=0;V=N[M++];){if(I.call(this,U,V)){T.push('<li title="',D(H.call(this,U,V)),'" data-index="',J,'" class="',(J%2?L.even:L.odd),'">',Q.call(this,U,V,J),"</li>");S.push(V);J++}}O=T.join("");this.cache.set(R,{html:O,data:S});this.itemsData=S}P.focusedItem=null;this.fireEvent("deselect",[this.elements]);P.list.set("html",O);if(this.options.maxVisibleItems){P.applyMaxHeight(this.options.maxVisibleItems)}},setupList:function(){this.inputedText=this.elements.field.node.get("value");if(this.inputedText!==this.oldInputedText){this.forceSetupList(this.inputedText)}else{this.elements.list.hide()}return true},forceSetupList:function(H){H=H||this.elements.field.node.get("value");if(H.length>=this.options.minChars){clearInterval(this.prepareTimer);this.prepareTimer=this.data.prepare.delay(this.options.delay,this.data,this.inputedText)}},dataReady:function(){this.update();if(this.onUpdate){this.onUpdate();this.onUpdate=null}var H=this.elements.list;if(H.list.get("html")){if(this.active){H.show()}}else{this.fireEvent("noItemToList",[this.elements]);H.hide()}},setInputValue:function(){var I=this.elements.list;if(I.focusedItem){var J=I.focusedItem.get("title");this.elements.field.node.set("value",J);var H=I.focusedItem.get("data-index");this.fireEvent("select",[this.elements,this.itemsData[H],J,H])}I.hide()},focusItem:function(I){var H=this.elements.list;if(H.showing){H.focusItem(I)}else{this.forceSetupList();this.onUpdate=function(){H.focusItem(I)}}},addSelectEvents:function(){this.addEvents({select:function(H){H.field.addClass("selected")},deselect:function(H){H.field.removeClass("selected")}})},initData:function(H){this.data=(typeOf(H)=="string")?new A.Autocomplete.Data.Request(H,this.cache,this.elements.field,this.options.requestOptions,this.options.urlOptions):new A.Autocomplete.Data(H,this.cache);this.data.addEvent("ready",this.dataReady.bind(this))},initCache:function(){var H=this.options.cacheLength;if(this.options.cacheType=="shared"){this.cache=G;this.cache.setMaxLength(H)}else{this.cache=new A.Autocomplete.Cache(H)}},refreshCache:function(H){this.cache.refresh();this.cache.setMaxLength(H||this.options.cacheLength)},refreshAll:function(I,H){this.refreshCache(I);this.data.refreshKey(H)}});A.Autocomplete.Select=new Class({Extends:A.Autocomplete,options:{syncName:"id",valueField:null,valueFilter:function(H){return H.id}},initialize:function(H,K,I,J){this.parent(H,K,I,J);this.valueField=F(this.options.valueField);if(!this.valueField){return }this.syncWithValueField(K)},syncWithValueField:function(I){var H=this.getValueFromValueField();if(H&&this.options.syncName){this.addParameter(I);this.addDataReadyEvent(H);this.data.prepare(this.elements.field.node.get("value"))}else{this.addValueFieldEvents()}},addValueFieldEvents:function(){this.addEvents({"select":function(I,H){this.valueField.set("value",this.options.valueFilter.call(this,H))},"deselect":function(H){this.valueField.set("value","")}})},addParameter:function(H){this.parameter={name:this.options.syncName,value:function(){return this.valueField.value}.bind(this)};if(this.data.url){this.data.url.addParameter(this.parameter)}},addDataReadyEvent:function(J){var I=this;var H=function(){I.addValueFieldEvents();var K=this.get();for(var L=K.length;L--;){if(I.options.valueFilter.call(I,K[L])==J){var M=I.filters.formatMatch.call(I,"",K[L],0);I.elements.field.node.set("value",M);I.fireEvent("select",[I.elements,K[L],M,L]);break}}if(this.url){this.url.removeParameter(I.parameter)}this.removeEvent("ready",H)};this.data.addEvent("ready",H)},getValueFromValueField:function(){return this.valueField.get("value")}});A.Autocomplete.Select.One=new Class({Extends:A.Autocomplete.Select,options:{filter:{path:"text"}},initialize:function(H,I,J){this.select=F(H);this.replaceSelect();this.parent(this.field,this.createDataArray(),Object.merge(I||{},{valueField:this.select,valueFilter:function(K){return K.value}}),J)},replaceSelect:function(){var H=this.select.getSelected()[0];this.field=new Element("input",{type:"text"});var I=H.get("value");if(I||I===0){this.field.set("value",H.get("html"))}this.select.setStyle("display","none");this.field.inject(this.select,"after")},createDataArray:function(){var I=this.select.options,K=[];for(var J=0,H,L;H=I[J++];){L=H.value;if(L||L===0){K.push({value:L,text:H.innerHTML})}}return K},addValueFieldEvents:function(){this.addEvents({"select":function(K,J,L,H){var I=this.valueField.getElement('option[value="'+this.options.valueFilter.call(this,J)+'"]');if(I){I.selected=true}},"deselect":function(I){var H=this.valueField.getSelected()[0];if(H){H.selected=false}}})},getValueFromValueField:function(){return this.valueField.getSelected()[0].get("value")}});A.Element=new Class({Implements:[Events],initialize:function(H){this.setNode(H);this.createBoundEvents();this.attach()},setNode:function(H){this.node=H?F(H)||$$(H)[0]:this.render()},createBoundEvents:function(){this.bound={};this.boundEvents.each(function(H){this.bound[H]=function(I){this.fireEvent("before"+H.capitalize(),I);this[H]&&this[H](I);this.fireEvent(H,I);return true}.bind(this)},this)},attach:function(){for(var H in this.bound){this.node.addEvent(H,this.bound[H])}},detach:function(){for(var H in this.bound){this.node.removeEvent(H,this.bound[H])}},addClass:function(H){this.node.addClass(this.options.classes[H])},removeClass:function(H){this.node.removeClass(this.options.classes[H])},toElement:function(){this.node},render:function(){}});A.Element.Field=new Class({Extends:A.Element,Implements:[Options],options:{classes:{loading:"ma-loading",selected:"ma-selected"}},initialize:function(I,H){this.keyPressControl={};this.boundEvents=["paste","focus","blur","click","keyup","keyrepeat"];if(C.ie6){this.boundEvents.push("keypress")}this.setOptions(H);this.parent(I);F(E).addEvent("unload",function(){if(this.node){this.node.set("autocomplete","on")}}.bind(this))},setNode:function(H){this.parent(H);this.node.set("autocomplete","off")},keyrepeat:function(H){clearInterval(this.keyrepeatTimer);this.keyrepeatTimer=this._keyrepeat.delay(1,this,H)},_keyrepeat:function(H){this.fireEvent("delayedKeyrepeat",H)},destroy:function(){this.detach();this.node.removeAttribute("autocomplete")},keypress:function(H){if(H.key=="enter"){this.bound.keyrepeat(H)}}});A.Element.List=new Class({Extends:A.Element,Implements:[Options],options:{width:"field",classes:{container:"ma-container",hover:"ma-hover",odd:"ma-odd",even:"ma-even"}},initialize:function(H){this.boundEvents=["mousedown","mouseover"];this.setOptions(H);this.parent();this.focusedItem=null},applyMaxHeight:function(K){var H=this.list.childNodes;var J=H[K-1]||(H.length?H[H.length-1]:null);if(!J){return }J=F(J);for(var I=2;I--;){this.node.setStyle("height",J.getCoordinates(this.list).bottom)}},mouseover:function(I){var H=this.getItemFromEvent(I),J=this.options.classes.hover;if(!H){return true}if(this.focusedItem){this.focusedItem.removeClass(J)}H.addClass(J);this.focusedItem=H;this.fireEvent("focusItem",[this.focusedItem])},mousedown:function(H){H.preventDefault();this.shouldNotBlur=true;if(!(this.focusedItem=this.getItemFromEvent(H))){H.dontHide=true;return true}this.focusedItem.removeClass(this.options.classes.hover)},focusItem:function(I){var J=this.options.classes.hover,H;if(this.focusedItem){if((H=this.focusedItem[I=="up"?"getPrevious":"getNext"]())){this.focusedItem.removeClass(J);H.addClass(J);this.focusedItem=H;this.scrollFocusedItem(I)}}else{if((H=this.list.getFirst())){H.addClass(J);this.focusedItem=H}}},scrollFocusedItem:function(K){var H=this.focusedItem.getCoordinates(this.list),J=this.node.scrollTop;if(K=="down"){var L=H.bottom-this.node.getStyle("height").toInt();if((L-J)>0){this.node.scrollTop=L}}else{var I=H.top;if(J&&J>I){this.node.scrollTop=I}}},getItemFromEvent:function(I){var H=I.target;while(H&&H.tagName.toLowerCase()!="li"){if(H===this.node){return null}H=H.parentNode}return F(H)},render:function(){var H=new Element("div",{"class":this.options.classes.container});if(H.bgiframe){H.bgiframe({top:0,left:0})}this.list=new Element("ul").inject(H);F(document.body).grab(H);return H},positionNextTo:function(H){var I=this.options.width,J=this.node;var K=H.getCoordinates();J.setStyle("width",I=="field"?H.getWidth().toInt()-J.getStyle("border-left-width").toInt()-J.getStyle("border-right-width").toInt():I);J.setPosition({x:K.left,y:K.bottom})},show:function(){this.node.scrollTop=0;this.node.setStyle("visibility","visible");this.showing=true},hide:function(){this.showing=false;this.node.setStyle("visibility","hidden")}});A.Autocomplete.Filter={filters:{},get:function(H){var I=H.type,K=(H.path||"").split(".");var J=(I&&this.filters[I])?this.filters[I](this,K):H;return Object.merge(this.defaults(K),J)},define:function(I,H){this.filters[I]=H},defaults:function(I){var H=this;return{filter:function(K,J){return K?H._getValueFromKeys(J,I).test(new RegExp(K.escapeRegExp(),"i")):true},formatMatch:function(K,J){return H._getValueFromKeys(J,I)},formatItem:function(L,K,J){return L?H._getValueFromKeys(K,I).replace(new RegExp("("+L.escapeRegExp()+")","gi"),"<strong>$1</strong>"):H._getValueFromKeys(K,I)}}},_getValueFromKeys:function(L,J){var I,K=L;for(var H=0;I=J[H++];){K=K[I]}return K}};A.Autocomplete.Filter.define("contains",function(H,I){return{}});A.Autocomplete.Filter.define("startswith",function(H,I){return{filter:function(K,J){return K?H._getValueFromKeys(J,I).test(new RegExp("^"+K.escapeRegExp(),"i")):true}}});A.Autocomplete.Data=new Class({Implements:[Options,Events],initialize:function(I,H){this._cache=H;this.data=I;this.dataString=JSON.encode(this.data)},get:function(){return this.data},getKey:function(){return this.cachedKey},prepare:function(H){this.cachedKey=this.dataString+(H||"");this.fireEvent("ready")},cache:function(H,I){this._cache.set(H,I)},refreshKey:function(){}});A.Autocomplete.Data.Request=new Class({Extends:A.Autocomplete.Data,options:{noCache:true,formatResponse:function(H){return H}},initialize:function(K,I,L,J,H){this.setOptions(J);this.rawUrl=K;this._cache=I;this.element=L;this.urlOptions=H;this.refreshKey();this.createRequest()},prepare:function(H){this.cachedKey=this.url.evaluate(H);if(this._cache.has(this.cachedKey)){this.fireEvent("ready")}else{this.request.send({url:this.cachedKey})}},createRequest:function(){var H=this;this.request=new Request.JSON(this.options);this.request.addEvents({request:function(){H.element.addClass("loading")},complete:function(){H.element.removeClass("loading")},success:function(I){H.data=H.options.formatResponse(I);H.fireEvent("ready")}})},refreshKey:function(H){H=Object.merge(this.urlOptions,{url:this.rawUrl},H||{});this.url=new A.Autocomplete.Data.Request.URL(H.url,H)}});A.Autocomplete.Data.Request.URL=new Class({Implements:[Options],options:{queryVarName:"q",extraParams:null,max:20},initialize:function(I,H){this.setOptions(H);this.rawUrl=I;this.url=I;this.url+=this.url.contains("?")?"&":"?";this.dynamicExtraParams=[];var K=Array.from(this.options.extraParams);for(var J=K.length;J--;){this.addParameter(K[J])}if(this.options.max){this.addParameter("limit="+this.options.max)}},evaluate:function(K){K=K||"";var J=this.dynamicExtraParams,H=[];H.push(this.options.queryVarName+"="+encodeURIComponent(K));for(var I=J.length;I--;){H.push(encodeURIComponent(J[I].name)+"="+encodeURIComponent(Function.from(J[I].value)()))}return this.url+H.join("&")},addParameter:function(H){if(H.nodeType==1||typeOf(H.value)=="function"){this.dynamicExtraParams.push(H)}else{this.url+=((typeOf(H)=="string")?H:encodeURIComponent(H.name)+"="+encodeURIComponent(H.value))+"&"}},removeParameter:function(H){this.dynamicExtraParams.erase(H)}});A.Autocomplete.Cache=new Class({initialize:function(H){this.refresh();this.setMaxLength(H)},set:function(H,I){if(!this.cache[H]){if(this.getLength()>=this.maxLength){var J=this.pos.shift();this.cache[J]=null;delete this.cache[J]}this.cache[H]=I;this.pos.push(H)}return this},get:function(H){return this.cache[H||""]||null},has:function(H){return !!this.get(H)},getLength:function(){return this.pos.length},refresh:function(){this.cache={};this.pos=[]},setMaxLength:function(H){this.maxLength=Math.max(H,1)}});G=new A.Autocomplete.Cache();E.Meio=A})(this,document.id||$)