# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class ShareDestinationFormatType(str, Enum):

    unknown_type = "UnknownType"  #: Unknown format.
    hcs = "HCS"  #: StorSimple data format.
    block_blob = "BlockBlob"  #: Azure storage block blob format.
    page_blob = "PageBlob"  #: Azure storage page blob format.
    azure_file = "AzureFile"  #: Azure storage file format.
    managed_disk = "ManagedDisk"  #: Azure Compute Disk.


class AccessProtocol(str, Enum):

    smb = "SMB"  #: Server Message Block protocol(SMB).
    nfs = "NFS"  #: Network File System protocol(NFS).


class AddressValidationStatus(str, Enum):

    valid = "Valid"  #: Address provided is valid.
    invalid = "Invalid"  #: Address provided is invalid or not supported.
    ambiguous = "Ambiguous"  #: Address provided is ambiguous, please choose one of the alternate addresses returned.


class AddressType(str, Enum):

    none = "None"  #: Address type not known.
    residential = "Residential"  #: Residential Address.
    commercial = "Commercial"  #: Commercial Address.


class SkuName(str, Enum):

    data_box = "DataBox"  #: DataBox.
    data_box_disk = "DataBoxDisk"  #: DataBoxDisk.
    data_box_heavy = "DataBoxHeavy"  #: DataBoxHeavy.


class SkuDisabledReason(str, Enum):

    none = "None"  #: SKU is not disabled.
    country = "Country"  #: SKU is not available in the requested country.
    region = "Region"  #: SKU is not available to push data to the requested Azure region.
    feature = "Feature"  #: Required features are not enabled for the SKU.
    offer_type = "OfferType"  #: Subscription does not have required offer types for the SKU.
    no_subscription_info = "NoSubscriptionInfo"  #: Subscription has not registered to Microsoft.DataBox and Service does not have the subscription notification.


class NotificationStageName(str, Enum):

    device_prepared = "DevicePrepared"  #: Notification at device prepared stage.
    dispatched = "Dispatched"  #: Notification at device dispatched stage.
    delivered = "Delivered"  #: Notification at device delivered stage.
    picked_up = "PickedUp"  #: Notification at device picked up from user stage.
    at_azure_dc = "AtAzureDC"  #: Notification at device received at azure datacenter stage.
    data_copy = "DataCopy"  #: Notification at data copy started stage.


class CopyStatus(str, Enum):

    not_started = "NotStarted"  #: Data copy hasn't started yet.
    in_progress = "InProgress"  #: Data copy is in progress.
    completed = "Completed"  #: Data copy completed.
    completed_with_errors = "CompletedWithErrors"  #: Data copy completed with errors.
    failed = "Failed"  #: Data copy failed. No data was copied.
    not_returned = "NotReturned"  #: No copy triggered as device was not returned.


class StageName(str, Enum):

    device_ordered = "DeviceOrdered"  #: An order has been created.
    device_prepared = "DevicePrepared"  #: A device has been prepared for the order.
    dispatched = "Dispatched"  #: Device has been dispatched to the user of the order.
    delivered = "Delivered"  #: Device has been delivered to the user of the order.
    picked_up = "PickedUp"  #: Device has been picked up from user and in transit to azure datacenter.
    at_azure_dc = "AtAzureDC"  #: Device has been received at azure datacenter from the user.
    data_copy = "DataCopy"  #: Data copy from the device at azure datacenter.
    completed = "Completed"  #: Order has completed.
    completed_with_errors = "CompletedWithErrors"  #: Order has completed with errors.
    cancelled = "Cancelled"  #: Order has been cancelled.
    failed_issue_reported_at_customer = "Failed_IssueReportedAtCustomer"  #: Order has failed due to issue reported by user.
    failed_issue_detected_at_azure_dc = "Failed_IssueDetectedAtAzureDC"  #: Order has failed due to issue detected at azure datacenter.
    aborted = "Aborted"  #: Order has been aborted.


class StageStatus(str, Enum):

    none = "None"  #: No status available yet.
    in_progress = "InProgress"  #: Stage is in progress.
    succeeded = "Succeeded"  #: Stage has succeeded.
    failed = "Failed"  #: Stage has failed.
    cancelled = "Cancelled"  #: Stage has been cancelled.
    cancelling = "Cancelling"  #: Stage is cancelling.
    succeeded_with_errors = "SucceededWithErrors"  #: Stage has succeeded with errors.
