# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.7
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.





from sys import version_info
if version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_v8eval', [dirname(__file__)])
        except ImportError:
            import _v8eval
            return _v8eval
        if fp is not None:
            try:
                _mod = imp.load_module('_v8eval', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _v8eval = swig_import_helper()
    del swig_import_helper
else:
    import _v8eval
del version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.


def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr_nondynamic(self, class_type, name, static=1):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    if (not static):
        return object.__getattr__(self, name)
    else:
        raise AttributeError(name)

def _swig_getattr(self, class_type, name):
    return _swig_getattr_nondynamic(self, class_type, name, 0)


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object:
        pass
    _newclass = 0



def initialize():
    return _v8eval.initialize()
initialize = _v8eval.initialize

def dispose():
    return _v8eval.dispose()
dispose = _v8eval.dispose
class _V8(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _V8, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _V8, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _v8eval.new__V8()
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _v8eval.delete__V8
    __del__ = lambda self: None

    def eval(self, src):
        return _v8eval._V8_eval(self, src)

    def call(self, func, args):
        return _v8eval._V8_call(self, func, args)

    def enable_debugger(self, port):
        return _v8eval._V8_enable_debugger(self, port)

    def disable_debugger(self):
        return _v8eval._V8_disable_debugger(self)
_V8_swigregister = _v8eval._V8_swigregister
_V8_swigregister(_V8)

# This file is compatible with both classic and new-style classes.


# the following is appended to swig-generated file including _V8
import json


class V8Error(Exception):
    """Represents a V8 exception.

    Args:
        message (str): The message of a V8 exception.
    """
    def __init__(self, message):
        self.message = message

    def __str__(self):
        return self.message


class V8:
    """Represents a V8 instance."""
    def __init__(self):
        self._v8 = _V8()

    def eval(self, src):
        """Evaluates JavaScript code.

        Args:
            src (str): JavaScript code.

        Returns:
            The result of the JavaScript code.
            The result is marshalled/unmarshalled by using JSON.

        Raises:
            TypeError: If src is not a string.

            V8Error: If some JavaScript exception happens.
        """
        if not isinstance(src, basestring):
            raise TypeError('source code not string')

        res = self._v8.eval(src)
        if res == 'undefined':
            return None
        else:
            try:
                return json.loads(res)
            except ValueError:
                raise V8Error(res)

    def call(self, func, args):
        """Calls a JavaScript function.

        Args:
            func (str): Name of a JavaScript function.

            args (list): Argument list to pass.

        Returns:
            The result of the JavaScript function.
            The result is marshalled/unmarshalled by using JSON.

        Raises:
            TypeError: If either func is not a string or args is not a list.

            V8Error: If some JavaScript exception happens.
        """
        if not isinstance(func, basestring):
            raise TypeError('function name not string')
        if not isinstance(args, list):
            raise TypeError('arguments not list')

        args_str = json.dumps(args)
        res = self._v8.call(func, args_str)
        if res == 'undefined':
            return None
        else:
            try:
                return json.loads(res)
            except ValueError:
                raise V8Error(res)

    def enable_debugger(self, port):
        """"Starts a debug server associated with the V8 instance.

        Args:
            port (int): The TCP/IP port the server will listen, at localhost.

        Return:
            None.

        Raises:
            TypeError: If port is not an int.

            V8Error: If failing to start the debug server.
        """
        if not isinstance(port, int):
            raise TypeError('port not integer')

        if not self._v8.enable_debugger(port):
            raise V8Error('failed to start debug server')

    def disable_debugger(self):
        """"Stops the debug server, if running.

        Args:
            None.

        Returns:
            None.

        Raises:
            None.
        """
        self._v8.disable_debugger()

# initialize the V8 runtime environment
initialize()
