# -*- coding: utf-8 -*-

"""This code is a part of Hydra Toolkit

.. module:: hydratk.translation.en.messages
   :platform: Unix
   :synopsis: English language translation for global messages
.. moduleauthor:: Petr Czaderna <pc@hydratk.org>

"""

language = {
  'name' : 'English',
  'ISO-639-1' : 'en'
}

from hydratk.core import const

HIGHLIGHT_START = chr(27)+chr(91)+"1m"
HIGHLIGHT_US    = chr(27)+chr(91)+"4m"
HIGHLIGHT_END   = chr(27)+chr(91)+"0m"

msg = {
    'htk_print_short_desc'            : [HIGHLIGHT_START + const.APP_NAME +" v"+ const.APP_VERSION + const.APP_REVISION + HIGHLIGHT_END + " for Unix operating systems"],
    'htk_print_cp_string'             : ["(c) " + const.APP_AUTHORS + " " + "(" + const.APP_DEVEL_YEAR + ")"],
    'htk_unknown_command'             : ["Unknown command: " + HIGHLIGHT_START +"{0}" + HIGHLIGHT_END +", for help type command " + HIGHLIGHT_START + "help" + HIGHLIGHT_END],
    'htk_help_syntax'                 : ["Usage: " + HIGHLIGHT_START + "{0} [options] command" + HIGHLIGHT_END],
    'htk_help_commands'               : [HIGHLIGHT_US + 'Commands:' + HIGHLIGHT_END],
    'htk_help_command'                : [HIGHLIGHT_US + 'Command:' + HIGHLIGHT_END],
    'htk_help_options'                : [HIGHLIGHT_US + 'Options:' + HIGHLIGHT_END],
    'htk_help_option'                 : [HIGHLIGHT_US + 'Option:' + HIGHLIGHT_END],
    'htk_help_glob_options'           : [HIGHLIGHT_US + 'Global Options:' + HIGHLIGHT_END], 
    'htk_help_on_help'                : ["For list of the all available commands and options type " + HIGHLIGHT_START + "{0} help" + HIGHLIGHT_END],
    'htk_invalid_cmd'                 : ["Invalid command: {0}"],
    'htk_undetected_cmd'              : ["Input command was not detected"],
    'htk_app_start'                   : ["Starting application"],
    'htk_app_stop'                    : ["Stopping application"],
    'htk_app_exit'                    : ["Application exit"],
    'htk_conf_not_exists'             : ["Config file '{0}' doesn't exists"],
    'htk_opt_set'                     : ["Option '{0}' set to: '{0}'"],
    'htk_unrecognized_opt'            : ["Option '{0}' is not recognized"],
    'htk_opt_ignore'                  : ["Option setting '{0}' was ignored, because of invalid value: '{0}'"],
    'htk_conf_opt_missing'            : ["Config error, section: '{0}', option: '{1}' is not defined"],
    'htk_conf_opt_val_err'            : ["Config error, section: '{0}', option: '{1}' incorrect value"],
    'htk_debug_enabled'               : ["Starting application in debug mode"], 
    'htk_lang_set'                    : ["Language set to '{0}'"],
    'htk_run_mode_set'                : ["Run mode set to '{0} ({1})'"], 
    'htk_invalid_run_mode_set'        : ["Run mode '{0}' is not supported"],    
    'htk_invalid_lang_set'            : ["Language '{0}' is not supported"],
    'htk_invalid_debug_level_set'     : ["Debug level '{0}' is not supported"],
    'htk_debug_level_set'             : ["Debug level set to {0}"],
    'htk_invalid_debug_channel_set'   : ["Debug channel '{0}' is not supported"],
    'htk_debug_channel_set'           : ["Debug channel set to {0}"],
    'htk_msg_router_id_set'           : ["Main message router id set to '{0}'"],
    'htk_msg_router_init_ok'          : ["Message Router '{0}' initialized successfully"],
    'htk_core_msg_service_add_ok'     : ["Core message service '{0}' registered successfully"],
    'htk_core_msgq_init_ok'           : ["Core message queue '{0}' initialized successfully"],
    'htk_core_msgq_connect_ok'        : ["Core message queue '{0}' connected successfully"],
    'htk_load_int_ext'                : ["Loading internal extension: '{0}'"],
    'htk_load_int_ext_success'        : ["Internal extension: '{0}' loaded successfully"], 
    'htk_load_ext_ext'                : ["Loading external extension: '{0}'"],
    'htk_load_ext_msg'                : ["Trying to to load extension messages for language {0}, package '{1}'"],
    'htk_load_ext_msg_success'        : ["Extensions messages for language {0}, loaded successfully"],
    'htk_load_ext_msg_failed'         : ["Failed to load extension messages for language {0}, reason: {1}"],
    'htk_load_ext_help'               : ["Trying to to load extension help for language {0}, package '{1}'"],
    'htk_load_ext_help_failed'        : ["Failed to load extension help for language {0}, reason: {1}"],
    'htk_load_global_msg'             : ["Trying to to load global messages for language '{0}', package '{1}'"],
    'htk_load_global_msg_success'     : ["Global messages for language {0}, loaded successfully"],
    'htk_load_global_msg_failed'      : ["Failed to load global messages for language {0}, reason: {1}"],
    'htk_load_global_help'            : ["Trying to to load global help for language {0}, package '{1}'"],
    'htk_load_global_help_success'    : ["Global help for language {0}, loaded successfully"],
    'htk_load_global_help_failed'     : ["Failed to load global help for language {0}, reason: {1}"],
    'htk_load_package_msg'            : ["Trying to to load package {0} messages for language '{1}'"],
    'htk_load_package_msg_success'    : ["Package {0} messages for language {1}, loaded successfully"],
    'htk_load_package_msg_failed'     : ["Failed to load package {0} messages for language {1}, reason: {2}"],
    'htk_ext_ext_dir_not_exists'      : ["External extension directory '{0}' configured, but doesn't exists"],
    'htk_fin_load_int_ext'            : ["Finished loading internal extensions"],
    'htk_fin_load_ext_ext'            : ["Finished loading external extensions"],
    'htk_load_ext_ext_success'        : ["External extension: '{0}' loaded successfully"], 
    'htk_fail_load_int_ext'           : ["Loading internal extension: '{0}' failed with error: {1}"],
    'htk_fail_init_int_ext'           : ["Initialization of internal extension: '{0}' failed with error: {1}"], 
    'htk_fail_load_ext_ext'           : ["Loading external extension: '{0}' failed with error: {1}"],  
    'htk_fail_to_create_obj'          : ["Creating object failed"],
    'htk_cthread_init'                : ["Initializing core thread id: {0}"],
    'htk_cworker_init'                : ["Starting to work"],
    'htk_cworker_term'                : ["Terminating work"],
    'htk_cthread_destroy'             : ["Destroying core thread id: {0}"],
    'htk_cthread_sleep'               : ["Sleeping..."],
    'htk_cthread_awake'               : ["Awake"],
    'htk_core_workers_num_set'        : ["Number of core workers set to: {0}"], 
    'htk_pid_file_set'                : ["Saving PID {0} to file: {1}"], 
    'htk_pid_file_delete'             : ["PID file deleted: {0}"],
    'htk_app_not_running'             : ["Application is running, PID not found"],
    'htk_app_stopped'                 : ["Application was shuted down"],
    'htk_app_not_running_except'      : ["Application is running, during the shutdnow request an exception was raised"],
    'htk_app_running_with_pid'        : ["Application is running, main PID is {0}"],
    'htk_app_not_running_with_pid'    : ["Application is not running, found previous run PID {0}"],
    'htk_app_stop_request_soft'       : ["Sending request to shutdown the application (soft)"],
    'htk_int_msgq_init'               : ["Initializing internal global message queue, qid: {0}"],
    'htk_oint_msgq_init'              : ["Initializing observer's private message queue"], 
    'htk_observer_init'               : ["Starting to observe"],
    'htk_observer_term'               : ["Stopping observation"],
    'htk_observer_sleep'              : ["Sleeping..."],
    'htk_observer_awake'              : ["Awake"],
    'htk_sig_recv'                    : ["Retrived signal: {0}"],
    'htk_reg_int_srv_msgq'            : ["Registering internal message queue id: {0} for service: {1}"],
    'htk_app_service_reg_ok'          : ["Registered application service {0} - {1}"],
    'htk_app_service_start_ok'        : ["Application service {0} successfully started"],
    'htk_app_service_stop'            : ["Stopping application service {0}"],
    'htk_app_service_stop_failed'     : ["Failed to stop applicaton service {0} in defined time"],
    'htk_app_service_stop_hard'       : ["Stopping application service {0} (hard)"],
    'htk_app_service_inactive_skip'   : ["Bypassing inactive application service {0}"],
    'htk_app_service_already_running' : ["Application service {0} is already running"],
    'htk_create_cfg_db'               : ["Creating config database file: {0}"],
    'htk_remove_cfg_db'               : ["Removing previous config database file"],
    'htk_cfg_db_exists'               : ["Previous config database file exists, use --force to overwrite"],
    'htk_create_cfg_db_error'         : ["Cannot create config database file {0}"],
    'htk_cfg_db_not_spec'             : ["Config database file not specified"],
    'htk_reg_msg_service_failed'      : ["Failed to register message service: {0}"],
    'htk_write_cfg_db'                : ["Writing configuration database"],
    'htk_cworker_check_priv_msg'      : ["Checking privmsg"],
    'htk_cworker_check_activity'      : ["Checking live status on thread: {0}, last activity before: {1}"],
    'htk_loading_ext_cfg'             : ["Trying to load extension config {0}"],
    'htk_ext_cfg_loaded'              : ["Loaded extension config {0}"],
    'htk_loading_base_cfg'            : ["Trying to load base config {0}"],
    'htk_base_cfg_loaded'             : ["Loaded base config {0}"],
    'htk_base_cfg_missing'            : ["Missing global config file {0}"],
    'htk_loading_extension'           : ["%s is archive file... loading from {0}"],
    'htk_extension_wrong_cfg_file'    : ["Found not properly configured extension {0}, file {1} is not valid"],  
    'htk_extension_wrong_cfg'         : ["Found not properly configured extension {0}"],
    'htk_help_cmd_def_missing'        : ["Missing help command {0} definition, languague {1}"],
    'htk_option_def_missing'          : ["Missing option {0} definition, languague {1}"],
    'htk_cworker_process_msg'         : ["PONG from thread {0}, speed: {1}"],
    'htk_duplicate_extension'         : ["Extension '{0}' load duplicate"],
    'htk_short_opt_registered'        : ["Short option {0} is already registered for matching"],
    'htk_short_opt_invalid'           : ["Short option {0} is not valid string"],
    'htk_long_opt_registered'         : ["Long option {0} is already registered for matching"],
    'htk_long_opt_invalid'            : ["Long option {0} is not valid string"],
    'htk_cmd_registered'              : ["Command {0} is already registered for matching"],
    'htk_cmd_invalid'                 : ["Command {0} is not valid string"],
    'htk_fn_hook_invalid'             : ["Functionality Hook error, {0} have to return True"],
    'htk_app_service_invalid'         : ["Service name must be a valid string, your input was: {0}"],
    'htk_app_service_registered'      : ["Service with name: {0} already registered"],
    'htk_app_service_desc_missing'    : ["Service description has to be specified"],
    'htk_cb_not_callable'             : ["Callback parameter must be a callable object"],
    'htk_app_service_start_failed'    : ["Failed to start application service {0}"]                                            
}
