# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest

from ... import models as _models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class PolicyOperations:
    """PolicyOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.security.attestation._generated.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def get(
        self,
        attestation_type: Union[str, "_models.AttestationType"],
        **kwargs
    ) -> "_models.PolicyResponse":
        """Retrieves the current policy for an attestation type.

        Retrieves the current policy for an attestation type.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence.
        :type attestation_type: str or ~azure.security.attestation._generated.models.AttestationType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PolicyResponse, or the result of cls(response)
        :rtype: ~azure.security.attestation._generated.models.PolicyResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-01"
        accept = "application/json"

        # Construct URL
        url = self.get.metadata['url']  # type: ignore
        path_format_arguments = {
            'instanceUrl': self._serialize.url("self._config.instance_url", self._config.instance_url, 'str', skip_quote=True),
            'attestationType': self._serialize.url("attestation_type", attestation_type, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CloudError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PolicyResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get.metadata = {'url': '/policies/{attestationType}'}  # type: ignore

    async def set(
        self,
        attestation_type: Union[str, "_models.AttestationType"],
        new_attestation_policy: str,
        **kwargs
    ) -> "_models.PolicyResponse":
        """Sets the policy for a given attestation type.

        Sets the policy for a given attestation type.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence.
        :type attestation_type: str or ~azure.security.attestation._generated.models.AttestationType
        :param new_attestation_policy: JWT Expressing the new policy whose body is a
         StoredAttestationPolicy object.
        :type new_attestation_policy: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PolicyResponse, or the result of cls(response)
        :rtype: ~azure.security.attestation._generated.models.PolicyResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-01"
        content_type = kwargs.pop("content_type", "text/plain")
        accept = "application/json"

        # Construct URL
        url = self.set.metadata['url']  # type: ignore
        path_format_arguments = {
            'instanceUrl': self._serialize.url("self._config.instance_url", self._config.instance_url, 'str', skip_quote=True),
            'attestationType': self._serialize.url("attestation_type", attestation_type, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(new_attestation_policy, 'str')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CloudError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PolicyResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    set.metadata = {'url': '/policies/{attestationType}'}  # type: ignore

    async def reset(
        self,
        attestation_type: Union[str, "_models.AttestationType"],
        policy_jws: str,
        **kwargs
    ) -> "_models.PolicyResponse":
        """Resets the attestation policy for the specified tenant and reverts to the default policy.

        Resets the attestation policy for the specified tenant and reverts to the default policy.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence.
        :type attestation_type: str or ~azure.security.attestation._generated.models.AttestationType
        :param policy_jws: JSON Web Signature with an empty policy document.
        :type policy_jws: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PolicyResponse, or the result of cls(response)
        :rtype: ~azure.security.attestation._generated.models.PolicyResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PolicyResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-10-01"
        content_type = kwargs.pop("content_type", "text/plain")
        accept = "application/json"

        # Construct URL
        url = self.reset.metadata['url']  # type: ignore
        path_format_arguments = {
            'instanceUrl': self._serialize.url("self._config.instance_url", self._config.instance_url, 'str', skip_quote=True),
            'attestationType': self._serialize.url("attestation_type", attestation_type, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(policy_jws, 'str')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CloudError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PolicyResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    reset.metadata = {'url': '/policies/{attestationType}:reset'}  # type: ignore
